<?php
class sidang_list extends CI_Controller {
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		if($this->session->userdata('is_logged_in') AND empty($enc)){
			redirect('dashboard');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);
		}elseif($functions == 'search_detail'){
			$keyword ='search_detail';
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$this->showData($enc,$idalurperkara,2,$page, $keyword, $where);
		
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	public function search(){
		if(empty($_POST)){
			$params =  $this->nativesession->get_flash_session('params');
			$this->type($params);
			return;
		}
		$keyword = $this->input->post('search_keyword',TRUE);
		$date = $this->tanggalhelper->convertToMysqlDate($this->input->post('search_date',TRUE));
		$enc = $this->input->post('enc',TRUE);
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->session->set_userdata('total_rows',-1);
		$this->showData($enc,$idalurperkara,NULL,0,$keyword,$date);
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=2,$start_page=0,$keyword='',$date=''){
			$asc_desc = $this->session->userdata('asc_desc');
			$this->load->model('sidang_list/m_sidang_list','perkara');
			if($start_page>0){
				$begin_limit = ($start_page-1)*50;
			}else{
				$begin_limit = 0;
				$start_page = 1;
			}
			if ($date==''){
				$query = $this->perkara->get_list_sidang($idalurperkara,$col,$asc_desc,$begin_limit,$keyword);
				$today = $this->tanggalhelper->convertDayDate(date('Y-m-d'));
			} else {
				$query = $this->perkara->get_list_sidang($idalurperkara,$col,$asc_desc,$begin_limit,$keyword,$date);
				$today = '';
			}
			$data['list_perkara'] = $query;
			
			if($this->session->userdata('total_rows')){
				if($this->session->userdata('total_rows')==-1){
					$data['total_rows'] = $this->perkara->fecth_data_num($idalurperkara,$keyword);
					$this->session->set_userdata('total_rows',$data['total_rows']);
				}else{
					$data['total_rows'] = $this->session->userdata('total_rows');
				}
			}else{
				$data['total_rows'] = $this->perkara->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}
			
			if ($idalurperkara=='1,2,3,4,5,6,7,8,9,10,11,12,13,14,111,112,113,114,115,116,117,118,119,120,121'){
				$judulnya="";
			}elseif($idalurperkara=='1,2,7,8'){
				$judulnya="PERDATA UMUM";
			}elseif($idalurperkara=='3,4,5,6'){
				$judulnya="PERDATA KHUSUS";
			}elseif($idalurperkara=='111,112,113,114,119'){
				$judulnya="PIDANA UMUM";
			}elseif($idalurperkara=='115,116,117,118'){
				$judulnya="PIDANA KHUSUS";
			}else{
				$judulnya=$this->perkara->getJenisPerkara($idalurperkara);
			}
			
			$data['page_active'] = $begin_limit;
			$data['page_title'] = 'JADWAL SIDANG PERKARA '.strtoupper($judulnya).'. '.$today;
			$data['judulForm1'] = 'No';
			$data['judulForm2'] = 'Tanggal';
			$data['judulForm3'] = 'Sidang Keliling';
			$data['judulForm4'] = 'Ruangan';
			$data['judulForm5'] = 'Nomor Perkara';
			$data['judulForm6'] = 'Agenda';
			
			$data['judulForm9'] = 'Majelis Hakim';
			$data['judulForm10'] = 'Panitera Pengganti';
			$data['judulForm11'] = 'Keterangan';
			$data['judulForm12'] = 'Link';	
			$data['main_body'] = 'jadwal_sidang_list/jadwal_sidang_list';

			$data['enc'] = $enc;
			$data['idalurperkara'] = $idalurperkara;
			$data['page_url'] = 'jadwal_sidang_list';
			$data['page_number'] = $start_page;
			if(empty($keyword) AND !empty($date)){
				$data['keyword'] = $date;
			}elseif(!empty($keyword) AND empty($date)){
				$data['keyword'] = $keyword;
			}else{
				$data['keyword'] = $keyword;
			}
			$data['keyword'] = base64_encode($this->encrypt->encode($data['keyword']));
			$data['column_sorted'] = $col;
			$this->load->vars($data);
			$this->load->view('header');
			$this->load->view('body/body');
	}
}