<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Saldo extends CI_Controller {


	function index(){
		if($this->session->userdata('idgroup')>2){
			redirect('login');
		}

		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		$this->showPage();
	}

	function showPage(){
		$data['page_title'] = 'Konfigurasi Saldo Awal ';
		$data['main_body'] = 'saldo/saldo_awal';
		$data['enc'] = "";
		$data['page_url'] = 'saldo_update';

		$this->load->model('saldo/db_saldo');

		$data['alur_perkara_list'] = $this->db_saldo->get_lits_alur_perkara();

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	function info(){ 
		$this->load->model('saldo/db_saldo');
		$alur_id = $this->input->post('alur_id',TRUE);
		if(!empty($alur_id)){
			$query = $this->db_saldo->get_lits_alur_perkara($alur_id);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					$tgl ='';
					if(!empty($row->tanggal_saldo_awal)){
						$date_fmt = new DateTime(str_replace("-","",$row->tanggal_saldo_awal));
						$tgl = $date_fmt->format('d/m/Y');
					}
					echo json_encode(array(
						'st'=>1,
						'nama'=>$row->nama,
						'tgl_saldo'=>$tgl,
						'jml_saldo'=>number_format($row->jumlah_saldo_awal, 0, ',', '.'),
						'ket'=>$row->keterangan
						)
					);
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>$alur_id));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>$alur_id));
		}
		
	}

	function validate_input(){
		$this->form_validation->set_rules('alur_id', 'Alur Perkara', 'trim|required|xss_clean');
		
		$this->form_validation->set_rules('tgl_saldo', 'Tanggal Saldo', 'trim|required|xss_clean');
		$this->form_validation->set_rules('saldo_awal', 'Jumlah Saldo Awal', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		}else{
			$jml_saldo = str_replace('.', '', $this->input->post('saldo_awal',TRUE));
			$data = array(
				array(
					'id' =>$this->input->post('alur_id',TRUE),
					'col_name' =>'tanggal_saldo_awal',
					'value' => $this->parseDate($this->input->post('tgl_saldo',TRUE))
					),
				array(
					'id' =>$this->input->post('alur_id',TRUE),
					'col_name' =>'jumlah_saldo_awal',
					'value' => $jml_saldo
					),
				array(
					'id' =>$this->input->post('alur_id',TRUE),
					'col_name' =>'keterangan',
					'value' => $this->input->post('keterangan',TRUE)
					),
				array(
					'id' =>$this->input->post('alur_id',TRUE),
					'col_name' =>'diperbaharui_tanggal',
					'value' => date("Y-m-d h:i:s",time())
					),
				array(
					'id' =>$this->input->post('alur_id',TRUE),
					'col_name' =>'diperbaharui_oleh',
					'value' => $this->session->userdata('username')
					)
				);
			$this->load->model('saldo/db_saldo');
			if($this->db_saldo->update_data($data)===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase'));
			}

			
		}
	}

	function parseDate($tgl){
		$tmp = explode('/', $tgl);
		return $tmp[2].'-'.$tmp[1].'-'.$tmp[0];
	}
}