<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Laporan extends CI_Controller {
	function index($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		if(count($segment)!=4){
			show_404();
		}
		
		$this->show($segment[3]);
	}


	function show($enc){
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('report/report');
		$title_perkara = '';
		$tmp = explode(",", $idalurperkara);
		$list_perkara = array();
		if(count($tmp)>0){
			for ($i=0; $i < count($tmp); $i++) {
				if($i>0){
					$title_perkara .= " DAN ";
				}
				$perkara_nama = $this->report->getJenisPerkara($tmp[$i]);
				array_push($list_perkara,array('id'=>$tmp[$i],'nama'=>$perkara_nama));
				$title_perkara .= strtoupper($perkara_nama);
			}
		}else{
			$perkara_nama = $this->report->getJenisPerkara($idalurperkara);
			array_push($list_perkara,array('id'=>$idalurperkara,'nama'=>$perkara_nama));
			$title_perkara = strtoupper($perkara_nama);
		}

		$year = array(date("Y",time()));
		$tahun_sekarang = date("Y",time());
		$min_tahun = $tahun_sekarang;
		$query = $this->report->get_tahun($idalurperkara);
		if($query->num_rows==1){
			foreach ($query->result() as $row) {
				$min_tahun = $row->years;
			}
		}
		$tmp = $tahun_sekarang;
		if($min_tahun<$tahun_sekarang AND !empty($min_tahun)){
			while (TRUE) {
				$tmp--;
				if($tmp<$min_tahun){
					break;
				}
				array_push($year, $tmp);
			}
		}

		$data['list_perkara'] = $list_perkara;
		$data['jenis_laporan'] = $this->fetch_jenis_laporan($idalurperkara);
		$data['rekap_laporan'] = $this->fetch_rekap_laporan($idalurperkara);
		$data['tahun'] = $year;
		$data['page_title'] = 'LAPORAN PERKARA '.$title_perkara;
		$data['enc'] = $enc;
		$data['page_url'] = 'proses_alur_perkara_list';

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('laporan/laporan');
		$this->load->view('footer');
	}

	function fetch_jenis_laporan($idalurperkara){
		if($idalurperkara=='119'){
		   $jenis_laporan=array();	
		}else{
     	   $jenis_laporan = array(
			array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN KASASI',
				'id' => 'x,y',
				'tahapan' => '30'),
			array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN PENINJAUAN KEMBALI',
				'id' => 'x,y',
				'tahapan' => '40')
			);
		}


		if($idalurperkara=='1,2'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PERDATA GUGATAN',
				'id' => '1',
				'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA PERDATA PERMOHONAN',
					'id' => '2',
					'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
					'id' => '1',
					'tahapan' => '20'));
		}elseif($idalurperkara=='15,16'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PERDATA GUGATAN',
				'id' => '15',
				'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA PERDATA PERMOHONAN',
					'id' => '16',
					'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
					'id' => '15',
					'tahapan' => '20'));
		}elseif($idalurperkara=='3,4'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PERDATA KEPAILITAN',
				'id' => '3',
				'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA PERDATA PKPU',
					'id' => '4',
					'tahapan' => '10'));
		}elseif($idalurperkara=='5'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PERDATA HAK KEKAYAAN INTELEKTUAL',
				'id' => '5',
				'tahapan' => '10'));
		}elseif($idalurperkara=='6'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PERDATA HUBUNGAN INDUSTRI',
				'id' => '6',
				'tahapan' => '10'));
		}elseif($idalurperkara=='8'){
			$jenis_laporan = array(array(
				'nama'=>'LAPORAN PERKARA PERDATA GUGATAN SEDERHANA',
				'id' => '8',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA PERDATA GUGATAN SEDERHANA',
				'id' => '8',
				'tahapan' => '10')
			);
		}elseif($idalurperkara=='9'){
			$jenis_laporan = $this->add_pdt($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN KEADAAN PERKARA TATA USAHA NEGARA',
				'id' => '1',
				'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
					'id' => '2',
					'tahapan' => '10'));
		}elseif($idalurperkara=='111,112,113,114'){
			$jenis_laporan = $this->add_pid($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PIDANA BIASA',
				'id' => '111',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA PIDANA SINGKAT',
				'id' => '112',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA PIDANA CEPAT',
				'id' => '113',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA PIDANA LALU LINTAS',
				'id' => '114',
				'tahapan' => '10')
			,
			array(
				'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
				'id' => '111,112,113,114',
				'tahapan' => '20')
			);
		}elseif($idalurperkara=='115'){
			$jenis_laporan = $this->add_pid($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA TINDAK PIDANA KORUPSI',
				'id' => '115',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
				'id' => '115',
				'tahapan' => '20'));
		}elseif($idalurperkara=='116'){
			$jenis_laporan = $this->add_pid($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PIDANA PERIKANAN',
				'id' => '116',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
				'id' => '116',
				'tahapan' => '20'));
		}elseif($idalurperkara=='117'){
			$jenis_laporan = $this->add_pid($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA HAK ASASI MANUSIA',
				'id' => '117',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA YANG DIMOHONKAN BANDING',
				'id' => '117',
				'tahapan' => '20')
			);
		}elseif($idalurperkara=='118'){
			$jenis_laporan = $this->add_pid($jenis_laporan);
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PIDANA ANAK',
				'id' => '118',
				'tahapan' => '10'),
			array(
				'nama'=>'LAPORAN PERKARA PIDANA ANAK YANG DIMOHONKAN BANDING',
				'id' => '118',
				'tahapan' => '20'));
		}elseif($idalurperkara=='119'){
			$jenis_laporan = $this->assign_alur($jenis_laporan,$idalurperkara);
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN PERKARA PIDANA PRA PERADILAN',
				'id' => '119',
				'tahapan' => '10'));
		}
		return $jenis_laporan;
	}

	function add_pdt($jenis_laporan){
		array_push($jenis_laporan,array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN EKSEKUSI',
				'id' => 'x,y',
				'tahapan' => '50'),
			array('nama'=>'LAPORAN KEUANGAN PERKARA',
				'id' => 'x,y',
				'tahapan' => '88'),
			array('nama'=>'LAPORAN PENERIMAAN HAK KEPANITERAAN LAINNYA',
				'id' => 'x,y',
				'tahapan' => '99')
			);
		return $jenis_laporan;
	}
	function add_pid($jenis_laporan){
		array_push($jenis_laporan,array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN GRASI',
				'id' => 'x,y',
				'tahapan' => '60')
			);
		return $jenis_laporan;
	}
	function assign_alur($jenis_laporan,$idalurperkara){
		foreach ($jenis_laporan as $key=>$value) {
			$jenis_laporan[$key]['id'] = $idalurperkara;
		}
		return $jenis_laporan;
	}

	function fetch_rekap_laporan($idalurperkara){
		$rekap_laporan = array(
			array('nama'=>'REKAPITULASI PERKARA',
				'id' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI KEGIATAN HAKIM PN',
				'id' => '2',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI KEGIATAN HAKIM BANDING',
				'id' => '2',
				'tahapan' => '20'),
			array('nama'=>'REKAPITULASI KEGIATAN HAKIM KASASI',
				'id' => '2',
				'tahapan' => '30'),
			array('nama'=>'REKAPITULASI KEGIATAN HAKIM PENINJAUAN KEMBALI',
				'id' => '2',
				'tahapan' => '40'),
			array('nama'=>'REKAPITULASI KEGIATAN PANITERA PENGGANTI PN',
				'id' => '3',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI KEGIATAN PANITERA PENGGANTI BANDING',
				'id' => '3',
				'tahapan' => '20'),
			array('nama'=>'REKAPITULASI KEGIATAN PANITERA PENGGANTI KASASI',
				'id' => '3',
				'tahapan' => '30'),
			array('nama'=>'REKAPITULASI KEGIATAN PANITERA PENGGANTI PENINJAUAN KEMBALI',
				'id' => '3',
				'tahapan' => '40'),
			array('nama'=>'REKAPITULASI KLASIFIKASI PERKARA',
				'id' => '4',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI LAMANYA PENANGANAN PERKARA',
				'id' => '5',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI UPAYA HUKUM BANDING',
				'id' => '6',
				'tahapan' => '20'),
			array('nama'=>'REKAPITULASI UPAYA HUKUM KASASI',
				'id' => '6',
				'tahapan' => '30'),
			array('nama'=>'REKAPITULASI UPAYA HUKUM PK',
				'id' => '6',
				'tahapan' => '40'),
			array('nama'=>'REKAPITULASI UPAYA HUKUM EKSEKUSI',
				'id' => '6',
				'tahapan' => '50'),
			array('nama'=>'REKAPITULASI UPAYA HUKUM GRASI',
				'id' => '6',
				'tahapan' => '60'),
			array('nama'=>'REKAPITULASI TOTAL UPAYA HUKUM',
				'id' => '6',
				'tahapan' => '40')
			);

		if($idalurperkara=='1,2'){
			unset($rekap_laporan[15]);
		}elseif($idalurperkara>100 and $idalurperkara<>119){
			unset($rekap_laporan[14]);
		}elseif($idalurperkara>100 and $idalurperkara==119){
			unset($rekap_laporan[2]);
			unset($rekap_laporan[3]);
			unset($rekap_laporan[4]);
			unset($rekap_laporan[5]);
			unset($rekap_laporan[6]);
			unset($rekap_laporan[7]);
			unset($rekap_laporan[8]);
			unset($rekap_laporan[9]);
			unset($rekap_laporan[10]);
			unset($rekap_laporan[11]);
			unset($rekap_laporan[12]);
			unset($rekap_laporan[13]);
			unset($rekap_laporan[14]);
			unset($rekap_laporan[15]);
			unset($rekap_laporan[16]);
		}elseif($idalurperkara=='3,4'){
			unset($rekap_laporan[2]);
			unset($rekap_laporan[6]);
			#unset($rekap_laporan[9]);
			unset($rekap_laporan[11]);
			unset($rekap_laporan[15]);
		}elseif($idalurperkara=='5'){
			unset($rekap_laporan[2]);
			unset($rekap_laporan[6]);
			#unset($rekap_laporan[9]);
			unset($rekap_laporan[11]);
			unset($rekap_laporan[15]);
		}
		return $rekap_laporan;
	}
}