<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_perdata extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idalurperkara = $this->nativesession->get_flash_session('alur_perkara_id');
		if (!$this->authorization->HasRuleAddPendaftaran($idalurperkara) AND !$this->authorization->HasRuleAddPendaftaranBanding($idalurperkara)){
			show_404();
		}
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		if($idtahapan==10){
			$this->show_data($idalurperkara,$idtahapan);
		}elseif ($idtahapan==20) {
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('alur_perkara_id', $idalurperkara);
			$this->nativesession->set_flash_session('tahapan_id', $idtahapan);
			redirect('add_perdata_banding');
		}elseif ($idtahapan==30) {
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('alur_perkara_id', $idalurperkara);
			$this->nativesession->set_flash_session('tahapan_id', $idtahapan);
			redirect('add_kasasi');
		}elseif ($idtahapan==40) {
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('alur_perkara_id', $idalurperkara);
			$this->nativesession->set_flash_session('tahapan_id', $idtahapan);
			redirect('add_pk');
		}elseif ($idtahapan==50){
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('alur_perkara_id', $idalurperkara);
			$this->nativesession->set_flash_session('tahapan_id', $idtahapan);
			redirect('add_perdata_eksekusi');
			
		}elseif ($idtahapan==51){
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('alur_perkara_id', $idalurperkara);
			$this->nativesession->set_flash_session('tahapan_id', $idtahapan);
			redirect('add_eksekusi_hak_tanggungan');
			
		}
	}

	function show_data($idalurperkara,$idtahapan){
		$this->load->model('perkara/new_perdata','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		$data['main_body'] = 'perkara/new_perdata';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		
		$data['biaya'] = $this->perkara->getBiayaPerkara($idalurperkara,$idtahapan);
		$data['current_date'] = date('d/m/Y');
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
		elseif($jenis_pengadilan==3)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN-#kode_pn#';
		elseif($jenis_pengadilan==4)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
		$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,date("Y"));
		$kode = $this->perkara->getKodePerkara($idalurperkara);
		$kodePN = $this->perkara->getKodePN();
		$data['no_perkara'] = $this->parseFormat($format,$urutan,date("Y"),$kode,$kodePN);
		if($jenis_pengadilan==1)
			$format_manual = '/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
		elseif($jenis_pengadilan==3)
			$format_manual = '/#kode_alur_perkara#/#tahun#/PTUN-#kode_pn#';
		elseif($jenis_pengadilan==4)
			$format_manual = '/#kode_alur_perkara#/#tahun#/#kode_pn#';
		$data['no_perkara_manual'] = $this->parseFormat($format_manual,$urutan,date("Y"),$kode,$kodePN);
		$data['no_urutan_perkara'] = $urutan;
		$data['no_urut'] = $this->perkara->getNomorUrutRegister($idalurperkara,date("Y-m"));
		$data['jenis_perkara'] = $this->perkara->getKlasifikasiPerkara($idalurperkara);
		$data['enc'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function getFormat(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idjenisperkara = $this->input->post('val',TRUE);
		$date = $this->input->post('date',TRUE);
		if(is_numeric($idalurperkara) AND $idalurperkara>0){
			$this->load->model('perkara/new_perdata','perkara');
			if($idjenisperkara=='-1'){
				$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
				if($jenis_pengadilan==1)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
				elseif($jenis_pengadilan==3)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN-#kode_pn#';
				elseif($jenis_pengadilan==4)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
			}elseif($idalurperkara==7){
				$format = '#nomor_urut_perkara#/Pdt.Bth/#tahun#/PN #kode_pn#';
			}else{
				$format = $this->perkara->getFormatPerkara($idjenisperkara);
			}
			$kode = $this->perkara->getKodePerkara($idalurperkara);
			$kodePN1 = $this->perkara->getKodePN();
			
			#parse tahun
			$tmp = explode("/", $date);
			$tahun = $tmp[2];
			$bulan = $tmp[1];
			$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,$tahun);

			#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN.#kode_pn#
			$tglNomor = $this->tanggalhelper->convertToMysqlDate($date);
			$selisih = $this->tanggalhelper->getSelisihHari($tglNomor,'2014-03-20');
			if($selisih>0 AND $jenis_pengadilan==1){
				if (file_exists(FCPATH."resources/ini/pnformat.ini")){
		            $iniArray = parse_ini_file(FCPATH."resources/ini/pnformat.ini");
		            $kodepn = $iniArray[$kodePN1];
		            $kode = strtoupper($kode);
		            $format = str_replace('PN ', 'PN.', $format);
	        	}
			}else{
				$kodepn = $kodePN1;
			}
			$format = $this->parseFormat($format,$urutan,$tahun,$kode,$kodepn);
			$nourutregister= $this->perkara->getNomorUrutRegister($idalurperkara,$tahun.'-'.$bulan);
			echo json_encode(array('st'=>1,'msg'=>$format,'nourutregister'=>$nourutregister));
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
		}
	}

	function parseFormat($format,$urutan,$tahun,$kode,$kodePN){
		$format = str_replace("#nomor_urut_perkara#",$urutan,$format);
		$format = str_replace("#kode_alur_perkara#",$kode,$format);
		$format = str_replace("#tahun#",$tahun,$format);
		$format = str_replace("#kode_pn#",$kodePN,$format);
		return $format;
	}

	function validateNomorPerkara(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$date = $this->input->post('date',TRUE);
		$urutan = $this->input->post('urutan',TRUE);
		$no_manual = $this->input->post('no_manual',TRUE);
		$no_urut_register = $this->input->post('no_urut_register',TRUE);
		$this->load->model('perkara/new_perdata','perkara');
		$nomor_perkara = $urutan.$no_manual;

		if($this->perkara->cekNomorUrut($date, $no_urut_register)->num_rows()==0 && $this->perkara->cekNomorPerkara($nomor_perkara)->num_rows()==0){
			echo json_encode(array('st'=>1,'msg'=>'Valid'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR, Nomor Perkara Sudah Terdaftar Di dalam Sistem. Periksa Kembali Nomor Yang Anda Masukan.'));
		}
	}

	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$klas_perkara = $this->input->post('klas_perkara',TRUE);
		if($klas_perkara==-1){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Anda Belum Memilih Klasifikasi Perkara'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('klas_perkara', 'Klasifikasi Perkara', 'trim|required|numeric|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		
		$this->form_validation->set_rules('generate', 'Generate Nomor Perkara', 'trim|required|numeric|xss_clean');
		$generate = $this->input->post('generate',TRUE);
		if($generate==1){
			$this->form_validation->set_rules('no_perkara_auto', 'Nomor Perkara', 'trim|required|xss_clean|is_unique[perkara.nomor_perkara]');
		}elseif ($generate==0) {
			$this->form_validation->set_rules('no_urutan_manual', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('no_perkara_manual', 'Nomor Perkara', 'trim|required|xss_clean');
		}else{
			show_404();
		}

		$this->form_validation->set_rules('prodeo', 'Prodeo', 'trim|required|numeric|xss_clean');
		$prodeo = $this->input->post('prodeo',TRUE);
		$jenis_prodeo = -1;
		if($prodeo==1){
			$this->form_validation->set_rules('jenis_prodeo', 'Jenis Prodeo', 'trim|required|numeric|xss_clean');
			$jenis_prodeo = $this->input->post('jenis_prodeo',TRUE);
			if($jenis_prodeo!=2 AND $jenis_prodeo!=3){
				echo json_encode(array('st'=>0,'msg'=>'Silahkan Pilih Jenis Prodeo'));
				return;
			}
			$id_pembiayaan = $jenis_prodeo;
		}else{
			$id_pembiayaan = 1;
		}

		$this->form_validation->set_rules('b_panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		}else{
			
			
			$noUrutReg = $this->input->post('no_urut',TRUE);
			$this->load->model('perkara/new_perdata','perkara');
			$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$isNoUrutRegisterExists = $this->perkara->isNomorUrutRegisterExists($this->input->post('tgl_pendaftaran',TRUE),$idalurperkara,$noUrutReg);
			if($isNoUrutRegisterExists==TRUE OR $isNoUrutRegisterExists==-2){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Urut Register Sudah Ada'.$isNoUrutRegisterExists));
				return;
			}

			$tgl_pendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			if($generate==1){
				$noPerkara = $this->input->post('no_perkara_auto',TRUE);
			}elseif ($generate==0) {
				$noPerkara =$this->input->post('no_urutan_manual',TRUE).$this->input->post('no_perkara_manual',TRUE);
			}

			$tmp = explode("/", $noPerkara);
			if((count($tmp)!=5 AND $idalurperkara==9) AND count($tmp)!=4){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Please Refresh Your Browser'.count($tmp)));
				return;
			}
			
			$nomor_urut_perkara = $tmp[0];
			$tmpIndexs = $tmp[0];
			if($tmpIndexs<10){
				$tmpIndexs = '000'.$tmpIndexs;
			}elseif($tmpIndexs>9 and $tmpIndexs <1000){
				$tmpIndexs = '00'.$tmpIndexs;
			}
			$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;
			$isPerkaraExists = $this->perkara->isNomorPerkaraExist($noPerkara);
			if($isPerkaraExists===TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Perkara Sudah Ada Didalam System'));
				return;
			}
			$no_ref = $this->input->post('no_ref',TRUE);
			$b_panjar = str_replace('.','',$this->input->post('b_panjar',TRUE));
			$b_pendaftaran = str_replace('.','',$this->input->post('b_pendaftaran',TRUE));
			$b_atk = str_replace('.','',$this->input->post('b_atk',TRUE));
			if($b_panjar<($b_pendaftaran+$b_atk)){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
				return;
			}elseif ($b_panjar==0 AND $jenis_prodeo<>3) {
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Biaya Panjar Tidak Boleh Kosong'));
				return;
			}

			#masukan ke db
			#
			$jenisPerkara = $this->perkara->getJenisPerkaraNama($klas_perkara);
			if($jenisPerkara->num_rows>0){
				foreach ($jenisPerkara->result() as $row) {
					$kode = $row->kode;
					$jenisPerkaraNama = $row->nama;
					$jenisPerkaraText = $row->nama_lengkap;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Please Refresh Your Browser'));
				return;
			}
			$dayName = $this->tanggalhelper->getDayName($tgl_pendaftaran);
			if($dayName=="Sunday" OR $dayName=="Saturday"){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Dapat memilih diluar hari kerja (Sabtu - Minggu).'));
				return;
			}

			

			$data_perkara = array(
				'nomor_perkara' => $noPerkara,
				'alur_perkara_id' => $idalurperkara,
				'tanggal_pendaftaran' => $tglPendaftaran,
				'jenis_perkara_id' => $klas_perkara,
				'jenis_perkara_kode' => $kode,
				'jenis_perkara_nama' => $jenisPerkaraNama,
				'jenis_perkara_text' => $jenisPerkaraText,
				'nomor_urut_register' => $noUrutReg,
				'nomor_urut_perkara' => $nomor_urut_perkara,
				'nomor_indeks' => $nomorIndexs,
				'tahapan_terakhir_id' => 10,
				'tahapan_terakhir_text' => 'Pendaftaran',
				'proses_terakhir_id' => 10,
				'proses_terakhir_text' => 'Pendaftaran Perkara',
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
			if(!empty($prodeo)){
				$data_perkara['prodeo'] = $prodeo;
			}
			$data_keuangan_perkara = array(
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 1,
					'jenis_biaya_id' => 1,
					'urutan' => 1,
					'jenis_transaksi' => 1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Panjar Biaya Perkara',
					'jumlah' => $b_panjar,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 11,
					'jenis_biaya_id' => 61,
					'urutan' => 2,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pendaftaran/PNBP',
					'jumlah' => $b_pendaftaran,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 12,
					'jenis_biaya_id' => 155,
					'urutan' => 3,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pemberkasan/ATK',
					'jumlah' => $b_atk,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				)
			);
			if($this->perkara->add_data($data_perkara,$data_keuangan_perkara)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
			}	
		}
	}
}