<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_delegasi extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu

		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$this->show_data();
	}

	function show_data(){
		$this->load->model('perkara/delegasi','delegasi');
		$history = $this->nativesession->get_flash_session('url_requested');
		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
		$idalur=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalur'),TRUE));
		$iddelegasi=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('encDelegasi'),TRUE));
		$idpnasal=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpnasal'),TRUE));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpntujuan'),TRUE));
		
		$data['list_pt'] = $this->delegasi->get_list_pt('',$data['jenis_pengadilan']);
		$data['list_pn'] = $this->delegasi->get_list_pn();
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
		$data['idpt']='';
		$data['delegasi_id']='';
		$data['alur_perkara_id']='';
		$data['perkara_id']='';
		$data['id_jenis_delegasi']='';
		$data['id_pn_asal']='';
		$data['idpn']='';
		$data['pn_asal_text']='';
		$data['pn_tujuan_text']='';
		$data['kode_satker_asal']='';
		$data['id_pn_tujuan']='';
		$data['tgl_surat']='';
		$data['tgl_delegasi']='';
		$data['nomor_surat']='';
		$data['namadokumen']='';
		$data['tgl_sidang']='';
		$data['tgl_resi']='';
		$data['nomor_resi']='';
		$data['biaya']=0;
		$data['tgl_pengiriman']='';
		$data['para_pihak']='';
		$data['nomor_perkara']='';
		$data['catatan']='';
		$data['jenis_perkara']='';
		$data['tanggal_pendaftaran_perkara']='';
		$data['previous']='';

		$data['judul'] = 'TAMBAH PERMOHONAN BANTUAN DELEGASI KELUAR ';
		$data['edit']='';
		$data['idalur']=base64_encode($this->encrypt->encode('2'));
		$data['current_date'] = date('d/m/Y');
		$this->load->view('delegasi/add_delegasi',$data);

	}

	function edit(){
			$segment = $this->uri->segment_array();
			
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
			$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$get_id_pt = $this->delegasi->get_id_pt($idpntujuan);
			if ($get_id_pt->num_rows > 0) {
				foreach ($get_id_pt->result() as $row) {
					$data['idpt']=$row->id;
				}
			}

			$data['list_pt'] = $this->delegasi->get_list_pt('',$data['jenis_pengadilan']);
			$data['list_pn'] = $this->delegasi->get_list_pn();
			$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
			$data['data_pn_asal']=$this->delegasi->identitasPN();
			$data['previous']=$this->nativesession->get_flash_session('main_url_requested');
			$data['data_jurusita'] = $this->delegasi->getDataJurusita($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['data_pn_asal']=$this->delegasi->identitasPN();

							
			foreach ($data['delegasi_detil']->result() as $row) {
				$data['delegasi_id']=$row->id;	
				$data['perkara_id']=base64_encode($this->encrypt->encode($row->perkara_id));
				$data['nomor_perkara']=$row->nomor_perkara;
				$data['id_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
				$data['kode_satker_asal']=$row->kode_satker_asal;
				$data['pn_asal_text']=$row->pn_asal_text;
				$data['id_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
				$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
				$data['pn_tujuan_text']=$row->pn_tujuan_text;
				$data['tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
				$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
				$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
				$data['tgl_surat']=$this->tanggalhelper->convertToInputDate($row->tgl_surat);
				$data['tgl_pengiriman']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman);
				$data['nomor_surat']=$row->nomor_surat;
				$data['namadokumen']=$row->namadokumen;
				$data['tgl_sidang']=$this->tanggalhelper->convertToInputDate($row->tgl_sidang);
				$data['document']=$row->document;
				$data['document_size']=$row->document_size;
				$data['document_mime']=$row->document_mime;
				$data['tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
				$data['nomor_resi']=$row->nomor_resi;
				$data['biaya']=$row->biaya;
				$data['para_pihak']=$row->pihak;
				$data['catatan']=$row->catatan;
			}

			$dataPerkara = $this->delegasi->fetchData($data['nomor_perkara'],'');
			if($dataPerkara->num_rows>0){
				foreach ($dataPerkara->result() as $row) {
					$data['alur_perkara_id']=$row->alur_perkara_id;
					$data['jenis_perkara']= $row->jenis_perkara_nama;
					$data['tanggal_pendaftaran_perkara']= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
				}
			}else{
						$data['alur_perkara_id']='';
						$data['jenis_perkara']= "Jenis perkara tidak ditemukan";
						$data['tanggal_pendaftaran_perkara']= "tanggal pendaftaran tidak ditemukan";
			}


			if (empty($data['jenis_perkara'])){
				$data['jenis_perkara']='';
			} 
			$data['judul'] = 'EDIT PERMOHONAN BANTUAN DELEGASI KELUAR ';
			$data['edit']='edit';
			$data['idalur']=base64_encode($this->encrypt->encode('2'));
			$data['current_date'] = date('d/m/Y');
			$this->load->view('delegasi/add_delegasi',$data);
	}

	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/delegasi','delegasi');

		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('id_pn_tujuan', 'PN Tujuan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('id_jenis_delegasi', 'Jenis Delegasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('para_pihak', 'Pihak / Para Pihak', 'trim|required|xss_clean');
		$edit=$this->input->post('is_edit',TRUE);

		if ($edit==''){
			$lastid = $this->delegasi->get_last_id();
			$id_pn_tujuan=$this->input->post('id_pn_tujuan',TRUE);
		}else{
			$lastid=$this->encrypt->decode(base64_decode($this->input->post('delegasi_id',TRUE)));
			$id_pn_tujuan=$this->encrypt->decode(base64_decode($this->input->post('id_pn_tujuan',TRUE)));
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
		$id_pn_asal=$this->encrypt->decode(base64_decode($this->input->post('id_pn_asal',TRUE)));
		$id_jenis_delegasi=$this->input->post('id_jenis_delegasi',TRUE);
		$kodeSatker= $this->delegasi->getKodeSatker($id_pn_tujuan);
		$jenisDelegasi= $this->delegasi->getJenisDelegasi($id_jenis_delegasi);
		
		foreach ($kodeSatker->result() as $row) {
			$kode_satker=$row->kode;
		}
		foreach ($jenisDelegasi->result() as $row) {
			$jenis_delegasi_text=$row->jenis_delegasi;
		}

		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
		$pn_asal_text=$this->input->post('pn_asal_text',TRUE);
		$kode_satker_asal=$this->input->post('kode_satker_asal',TRUE);
		$pn_tujuan_text=$this->input->post('pn_tujuan_text',TRUE);
		$tgl_delegasi= $this->input->post('tgl_delegasi',TRUE);
		$tgl_surat= $this->input->post('tgl_surat',TRUE);
		$tgl_pengiriman= $this->input->post('tgl_pengiriman',TRUE);
		$tgl_sidang= $this->input->post('tgl_sidang',TRUE);
		$nomor_surat = $this->input->post('nomor_surat',TRUE);
		$nomor_perkara = $this->input->post('nomor_perkara',TRUE);
		$catatan= $this->input->post('catatan',TRUE);
		$tmpbiaya=$this->input->post('biaya',TRUE);
		$tmpbiaya1=str_replace(',', '', $tmpbiaya);
		$biaya=intval(str_replace('.', '', $tmpbiaya1));
		$tgl_resi=$this->input->post('tgl_resi',TRUE);
		if ($tgl_resi=='') {
			$tgl_resi=NULL;
		}else{
			$tgl_resi=$this->input->post('tgl_resi',TRUE);
		}
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$para_pihak=$this->input->post('para_pihak',TRUE);
		$datainsert = array(
			'id'=>$lastid,
			'id_pn_asal'=>$id_pn_asal,
			'pn_asal_text'=>$pn_asal_text,
			'kode_satker_asal'=>$kode_satker_asal,
			'nomor_perkara'=>$nomor_perkara,
			'perkara_id'=>$perkara_id,
			'id_pn_tujuan' => $id_pn_tujuan,
			'kode_satker_tujuan'=>$kode_satker,
			'pn_tujuan_text' => $pn_tujuan_text,
			'tgl_delegasi' => $this->tanggalhelper->convertToMysqlDate($tgl_delegasi),
			'tgl_sidang' => $this->tanggalhelper->convertToMysqlDate($tgl_sidang),
			'id_jenis_delegasi' => $id_jenis_delegasi,
			'jenis_delegasi_text' => $jenis_delegasi_text,
			'tgl_surat'=>$this->tanggalhelper->convertToMysqlDate($tgl_surat),
			'tgl_pengiriman' => $this->tanggalhelper->convertToMysqlDate($tgl_pengiriman),
			'nomor_surat' => $nomor_surat,
			'catatan' => $catatan,
			'tgl_resi'=>$this->tanggalhelper->convertToMysqlDate($tgl_resi),
			'nomor_resi' => $nomor_resi,
			'nomor_surat' => $nomor_surat,
			'biaya' => intval($biaya),
			'pihak' => $para_pihak,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time()),
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		if ($edit==''){
			if($this->delegasi->add_permohonan($datainsert)){
				$this->nativesession->set_flash_session('iddelegasi',$lastid);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Simpan Delegasi Tidak Berhasil'));
				return;
			}
		}else{
			if($this->delegasi->edit_permohonan($datainsert,$lastid,$id_pn_asal,$id_pn_tujuan)){
				$this->nativesession->set_flash_session('iddelegasi',$lastid);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Diubah'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Edit Delegasi Tidak Berhasil'));
				return;
			}
		}	
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		$iddelegasi=$this->encrypt->decode(base64_decode($this->input->post('delegasi_id',TRUE)));
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/delegasi','delegasi');
			$delData = $this->delegasi->del_data($iddelegasi);
		if($delData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data delegasi keluar berhasil dihapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
	}

	function validatePost(){
		$this->load->model('perkara/delegasi','delegasi');

		$encDelegasi = $this->nativesession->get_flash_session('iddelegasi');
		$config['allowed_types'] = 'gif|jpg|png|blob|pdf';
		$filename=$_FILES['filedokumen']['name'];

		$mime=$_FILES['filedokumen']['type'];
		$size=$_FILES['filedokumen']['size'];		
		$datafile=file_get_contents($_FILES['filedokumen']['tmp_name']);

		$datainsert=array(
						'namadokumen'=>$filename,
						'document'=>$datafile,
						'document_size'=>$size,
						'document_mime'=>$mime
						);
		try {
			$this->db->where('id',$encDelegasi);
			$this->db->update('delegasi_keluar',$datainsert);
		} catch (Exception $e) {
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Data delegasi berhasil Disimpan.'));
		return;
		

	}

	function fetchData(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		
		$nomor_perkara=trim($this->input->post('val',TRUE));
		
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Masih Kosong.'));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi_keluar');
		$dataPerkara = $this->delegasi_keluar->fetchData($nomor_perkara);

		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$perkara_id = $row->perkara_id;
				$alur_perkara_id=$row->alur_perkara_id;
				$jenis_perkara_nama= $row->jenis_perkara_nama;
				$tanggal_pendaftaran_perkara= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
			}
				$pihak1= $this->delegasi_keluar->get_data_pihak($perkara_id,'1');
				$nama_pihak1='';
				$counter=0;
				if($pihak1->num_rows>0){
							$nama_pihak1 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;width:400px;height:30px;background-color: #5FB85C;">Penggugat </th>
												<th style="width:400px;height:30px;background-color: #5FB85C;">Kuasa Hukum</th>
											</tr>'
											;
											
						foreach ($pihak1->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak1 .='<tr class="tr_chk_pihak">
												<td  style="background:#fff;">
												<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
												</td>
											'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak1 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan Silahkan Mengisikan Pihak Terlebih Dahulu.'.$perkara_id
					));
					return;
				}

				$pihak2= $this->delegasi_keluar->get_data_pihak($perkara_id,'2');
				//print_r($pihak2->result());
				$nama_pihak2='';
				$counter=0;
				if($pihak2->num_rows>0){
							$nama_pihak2 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #5FB85C;height:30px;">Tergugat </th>
												<th style="background-color: #5FB85C;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak2->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak2 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak2 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan Silahkan Mengisikan Pihak Terlebih Dahulu.'
					));
					return;
				}
				$pihak3= $this->delegasi_keluar->get_data_pihak($perkara_id,'3');
				$nama_pihak3='';
				$counter=0;
				if($pihak3->num_rows>0){
						$nama_pihak3 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #5FB85C;height:30px;">Tergugat </th>
												<th style="background-color: #5FB85C;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak3->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak3 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak3 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}
				echo json_encode(array(
				'st'=>1,
				'enc'=>base64_encode($this->encrypt->encode($perkara_id)),
				'alur_perkara_id'=>$alur_perkara_id,
				'nama_pihak1'=>$nama_pihak1,
				'nama_pihak2'=>$nama_pihak2,
				'nama_pihak3'=>$nama_pihak3,
				'alur_perkara_id'=>$alur_perkara_id ,
				'tanggal_pendaftaran_perkara'=>$tanggal_pendaftaran_perkara,
				'perkara_nama'=>$jenis_perkara_nama,
				'msg'=>'Perkara Ditemukan.'
				));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}


	function fetchPihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idparapihak=$this->input->post('val',TRUE);
		$idparapihak=implode(',',$idparapihak);
		
		if(empty($idparapihak)){
			echo json_encode(array('st'=>0,'msg'=>'Belum ada pihak yang dipilih.'));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi');
		$dataParaPihak = $this->delegasi->fetchParaPihak($idparapihak);

		if($dataParaPihak->num_rows>0){
			foreach ($dataParaPihak->result() as $row) {
				$id[]= $row->id;
				$nama[]= $row->nama;
			}
				echo json_encode(array(
				'st'=>1,
				'idparapihak'=>$id,
				'parapihaknama'=>$nama,
				'msg'=>'Perkara Ditemukan.'
				));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}

	function popup_pihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$segment = $this->uri->segment_array();
		$perkara_id=$this->encrypt->decode(base64_decode($segment[3]));
		$this->load->model('perkara/delegasi','delegasi_keluar');

		$data['pihak1'] = $this->delegasi_keluar->get_data_pihak($perkara_id,1);
		$data['pihak2'] = $this->delegasi_keluar->get_data_pihak($perkara_id,2);
		$data['pihak3'] = $this->delegasi_keluar->get_data_pihak($perkara_id,3);
		$data['pihak4'] = $this->delegasi_keluar->get_data_pihak($perkara_id,4);
		$this->load->view('delegasi/popup_pihak',$data);

	}

	function search()
	{
		$keyword = $this->uri->segment(3);
		$data = $this->db->from('perkara')->like('nomor_perkara',$keyword1)->get();	

		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara

			);
		}
		echo json_encode($arr);
	}


		function downloadFile(){
			$segment = $this->uri->segment_array();
			$encDelegasi=$this->encrypt->decode(base64_decode($segment[3]));
			$this->load->model('perkara/delegasi','delegasi');
			//1 = delegasi masuk
			//2 = delegasi keluar
			$datautama=$this->delegasi->get_detil_delegasi('2',$encDelegasi,'','');
  			
			foreach ($datautama->result() as $row)
			{
				$data['namafile']=$row->namadokumen;
				$data['content']=$row->document;
	       		$data['type']=$row->document_mime;
	       		$data['size']=$row->document_size;

				//tampil dihalaman yang sama
				//$this->output->set_header('Content-type: '.$row->document_mime);
				//$this->output->set_output($row->document);
			}
			//----------- tampil di halaman lain
	       	$this->load->vars($data);
			$this->load->view('delegasi/downloadfile',$data,FALSE);
	}
}