<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Efiling extends CI_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('efiling/ecourt','efiling');
	}    
	function auto_complete($keyword){
		$data = $this->db->query('select perkara_id,nomor_perkara from perkara where alur_perkara_id not in (113,114) AND nomor_perkara like \''.$keyword.'/%\' limit 100');
		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara
			);
		}
		// minimal PHP 5.2
		echo json_encode($arr);
	}

	function get_efiling_masuk(){
		$enc_pn_asal=$this->session->userdata('enc_id_pn');
		$id_pn_asal=$this->encrypt->decode(base64_decode($enc_pn_asal));
		//$index_perkara=$this->efiling->get_index_perkara();		
		//$datasend=array('index_perkara'=>$index_perkara,'id_pn_asal'=>$id_pn_asal);
		$datasend=array('id_pn_asal'=>$id_pn_asal);
	    $data_string = json_encode($datasend);

	    $curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => base_url_e_filing()."api/efilingapi/get_efiling",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/json',
		    'Content-Length: ' . strlen($data_string)),
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 60,
		  CURLOPT_POSTFIELDS => $data_string,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST"));
		
		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			$st=$err;
		} else {
	 		$st=$response;
		}

		$status=json_decode($st);
		if ($status->status_kirim==TRUE) {
			echo json_encode(array('jumlah'=>count($status->msg)));
			for ($i=0; $i < count($status->msg) ; $i++) {
				$this->db->replace('perkara_efiling',get_object_vars($status->msg[$i]));
			}

		}else {
			echo json_encode(array('jumlah'=>0,'msg'=>'0'));
		}
	}


	function acak_character($length=6){
			$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		    $result = '';
		    for ($i = 1; $i < $length; $i++)
		        $result .= $characters[mt_rand($length, 35)];
		     return $result;
	}

	function reset_session_efiling(){
		$this->session->set_userdata('timer_cek_efiling',date('Y-m-d H:i:s'));
	}

	function cek_efiling_server_lokal(){
		$cari=$this->db->query('SELECT efiling_id from perkara_efiling where nomor_perkara is null');
		if ($cari->num_rows > 0 ) {
			echo json_encode(array('st'=>1,'value'=> $cari->num_rows));
		}else{
			echo json_encode(array('st'=>0));
		}
	}

	function show_hasil_pencarian(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$search=$this->input->post('search',TRUE);
		if($search!=""){
			$cari_efiling_m=$this->efiling->hasil_cari_m($search);			
			if($cari_efiling_m->num_rows()>0){
					$hslcari = "<div class='box'>
			             			<div class='box-header with-border'>
			              			<h3 class='box-title red'><strong>Hasil Pendaftaran Online</strong<small></small></h3>
			            			</div>";
						$hslcari .= "<div class='box-body'>
							              <table class='table table-bordered table-hover' style='font-size: 14px;'>
							                <tr>
							                  <th style='width: 3%;text-align:center'>No.</th>
							                  <th style='width: 12%'>Nomor Register<br>Online</th>
							                  <th style='width: 12%'>Tanggal Pendaftaran<br>Online</th>
							                  <th style='width: 17%'>Jenis Perkara</th>
							                  <th style='width: 10%'>Jumlah Panjar</th>
							                  <th style='width: 10%'>Status Pembayaran</th>
							                  <th style='width: 15%'>Nomor Perkara</th>
							                </tr>
											";
							    			$i=1;
				                  foreach ($cari_efiling_m->result() as $row) {
				                    if($row->alur_perkara_id==1){
				                      $jenis_perkara = 'Perdata Gugatan';
				                    }elseif($row->alur_perkara_id==2){
				                      $jenis_perkara = 'Perdata Permohonan';
				                    }
				                    if($row->status_pembayaran==1){
				                      $status_pembayaran='Dibayar';
				                    }else{
				                      $status_pembayaran='Menunggu Pembayaran';
				                    }
				                      $hslcari .="
				                          <tr>
				                            <td>".$i."</td>
				                            <td>".$row->nomor_register."</td>
				                            <td>".$this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran)."</td>
				                            <td>".$jenis_perkara."</td>
				                            <td> Rp. ".number_format($row->jumlah_skum,2,',','.')."</td>
				                            <td>".$status_pembayaran."</td>";
				                            if($row->nomor_perkara!=""){
				                            	$noper = $row->nomor_perkara;
				                            }else{
				                            	$noper = "<font color='red'>Belum diregister</font>";
				                            }
				                        $hslcari .= "<td>".$noper."</td></tr>";
				                    $i++;
				                  }         			
							    $hslcari .= "</div>";

						$hslcari.= "</table>";
	
				}else{
					$hslcari .= "";
				}

			echo json_encode(array('st'=>1,'hasil_cari'=>$hslcari));
			return;
			}else{

			echo json_encode(array('st'=>0));
			return;
		}
		
	}	
}