<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query('SELECT tanggal_pendaftaran, 
				left(tanggal_pendaftaran,7) AS tgl,
				tahun_pendaftaran,
				bulan_pendaftaran, 
				LEFT(tanggal_putusan,7) AS putusan, 
				LEFT(penetapan_majelis_hakim,7) AS majelis,
				hasil_mediasi,LEFT(tanggal_cabut,7) AS cabut,
				LEFT(keputusan_mediasi,7) AS mediasi, 
				LEFT(tanggal_gugur,7) AS gugur,LEFT(tanggal_minutasi,7) AS minutasi
				FROM v_perkara 
				WHERE alur_perkara_id IN ('.$idalurperkara.') AND tahun_pendaftaran<='.$tahun.';');
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			if($idalurperkara==8){
				return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					ORDER BY p.nama ASC");
			} else {
				return $this->db->query("
					SELECT jenis_perkara_id,jenis_perkara_nama,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
							ELSE 0
							END
						) AS sisa,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS putus_blm_minut,
					SUM(
						CASE 
							WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
							ELSE 0
							END
						) AS med_blm_minut,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
							ELSE 0
							END
						) AS masuk,
					SUM(
						CASE 
							WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS blm_majelis,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS putus,
					SUM(
						CASE 
							WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS minut,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
							WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS blm_minut,
					SUM(
						CASE 
							WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS cabut,
					SUM(
						CASE 
							WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS gugur,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_berhasil,
						SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_gagal
					FROM v_perkara
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(tanggal_pendaftaran,7) <='".$period."'
					GROUP BY jenis_perkara_id;");
				}
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
				        perkara_id,
				        nomor_perkara,
				        SUBSTRING_INDEX(majelis_hakim_nama,'
						',1) as hakim1 ,SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(majelis_hakim_nama,'
						',2),SUBSTRING_INDEX(majelis_hakim_nama,'
						',1),''),'
						',-1) as hakim2 ,SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(majelis_hakim_nama,'
						',3),SUBSTRING_INDEX(majelis_hakim_nama,'
						',2),''),'
						',-1) as hakim3,
				        panitera_pengganti_text,
				        CONCAT(status_mediator,'-',mediator_text) AS mediator,
				        jenis_perkara_nama,
				        tanggal_pendaftaran,
				        IF(LEFT(penetapan_majelis_hakim,7) > '".$period."',NULL,penetapan_majelis_hakim) AS penetapan_majelis_hakim,
				        IF(LEFT(sidang_pertama,7) > '".$period."',NULL,sidang_pertama) AS sidang_pertama,
				        IF(LEFT(penetapan_penunjukan_mediator,7) > '".$period."',NULL,penetapan_penunjukan_mediator) AS penetapan_penunjukan_mediator,
				        IF(LEFT(dimulai_mediasi,7) > '".$period."',NULL,dimulai_mediasi) AS dimulai_mediasi ,
				        IF(LEFT(keputusan_mediasi,7) > '".$period."',NULL,keputusan_mediasi) AS keputusan_mediasi,
				        IF(LEFT(tanggal_cabut ,7) > '".$period."',NULL,tanggal_cabut) AS tanggal_cabut,
				        IF(LEFT(tanggal_gugur ,7) > '".$period."',NULL,tanggal_gugur) AS tanggal_gugur,
				        IF(LEFT(tanggal_putusan ,7) > '".$period."',NULL,tanggal_putusan) AS tanggal_putusan,
				        IF(LEFT(tanggal_minutasi ,7) > '".$period."',NULL,tanggal_minutasi) AS tanggal_minutasi,
				        IF(LEFT(pemberitahuan_putusan_pihak1 ,7) > '".$period."',NULL,pemberitahuan_putusan_pihak1) AS pemberitahuan_putusan_pihak1,
				        IF(LEFT(pemberitahuan_putusan_pihak2 ,7) > '".$period."',NULL,pemberitahuan_putusan_pihak2) AS pemberitahuan_putusan_pihak2,
				        IF(LEFT(keputusan_mediasi ,7) > '".$period."',NULL,IF(hasil_mediasi = 'Y','Berhasil',IF(hasil_mediasi = 'T', 'Gagal', ''))) AS hasil_mediasi,
				        IF(LEFT(tanggal_putusan ,7) > '".$period."',NULL,IFNULL(status_putusan_kode, '')) AS amar_putusan,
				        status_putusan_nama 
				FROM
				        v_perkara 
				WHERE alur_perkara_id = ".$idalurperkara."
				        AND ((LEFT(tanggal_pendaftaran,7) <= '".$period."' 
				        AND ((  tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7) >= '".$period."') 
				                OR (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7) <= '".$period."' AND (tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7) >= '".$period."')) 
				                        OR (mediasi_berhasil IS NOT NULL AND LEFT(mediasi_berhasil,7) <= '".$period."' AND (tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7) >= '".$period."'))
				                )) OR ( LEFT(tanggal_pendaftaran,7) >= '".$period."' AND LEFT(tanggal_pendaftaran,7) < '".$period."')
				        )
				ORDER BY tahun_pendaftaran, bulan_pendaftaran, nomor_perkara ASC;
				");
		} catch (Exception $e) {
			
		}
	}
}