<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_delegasi_perkara extends CI_Controller {

	function tambah_delegasi_keluar(){
		$this->load->model('perkara/delegasi','delegasi');
		$history = $this->nativesession->get_flash_session('url_requested');
		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
		
		$idpnasal=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpnasal'),TRUE));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpntujuan'),TRUE));
		
		$data['list_pt'] = $this->delegasi->get_list_pt('',$data['jenis_pengadilan']);
		$data['list_pn'] = $this->delegasi->get_list_pn();
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
		$data['idpt']='';
		$data['delegasi_id']='';
		$data['alur_perkara_id']='';
		$data['perkara_id']='';
		$data['id_jenis_delegasi']='';
		$data['id_pn_asal']='';
		$data['idpn']='';
		$data['pn_asal_text']='';
		$data['pn_tujuan_text']='';
		$data['kode_satker_asal']='';
		$data['id_pn_tujuan']='';
		$data['tgl_surat']='';
		$data['tgl_delegasi']='';
		$data['nomor_surat']='';
		$data['namadokumen']='';
		$data['tgl_sidang']='';
		$data['tgl_resi']='';
		$data['nomor_resi']='';
		$data['biaya']=0;
		$data['tgl_pengiriman']='';
		$data['para_pihak']='';
		$data['nomor_perkara']='';
		$data['catatan']='';
		$data['jenis_perkara']='';
		$data['tanggal_pendaftaran_perkara']='';
		$data['previous']='';

		$data['judul'] = 'TAMBAH PERMOHONAN BANTUAN DELEGASI KELUAR ';
		$data['edit']='';
		$data['idalur']=base64_encode($this->encrypt->encode('2'));
		$data['current_date'] = date('d/m/Y');
		$this->load->view('delegasi/add_delegasi',$data);

	}

	function detil_delegasi(){
		$segment = $this->uri->segment_array();
		$idalur=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$enc_delegasi=$this->encrypt->decode(base64_decode($this->uri->segment(4)));
		$idpnasal=$this->encrypt->decode(base64_decode($this->uri->segment(5)));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->uri->segment(6)));
		
		$this->load->model('perkara/delegasi','delegasi');
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');

		$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$enc_delegasi,$idpnasal,$idpntujuan);
		$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$enc_delegasi,$idpnasal,$idpntujuan);
		//$data['delegasi_proses'] = $this->delegasi->getDelegasiProses($enc,"masuk");

		if ($data['delegasi_detil']->num_rows>=1) {
				foreach ($data['delegasi_detil']->result() as $row) {
						$data['delegasi_id']=$row->id;	
						$data['perkara_id']=$row->perkara_id;
						$data['nomor_perkara']=$row->nomor_perkara;
						$data['id_pn_asal']=$row->id_pn_asal;
						$data['kode_satker_asal']=$row->kode_satker_asal;
						$data['pn_asal_text']=$row->pn_asal_text;
						$data['id_pn_tujuan']=$row->id_pn_tujuan;
						$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['pn_tujuan_text']=$row->pn_tujuan_text;
						$data['tgl_delegasi']=$this->tanggalhelper->convertDayDate($row->tgl_delegasi);
						$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
						$data['tgl_sidang']=$this->tanggalhelper->convertDayDate($row->tgl_sidang);
						$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
						$data['tgl_surat']=$this->tanggalhelper->convertDayDate($row->tgl_surat);
						$data['tgl_pengiriman']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman);
						$data['nomor_surat']=$row->nomor_surat;
						$data['namadokumen']=$row->namadokumen;
						$data['document']=$row->document;
						$data['document_size']=$row->document_size;
						$data['document_mime']=$row->document_mime;
						$data['tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['nomor_resi']=$row->nomor_resi;
						$data['biaya']=$row->biaya;
						$data['para_pihak']=$row->pihak;
						$data['catatan']=$row->catatan;
				}
			}else{
						$data['delegasi_id']='';
						$data['perkara_id']='';
						$data['nomor_perkara']='';
						$data['id_pn_asal']='';
						$data['kode_satker_asal']='';
						$data['pn_asal_text']='';
						$data['id_pn_tujuan']='';
						$data['kode_satker_tujuan']='';
						$data['pn_tujuan_text']='';
						$data['tgl_delegasi']='';
						$data['id_jenis_delegasi']='';
						$data['tgl_sidang']='';
						$data['jenis_delegasi_text']='';
						$data['tgl_surat']='';
						$data['tgl_pengiriman']='';
						$data['nomor_surat']='';
						$data['namadokumen']='';
						$data['document']='';
						$data['document_size']='';
						$data['document_mime']='';
						$data['tgl_resi']='';
						$data['nomor_resi']='';
						$data['biaya']='';
						$data['para_pihak']='';
						$data['catatan']='';
		}

		if ($data['delegasi_proses']->num_rows>=1) {
				foreach ($data['delegasi_proses']->result() as $row) {
						$data['p_delegasi_id']=$row->delegasi_id;
						$data['p_tgl_surat_diterima']=$this->tanggalhelper->convertDayDate($row->tgl_surat_diterima);
						$data['p_perkara_id']=$row->perkara_id;
						$data['p_jurusita_id']=$row->jurusita_id;
						$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertDayDate($row->tgl_penunjukan_jurusita);
						$data['p_jurusita_nama']=$row->jurusita_nama;
						$data['p_id_pn_asal']=$row->id_pn_asal;
						$data['p_pn_asal_text']=$row->pn_asal_text;
						$data['p_kode_satker_asal']=$row->kode_satker_asal;
						$data['p_id_pn_tujuan']=$row->id_pn_tujuan;
						$data['p_pn_tujuan_text']=$row->pn_tujuan_text;
						$data['p_kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['p_tgl_relaas']=$this->tanggalhelper->convertDayDate($row->tgl_relaas);
						$data['p_nomor_relaas']=$row->nomor_relaas;
						$data['p_tgl_pengiriman_relaas']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman_relaas);
						$data['p_nomor_surat_pengantar_relaas']=$row->nomor_surat_pengantar_relaas;
						$data['p_id_status_delegasi']=$row->id_status_delegasi;
						$data['p_status_delegasi']=$row->status_delegasi;
						$data['p_namadokumen']=$row->namadokumen;
						$data['p_document']=$row->document;
						$data['p_document_size']=$row->document_size;
						$data['p_document_mime']=$row->document_mime;
						$data['p_tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['p_nomor_resi']=$row->nomor_resi;
						$data['p_biaya']=$row->biaya;
						$data['p_catatan']=$row->catatan;
					}
			}else{
						$data['p_delegasi_id']='';
						$data['p_tgl_surat_diterima']='';
						$data['p_perkara_id']='';
						$data['p_jurusita_id']='';
						$data['p_tgl_penunjukan_jurusita']='';
						$data['p_jurusita_nama']='';
						$data['p_id_pn_asal']='';
						$data['p_pn_asal_text']='';
						$data['p_kode_satker_asal']='';
						$data['p_id_pn_tujuan']='';
						$data['p_pn_tujuan_text']='';
						$data['p_kode_satker_tujuan']='';
						$data['p_tgl_relaas']='';
						$data['p_nomor_relaas']='';
						$data['p_tgl_pengiriman_relaas']='';
						$data['p_nomor_surat_pengantar_relaas']='';
						$data['p_id_status_delegasi']='';
						if (empty($data['p_status_delegasi'])) {
							$data['p_status_delegasi']='Belum dilaksanakan';
						}
						$data['p_namadokumen']='';
						$data['p_document']='';
						$data['p_document_size']='';
						$data['p_document_mime']='';
						$data['p_tgl_resi']='';
						$data['p_nomor_resi']='';
						$data['p_biaya']='';
						$data['p_catatan']='';
			}

		if ($idalur==1) {
			$data['page_title'] = 'INFORMASI DETIL DELEGASI MASUK';
		}else{
			$data['page_title'] = 'INFORMASI DETIL DELEGASI KELUAR';
		}

		foreach ($data['delegasi_detil']->result() as $key => $valdetil) {
			$$key=$valdetil;
		}

		$data['main_body'] = 'delegasi/detil_delegasi';
		$data['previous']=$this->nativesession->set_flash_session('previous',current_url());
		$data['idalur']=$idalur;
		$data['iddelegasi']=$enc_delegasi;
		$data['idpnasal']=$idpnasal;
		$data['idpntujuan']=$idpntujuan;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function downloadFile(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$datautama = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$datafile=$datautama->result();
				$data['filename']=$datafile[0]->namadokumen;
				$data['content']=$datafile[0]->document;
		       	$data['type']=$datafile[0]->document_mime;
		       	$data['size']=$datafile[0]->document_size;
	       	
	       	$this->output->set_header('Content-type: '.$data['type']);
			$this->output->set_output($data['content']);
	}

	function edit_data_umum(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');
			$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$get_id_pt = $this->delegasi->get_id_pt($idpntujuan);
			if ($get_id_pt->num_rows > 0) {
				foreach ($get_id_pt->result() as $row) {
					$data['idpt']=$row->id;
				}
			}

			$data['list_pt'] = $this->delegasi->get_list_pt('',$data['jenis_pengadilan']);
			$data['list_pn'] = $this->delegasi->get_list_pn();
			$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
			$data['data_pn_asal']=$this->delegasi->identitasPN();
			
			$data['data_jurusita'] = $this->delegasi->getDataJurusita($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$data['data_pn_asal']=$this->delegasi->identitasPN();

							
			foreach ($data['delegasi_detil']->result() as $row) {
				$data['delegasi_id']=$row->id;	
				$data['perkara_id']=base64_encode($this->encrypt->encode($row->perkara_id));
				$data['nomor_perkara']=$row->nomor_perkara;
				$data['id_pn_asal']=base64_encode($this->encrypt->encode($row->id_pn_asal));
				$data['kode_satker_asal']=$row->kode_satker_asal;
				$data['pn_asal_text']=$row->pn_asal_text;
				$data['id_pn_tujuan']=base64_encode($this->encrypt->encode($row->id_pn_tujuan));
				$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
				$data['pn_tujuan_text']=$row->pn_tujuan_text;
				$data['tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
				$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
				$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
				$data['tgl_surat']=$this->tanggalhelper->convertToInputDate($row->tgl_surat);
				$data['tgl_pengiriman']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman);
				$data['nomor_surat']=$row->nomor_surat;
				$data['namadokumen']=$row->namadokumen;
				$data['tgl_sidang']=$this->tanggalhelper->convertToInputDate($row->tgl_sidang);
				$data['document']=$row->document;
				$data['document_size']=$row->document_size;
				$data['document_mime']=$row->document_mime;
				$data['tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
				$data['nomor_resi']=$row->nomor_resi;
				$data['biaya']=$row->biaya;
				$data['para_pihak']=$row->pihak;
				$data['catatan']=$row->catatan;
			}

			$dataPerkara = $this->delegasi->fetchData($data['nomor_perkara'],'');
			if($dataPerkara->num_rows>0){
				foreach ($dataPerkara->result() as $row) {
					$data['alur_perkara_id']=$row->alur_perkara_id;
					$data['jenis_perkara']= $row->jenis_perkara_nama;
					$data['tanggal_pendaftaran_perkara']= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
				}
			}else{
						$data['alur_perkara_id']='';
						$data['jenis_perkara']= "Jenis perkara tidak ditemukan";
						$data['tanggal_pendaftaran_perkara']= "tanggal pendaftaran tidak ditemukan";
			}


			if (empty($data['jenis_perkara'])){
				$data['jenis_perkara']='';
			}
			$data['previous']=$this->nativesession->get_flash_session('previous');
			$data['judul'] = 'EDIT PERMOHONAN BANTUAN DELEGASI KELUAR ';
			$data['edit']='edit';
			$data['idalur']=base64_encode($this->encrypt->encode('2'));
			$data['current_date'] = date('d/m/Y');
			$this->load->view('delegasi/add_delegasi',$data);
	}


	function simpan_data_umum(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/delegasi','delegasi');

		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('id_pn_tujuan', 'PN Tujuan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('id_jenis_delegasi', 'Jenis Delegasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('para_pihak', 'Pihak / Para Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('kode_satker_asal','pada kode konfigurasi sistem belum di seting,','required|xss_clean');		
		$this->form_validation->set_rules('tgl_delegasi', 'Tanggal Permohonan Delegasi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_resi', 'Tanggal Resi Pengiriman', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_resi', 'Nomor Resi Pengiriman', 'trim|required|xss_clean');

		$id_jenis_delegasi=$this->input->post('id_jenis_delegasi',TRUE);#didik
		if($id_jenis_delegasi==1){#didik
			$this->form_validation->set_rules('tgl_sidang', 'Tanggal sidang', 'trim|required|xss_clean');
		}

		$edit=$this->input->post('is_edit',TRUE);
		if ($edit==''){
			$lastid = $this->delegasi->get_last_id();
			$id_pn_tujuan=$this->input->post('id_pn_tujuan',TRUE);
		}else{
			$lastid=$this->encrypt->decode(base64_decode($this->input->post('delegasi_id',TRUE)));
			$id_pn_tujuan=$this->encrypt->decode(base64_decode($this->input->post('id_pn_tujuan',TRUE)));
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
		$id_pn_asal=$this->encrypt->decode(base64_decode($this->input->post('id_pn_asal',TRUE)));

		$kodeSatker= $this->delegasi->getKodeSatker($id_pn_tujuan);
		$jenisDelegasi= $this->delegasi->getJenisDelegasi($id_jenis_delegasi);
		
		foreach ($kodeSatker->result() as $row) {
			$kode_satker=$row->kode;
		}
		foreach ($jenisDelegasi->result() as $row) {
			$jenis_delegasi_text=$row->jenis_delegasi;
		}

		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('perkara_id',TRUE)));
		$pn_asal_text=$this->input->post('pn_asal_text',TRUE);
		$kode_satker_asal=$this->input->post('kode_satker_asal',TRUE);
		$pn_tujuan_text=$this->input->post('pn_tujuan_text',TRUE);
		$tgl_delegasi= $this->input->post('tgl_delegasi',TRUE);
		$tgl_surat= $this->input->post('tgl_surat',TRUE);
		$tgl_pengiriman= $this->input->post('tgl_pengiriman',TRUE);
		$tgl_sidang= $this->input->post('tgl_sidang',TRUE);
		$nomor_surat = $this->input->post('nomor_surat',TRUE);
		$nomor_perkara = $this->input->post('nomor_perkara',TRUE);
		$catatan= $this->input->post('catatan',TRUE);
		$tmpbiaya=$this->input->post('biaya',TRUE);
		$tmpbiaya1=str_replace(',', '', $tmpbiaya);
		$biaya=intval(str_replace('.', '', $tmpbiaya1));
		$tgl_resi=$this->input->post('tgl_resi',TRUE);
		if ($tgl_resi=='') {
			$tgl_resi=NULL;
		}else{
			$tgl_resi=$this->input->post('tgl_resi',TRUE);
		}
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$para_pihak=$this->input->post('para_pihak',TRUE);
		$datainsert = array(
			'id'=>$lastid,
			'id_pn_asal'=>$id_pn_asal,
			'pn_asal_text'=>$pn_asal_text,
			'kode_satker_asal'=>$kode_satker_asal,
			'nomor_perkara'=>$nomor_perkara,
			'perkara_id'=>$perkara_id,
			'id_pn_tujuan' => $id_pn_tujuan,
			'kode_satker_tujuan'=>$kode_satker,
			'pn_tujuan_text' => $pn_tujuan_text,
			'tgl_delegasi' => $this->tanggalhelper->convertToMysqlDate($tgl_delegasi),
			'tgl_sidang' => $this->tanggalhelper->convertToMysqlDate($tgl_sidang),
			'id_jenis_delegasi' => $id_jenis_delegasi,
			'jenis_delegasi_text' => $jenis_delegasi_text,
			'tgl_surat'=>$this->tanggalhelper->convertToMysqlDate($tgl_surat),
			'tgl_pengiriman' => $this->tanggalhelper->convertToMysqlDate($tgl_pengiriman),
			'nomor_surat' => $nomor_surat,
			'catatan' => $catatan,
			'tgl_resi'=>$this->tanggalhelper->convertToMysqlDate($tgl_resi),
			'nomor_resi' => $nomor_resi,
			'nomor_surat' => $nomor_surat,
			'biaya' => intval($biaya),
			'pihak' => $para_pihak,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time()),
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		if ($edit==''){
			if($this->delegasi->add_permohonan($datainsert)){
				$this->nativesession->set_flash_session('iddelegasi',$lastid);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Simpan Delegasi Tidak Berhasil'));
				return;
			}
		}else{
			if($this->delegasi->edit_permohonan($datainsert,$lastid,$id_pn_asal,$id_pn_tujuan)){
				$this->nativesession->set_flash_session('iddelegasi',$lastid);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Diubah'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Edit Delegasi Tidak Berhasil'));
				return;
			}
		}	
	}


	function simpanDokumen(){
		$this->load->model('perkara/delegasi','delegasi');

		$encDelegasi = $this->nativesession->get_flash_session('iddelegasi');
		$config['allowed_types'] = 'gif|jpg|png|blob|pdf';
		$filename=$_FILES['filedokumen']['name'];

		$mime=$_FILES['filedokumen']['type'];
		$size=$_FILES['filedokumen']['size'];		
		$datafile=file_get_contents($_FILES['filedokumen']['tmp_name']);

		$datainsert=array(
						'namadokumen'=>$filename,
						'document'=>$datafile,
						'document_size'=>$size,
						'document_mime'=>$mime
						);
		try {
			$this->db->where('id',$encDelegasi);
			$this->db->update('delegasi_keluar',$datainsert);
		} catch (Exception $e) {
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Data delegasi berhasil Disimpan.'));
		return;
		

	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		$iddelegasi=$this->encrypt->decode(base64_decode($this->input->post('delegasi_id',TRUE)));
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/delegasi','delegasi');
			$delData = $this->delegasi->del_data($iddelegasi);
		if($delData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data delegasi keluar berhasil dihapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
	}

	function fetchDataPerkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		
		$nomor_perkara=trim($this->input->post('val',TRUE));
		
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Masih Kosong.'));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi_keluar');
		$dataPerkara = $this->delegasi_keluar->fetchData($nomor_perkara);

		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$perkara_id = $row->perkara_id;
				$alur_perkara_id=$row->alur_perkara_id;
				$jenis_perkara_nama= $row->jenis_perkara_nama;
				$tanggal_pendaftaran_perkara= $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
			}
				$pihak1= $this->delegasi_keluar->get_data_pihak($perkara_id,'1');
				$nama_pihak1='';
				$counter=0;
				if($pihak1->num_rows>0){
							$nama_pihak1 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;width:400px;height:30px;background-color: #5FB85C;">Penggugat </th>
												<th style="width:400px;height:30px;background-color: #5FB85C;">Kuasa Hukum</th>
											</tr>'
											;
											
						foreach ($pihak1->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak1 .='<tr class="tr_chk_pihak">
												<td  style="background:#fff;">
												<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
												</td>
											'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak1 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan Silahkan Mengisikan Pihak Terlebih Dahulu.'.$perkara_id
					));
					return;
				}

				$pihak2= $this->delegasi_keluar->get_data_pihak($perkara_id,'2');
				//print_r($pihak2->result());
				$nama_pihak2='';
				$counter=0;
				if($pihak2->num_rows>0){
							$nama_pihak2 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #5FB85C;height:30px;">Tergugat </th>
												<th style="background-color: #5FB85C;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak2->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak2 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak2 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan Silahkan Mengisikan Pihak Terlebih Dahulu.'
					));
					return;
				}
				$pihak4= $this->delegasi_keluar->get_data_pihak($perkara_id,'4');
				$nama_pihak4='';
				$counter=0;
				if($pihak4->num_rows>0){
							$nama_pihak4 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #5FB85C;height:30px;">Turut Tergugat </th>
												<th style="background-color: #5FB85C;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak4->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak4 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak4 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}else{
					echo json_encode(array(
						'st'=>0,
						'msg'=>'Pihak Tidak Ditemukan Silahkan Mengisikan Pihak Terlebih Dahulu.'
					));
					return;
				}
				$pihak3= $this->delegasi_keluar->get_data_pihak($perkara_id,'3');
				$nama_pihak3='';
				$counter=0;
				if($pihak3->num_rows>0){
						$nama_pihak3 = '<tr class="judul_tabel">
												<th style="border-right: 3px solid white;background-color: #5FB85C;height:30px;">Intervensi </th>
												<th style="background-color: #5FB85C;height:30px;">Kuasa Hukum</th>
											</tr>'
											;
						foreach ($pihak3->result() as $row) {
							$idpihak=$row->id_pihak;
							$identitas_pihak ='Nama  :'.$row->nama.'<br>Alamat : '.$row->alamat.'<br>Pekerjaan : '.$row->pekerjaan.'<br>';
							$nama_pihak3 .='<tr class="tr_chk_pihak">
											<td  style="background:#fff;width:290px;">
											<input value="'.$identitas_pihak.'" class="chk_pihak" name="chk_pihak" type="checkbox">'.$row->nama.'
											</td>
											</tr>'
											;
							if (!empty($row->id_kuasa)){
							$identitas_kuasa ='Nama  :'.$row->nama_kuasa.'<br>Alamat : '.$row->alamat_kuasa.'<br>Pekerjaan : Kuasa<br>';
							$nama_pihak3 .='
												<td  style="background:#fff">
												<input value="'.$identitas_kuasa.'" name="chk_pihak" type="checkbox">'.$row->nama_kuasa.'
												</td>
											</tr>'
											;
							}
							$counter++;
						}
				}
				echo json_encode(array(
				'st'=>1,
				'enc'=>base64_encode($this->encrypt->encode($perkara_id)),
				'alur_perkara_id'=>$alur_perkara_id,
				'nama_pihak1'=>$nama_pihak1,
				'nama_pihak2'=>$nama_pihak2,
				'nama_pihak3'=>$nama_pihak3,
				'nama_pihak4'=>$nama_pihak4,
				'alur_perkara_id'=>$alur_perkara_id ,
				'tanggal_pendaftaran_perkara'=>$tanggal_pendaftaran_perkara,
				'perkara_nama'=>$jenis_perkara_nama,
				'msg'=>'Perkara Ditemukan.'
				));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}


function popup_penunjukan_jurusita() {
		$this->load->model('perkara/delegasi','delegasi');
		$segment = $this->uri->segment_array();
		if 	($segment[3]!=''){
			$data['idalur']=$segment[3];
		}else {
			$data['idalur']=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalur'),TRUE));
		}
		
		$data['iddelegasi']=$segment[4];
		$data['idpnasal']=$segment[5];
		$data['idpntujuan']=$segment[6];



		if (count($segment)<=6){
			$judul="Penunjukan";
			$data['edit']=0;
		}else{
			$data['edit']=$segment[7];
    		$judul="Edit Penunjukan";
		}

		$data['delegasi_detil']=$this->delegasi->get_detil_delegasi($data['idalur'],$segment[4],$segment[5],$segment[6]);
    	$data['delegasi_proses']=$this->delegasi->get_detil_proses($data['idalur'],$segment[4],$segment[5],$segment[6]);

    	foreach ($data['delegasi_detil']->result() as $row) {
			$data['p_tgl_delegasi']=$this->tanggalhelper->convertToInputDate($row->tgl_delegasi);
			$data['tgl_surat_pengantar']=$row->tgl_surat;
		}

		foreach ($data['delegasi_proses']->result() as $row) {
			$data['p_jurusita_id']=$row->jurusita_id;
			$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertToInputDate($row->tgl_penunjukan_jurusita);
			$data['p_jurusita_nama']=$row->jurusita_nama;
		}

		$data['previous']=$this->nativesession->get_flash_session('previous');
		$data['judul']=$judul;
		$data['data_jurusita'] = $this->delegasi->getDataJurusita();
		$data['current_date'] = date('d/m/Y');
		$this->load->view('delegasi/edit_jurusita',$data);
	}


	function simpan_jurusita(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');
		$this->form_validation->set_rules('id_jurusita_txt', 'Jurusita', 'trim|xss_clean|required');
		$this->form_validation->set_rules('jurusita_nama_txt', 'Jurusita', 'trim|xss_clean|required');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		return;
		}

		$this->load->model('perkara/delegasi','delegasi');
		$edit=$this->input->post('edit',TRUE);
		
		$id_delegasi=$this->input->post('iddelegasi',TRUE);
		$id_pn_asal=$this->input->post('idpnasal',TRUE);
		$id_pn_tujuan=$this->input->post('idpntujuan',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$tgl_jurusita=$this->input->post('tgl_jurusita',TRUE);

		#didik
		$tgl_surat_pengantar=$this->input->post('tgl_surat_pengantar',TRUE);
		$tgl_penunjukan_jurusita_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_jurusita);
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_pengantar,$tgl_penunjukan_jurusita_delegasi);		
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penunjukan Jurusita/Jurusita Pengganti Tidak Boleh Kurang Dari Tanggal Surat Pengantar Relaas Satker Asal. '.$this->tanggalhelper->convertDayDate($tgl_surat_pengantar)));
			return;
		}
		#end

		$dataPerkara = $this->delegasi->get_detil_delegasi('1',$id_delegasi,$id_pn_asal,$id_pn_tujuan);
		foreach ($dataPerkara->result() as $key => $valdetil) {
			$$key=$valdetil;
		}
		foreach ($valdetil as $key => $val){
				$$key=$val;	
		}
		$id_perkara=$perkara_id;
		if ($edit==TRUE) {
		$datainsert = array(
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan);
		}else{
		$datainsert = array(
				'delegasi_id'=>$id_delegasi,
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan,
				'id_status_delegasi'=>'0',
				'status_delegasi'=>'Penunjukan Jurusita');
		}

			if($this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
				return;
			}
	}

	function update_pelaksanaan(){
		$segment=$this->uri->segment_array();
		
		$iddelegasi=$this->encrypt->decode(base64_decode($this->uri->segment('3')));
		$idpnasal=$this->encrypt->decode(base64_decode($this->uri->segment('4')));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->uri->segment('5')));
		$edit=$this->encrypt->decode(base64_decode($this->uri->segment('6')));

		$this->load->model('perkara/delegasi','delegasi');
		$idpt='';
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['delegasi_proses'] = $this->delegasi->get_detil_proses(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['data_jurusita'] = $this->delegasi->getDataJurusita(1,$iddelegasi,$idpnasal,$idpntujuan);
		$data['list_pt'] = $this->delegasi->get_list_pt('',$jenis_pengadilan);
		$data['list_pn'] = $this->delegasi->get_list_pn($idpt);
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
			if ($data['delegasi_detil']->num_rows>=1) {
				foreach ($data['delegasi_detil']->result() as $row) {
						$data['delegasi_id']=$row->id;	
						$data['perkara_id']=$row->perkara_id;
						$data['p_perkara_id']=$row->perkara_id;
						$data['nomor_perkara']=$row->nomor_perkara;
						$data['pihak']=$row->pihak;
						$data['id_pn_asal']=$row->id_pn_asal;
						$data['kode_satker_asal']=$row->kode_satker_asal;
						$data['pn_asal_text']=$row->pn_asal_text;
						$data['id_pn_tujuan']=$row->id_pn_tujuan;
						$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['pn_tujuan_text']=$row->pn_tujuan_text;
						$data['tgl_delegasi']=$this->tanggalhelper->convertDayDate($row->tgl_delegasi);
						$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
						$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
						$data['tgl_surat']=$this->tanggalhelper->convertDayDate($row->tgl_surat);
						$data['tgl_pengiriman']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman);
						$data['nomor_surat']=$row->nomor_surat;
						$data['namadokumen']=$row->namadokumen;
						$data['document']=$row->document;
						$data['document_size']=$row->document_size;
						$data['document_mime']=$row->document_mime;
						$data['tgl_sidang']=$this->tanggalhelper->convertDayDate($row->tgl_sidang);
						$data['tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['nomor_resi']=$row->nomor_resi;
						$data['biaya']=$row->biaya;
						$data['catatan']=$row->catatan;
						$data['tgl_surat_relaas']=$row->tgl_surat;#didik
				}
			}else{
						$data['delegasi_id']='';
						$data['perkara_id']='';
						$data['nomor_perkara']='';
						$data['pihak']='';
						$data['id_pn_asal']='';
						$data['kode_satker_asal']='';
						$data['pn_asal_text']='';
						$data['id_pn_tujuan']='';
						$data['kode_satker_tujuan']='';
						$data['pn_tujuan_text']='';
						$data['tgl_delegasi']='';
						$data['id_jenis_delegasi']='';
						$data['jenis_delegasi_text']='';
						$data['tgl_sidang']='';
						$data['tgl_surat']='';
						$data['tgl_pengiriman']='';
						$data['nomor_surat']='';
						$data['namadokumen']='';
						$data['document']='';
						$data['document_size']='';
						$data['document_mime']='';
						$data['tgl_resi']='';
						$data['nomor_resi']='';
						$data['biaya']='';
						$data['catatan']='';
						$data['tgl_surat_relaas']='';#didik
			}
			
			if ($data['delegasi_proses']->num_rows>=1) {
				foreach ($data['delegasi_proses']->result() as $row) {
						$data['p_delegasi_id']=$row->delegasi_id;
						$data['p_tgl_surat_diterima']=$this->tanggalhelper->convertToInputDate($row->tgl_surat_diterima);
						$data['p_jurusita_id']=$row->jurusita_id;
						$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertDayDate($row->tgl_penunjukan_jurusita);
						$data['p_jurusita_nama']=$row->jurusita_nama;
						$data['p_id_pn_asal']=$row->id_pn_asal;
						$data['p_pn_asal_text']=$row->pn_asal_text;
						$data['p_kode_satker_asal']=$row->kode_satker_asal;
						$data['p_id_pn_tujuan']=$row->id_pn_tujuan;
						$data['p_pn_tujuan_text']=$row->pn_tujuan_text;
						$data['p_kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['p_tgl_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_relaas);
						$data['p_nomor_relaas']=$row->nomor_relaas;
						$data['p_tgl_pengiriman_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman_relaas);
						$data['p_nomor_surat_pengantar_relaas']=$row->nomor_surat_pengantar_relaas;
						$data['p_id_status_delegasi']=$row->id_status_delegasi;
						$data['p_status_delegasi']=$row->status_delegasi;
						$data['p_namadokumen']=$row->namadokumen;
						$data['p_document']=$row->document;
						$data['p_document_size']=$row->document_size;
						$data['p_document_mime']=$row->document_mime;
						$data['p_tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
						$data['p_nomor_resi']=$row->nomor_resi;
						$data['p_biaya']=$row->biaya;
						$data['p_catatan']=$row->catatan;
						$data['tgl_penunjukan_jurusita']=$row->tgl_penunjukan_jurusita;#didik
					}
			}else{
						$data['p_delegasi_id']='';
						$data['p_tgl_surat_diterima']='';
						$data['p_perkara_id']='';
						$data['p_jurusita_id']='';
						$data['p_tgl_penunjukan_jurusita']='';
						$data['p_jurusita_nama']='';
						$data['p_id_pn_asal']='';
						$data['p_pn_asal_text']='';
						$data['p_kode_satker_asal']='';
						$data['p_id_pn_tujuan']='';
						$data['p_pn_tujuan_text']='';
						$data['p_kode_satker_tujuan']='';
						$data['p_tgl_relaas']='';
						$data['p_nomor_relaas']='';
						$data['p_tgl_pengiriman_relaas']='';
						$data['p_nomor_surat_pengantar_relaas']='';
						$data['p_id_status_delegasi']='';
						$data['p_status_delegasi']='';
						$data['p_namadokumen']='';
						$data['p_document']='';
						$data['p_document_size']='';
						$data['p_document_mime']='';
						$data['p_tgl_resi']='';
						$data['p_nomor_resi']='';
						$data['p_biaya']='';
						$data['p_catatan']='';
						$data['tgl_penunjukan_jurusita']='';#didik
			}
	
		$data['page_title'] = "PELAKSANAAN DELEGASI MASUK";
		$data['judul']="Proses";
		$data['main_body'] = 'delegasi/update_pelaksanaan';	

		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');

		$data['previous']=$this->nativesession->get_flash_session('previous');
		$data['iddelegasi']=$iddelegasi;
		$data['idalur']='2';
		$data['idpnasal']=$idpnasal;
		$data['idpntujuan']=$idpntujuan;
		$data['edit']=$edit;
		
		$data['statusDelegasi']=array('Telah Dilaksanakan','Tidak dapat dilaksanakan');
		$data['diterimaOleh']=array('Langsung','Tidak Langsung');
		$data['current_date'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function simpan_pelaksanaan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');
		$this->form_validation->set_rules('nomor_relaas', 'Nomor Relaas', 'required');
		$this->form_validation->set_rules('tgl_relaas', 'Tanggal Pelaksanaan Delegasi', 'required');
		$this->form_validation->set_rules('p_tgl_resi', 'Tanggal Resi Pengiriman', 'trim|xss_clean|required');
		$this->form_validation->set_rules('id_status_delegasi_txt', 'Status Delegasi', 'trim|xss_clean|required');
		$this->form_validation->set_rules('biaya', 'Biaya Panggilan', 'trim|xss_clean|required');
		$this->form_validation->set_rules('nomor_resi', 'Nomor Resi', 'trim|xss_clean|required');
		$this->form_validation->set_rules('nomor_surat_pengantar_relaas', 'Nomor Surat Pengantar Relaas', 'trim|xss_clean|required');

		$edit=$this->input->post('edit',TRUE);

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Peringatan:<br /> Tidak Berhasil'.validation_errors()));
		return;
		}
		$biaya = str_replace(',','',$this->input->post('biaya',TRUE));
		if (intval($biaya)==0) {
			echo json_encode(array('st'=>0,'msg'=>'Biaya panggilan tidak boleh kosong'));
			return;;
		}
		$this->load->model('perkara/delegasi','delegasi');

		$catatan=$this->input->post('catatan_proses',TRUE);
		$id_delegasi=$this->input->post('delegasi_id',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
		$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);
		$nomor_relaas=$this->input->post('nomor_relaas',TRUE);
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$nomor_surat_pengantar_relaas=$this->input->post('nomor_surat_pengantar_relaas',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$id_status_delegasi=$this->input->post('id_status_delegasi_txt',TRUE);
		$status_delegasi=$this->input->post('status_delegasi_txt',TRUE);

		$tgl_surat_diterima=$this->input->post('tgl_surat_diterima',TRUE);		
		$tgl_relaas=$this->input->post('tgl_relaas',TRUE);
		$tgl_pengiriman_relaas=$this->input->post('tgl_pengiriman_relaas',TRUE);
		$tgl_resi=$this->input->post('p_tgl_resi',TRUE);		
		$id_perkara=$this->input->post('perkara_id',TRUE);
		#didik
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		
		$tgl_surat_diterima_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_surat_diterima);
		if($tgl_surat_diterima_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}
		$tgl_relaas_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_relaas);
		if($tgl_relaas_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}
		$tgl_pengiriman_relaas_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_pengiriman_relaas);
		if($tgl_pengiriman_relaas_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}
		$tgl_resi_delegasi = $this->tanggalhelper->convertToMysqlDate($tgl_resi);
		if($tgl_resi_delegasi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}
		
		#------
		$selisih4 = $this->tanggalhelper->getSelisihHari($tgl_surat_diterima_delegasi,$curr_date);
		if($selisih4<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Pengantar Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}		
		$selisih2 = $this->tanggalhelper->getSelisihHari($tgl_relaas_delegasi,$curr_date);
		if($selisih2<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Delegasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		$selisih1 = $this->tanggalhelper->getSelisihHari($tgl_pengiriman_relaas_delegasi,$curr_date);
		if($selisih1<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Relaas Diterima Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		$selisih3 = $this->tanggalhelper->getSelisihHari($tgl_resi_delegasi,$curr_date);
		if($selisih3<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Resi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		
		#--------		
		$dayname = $this->tanggalhelper->getDayName($tgl_relaas_delegasi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pelaksanaan Delegasi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		$dayname = $this->tanggalhelper->getDayName($tgl_resi_delegasi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Resi Pengiriman Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		$dayname = $this->tanggalhelper->getDayName($tgl_surat_diterima_delegasi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Surat Pengantar Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		#--------Tidak Boleh Kurang Dari
		$tgl_surat_relaas = $this->input->post('tgl_surat_relaas',TRUE);
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_surat_relaas,$tgl_surat_diterima_delegasi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Berkas Relaas Diterima Tidak Boleh Kurang Dari Tanggal Surat Pengantar Satker Asal. '.$this->tanggalhelper->convertDayDate($tgl_surat_relaas)));
			return;
		}
		$tgl_penunjukan_jsp = $this->input->post('tgl_penunjukan_jsp',TRUE);		
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_penunjukan_jsp,$tgl_relaas_delegasi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Delegasi Tidak Boleh Kurang Dari Tanggal Penunjukan Jurusita. '.$this->tanggalhelper->convertDayDate($tgl_penunjukan_jsp)));
			return;
		}
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_relaas,$tgl_pengiriman_relaas);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Surat Pengantar Tidak Boleh Kurang Dari Tanggal Pelaksanaan Delegasi. '.$this->tanggalhelper->convertDayDate($tgl_relaas_delegasi)));
			return;
		}
		$selisih = $this->tanggalhelper->getSelisihHari($tgl_relaas,$tgl_resi_delegasi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Resi Pengiriman Tidak Boleh Kurang Dari Tanggal Pelaksanaan Delegasi. '.$this->tanggalhelper->convertDayDate($tgl_relaas_delegasi)));
			return;
		}
				
		#END

		$identitasPNTujuan= $this->delegasi->getDataPN($id_pn_tujuan);
		foreach ($identitasPNTujuan->result() as $row) {
			$kode_satker_tujuan=$row->kode;
			$pn_tujuan_txt=$row->nama;
		}
		$identitasPNAsal= $this->delegasi->getDataPN($id_pn_asal);
		foreach ($identitasPNAsal->result() as $row) {
			$kode_satker_asal=$row->kode;
			$pn_asal_txt=$row->nama;
		}
		$datainsert = array(
				'tgl_surat_diterima'=>$this->tanggalhelper->convertToMysqlDate($tgl_surat_diterima),
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'pn_asal_text'=>$pn_asal_txt,
				'kode_satker_asal'=>$kode_satker_asal,
				'id_pn_tujuan'=>$id_pn_tujuan,
				'pn_tujuan_text'=>$pn_tujuan_txt,
				'kode_satker_tujuan'=>$kode_satker_tujuan,
				'tgl_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_relaas),
				'nomor_relaas'=>$nomor_relaas,
				'tgl_pengiriman_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_pengiriman_relaas),
				'nomor_surat_pengantar_relaas'=>$nomor_surat_pengantar_relaas,
				'id_status_delegasi'=>$id_status_delegasi,
				'status_delegasi'=>$status_delegasi,
				'diinput_oleh'=>$user,
				'diinput_tanggal'=>date('Y-m-d'),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time()),
				'catatan'=>$catatan,
				'tgl_resi'=>$this->tanggalhelper->convertToMysqlDate($tgl_resi),
				'biaya'=>$biaya,
				'nomor_resi'=>$nomor_resi);


			$this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
			
			if($this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
			 	echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
			 	return;
			 }else{
			 	echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
			 	return;
			}
	}


	function simpanFileproses(){
			$this->load->model('perkara/delegasi','delegasi');
			$edit="edit";
			$id_delegasi=$this->input->post('delegasi_id',TRUE);
			$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
			$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);

			
	
			$config['allowed_types'] = 'gif|jpg|png|blob|pdf';
			$filename=$_FILES['filedokumen']['name'];
			$mime=$_FILES['filedokumen']['type'];
			$size=$_FILES['filedokumen']['size'];		
			$datafile=file_get_contents($_FILES['filedokumen']['tmp_name']);

			$datainsert=array(
							'namadokumen'=>$filename,
							'document'=>$datafile,
							'document_size'=>$size,
							'document_mime'=>$mime
							);
			
			$this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
	}
	
}