<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_biaya extends CI_Controller {
	function index(){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['idperkara'] = $this->nativesession->get_flash_session('perkara_id');
		if(empty($data['idperkara']) OR intval($data['idperkara'])<0){
			show_404();
		}


		$data['tahapan_id'] = $this->nativesession->get_flash_session('tahapan_id');
		if(empty($data['tahapan_id']) OR intval($data['tahapan_id'])<0){
			show_404();
		}

		$this->load->model('biaya_perkara/biaya_perkara_m');
		$tahapanperkara = $this->biaya_perkara_m->data_perkara($data['idperkara']);
		foreach ($tahapanperkara->result() as $row) {
				$tahapan_perkara_id=$row->tahapan_terakhir_id;
				$alurperkara=$row->alur_perkara_id;
		}
		
		//$tahapanidperkara=$tahapan_perkara_id;
		$tahapanidperkara=$data['tahapan_id'] ;
		if($tahapanidperkara<20){
			$tahapanidperkara=10;
		}
		$alurperkaraid=$alurperkara;
		$data['alurperkaraid']=$alurperkaraid;
		$data['biaya_perkara']=$this->biaya_perkara_m->get_jurnal_biaya_perkara($data['idperkara'],$data['tahapan_id']);
		
		if($tahapanidperkara==10 && ($alurperkaraid==1 || $alurperkaraid==15)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA GUGATAN TINGKAT PERTAMA';	
		}elseif($tahapanidperkara==10 && ($alurperkaraid==2 || $alurperkaraid==16)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN TINGKAT PERTAMA';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==8){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA GUGATAN SEDERHANA';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==3){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA KEPAILITAN TINGKAT PERTAMA';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==4){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PENUNDAAN KEWAJIBAN PEMBAYARAN UTANG';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==5){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA HAK KEKAYAAN INTELEKTUAL TINGKAT PERTAMA ';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==6){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PENGADILAN HUBUNGAN INDUSTRIAL TINGKAT PERTAMA ';	
		}elseif($tahapanidperkara==10 && $alurperkaraid==7){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERLAWANAN TINGKAT PERTAMA';
		}elseif($tahapanidperkara==10 && $alurperkaraid==9){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA GUGATAN TUN';
		}elseif($tahapanidperkara==10 && $alurperkaraid==10){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN UU AP';
		}elseif($tahapanidperkara==10 && $alurperkaraid==11){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN KEBERATAN (KIP)';
		}elseif($tahapanidperkara==10 && $alurperkaraid==12){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN FIKTIF POSITIF';
		}elseif($tahapanidperkara==10 && $alurperkaraid==13){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN PENYALAHGUNAAN WEWENANG';
		}elseif($tahapanidperkara==10 && $alurperkaraid==14){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA PERMOHONAN PERTANAHAN';
		}elseif($tahapanidperkara==20 && ($alurperkaraid==1  || $alurperkaraid==7 || $alurperkaraid==15)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN BANDING PERKARA GUGATAN ';				
		}elseif($tahapanidperkara==20 && $alurperkaraid==9){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN BANDING PERKARA GUGATAN TUN ';				
		}elseif($tahapanidperkara==20 && $alurperkaraid==10){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN BANDING PERKARA PERMOHONAN UU AP ';				
		}elseif($tahapanidperkara==30 && ($alurperkaraid==1 || $alurperkaraid==2 || $alurperkaraid==7 || $alurperkaraid==15 || $alurperkaraid==16)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN KASASI';				
		}elseif($tahapanidperkara==30 && ($alurperkaraid==3 || $alurperkaraid==4)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN KASASI PERKARA KEPAILTAN & PKPU';				
		}elseif($tahapanidperkara==30 && $alurperkaraid==5){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN KASASI PERKARA HAK KEKAYAAN INTELEKTUAL ';				
		}elseif($tahapanidperkara==30 && $alurperkaraid==6){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN KASASI PERKARA PENGADILAN HUBUNGAN INDUSTRIAL';				
		}elseif($tahapanidperkara==30 && $alurperkaraid==9){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN KASASI PERKARA GUGATAN TUN ';				
		}elseif($tahapanidperkara==30 && $alurperkaraid==11){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN KASASI PERKARA PERMOHONAN KEBERATAN (KIP) ';				
		}elseif($tahapanidperkara==30 && $alurperkaraid==14){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN KASASI PERKARA PERMOHONAN PERTANAHAN ';				
		}elseif($tahapanidperkara==40 && ($alurperkaraid==1 || $alurperkaraid==4 || $alurperkaraid==7 || $alurperkaraid==15)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN PENINJAUAN KEMBALI';				
		}elseif($tahapanidperkara==40 && ($alurperkaraid==3 || $alurperkaraid==4)){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN PENINJAUAN KEMBALI PERKARA KEPAILTAN & PKPU';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==5){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN PK PERKARA HAK KEKAYAAN INTELEKTUAL ';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==6){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PK PERKARA PENGADILAN HUBUNGAN INDUSTRIAL';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==9){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PK PERKARA GUGATAN TUN';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==10){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PK PERKARA PERMOHONAN UU AP';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==11){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PK PERKARA PERMOHONAN KEBERATAN (KIP)';				
		}elseif($tahapanidperkara==40 && $alurperkaraid==14){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PK PERKARA PERMOHONAN PERTANAHAN';				
		}elseif($tahapanidperkara==50 && ($alurperkaraid==1 || $alurperkaraid==7 || $alurperkaraid==15) ){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN EKSEKUSI';				
		}elseif($tahapanidperkara==50 && $alurperkaraid==6 ){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN EKSEKUSI PERKARA PHI';				
		}elseif($tahapanidperkara==50 && $alurperkaraid==9 ){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN EKSEKUSI PERKARA GUGATAN TUN';				
		}elseif($tahapanidperkara==50 && $alurperkaraid==10 ){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN EKSEKUSI PERKARA PERMOHONAN UU AP';				
		}elseif($tahapanidperkara==50 && $alurperkaraid==14 ){
			$data['page_title'] = 'BUKU JURNAL KEUANGAN PERMOHONAN EKSEKUSI PERKARA PERMOHONAN PERTANAHAN';				
		}
		
		$data['back']=$this->nativesession->get('main_url_requested');
		$data['data_perkara'] = $this->biaya_perkara_m->data_perkara($data['idperkara']);
		#didik22052016
		$is_prodeo = $this->biaya_perkara_m->cek_prodeo($data['idperkara'],$tahapanidperkara);
		if(!empty($is_prodeo)){
			if($is_prodeo->num_rows>0){
				foreach ($is_prodeo->result() as $row) {
					if($row->id_pembiayaan==1){
						$data['is_prodeo'] = 'Tidak';
					}else if($row->id_pembiayaan==2){
						$data['is_prodeo'] = 'Prodeo Dipa';
					}else if($row->id_pembiayaan==3){
						$data['is_prodeo'] = 'Prodeo Murni';
					}
				}
			}
		}
		#end
		$data['main_body'] = 'jurnal_perkara/jurnal_biaya';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function form_add_biaya(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$api = $this->uri->segment(3);
		$alur_perkara = $this->encrypt->decode(base64_decode($api));
		if(empty($alur_perkara) OR intval($alur_perkara)<0){
			show_404();
		}

		$tti = $this->uri->segment(4);
		$tahapan = $this->encrypt->decode(base64_decode($tti));
		if(empty($tahapan) OR intval($tahapan)<0){
			show_404();
		}

		$idbiayatmp = $this->uri->segment(5);
		$idbiayaperkara = $this->encrypt->decode(base64_decode($idbiayatmp));

		$aksitmp = $this->uri->segment(6);
		$aksi = $this->encrypt->decode(base64_decode($aksitmp));
		
		if($tahapan<20){
			$tahapan=10;
		}

		$this->tampil_form_add_biaya($idperkara,$alur_perkara,$tahapan,$idbiayaperkara,$aksi);
	}

	function tampil_form_add_biaya($idperkara,$alur_perkara,$tahapan,$idbiayaperkara,$aksi){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['idperkara']=base64_encode($this->encrypt->encode($idperkara));
		$data['alur_perkara']=base64_encode($this->encrypt->encode($alur_perkara));
		$data['tahapan']=base64_encode($this->encrypt->encode($tahapan));
		$data['thp']=$tahapan;
		$data['aksi']='';
		$data['idbiayaperkara']='';
		$data['id_kategori_biaya']='';
		$data['id_jenis_biaya']='';
		$data['pihak_ke']='';
		$data['pihak_id']='';
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		
		$this->load->model('biaya_perkara/biaya_perkara_m','biaya');
		$data['data_perkara'] = $this->biaya->data_perkara($data['idperkara']);
		$data['data_kategori_biaya'] = $this->biaya->get_kategori_biaya_all($alur_perkara);
		$data['data_jenis_biaya'] = $this->biaya->get_jenis_biaya_all($tahapan,$alur_perkara);

		if($idbiayaperkara!=''){
		$result_data_biaya = $this->biaya->get_data_edit_biaya($idbiayaperkara);
		if($result_data_biaya!=''){
			if($result_data_biaya->num_rows()>0){
				foreach ($result_data_biaya->result() as $row) {
					$data['idbiayaperkara'] = base64_encode($this->encrypt->encode($row->id));
					$data['tgl_transaksi'] = $row->tanggal_transaksi;
					$data['id_kategori_biaya'] = $row->kategori_id;
					$data['id_jenis_biaya'] = $row->jenis_biaya_id;
					$data['pihak_ke'] = $row->pihak_ke;
					$data['pihak_id'] = $row->pihak_id;
					$data['jumlah'] = $row->jumlah;
					$data['uraian'] = $row->uraian;
					$data['keterangan'] = $row->keterangan;
					$data['aksi'] = base64_encode($this->encrypt->encode($aksi));
				}		}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada ID Biaya');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. ID pada Perkara Biaya Not Found');
			exit();
		}
		}

		if($idperkara!=''){
			$result_data_perkara = $this->biaya->data_perkara($idperkara);
			if($result_data_perkara!=''){
				if($result_data_perkara->num_rows()>0){
					foreach ($result_data_perkara->result() as $row) {
						$data['nomor_perkara'] = $row->nomor_perkara;
						$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
						$data['pihak1_text'] = $row->pihak1_text;
						$data['pihak2_text'] = $row->pihak2_text;
						$data['prodeo'] = $row->prodeo;
						$data['alur_perkara_id'] = $row->alur_perkara_id;
						$data['tahapan_terakhir_id'] = $row->tahapan_terakhir_id;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkada ID Not Found');
				exit();
			}
		}

		if($idperkara!=''){
			$data['pihak_pembayar'] = $this->biaya->pihak_pembayar($idperkara);
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkada ID Not Found');
				exit();
		}
		
		$this->load->vars($data);
		$this->load->view('jurnal_perkara/add_biaya_form');
	}

	function validateInput(){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if(empty($_POST)){
			show_404();
		}


		$this->form_validation->set_rules('tgl_transaksi', 'Tanggal Transaksi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('fpihak_ke', 'Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pihak_pembayar', 'Nama Pihak Pembayar', 'trim|required|xss_clean');
		$this->form_validation->set_rules('kategori_biaya', 'Kategori Biaya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_biaya', 'Jenis Biaya', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('uraian', 'Uraian', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jumlah', 'Jumlah', 'trim|required|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('idbiayaperkara', 'ID Biaya Perkara', 'trim|xss_clean');
		$this->form_validation->set_rules('tanggal_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('aksi', 'Aksi', 'trim|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
			if(empty($idperkara) OR intval($idperkara)<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}
			
			$alur_perkara = $this->encrypt->decode(base64_decode($this->input->post('alur_perkara_id',TRUE)));
			if(empty($alur_perkara) OR intval($alur_perkara)<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}

			$tahapan = $this->encrypt->decode(base64_decode($this->input->post('tahapan_terakhir_id',TRUE)));
			if(empty($tahapan) OR intval($tahapan)<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}

			$idbiayaperkara=$this->encrypt->decode(base64_decode($this->input->post('idbiayaperkara',TRUE)));
			$aksi= $this->encrypt->decode(base64_decode($this->input->post('aksi',TRUE)));

			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				
				$this->load->model('biaya_perkara/biaya_perkara_m','biaya');

				if($idperkara!=''){
				$result_panjar = $this->biaya->get_panjar_biaya($idperkara,$tahapan);
				if($result_panjar!=''){
					if($result_panjar->num_rows()>0){
						foreach ($result_panjar->result() as $row) {
							$panjar = $row->jumlah;
						}
					}else{
						$this->error_page->show_error_msg('Error Found','Tidak ada ID Biaya');
						exit();
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. ID pada Perkara Biaya Not Found');
					exit();
				}
				}

				if($idperkara!=''){
					$tgl_cek_daftar=$this->biaya->get_tgl_pendaftaran($idperkara,$tahapan);
					if($tgl_cek_daftar!=''){
						foreach ($tgl_cek_daftar->result() as $row) {
							$tgl_daftar = $row->tgl_daftar;
						}

					}
				}

				$detil_pembiayaan=$this->biaya->get_detil_biaya($idperkara);
				foreach ($detil_pembiayaan->result() as $row) {
					$id_pembiayaan=$row->id_pembiayaan;
				}
				$idpembiayaan=$id_pembiayaan;

				$id_jenis_biaya=$this->input->post('jenis_biaya',TRUE);

				$detil_jenis_biaya=$this->biaya->get_detil_jenis_biaya($id_jenis_biaya);
				foreach ($detil_jenis_biaya->result() as $row) {
					$jenis_transaksi=$row->jenis_transaksi;
				}
				$jenistransaksi=$jenis_transaksi;

				$biaya_materai=$this->biaya->get_jml_biaya($tahapan,$alur_perkara,152);
				foreach ($biaya_materai->result() as $row) {
					$jmlbiaya_materai=$row->jmlbiaya;
				}
				$materai=!empty($jmlbiaya_materai)?$jmlbiaya_materai:0;

				$biaya_redaksi=$this->biaya->get_jml_biaya($tahapan,$alur_perkara,157);
				foreach ($biaya_redaksi->result() as $row) {
					$jmlbiaya_redaksi=!empty($row->jmlbiaya)?$row->jmlbiaya:'';
				}
				$redaksi=!empty($jmlbiaya_redaksi)?$jmlbiaya_redaksi:0;

				$maxid=$this->biaya->get_maxid_perkara_biaya();
				foreach ($maxid->result() as $row) {
					$maxid_perkara_biaya=$row->maxid;
				}
				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');
				
				$tgl_transaksi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE));
				$pihak_ke = $this->input->post('fpihak_ke',TRUE);
				$pihak_id = $this->input->post('pihak_pembayar',TRUE);

				$cek_tgl_perkara=0;
				if(!empty($id_jenis_biaya) && $id_jenis_biaya==1 && $tahapan==10){
					$cek_tgl_perkara=1;
				}
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_transaksi,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Transaksi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				if($tgl_daftar!='' && $id_jenis_biaya<>1 ){
					$cek_dgn_daftar = $this->tanggalhelper->getSelisihHari($tgl_daftar,$tgl_transaksi);
					if($cek_dgn_daftar<0){
						if($tahapan==10){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal pendaftaran'));
							return;
						}elseif($tahapan==20){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal permohonan banding'));
							return;							
						}elseif($tahapan==30){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal permohonan kasasi'));
							return;
						}elseif($tahapan==40){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal permohonan peninjauan kembali'));
							return;
						}elseif($tahapan==50){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal permohonan eksekusi'));
							return;
						}
					}
				}


				$dayname = $this->tanggalhelper->getDayName($tgl_transaksi);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Transaksi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tgl_pendaftaran = $this->input->post('tanggal_pendaftaran',TRUE);
				if($cek_tgl_perkara<>1){
					$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$tgl_transaksi);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal pendaftaran '));
						return;
					}
				}

		
				$id_perkara_biaya=$maxid_perkara_biaya;
				$jumlah_biaya = str_replace('.','',$this->input->post('jumlah',TRUE));
				if($jenistransaksi<0){
					if(($panjar-$jumlah_biaya)<0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jumlah biaya melebihi sisa panjar, biaya tidak bisa disimpan'));
							return;
					}
				}
				$biaya_pnbp = $this->biaya->getBiayaPnbp($alur_perkara);
				if(!empty($biaya_pnbp)){
					if($biaya_pnbp->num_rows>0){
						foreach ($biaya_pnbp->result() as $row) {
							if($tahapan==$row->tahapan_id){
								$biayaPnbp = $row->jumlah;
							}
						}
					}
				}
				$biaya_Atk = $this->biaya->getBiayaAtk($alur_perkara);
				if(!empty($biaya_Atk)){
					if($biaya_Atk->num_rows>0){
						foreach ($biaya_Atk->result() as $row) {
							if($tahapan==$row->tahapan_id){
								$biayaAtk = $row->jumlah;
							}
						}
					}
				}
				$jumlah_pnbp_atk = $biayaPnbp+$biayaAtk;
				if($id_jenis_biaya==1 OR $id_jenis_biaya==2 OR $id_jenis_biaya==4 OR $id_jenis_biaya==6 OR $id_jenis_biaya==223 AND $idpembiayaan!=3){
					if($jumlah_biaya<$jumlah_pnbp_atk){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jumlah biaya panjar, Tidak boleh kurang dari Rp.'.$jumlah_pnbp_atk.',-'));
							return;
					}
				}


				$data = array(
						'id' => $id_perkara_biaya,
						'id_pembiayaan' => $idpembiayaan,
						'perkara_id' => $idperkara,
						'tahapan_id' => $tahapan,
						'kategori_id' => $this->input->post('kategori_biaya',TRUE),
						'jenis_biaya_id' => $id_jenis_biaya,
						'pihak_id' => $pihak_id,
						'pihak_ke' => $pihak_ke,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $tgl_transaksi,
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				$data_edit = array(
						'kategori_id' => $this->input->post('kategori_biaya',TRUE),
						'jenis_biaya_id' => $id_jenis_biaya,
						'pihak_id' => $pihak_id,
						'pihak_ke' => $pihak_ke,						
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $tgl_transaksi,
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				$data_edit_tanggal_perkara = array(
						'tanggal_pendaftaran' => $tgl_transaksi,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				$data_edit_is_panjar = array(
						'tanggal_transaksi' => $tgl_transaksi,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				
				if($aksi==''){
					$result = $this->biaya->add_perkara_biaya($data);
					//jika_biaya_redaksi
					$id_perkara_biaya_redmat=$id_perkara_biaya+1;

					$data_materai = array(
						'id' => $id_perkara_biaya_redmat,
						'id_pembiayaan' => $idpembiayaan,
						'perkara_id' => $idperkara,
						'tahapan_id' => $tahapan,
						'kategori_id' => 8,
						'jenis_biaya_id' => 152,
						'pihak_id' => $pihak_id,
						'pihak_ke' => $pihak_ke,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $tgl_transaksi,
						'uraian' => 'Materai',
						'jumlah' => $materai,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
						);
					$data_redaksi = array(
						'id' => $id_perkara_biaya_redmat,
						'id_pembiayaan' => $idpembiayaan,
						'perkara_id' => $idperkara,
						'tahapan_id' => $tahapan,
						'kategori_id' => 13,
						'jenis_biaya_id' => 157,
						'pihak_id' => $pihak_id,
						'pihak_ke' => $pihak_ke,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $tgl_transaksi,
						'uraian' => 'Redaksi',
						'jumlah' => $redaksi,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
						);

					if($id_jenis_biaya==157){
					   $result = $this->biaya->add_perkara_biaya($data_materai);						   
					}elseif($id_jenis_biaya==152){
					   $result = $this->biaya->add_perkara_biaya($data_redaksi);						   
					}

				}elseif($aksi=='edit'){
					$result = $this->biaya->edit_perkara_biaya($data_edit,$idbiayaperkara);
				}

				if($aksi=='edit' && $cek_tgl_perkara==1){
					$result = $this->biaya->edit_pendaftaran_perkara($data_edit_tanggal_perkara,$idperkara);	
					$result = $this->biaya->edit_perkara_biaya_ispanjar_61($data_edit_is_panjar,$idperkara);
					$result = $this->biaya->edit_perkara_biaya_ispanjar_155($data_edit_is_panjar,$idperkara);		
				}

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}
				if($result===TRUE){
					
					if($idperkara!=''){
					$result_panjar_akhir = $this->biaya->get_panjar_biaya($idperkara,$tahapan);
					if($result_panjar_akhir!=''){
						if($result_panjar_akhir->num_rows()>0){
							foreach ($result_panjar_akhir->result() as $row) {
								$panjar_akhir = $row->jumlah;
							}
						}else{
							$this->error_page->show_error_msg('Error Found','Tidak ada ID Biaya');
							exit();
						}
					}else{
						$this->error_page->show_error_msg('Error Found','Something the right happen. ID pada Perkara Biaya Not Found');
						exit();
					}
					}

					if($panjar_akhir<100000){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan, mohon jadi perhatian untuk Bapak/Ibu Hakim <font color="red">Sisa Panjar hampir habis</font>. Sisa panjar sebesar :'.$panjar_akhir));
						return;
					}else{
						if($id_jenis_biaya==157){
							echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan</br>Perhatian : Pengeluaran Biaya Materai telah terisi otomatis ketika anda menjurnal Biaya Redaksi sebesar Rp. 6.000,-'));
							return;
						}elseif($id_jenis_biaya==152){
							echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan</br>Perhatian : Pengeluaran Biaya Redaksi telah terisi otomatis ketika anda menjurnal Biaya Materai sebesar Rp. 5.000,-'));
							return;
						}else{
							echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
							return;
						}
					}

				}
										
			}
		}
	}

	function hapus_perkara_biaya(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idbiayaperkara = $this->encrypt->decode(base64_decode($this->input->post('idbiayaperkara')));
		if(!is_numeric($idbiayaperkara) OR !intval($idbiayaperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan biaya yang dihapus.'));
			return;
		}
		
		$this->load->model('biaya_perkara/biaya_perkara_m','biaya');
		if($this->biaya->hapus_perkara_biaya($idbiayaperkara)){
			echo json_encode(array('st'=>1,'msg'=>'Biaya telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}	
}