<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class C_template_tun_perlawanan extends CI_Controller {

    function index() {
        show_404();
    }

    function cetak_sidang_pertama_perlawanan(){      
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }

        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $this->load->model('generate_template/m_template_tun_perlawanan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['datapenetapansidang']=$this->template->getDataPenetapanSidang($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('9','13','114','1','');
        $this->load->view('generate_template/cetak_tun_perlawanan_sidang_pertama',$data,FALSE);
    }

    function popup_pilihan_ketua(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Penetapan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(1)),
                'nama' => 'Ketua Pengadilan'),
            array('id' => base64_encode($this->encrypt->encode(2)),
                'nama' => 'Wakil Ketua Pengadilan')
            );
        $this->load->view('generate_template/popup_tun_pilihan',$data,FALSE);

    }

    function popup_pilihan_panitera(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Penunjukan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(3)),
                'nama' => 'Panitera'),
            array('id' => base64_encode($this->encrypt->encode(4)),
                'nama' => 'Wakil Panitera')
            );
        $this->load->view('generate_template/popup_tun_pilihan',$data,FALSE);
    }

    function popup_pilihan_panitera_pbt(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Pemberitahuan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(3)),
                'nama' => 'Panitera Sekretaris'),
            array('id' => base64_encode($this->encrypt->encode(4)),
                'nama' => 'Wakil Panitera')
            );
        $this->load->view('generate_template/popup_tun_pilihan',$data,FALSE);

    }


    function popup_pilihan_pihak(){
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $pihakke = $segment[5];
        if(!empty($segment[6])){
            $data['idjadwal'] = $segment[6];
        }        
        $data['judul'] = 'Cetak Dokumen Pemberitahuan/Panggilan';
        $data['nama_kolom'] = 'Kepada';
        $data['idoption'] = 'enc_pihak';

        $data['pilihan'] = array();
        $this->load->model('generate_template/m_template_tun_perlawanan','model_template');
        $list_pihak = $this->model_template->getListPihak($idperkara,$pihakke);
        $data['isclickable'] = TRUE;
        if($list_pihak->num_rows>0){
            $i=1;
            $data['pilihan'] = array(array('id' => 0,
                'nama' => 'Pilih Pihak'));
            foreach ($list_pihak->result() as $row) {
                $data['pilihan'][$i] = array(
                    'id' => base64_encode($this->encrypt->encode($row->id)),
                    'nama' => $row->nama
                );
                $i++;
            }
        }else{
            $data['pilihan'] = array(
            array('id' => base64_encode($this->encrypt->encode(0)),
                'nama' => 'Pihak Tidak Ditemukan')
            );
            /* Jika Pihak Tidak Ditemukan, Maka Tombol Cetak Tidak Ditampilkan */
            $data['isclickable'] = FALSE;
        }
        $this->load->view('generate_template/popup_tun_pilihan',$data,FALSE);

    }

    function cetak_template(){  
        
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }

        if(empty($_POST)){
            $segment = $this->uri->segment_array();            
            $data['enc'] = $segment[3];
            $idtemplate = $segment[4];
            $data['options'] = '';
            if(!empty($segment[5])){
                $data['idpihak'] =$this->encrypt->decode(base64_decode($segment[5]));
            }
        }else{
            $idtemplate=$this->encrypt->decode(base64_decode($this->input->post('enc_template',TRUE)));
            $idpihak=$this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
            $data['enc'] = $this->input->post('enc',TRUE);
            $data['options'] = $this->encrypt->decode(base64_decode($this->input->post('options',TRUE)));
            $data['idpihak'] = $idpihak;
            $idjadwal = $this->input->post('idjadwal',TRUE);
            if(!empty($idjadwal)){
                $data['idjadwal']=$this->encrypt->decode(base64_decode($idjadwal));
            }            
        }

        $this->load->model('generate_template/m_template_tun_perlawanan','model_template');
        $data['template'] = $this->model_template->fetch_filename($idtemplate);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        
        $data['idperkara'] = $idperkara;
        $this->load->view('generate_template/cetak_template',$data,FALSE);
    }
   
}
?>