<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_penetapan extends CI_Controller {

    function index() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); 
        }
    }

    function popup_penetapan_majelis_hakim_pid(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment('3'); 

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['penandatangan']=$this->template->getDataPN();

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $template=$this->template2->getDataDocumentTemplate('111','12','20','1','');
        $i=0;
        $jumdata=count($template->result());
        foreach ($template->result() as $template){
            if ($jumdata=='1'){
                $judul['0']=$template->namatemplate;
                $jnsperkara=$template->jnsperkara;
            }else{
                if ($i=='0'){
                    $judul=$template->namatemplate;
                    $judul=explode("",$judul);
                    $jnsperkara=$template->jnsperkara;
                }
            }
        }
        $data['judul']=$judul['0'];
        $data['jnsperkara']=$jnsperkara;
        $this->load->view('generate_template/popup_penetapan_majelis_hakim_pid', $data, FALSE);
    }

    function cetak_penetapan_majelis_hakim_pid(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->input->post('enc',TRUE);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }           
        $data['ditetapkanoleh'] = $this->input->post('ditetapkanoleh',TRUE);
        if(!is_numeric($data['ditetapkanoleh']) OR !intval($data['ditetapkanoleh'])>0){
            show_404();
            exit();
        }           
		
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['dataterdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['namaKejaksaan'] = $this->template->getKejaksaan($idperkara)->row()->kejaksaan;
        
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','20','1',''); 
        $this->load->view('generate_template/cetak_penetapan_pidana_majelis_hakim',$data,FALSE);
    }

    function popup_penetapan_penunjukan_pp(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['penandatangan']=$this->template->getDataPN();

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','30','1','');
        $this->load->view('generate_template/popup_penetapan_penunjukan_pp', $data, FALSE);
    }
    
    function cetak_penetapan_penunjukan_pp(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

		$data['enc']=$this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }          
		$data['ditetapkanoleh']=$this->input->post('ditetapkanoleh',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['dataterdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','30','1','');        
        $this->load->view('generate_template/cetak_penetapan_pidana_pp',$data,FALSE);
    }

    function cetak_sidang_pertama_pidana() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['dataterdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['datapenetapansidang']=$this->template->getDataPenetapanSidang($idperkara);
        $data['namaKejaksaan'] = $this->template->getKejaksaan($idperkara)->row()->kejaksaan;

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','80','1','');
        $this->load->view('generate_template/cetak_penetapan_pidana_sidang_pertama',$data,FALSE);
    }

    function popup_penetapan_kpn_perkara_tidak_termasuk_wewenangnya() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['penandatangan']=$this->template->getDataPN();
		$data['curr_date'] = date('d/m/Y');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','10','10','10','');
        $this->load->view('generate_template/popup_penetapan_kpn_perkara_tidak_termasuk_wewenangnya', $data, FALSE);
    }

    function cetak_penetapan_kpn_perkara_tidak_termasuk_wewenangnya() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
		$data['enc']=$this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }           
        $data['ditetapkanoleh'] = $this->input->post('ditetapkanoleh',TRUE);
        $data['wewenang'] = $this->input->post('wewenang',TRUE);
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);
		
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['dataterdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
		
        # tri edited 30 May 2016

        $tanggal_penetapan = $this->tanggalhelper->convertToMysqlDate($data['tgl_penetapan']);
        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);
        $jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
        if($alur_perkara_id<100 AND $jenis_pengadilan==1)
            $status_putusan_id = 80;
        elseif($alur_perkara_id<100 AND $jenis_pengadilan==3)
            $status_putusan_id = 81;
        elseif($alur_perkara_id>100 AND $jenis_pengadilan==1)
            $status_putusan_id = 79;
        elseif($alur_perkara_id>100 AND $jenis_pengadilan==1 AND $alur_perkara_id!=119)
            $status_putusan_id = 82;
        elseif($jenis_pengadilan==1 AND $alur_perkara_id==119)
            $status_putusan_id = 83;

        if($data['datapengadilan']!=''){
            if($data['datapengadilan']->num_rows()>0){
                $nama_pengadilan = ucwords($data['datapengadilan']->row()->NamaPN);
            }
        }

        $data_putusan_terdakwa = array();
        if($data['dataterdakwa']!=''){
            if($data['dataterdakwa']->num_rows()>0){
                $i = 0;
                foreach ($data['dataterdakwa']->result() as $row) {
                    $data_putusan_terdakwa[$i] = array(
                        'pihak2_id' =>$row->id,
                        'perkara_id' =>$row->perkara_id,
                        'pihak_id' =>$row->pihak_id,
                        'tanggal_putusan' =>$tanggal_penetapan,
                        'status_putusan_id' =>$status_putusan_id,
                        'status_putusan_text' =>'Pengadilan Tidak Berwenang',
                        'diinput_oleh' => $this->session->userdata('username'),
                        'diinput_tanggal' => date("Y-m-d h:i:s",time())
                        );
                    if($row->urutan==1){
                        $nama_terdakwa = $row->nama;
                    }
                }
                $nama_pengadilan = $data['datapengadilan']->row()->NamaPN;
                if($data['dataterdakwa']->num_rows()>1)
                    $nama_terdakwa = $nama_terdakwa.' dkk;';
            }
        }

        
        $amar_text = '<p ><strong>MENETAPKAN:</strong></p>
                        <ol>
                         <li >Menyatakan '.$nama_pengadilan.' tidak berwenang mengadili perkara '.$nama_terdakwa.';</li>
                         <li >Memerintahkan mengembalikan surat pelimpahan perkara kepada Penuntut Umum;</li>
                         <li >Memerintahkan salinan penetapan ini disampaikan kepada Terdakwa atau Penasihat Hukumnya dan Penyidik.</li>
                        </ol>';
        
        $data_putusan = array(
            'perkara_id' => $idperkara,
            'putusan_verstek' => 'T',
            'tanggal_putusan' => $this->tanggalhelper->convertToMysqlDate($data['tgl_penetapan']),
            'status_putusan_id' => $status_putusan_id,
            'status_putusan_nama' => 'Pengadilan Tidak Berwenang',
            'status_putusan_text' => 'Pengadilan Tidak Berwenang',
            'amar_putusan' => $amar_text,
            'diinput_oleh' => $this->session->userdata('username'),
            'diinput_tanggal' => date("Y-m-d h:i:s",time())
        );

        
        $this->template->add_data_putusan_akhir_tidak_berwenang($data_putusan);
        if($alur_perkara_id>100 AND $alur_perkara_id!=119)
            $this->template->add_putusan_tedakwa($data_putusan_terdakwa);

        #### batas edit
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','10','10','10','');
        $this->load->view('generate_template/cetak_penetapan_kpn_perkara_tidak_termasuk_wewenangnya',$data,FALSE);
    }

    function popup_penetapan_hakim_pidana_cepat(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['penandatangan']=$this->template->getDataPN();
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $template=$this->template2->getDataDocumentTemplate('113','12','20','1','');
        $i=0;
        $jumdata=count($template->result());
        foreach ($template->result() as $template){
            if ($jumdata=='1'){
                $judul['0']=$template->namatemplate;
                $jnsperkara=$template->jnsperkara;
            }else{
                if ($i=='0'){
                    $judul=$template->namatemplate;
                    $judul=explode("",$judul);
                    $jnsperkara=$template->jnsperkara;
                }
            }
        }

        $data['judul']=$judul['0'];
        //$data['judul']=""; //override
        $data['jnsperkara']=$jnsperkara;
        $this->load->view('generate_template/popup_penetapan_hakim_pidana_cepat', $data, FALSE);
    }

    function cetak_penetapan_hakim_pidana_cepat(){  
        if(empty($_POST)){
            show_404();
        }
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }           
        $data['ditetapkanoleh'] = $this->input->post('ditetapkanoleh',TRUE);
        if(!is_numeric($data['ditetapkanoleh']) OR !intval($data['ditetapkanoleh'])>0){
            show_404();
            exit();
        }           
        if($data['ditetapkanoleh']==-1){
            echo json_encode(array('st'=>0,'msg'=>'Error:<br />Pembuat Penetapan Belum Terpilih.'));
            return;
        }

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['dataterdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
         
        $data['template']=$this->template2->getDataDocumentTemplate('113','12','20','1','');
        
        $this->load->view('generate_template/cetak_penetapan_pidana_cepat_hakim',$data,FALSE);
    }

    function cetak_penetapan_penahanan_hakim_pn(){
       if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();

        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$segment[5];
        $data['encpihak']=$segment[5];
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
            show_404();
            exit();
        }
        
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','2','');
        $this->load->view('generate_template/cetak_penetapan_penahanan_hakim_pn',$data,FALSE);
    }

    function popup_penetapan_pembantaran_penahanan(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
		$data['curr_date'] = date('d/m/Y');
		
        $this->load->model('generate_template/m_template_penetapan','template');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','1','');
        
        $this->load->view('generate_template/popup_penetapan_pembantaran_penahanan', $data, FALSE);
    }

    function cetak_penetapan_pembantaran_penahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
            show_404();
            exit();
        }           
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','1','');
        $this->load->view('generate_template/cetak_penetapan_pembantaran_penahanan',$data,FALSE);
    }


    function popup_penetapan_penahanan_hakim_pn_sedangberjalan(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
 		$data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
 		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','3','');
        $this->load->view('generate_template/popup_penetapan_penahanan_hakim_pn_sedangberjalan', $data, FALSE);  
    }
    
    function cetak_penetapan_penahanan_hakim_pn_sedangberjalan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }           
        $data['enctahan'] = $this->input->post('enctahan',TRUE);
        $idpenahanan=$this->encrypt->decode(base64_decode($data['enctahan']));
        if(!is_numeric($idpenahanan) OR !intval($idpenahanan)>0){
             show_404();
             exit();
        }
        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
         }
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);
		$data['tgl_sejak']=$this->template->getDataPenahanan($idpenahanan)->row()->mulai;
		$data['tgl_sampai']=$this->template->getDataPenahanan($idpenahanan)->row()->sampai;

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','3','');
        
        $this->load->view('generate_template/cetak_penetapan_penahanan_hakim_pn_sedangberjalan',$data,FALSE);
    }     

    function popup_penetapan_penangguhan_penahanan_dengan_jaminan(){
         if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		$data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
		$data['jnstmp']=$this->uri->segment('6');
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
 		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
      
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');  
		if($data['jnstmp']==1){			
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','4','');
        }else{
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','5','');
		}
        $this->load->view('generate_template/popup_penetapan_penangguhan_penahanan_dengan_jaminan', $data, FALSE);  
    }

    function cetak_penetapan_penangguhan_penahanan_dengan_jaminan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $data['encpihak']=$this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }
        $data['jnstmp']=$this->input->post('jnstmp',TRUE);
        if(!is_numeric($data['jnstmp']) OR !intval($data['jnstmp'])>0){
             show_404();
             exit();
        }

		$data['tgl_penetapan']=$this->input->post('tgl_penetapan',TRUE);
		$data['jnstmp']=$this->input->post('jnstmp',TRUE);
		
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);
        
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if ($data['jnstmp']==1) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','4','');
        }else{
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','5','');
        }
            $this->load->view('generate_template/cetak_penetapan_penangguhan_penahanan_dengan_jaminan',$data,FALSE);
    }

    function popup_penetapan_penangguhan_penahanan_tanpa_jaminan(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		$data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
  		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
     
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','6','');
        $this->load->view('generate_template/popup_penetapan_penangguhan_penahanan_tanpa_jaminan', $data, FALSE);  
    }

    function cetak_penetapan_penangguhan_penahanan_tanpa_jaminan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $data['encpihak']=$this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }

		$data['tgl_penetapan']=$this->input->post('tgl_penetapan',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','6','');
        $this->load->view('generate_template/cetak_penetapan_penangguhan_penahanan_tanpa_jaminan',$data,FALSE);        
    }

    function popup_penetapan_penolakan_perpanjangan_tahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
        $data['jnstmp']=$this->uri->segment('6');
        if(!is_numeric($data['jnstmp']) OR !intval($data['jnstmp'])>0){
            show_404();
            exit();
        }
		$data['curr_date'] = date('d/m/Y');
		
        $this->load->model('generate_template/m_template_penetapan','template');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
		if ($data['jnstmp']==1){
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','9','');
		}else{
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','10','');			
		}
        $this->load->view('generate_template/popup_penetapan_penolakan_perpanjangan_tahanan', $data, FALSE);          
    }   

    function cetak_penetapan_penolakan_perpanjangan_tahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }
        $data['jnstmp'] = $this->input->post('jnstmp',TRUE);
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);
		
        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);
    
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if ($data['jnstmp']==1) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','9','');
        }elseif ($data['jnstmp']==2) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','10','');
        }
        $this->load->view('generate_template/cetak_penetapan_penolakan_perpanjangan_tahanan',$data,FALSE);
    }

    function popup_penetapan_pengalihan_penahanan_permohonan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
        $data['jnstmp']=$this->uri->segment('6');
        if(!is_numeric($data['jnstmp']) OR !intval($data['jnstmp'])>0){
            show_404();
            exit();
        }
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');   
		if($data['jnstmp']==1){
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','7','');
		}else{
			$data['template']=$this->template2->getDataDocumentTemplate('111','12','200','8','');
		}
        $this->load->view('generate_template/popup_penetapan_pengalihan_penahanan', $data, FALSE);          
    }

    function cetak_penetapan_pengalihan_penahanan_permohonan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }

        $data['jnstmp'] = $this->input->post('jnstmp',TRUE);
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);
		$data['tahanansebelumnya']=$this->input->post('tahanansebelumnya',TRUE);
		$data['menjaditahanan']=$this->input->post('menjaditahanan',TRUE);
        $data['tgl_berakhir'] = $this->input->post('tgl_berakhir',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);
        
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if ($data['jnstmp']==1) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','7','');
        }else{
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','8','');
        }
        $this->load->view('generate_template/cetak_penetapan_pengalihan_penahanan',$data,FALSE);
    }

    function popup_penetapan_perpanjangan_penahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
            show_404();
            exit();
        }
        $data['jnstmp']=$this->uri->segment('6');
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        if ($data['jnstmp']==1) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','11','');
        }elseif ($data['jnstmp']==2) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','12','');
        }elseif ($data['jnstmp']==3) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','13','');
        }elseif ($data['jnstmp']==4) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','14','');
        }elseif ($data['jnstmp']==5) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','15','');
        }elseif ($data['jnstmp']==6) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','16','');
        }elseif ($data['jnstmp']==7) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','17','');
        }elseif ($data['jnstmp']==8) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','18','');
        }
        $this->load->view('generate_template/popup_penetapan_perpanjangan_penahanan', $data, FALSE);          
    }

    function cetak_penetapan_perpanjangan_penahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan'] = $this->input->post('enctahan',TRUE);
        $idpenahanan=$this->encrypt->decode(base64_decode($data['enctahan']));
        if(!is_numeric($idpenahanan) OR !intval($idpenahanan)>0){
             show_404();
             exit();
        }
        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }
        $data['jnstmp'] = $this->input->post('jnstmp',TRUE);
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);
        $data['enctahan'] = $this->input->post('enctahan',TRUE);
       
        $this->load->model('generate_template/m_template_penetapan','template');
		$data['jenistahanan']=$this->template->getDataPenahanan($idpenahanan)->row()->jenis_tahanan.' '.$this->template->getDataPenahanan($idpenahanan)->row()->nama;
		$data['tgl_sejak']=$this->template->getDataPenahanan($idpenahanan)->row()->mulai;
        $tglMulai=$this->template->getDataPenahanan($idpenahanan)->row()->mulai;
		$data['tgl_sampai']=$this->template->getDataPenahanan($idpenahanan)->row()->sampai;
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->get_data_penahanan($idperkara,$idpihak,$tglMulai);
        $data['namaKejaksaan'] = $this->template->getKejaksaan($idperkara)->row()->kejaksaan;

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if ($data['jnstmp']==1) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','11','');
        }elseif ($data['jnstmp']==2) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','12','');
        }elseif ($data['jnstmp']==3) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','13','');
        }elseif ($data['jnstmp']==4) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','14','');
        }elseif ($data['jnstmp']==5) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','15','');
        }elseif ($data['jnstmp']==6) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','16','');
        }elseif ($data['jnstmp']==7) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','17','');
        }elseif ($data['jnstmp']==8) {
            $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','18','');
        }
        $this->load->view('generate_template/cetak_penetapan_perpanjangan_penahanan',$data,FALSE);
    }

    function popup_penetapan_ijin_meninggalkan_atau_keluar_tahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enctahan']=$this->uri->segment('4');
        $data['encpihak']=$this->uri->segment('5');
		$data['curr_date'] = date('d/m/Y');

        $this->load->model('generate_template/m_template_penetapan','template');
		$data['tglPendaftaran']=$this->template->getDataPerkara($idperkara)->row()->tanggal_pendaftaran;
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','19','');
        $this->load->view('generate_template/popup_penetapan_ijin_meninggalkan_atau_keluar_tahanan', $data, FALSE);          
    }

   function cetak_penetapan_ijin_meninggalkan_atau_keluar_tahanan() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encpihak'] = $this->input->post('encpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['encpihak']));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }
        $data['tgl_penetapan'] = $this->input->post('tgl_penetapan',TRUE);

        $this->load->model('generate_template/m_template_penetapan','template');
        $data['datapengadilan'] = $this->template->getDataPN();
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['dataterdakwa'] = $this->template->getDataPihakTerdakwa1($idperkara,$idpihak);
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara,$idpihak);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('111','12','200','19','');
        $this->load->view('generate_template/cetak_penetapan_ijin_meninggalkan_atau_keluar_tahanan',$data,FALSE);
    }   
}
?>