<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Var_template_tun extends CI_Model {    
    
    private $numpang = array();
    
    function __construct() {
        parent::__construct();
        $this->load->model('generate_template/m_new_template_tun','m_new_template');
    }

    function popup($file_name){
        $data['file_name']=$file_name;
        $this->load->vars($data);
        $this->load->view('generate_template/all_template_popup'); 
    }

    function kirim_variabel($data_id){
        $this->numpang=$data_id;
        // zeno fix 7-Feb-2018; menghindari LFI
		$file=preg_replace("/[^a-zA-Z0-9\/\\-\_\.\s]\ /","",urldecode($data_id['source_file']));
		// end zeno fix
        if ($file[0]=='/'){
            $file=substr($data_id['source_file'],1);
        }
        // zeno fix 20-Des-2017; membaca file template dengan absolute path, bukan url file.
		//$source_file = $this->filename_fixed(base_url("resources/template/new_template/".$file));
		$source_file = realpath(__DIR__."/../../../"."/resources/template/new_template/".$file);
		
		// end zeno fix
        $data['target_file']    = 'template_hasil.rtf';
        $data['Template'] = file_get_contents($source_file);
        $variabel   = array('var_general',
                            'var_penetapan',
                            'var_diversi',
                            'var_dismissal',
                            'var_mediasi',
                            'var_bas',
                            'var_penetapan_hari_sidang',
                            'var_jadwal_sidang',
                            'var_keterangan_saksi_adc',
                            'var_putusan_sela',
                            'var_putusan_akhir',
                            'var_pihak',
                            'var_keuangan',
                            'var_putusan_sela',
                            'var_penetapan_persiapan',
                            'var_bukti',
                            'var_data_sidang',
                            'var_biaya',
                            'var_mil',
                            'var_hasil_relaas'
                            );
        // zeno fix 7-Feb-2018; penambahan nama file berdasarkan template
		$tmp = preg_replace("/[^\-\_a-zA-Z0-9\s]/", "", urldecode(pathinfo(basename($file), PATHINFO_FILENAME)));
		$data['variabel'] = $this->get_variabel_and_value($variabel,$data_id);
        $tmp=str_replace('\highlight7','',$tmp.$data['variabel']['#nomor_perkara#']);
        $tmp= preg_replace('/[^a-zA-Z0-9\']/', '_',  $tmp);
        $data['target_file']=str_replace("'","_",trim($tmp)).'_.rtf';
        $this->load->view('generate_template/cetak_new_template.php',$data);
    }

    function filename_fixed($url){
		$parts = parse_url($url);
		$path_parts = array_map('rawurldecode', explode('/', $parts['path']));
		$port = isset($parts['port']) ? ':' . $parts['port'] : '';
		return $parts['scheme'] . '://' . $parts['host'].$port.implode('/', array_map('rawurlencode', $path_parts));
    }

    function get_variabel_and_value($variabel, $data_id){

        if(!empty($variabel)){
            $item=array();
            $item = array_merge($item,$this->replace_awal($data_id)); 
            foreach ($variabel as $key => $value) {
                $item = array_merge($item,$this->$value($data_id));
            }
            //$item = array_merge($item,$this->var_general());
            $field_var = array_keys($item);
            for($i = 0; $i <count($field_var) ; $i++) {
                if($item[$field_var[$i]]==''){
                    $item[$field_var[$i]]='.....';
                }
                $item[$field_var[$i]]='\highlight7 '.$this->templatehelper->cleanHtmlTagSpecial($item[$field_var[$i]]);
            }
            $item = array_merge($item,$this->var_global());
            return $item;
        }  
    }

    function replace_awal(){
        $item['#hari_menerima_putusan#']                = '#hari_menerima_putusan#';
        $item['#tgl_menerima_putusan#']                 = '#tanggal_menerima_putusan#';
        $item['#majelis_hakim#']                        = '#penetapan_majelis#';
        $item['#tanggal_penetapan_pp#']                 = '#tanggal_penetapan_panitera#';
        $item['#tanggal_putus_hijriah#']                = '#tanggal_putusan_hijriah#';
        $item['#tanggal_putus#']                        = '#tanggal_putusan#';
        $item['#hari_putus#']                           = '#hari_putusan#';
        $item['#jabatan_jurusita#']                     = '#jurusita#';
        $item['#hari_putus_sela#']                      = '#hari_putusan_sela#';
        $item['#tanggal_putus_sela#']                   = '#tanggal_putusan_sela#';
        $item['#tanggal_putus_hijriah_sela#']           = '#tanggal_putusan_sela_hijriah#';
        return $item;
    }

    function var_mil($data_id){
        $perkara = $this->m_new_template->get_var_mil();
        if ($perkara->num_rows() == 0 ) $item['__']=":D";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }
        switch ($data_id['pertimbangan1_mil']) {
            case 1:
                $pertimbangan='Bahwa Terdakwa  sudah  bukan lagi menjadi  yustisiabel Pengadilan Militer karena sejak tanggal .......... telah berubah pangkatnya menjadi golongan Perwira Menengah berdasarkan ..........';
                break;
            case 2:
                $pertimbangan='Bahwa Pengadilan Militer tidak berwenang mengadili perkara Terdakwa karena pada waktu tindak pidana dilakukan, Terdakwa tidak termasuk yustisiabel #satker#';
                break;
        }
        switch ($data_id['pertimbangan2_mil']) {
            case 1:
                $pertimbangan='Bahwa   tempat  kejadian  perkara  Terdakwa tidak termasuk wewenang #satker#';
                break;
            case 2:
                $pertimbangan='Bahwa tempat kesatuan Terdakwa tidak termasuk wewenang #satker#';
                break;
            case 3:
                $pertimbangan='Bahwa Terdakwa sudah beralih tugas ke Kesatuan yang berada di daerah hukum Pengadilan Militer .......... berdasarkan surat ..........';
                break;
        }
        if ($data_id['redaksi_bht_mil']==1){
            $redaksi_bht_mil="haknya dalam tenggang waktu 7 (tujuh) hari dihitung mulai hari berikutnya setelah Putusan diucapkan/diberitahukan untuk mencabut pernyataan menerima";
        }else{
            $redaksi_bht_mil="kesempatan berpikir dalam tenggang waktu 7 (tujuh) hari dihitung mulai hari berikutnya setelah Putusan diucapkan/diberitahukan untuk menyatakan menolak";
        }
        switch ($data_id['pernyataan_thd_petikan_terdakwa']) {
            case 1:
                $pernyataan_thd_petikan_terdakwa = 'Menerima putusan.';
                break;
            case 2:
                $pernyataan_thd_petikan_terdakwa = 'Menerima putusan, dengan mengajukan permohonan grasi.';
                break;
            case 3:
                $pernyataan_thd_petikan_terdakwa = 'Mengajukan permohonan banding.';
                break;
            case 4:
                $pernyataan_thd_petikan_terdakwa = 'Mohon waktu untuk berpikir.';
                break;
        }
        switch ($data_id['pernyataan_thd_petikan_oditur']) {
            case 1:
                $pernyataan_thd_petikan_oditur = 'Menerima putusan.';
            break;
            case 2:
                $pernyataan_thd_petikan_oditur = 'Mengajukan permohonan banding.';
                break;
            case 3:
                $pernyataan_thd_petikan_oditur = 'Mohon waktu untuk berpikir.';
                break;
            case 4:
                $pernyataan_thd_petikan_oditur = 'Mengajukan permohonan kasasi.';
                break;
        }
        $tmp=$this->tanggalhelper->convertToMysqlDate($data_id['tanggal']);
        $item['#tgl_pengembalian_berkas_mil#']          = $this->templatehelper->convertKeTglIndo($tmp);
        $item['#tgl_pengembalian_berkas_mil_huruf#']    = $this->templatehelper->getHari($tmp).' tanggal '.$this->templatehelper->Terbilang(substr($tmp, 8,2)).' bulan '.$this->templatehelper->getBulanFull(intval(substr($tmp, 5,2))).' tahun '.$this->templatehelper->Terbilang(substr($tmp, 0,4));
        $item['#pertimbangan_pengembalian_berkas_mil#'] = $pertimbangan;
        $item['#redaksi_bht_mil#']                      = $redaksi_bht_mil;
        $item['#pernyataan_thd_petikan_terdakwa#']      = $pernyataan_thd_petikan_terdakwa;
        $item['#pernyataan_thd_petikan_oditur#']        = $pernyataan_thd_petikan_oditur;
        return $item;
    }

    function var_general ($data_id){
        $var                            = $this->m_new_template->get_var_general($data_id);
        if ($var->num_rows() == 0 )  $var['#variabel_kres#']=":D";
        $item['#satker#']               = ucwords(strtolower($var->result()[0]->satker_kapital));
        if($var->result()[0]->jenis_pengadilan==2){
            $tmp=split(' ', $var->result()[0]->satker_kapital);
            $item['#satker#']=str_replace(ucwords(strtolower($tmp[2])), $tmp[2], $item['#satker#']);
        }
        $item['#nama_kota#']            = ucwords(strtolower($this->templatehelper->namaKota($var->result()[0]->satker_kapital)));
        $item['#nama_kota_kapital#']    = strtoupper($this->templatehelper->namaKota($var->result()[0]->satker_kapital));
        $item['#pengadilan_negeri#']    = ucwords(strtolower($var->result()[0]->pengadilan_negeri_kapital));
        $field_var = array_keys($var->result_array()[0]);
        foreach ($var->result() as $row) {
            for($i = 0; $i <count($field_var) ; $i++) {
                if (!empty($row->$field_var[$i])){
                    $item["#".$field_var[$i]."#"]=$row->$field_var[$i];
                    $this->numpang[$field_var[$i]]=$row->$field_var[$i];
                }else{
                    $item["#".$field_var[$i]."#"]=' ..................... ';    
                }
            }
            
        }
        $item['#jenis_perkara#']        = $item['#jenis_perkara_text#'];
        $perkara                        = $this->m_new_template->get_var_perkara();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
                if (!empty($row->$field_perkara[$i])){
                    $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];    
                    $this->numpang[$field_perkara[$i]]=$row->$field_perkara[$i];
                }else{
                    $item["#".$field_perkara[$i]."#"]=' ................. '; 
                }
            }
            
        }

        if($data_id['ditetapkan_oleh']=="1" || $data_id['ditetapkan_oleh']=="64" ){
            $item['#is_ketua#']               = 'Ketua';
            $item['#is_panitera#']           =  'Panitera';
        }else if ($data_id['ditetapkan_oleh']=="2" || $data_id['ditetapkan_oleh']=="66" ){
            $item['#nama_ketua#']            =  $item["#nama_wakil#"];
            $item['#nama_panitera#']         =  $item["#nama_wapan#"];
            $item['#is_ketua#']              =  'Wakil Ketua';
            $item['#is_panitera#']           =  'Wakil Panitera';
        }else if ($data_id['ditetapkan_oleh']=="3" || $data_id['ditetapkan_oleh']=="68" ){
            $item['#is_panitera#']           =  'Panitera';
        }else if ($data_id['ditetapkan_oleh']=="4" || $data_id['ditetapkan_oleh']=="70" ){
            $item['#nama_panitera#']         =  $item["#nama_wapan#"];
            $item['#is_panitera#']           =  'Wakil Panitera';
        }
        return $item;
    }

    function var_penetapan(){
        $hakim                          = $this->m_new_template->get_var_penetapan_hakim();
        $hakim_lama                     = $this->m_new_template->get_var_penetapan_hakim_lama();
        $panitera                       = $this->m_new_template->get_var_penetapan_panitera();
        $panitera_lama                  = $this->m_new_template->get_var_penetapan_panitera_lama();
        $jurusita                       = $this->m_new_template->get_var_penetapan_jurusita();
        $sidang                         = $this->m_new_template->get_var_penetapan_hari_sidang();
        $data_perlawanan                = $this->m_new_template->get_var_data_perlawanan();
        $jurusita_perlawanan            = $this->m_new_template->get_var_jurusita_plw();
        $hari_sidang_perlawanan         = $this->m_new_template->get_var_penetapan_hari_sidang_verzet();

        if ($hakim->num_rows() == 0 ) $item['#variabel_kres#']="..."; 
        $field_hakim = array_keys($hakim->result_array()[0]);
        $n=0;

        foreach ($jurusita_perlawanan->result() as $row) {
            $item['#nama_jurusita_perlawanan#'] = $row->nama_jurusita;
        }

        foreach ($data_perlawanan->result() as $row) {
            $item['#tgl_surat_perlawanan#'] = $this->templatehelper->convertKeTglIndo($row->tanggal_surat);
            $item['#tgl_daftar_perlawanan#'] = $this->templatehelper->convertKeTglIndo($row->tanggal_pendaftaran_verzet);
            $item['#tanggal_pmh_perlawanan#'] = $this->templatehelper->convertKeTglIndo($row->penetapan_majelis_hakim);
            $item['#tanggal_penetapan_ppjsp_plw#'] = $this->templatehelper->convertKeTglIndo($row->penetapan_panitera_pengganti);
            $item['#tanggal_penetapan_sidang_verzet#'] = $this->templatehelper->convertKeTglIndo($row->tanggal_penetapan_sidang_verzet);
            $item['#tanggal_sidang_pertama_verzet#'] = $this->templatehelper->convertKeTglIndo($row->tanggal_sidang_pertama_verzet);
            $item['#hari_sidang_pertama_perlawanan#']    = $this->templatehelper->getHari($row->tanggal_sidang_pertama_verzet);
            $item['#jam_sidang_pertama_perlawanan#']    = $row->jam_sidang;
        }

        foreach ($hari_sidang_perlawanan->result() as $row){
            $item['#jam_sidang_pertama_perlawanan#']    = $row->jam_sidang;
            $item['#agenda_sidang_perlawanan#']         = $row->agenda;
        }

        foreach ($hakim->result() as $row) {
            if ($row->jabatan_hakim_id=="1"){
                $ketua_majelis = $row->hakim_nama;
            }
            for($i = 0; $i <count($field_hakim) ; $i++) {
                if (!empty($row->$field_hakim[$i])) {
                      $item["#".$field_hakim[$i]."#"] = $row->$field_hakim[$i];    
                }else {
                      $item["#".$field_hakim[$i]."#"] ='..............'; 
                }
            }
           if($row->jabatan_hakim_id==1){
                if($this->numpang['jenis_pengadilan']==4){
                    $penetapan_majelis .= '1. \\tab ';   
                }
                $penetapan_majelis .= $this->templatehelper->standradnaming($row->hakim_nama)." \\tab ";
                if($this->numpang['jenis_pengadilan']==4){
                    $penetapan_majelis .= 'Sebagai Ketua Majelis';   
                }else{
                    $penetapan_majelis .= $row->jabatan_hakim_nama;   
                }
                $penetapan_majelis .= "; \\par ";

                $ketua_majelis = $row->hakim_nama;
                $item['#nrp_hakim_ketua#'] =$row->nip;
                $item['#pangkat_hakim_ketua#'] =$row->pangkat;
            }elseif($row->jabatan_hakim_id==2){
                ++$n;
                $item['#nama_hakim_anggota'.$n.'#'] ='#nama_hakim_anggota_'.$n.'#';
                $item['#hakim_anggota'.$n.'#'] ='#hakim_anggota_'.$n.'#';
                
                $item['#nama_hakim_anggota_'.$n.'#'] =$row->hakim_nama;
                $item['#hakim_anggota_'.$n.'#'] =$row->hakim_nama;
                $item['#nrp_hakim_anggota'.$n.'#'] =$row->nip;
                $item['#pangkat_hakim_anggota'.$n.'#'] =$row->pangkat;

                if($this->numpang['jenis_pengadilan']==4){
                    $penetapan_majelis .= ($n+1).'. \\tab ';   
                }

                $penetapan_majelis .= $this->templatehelper->standradnaming($row->hakim_nama)." \\tab ";
                if($this->numpang['jenis_pengadilan']==4){
                    $penetapan_majelis .= 'Sebagai ';   
                }

                $penetapan_majelis .= $row->jabatan_hakim_nama.";";
                if($n+1<$hakim->num_rows()){
                    $penetapan_majelis .=" \\par ";
                }else{
                    if($this->numpang['jenis_pengadilan']!=4){
                      $penetapan_majelis .=" \\par ";  
                    }
                }
            }elseif($row->jabatan_hakim_id==3){
                $penetapan_majelis .=$this->templatehelper->standradnaming($row->hakim_nama)." \\tab Hakim; \\par ";
                $ketua_majelis = $row->hakim_nama;
            }
           
        }

        $field_hakim_lama = array_keys($hakim_lama->result_array()[0]);
        $n=0;
        foreach ($hakim_lama->result() as $row) {
            for($i = 0; $i <count($field_hakim_lama) ; $i++) {
                if (!empty($row->$field_hakim_lama[$i])) {
                      $item["#".$field_hakim_lama[$i]."#"] = $row->$field_hakim_lama[$i];    
                }else {
                      $item["#".$field_hakim_lama[$i]."#"] ='..............'; 
                }
            }
           if($row->jabatan_hakim_id_lama==1){
                $ketua_majelis_lama = $row->hakim_nama_lama;
            }elseif($row->jabatan_hakim_id_lama==2){
                ++$n;
                $item['#nama_hakim_anggota'.$n.'_lama#'] ='#nama_hakim_anggota_'.$n.'_lama#';
                $item['#hakim_anggota'.$n.'_lama#'] ='#hakim_anggota_'.$n.'_lama#';
                $item['#nama_hakim_anggota_'.$n.'_lama#'] ='#hakim_anggota_'.$n.'_lama#';

                $item['#hakim_anggota_'.$n.'_lama#'] =$row->hakim_nama_lama;
                $item['#nrp_hakim_anggota'.$n.'_lama#'] =$row->nrp_hakim_lama;
                $item['#pangkat_hakim_anggota'.$n.'_lama#'] =$row->pangkat_hakim_lama;
            }elseif($row->jabatan_hakim_id_lama==3){
                $ketua_majelis_lama = $row->hakim_nama_lama;
            }
           
        }

        $field_panitera = array_keys($panitera->result_array()[0]);
        $no=0;
        foreach ($panitera->result() as $row) {
            if($no==0){
                $temp.='';
            }elseif($no==$panitera->num_rows()-1){
                $temp.=' dan ';
            }else{
                $temp.=', ';
            }
            $temp .= $this->templatehelper->standradnaming($row->nama_pp);
            for($i = 0; $i <count($field_panitera) ; $i++) {
              if (!empty($row->$field_panitera[$i])){
                    $item["#".$field_panitera[$i]."#"] = $row->$field_panitera[$i];  
              }else{
                    $item["#".$field_panitera[$i]."#"] ='..............'; 
              }
            }
            $looping_nama_pp_ttd .= $this->templatehelper->standradnaming($row->nama_pp). " \\par \\par \\par ";
            $penetapan_pp .= $this->templatehelper->standradnaming($row->nama_pp)." \\tab Panitera Pengganti; \\par ";
            $no++;
        }
        $penunjukan_pp=$temp.' sebagai Panitera Pengganti';

        $field_panitera_lama = array_keys($panitera_lama->result_array()[0]);
        $no=0;
        foreach ($panitera_lama->result() as $row) {
            for($i = 0; $i <count($field_panitera_lama) ; $i++) {
              if (!empty($row->$field_panitera_lama[$i])){
                    $item["#".$field_panitera_lama[$i]."#"] = $row->$field_panitera_lama[$i];  
              }else{
                    $item["#".$field_panitera_lama[$i]."#"] ='..............'; 
              }
            }
        }

        $field = array_keys($jurusita->result_array()[0]);
        foreach ($jurusita->result() as $row) {
            for($i = 0; $i <count($field) ; $i++) {
              if (!empty($row->$field[$i])){
                    $item["#".$field[$i]."#"] = $row->$field[$i];
                    if(substr($field[$i], 0,4)=='nama'){
                        $item["#".$field[$i]."#"] = $this->templatehelper->standradnaming($row->$field[$i]);
                    }
              }else{
                    $item["#".$field[$i]."#"] ='..............'; 
              }
            }
        }

        $no=0;
        foreach ($jurusita->result() as $row) {
            if($no==0){
                $temp.='';
            }elseif($no==$jurusita->num_rows()-1){
                $temp.=' dan ';
            }else{
                $temp.=', ';
            }
            
            $temp .= $this->templatehelper->standradnaming($row->nama_jurusita);

            if($row->jurusita==1){
                $temp.=' sebagai Jurusita';
            }else{
                $temp.=' sebagai Jurusita Pengganti';
            }
            $no++;
        }      

        $field_sidang = array_keys($sidang->result_array()[0]);
        foreach ($sidang->result() as $row) {
            for($i = 0; $i <count($field_sidang) ; $i++) {
              if (!empty($row->$field_sidang[$i])){
                    $item["#".$field_sidang[$i]."#"] = $row->$field_sidang[$i];  
              }else{
                    $item["#".$field_sidang[$i]."#"] ='..............'; 
              }
            }
        }

        if ($hakim->num_rows()==1 ){  
            $majelis_hakim_atau_hakim = " Hakim ";
            $hakim_ketua_hakim         =" Hakim ";
        }else {  
            $majelis_hakim_atau_hakim = " Majelis Hakim ";
            $hakim_ketua_hakim         =" Hakim Ketua ";
        }

        $item['#hakim_ketua_hakim#']                = $hakim_ketua_hakim;
        $item['#majelis_hakim_atau_hakim#']         = $majelis_hakim_atau_hakim;
        $item['#ketua_majelis#']                    = $ketua_majelis;
        $item['#ketua_majelis_lama#']               = $ketua_majelis_lama;
        $item['#ketua_or_anggota_majelis#']         = $ketua_majelis==$ketua_majelis_lama?'Ketua Majelis':'Hakim Anggota';

        $item['#penetapan_majelis#']                = $penetapan_majelis;
        $item['#looping_majelis#']                  = $penetapan_majelis;
        $item['#panitera#']                         = $item['#jabatan_pp#'];
        $item['#looping_panitera#']                 = ' dan dibantu \\par \\tab #penetapan_pp#';
        $item['#penunjukan_pp#']                    = $penunjukan_pp;
        $item['#penetapan_pp#']                     = $penetapan_pp;
        $item['#looping_nama_pp_ttd#']              = $looping_nama_pp_ttd;
        $item['#penetapan_jaksa#']                  = $this->penetapan_jaksa();
        $item['#penunjukan_jurusita#']              = $temp;
        return $item;
    }

    function var_keterangan_saksi_adc($data_id){
        $data_pihak     = $this->m_new_template->get_var_pihak(5);
        $tanya_jawab    = $this->m_new_template->get_var_keterangan_terdakwa();
        $hakim          = $this->m_new_template->get_var_penetapan_hakim();

        $tmp_pihak="";
        $tmp_penanya="";        
        $no_saksi=0;
        $no_tanya=1;
    
            foreach ($tanya_jawab->result() as $p) {
                if ($tmp_pihak != $p->saksi_id){
                    // $tmp_pihak=$row->pihak_id;
                    $tmp_pihak=$p->saksi_id;
                    $tmp_penanya=$p->penanya_id;
                    $no_saksi++;
                    if($no_saksi>1){
                        $final_adc.=$hakim_tanya_adc.$result_pertanyaan;
                    }

                    $hakim_tanya_adc='';
                    $result_pertanyaan='';
                    foreach ($data_pihak->result() as $row) {
                        if($tmp_pihak==$row->pihak_id){
                            $no_tanya=1;
                            if ($row->umur >= 14){
                                $hakim_tanya_adc = '\\tab Atas pertanyaan Hakim Ketua, Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') memberi jawaban sebagai berikut. \\par '; 
                            }else {
                                $hakim_tanya_adc = '\\tab Atas pertanyaan Hakim Ketua, Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') memberi jawaban sebagai berikut. \\par '; 
                            }
                        }
                    }
                }
                
                if($tmp_penanya!=$p->penanya_id){
                        $no_tanya=1;
                        $final_adc .= $hakim_tanya_adc.$result_pertanyaan;
                        $jumlah_hakim=$hakim->num_rows();
                      
                        $tmp_penanya=$p->penanya_id;
                        if ($p->penanya_id <6 ){
                            $hakim_tanya_adc =  " \\tab Selanjutnya, atas kesempatan yang diberikan Hakim Ketua, Hakim Anggota ". intval($tmp_penanya-1) ." mengajukan pertanyaan dan Saksi menjawab sebagai berikut \\par ";
                        } else if  ($p->penanya_id == 6) {
                            $hakim_tanya_adc =  ' \\tab Selanjutnya, atas kesempatan yang diberikan Hakim Ketua, Penuntut Umum mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';

                        }else if  ($p->penanya_id == 7) {
                             $hakim_tanya_adc =  '\\tab Selanjutnya, atas kesempatan yang diberikan Hakim Ketua, Penasihat Hukum mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';
                        }
                        $result_pertanyaan='';
                }
                // if($p->saksi_id==$row->pihak_id and $tmp_penanya==$p->penanya_id){
                if($tmp_penanya==$p->penanya_id){
                    $tr   = "{ \\trowd\\cellx3870\\cellx7880 "; $tr_e = " \\row }";
                    $td   = "{ \\intbl "; $td_e = " \\cell }";
                    $numb =" \\fi-426 \\li426 \\sa200 \\sl276 ";
                    $result_pertanyaan .= $tr.
                                              $td.$numb.$no_tanya.". \\tab ".$p->pertanyaan.$td_e.
                                              $td.' '.$td_e.
                                          $tr_e.
                                          $tr.
                                              $td.' '.$td_e.
                                              $td.$no_tanya.". ".$p->jawaban.$td_e.
                                          $tr_e;
                    $no_tanya++;
                }
            }
        // }
         $final_adc .= $hakim_tanya_adc.$result_pertanyaan;
         if ($final_adc==''){
            $final_adc=' \\falt ';
         }
      
         $item['#looping_tanya_jawab_saksi_adecharge#']= $final_adc;
         return $item;
    }

    function var_bas($data_id){
        $data_pihak         = $this->m_new_template->get_var_pihak(5);
        $tanya_jawab        = $this->m_new_template->get_var_tanya_jawab_bas();
        $hakim              = $this->m_new_template->get_var_penetapan_hakim();
        $pendapat_terdakwa  = $this->m_new_template->get_var_pendapat_terdakwa();
       
        // echo '<pre>';
        // print_r($data_pihak->result());
        // print_r($tanya_jawab->result());
        // print_r($pendapat_terdakwa->result());exit();
        $tmp_pihak="";
        $tmp_penanya="";        
        $no_saksi=0;
        $no_tanya=1;
        $pendapat="";
            foreach ($tanya_jawab->result() as $p) {
                if ($tmp_pihak != $p->saksi_id){
                    // $tmp_pihak=$row->pihak_id;
                    $tmp_pihak=$p->saksi_id;
                    $tmp_penanya=$p->penanya_id;
                    $no_saksi++;
                    if($no_saksi>1){
                        $final.=$hakim_tanya.$result_pertanyaan.$pendapat;
                    }


                    $hakim_tanya='';
                    $result_pertanyaan='';
                    foreach ($data_pihak->result() as $row) {
                        if($tmp_pihak==$row->pihak_id){
                            $no_tanya=1;
                            if ($row->umur >= 15){
                                 $hakim_tanya = '\\tab Selanjutnya, Hakim Ketua memerintahkan Penuntut Umum menghadirkan Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') di ruang sidang dan atas pertanyaan Hakim Ketua, kemudian Saksi menerangkan: \\par'.
                                              ' nama lengkap '.$this->templatehelper->standradnaming($row->nama).' tempat lahir: '.$row->tempat_lahir.', umur '.$row->umur.' tahun / tanggal lahir '.$row->tanggal_lahir.', jenis kelamin '.$row->jenis_kelamin.', kebangsaan '.$row->warga_negara.' tempat tinggal di '.$row->alamat.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.' \\par '.
                                              '\\tab Atas pertanyaan Hakim Ketua, Saksi menerangkan kenal/tidak kenal  dan tidak/mempunyai  hubungan keluarga sedarah atau semenda, tidak/dalam  ikatan suami istri, dan tidak/terikat  hubungan kerja dengan #terdakwa_para_terdakwa# ; \\par '.
                                            '\\tab Kemudian Saksi mengucapkan sumpah/janji menurut agamanya untuk memberikan keterangan yang benar dan tidak lain daripada yang sebenarnya; \\par '.
                                            'Selanjutnya Hakim Ketua mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par '; 
                            }else {
                                $hakim_tanya = '\\tab Selanjutnya, Hakim Ketua memerintahkan Penuntut Umum menghadirkan Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') di ruang sidang dan atas pertanyaan Hakim Ketua, kemudian Saksi menerangkan: \\par'.
                                          ' nama lengkap '.$this->templatehelper->standradnaming($row->nama).' tempat lahir: '.$row->tempat_lahir.', umur '.$row->umur.' tahun / tanggal lahir '.$row->tanggal_lahir.', jenis kelamin '.$row->jenis_kelamin.', kebangsaan '.$row->warga_negara.' tempat tinggal di '.$row->alamat.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.' \\par '.
                                        ' \\tab Kemudian, Hakim Ketua menerangkan sesuai ketentuan Pasal 171 KUHAP yang tidak boleh memberikan keterangan di bawah sumpah adalah anak yang umurnya belum cukup 15 (lima belas) tahun dan belum pernah kawin , oleh karena itu Saksi akan didengar keterangannya tanpa sumpah; \\par '; 
                            }
                        }
                        foreach ($pendapat_terdakwa->result() as $pt) {
                                $pendapat_loop .= $row->pihak_id.'/'.$pt->saksi_id.'. '.$row->pendapat.' \\par ';
                        }
                        $pendapat = ' Terhadap keterangan Saksi tersebut, Terdakwa/Para Terdakwa  memberikan pendapat ;\\par '.$pendapat_loop;
                    }
                }
                
                if($tmp_penanya!=$p->penanya_id){
                        $no_tanya=1;
                        $final.=$hakim_tanya.$result_pertanyaan;
                        $jumlah_hakim=$hakim->num_rows();
                        if ($p->penanya_id <6 ){
                            if ($tmp_penanya+1 != $p->penanya_id  ){
                                $final .= " \\tab Atas kesempatan yang diberikan Hakim Ketua untuk mengajukan pertanyaan kepada Saksi, Hakim Anggota ". intval($p->penanya_id-2) ." menyatakan cukup; \\par ";
                            }
                        }
                        if ($p->penanya_id ==6 ){
                            for ($i=$tmp_penanya+1; $i <=$jumlah_hakim ; $i++) { 
                                $final .= " \\tab Atas kesempatan yang diberikan Hakim Ketua untuk mengajukan pertanyaan kepada Saksi, Hakim Anggota ". intval($i-1) ." menyatakan cukup; \\par ";
                            }
                        }
                        $tmp_penanya=$p->penanya_id;
                        if ($p->penanya_id <6 ){
                        $hakim_tanya =" \\tab Selanjutnya, atas kesempatan yang diberikan Hakim Ketua, Hakim Anggota ". intval($tmp_penanya) ." mengajukan pertanyaan dan Saksi menjawab sebagai berikut \\par ";
                            
                        } else if  ($p->penanya_id == 6) {
                            $hakim_tanya = ' \\tab Atas kesempatan yang diberikan Hakim Ketua, Penuntut Umum Terdakwa mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';
                        }else if  ($p->penanya_id == 7) {
                             $hakim_tanya = ' \\tab Atas kesempatan yang diberikan Hakim Ketua, Penasihat Hukum Terdakwa mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';
                        }

                       
                        $result_pertanyaan='';
                }
               
                if($tmp_penanya==$p->penanya_id){
                    $tr   = "{ \\trowd\\cellx3870\\cellx7880 "; $tr_e = " \\row }";
                    $td   = "{ \\intbl "; $td_e = " \\cell }";
                    $numb =" \\fi-426 \\li426 \\sa200 \\sl276 ";
                    $result_pertanyaan .= $tr.
                                              $td.$numb.$no_tanya.". \\tab ".$p->pertanyaan.$td_e.
                                              $td.' '.$td_e.
                                          $tr_e.
                                          $tr.
                                              $td.' '.$td_e.
                                              $td.$no_tanya.". ".$p->jawaban.$td_e.
                                          $tr_e;
                    $no_tanya++;
                }
            }
        // }
         $final .=  $hakim_tanya.$result_pertanyaan.$pendapat;
         if ($final==''){
            $final=' \\falt ';
         }
         $item['#keterangan_ph#']   = $data_id['keterangan_ph'];
         $item['#mengerti_dakwaan#'] = $data_id['mengerti_dakwaan'];
         $item['#keterangan_hasil_putusan_sela#']=$data_id['keterangan_hasil_putusan_sela'];

         $item['#looping_tanya_jawab_saksi#']= $final;
         // print_r($final);exit();
         return $item;
    }

    function var_bas_agama($data_id){
        $data_pihak     = $this->m_new_template->get_var_pihak(5);
        $tanya_jawab    = $this->m_new_template->get_var_tanya_jawab_bas();
        $hakim          = $this->m_new_template->get_var_penetapan_hakim();
        // echo '<pre>';
        // print_r($hakim->num_rows());exit();
        $tmp_pihak="";
        $tmp_penanya="";        
        $no_saksi=0;
        $no_tanya=1;
    
            foreach ($tanya_jawab->result() as $p) {
                if ($tmp_pihak != $p->saksi_id){
                    // $tmp_pihak=$row->pihak_id;
                    $tmp_pihak=$p->saksi_id;
                    $tmp_penanya=$p->penanya_id;
                    $no_saksi++;
                    if($no_saksi>1){
                        $final.=$hakim_tanya.$result_pertanyaan;
                    }
                    $hakim_tanya='';
                    $result_pertanyaan='';
                    foreach ($data_pihak->result() as $row) {
                        if($tmp_pihak==$row->pihak_id){
                            $no_tanya=1;
                            if ($row->umur >= 14){
                                 $hakim_tanya = '\\tab Selanjutnya, Hakim Ketua memerintahkan Penuntut Umum menghadirkan Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') di ruang sidang dan atas pertanyaan Hakim Ketua, kemudian Saksi menerangkan: \\par'.
                                              ' nama lengkap '.$this->templatehelper->standradnaming($row->nama).' tempat lahir: '.$row->tempat_lahir.', umur '.$row->umur.' tahun / tanggal lahir '.$row->tanggal_lahir.', jenis kelamin '.$row->jenis_kelamin.', kebangsaan '.$row->warga_negara.' tempat tinggal di '.$row->alamat.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.' \\par '.
                                              'Atas pertanyaan Hakim Ketua, Saksi menerangkan kenal/tidak kenal  dan tidak/mempunyai  hubungan keluarga sedarah atau semenda, tidak/dalam  ikatan suami istri, dan tidak/terikat  hubungan kerja dengan #terdakwa_para_terdakwa# ; \\par '.
                                            'Kemudian Saksi mengucapkan sumpah/janji menurut agamanya untuk memberikan keterangan yang benar dan tidak lain daripada yang sebenarnya; \\par '.
                                            'Selanjutnya Hakim Ketua mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par '; 
                            }else {
                                $hakim_tanya = '\\tab Selanjutnya, Hakim Ketua memerintahkan Penuntut Umum menghadirkan Saksi ke-'.$no_saksi.' (ke '.$this->templatehelper->Terbilang($no_saksi).') di ruang sidang dan atas pertanyaan Hakim Ketua, kemudian Saksi menerangkan: \\par'.
                                          ' nama lengkap '.$this->templatehelper->standradnaming($row->nama).' tempat lahir: '.$row->tempat_lahir.', umur '.$row->umur.' tahun / tanggal lahir '.$row->tanggal_lahir.', jenis kelamin '.$row->jenis_kelamin.', kebangsaan '.$row->warga_negara.' tempat tinggal di '.$row->alamat.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.' \\par '.
                                        'Kemudian, Hakim Ketua menerangkan sesuai ketentuan Pasal 171 KUHAP yang tidak boleh memberikan keterangan di bawah sumpah adalah anak yang umurnya belum cukup 15 (lima belas) tahun dan belum pernah kawin , oleh karena itu Saksi akan didengar keterangannya tanpa sumpah; \\par '; 
                            }
                        }
                    }
                }
                
                if($tmp_penanya!=$p->penanya_id){
                        $no_tanya=1;
                        $final.=$hakim_tanya.$result_pertanyaan;
                        $jumlah_hakim=$hakim->num_rows();
                        if ($p->penanya_id <6 ){
                            if ($tmp_penanya+1 != $p->penanya_id  ){
                                $final .= "Atas kesempatan yang diberikan Hakim Ketua untuk mengajukan pertanyaan kepada Saksi, Hakim Anggota ". intval($p->penanya_id-2) ." menyatakan cukup; \\par ";
                            }
                        }
                        if ($p->penanya_id ==6 ){
                            for ($i=$tmp_penanya+1; $i <=$jumlah_hakim ; $i++) { 
                                $final .= "Atas kesempatan yang diberikan Hakim Ketua untuk mengajukan pertanyaan kepada Saksi, Hakim Anggota ". intval($i-1) ." menyatakan cukup; \\par ";
                            }
                        }
                        $tmp_penanya=$p->penanya_id;
                        if ($p->penanya_id <6 ){
                        $hakim_tanya =" Selanjutnya, atas kesempatan yang diberikan Hakim Ketua, Hakim Anggota ". intval($tmp_penanya-1) ." mengajukan pertanyaan dan Saksi menjawab sebagai berikut \\par ";
                            
                        } else if  ($p->penanya_id == 6) {
                            $hakim_tanya = ' Atas kesempatan yang diberikan Hakim Ketua, Penuntut Umum Terdakwa mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';
                        }else if  ($p->penanya_id == 7) {
                             $hakim_tanya = ' Atas kesempatan yang diberikan Hakim Ketua, Penasihat Hukum Terdakwa mengajukan pertanyaan dan Saksi menjawab sebagai berikut. \\par ';
                        }
                        $result_pertanyaan='';
                }
                // if($p->saksi_id==$row->pihak_id and $tmp_penanya==$p->penanya_id){
                if($tmp_penanya==$p->penanya_id){
                    $tr   = "{ \\trowd\\cellx3870\\cellx7880 "; $tr_e = " \\row }";
                    $td   = "{ \\intbl "; $td_e = " \\cell }";
                    $numb =" \\fi-426 \\li426 \\sa200 \\sl276 ";
                    $result_pertanyaan .= $tr.
                                              $td.$numb.$no_tanya.". \\tab ".$p->pertanyaan.$td_e.
                                              $td.' '.$td_e.
                                          $tr_e.
                                          $tr.
                                              $td.' '.$td_e.
                                              $td.$no_tanya.". ".$p->jawaban.$td_e.
                                          $tr_e;
                    $no_tanya++;
                }
            }
        // }
         $final .=  $hakim_tanya.$result_pertanyaan;
         if ($final==''){
            $final=' \\falt ';
         }
         $item['#keterangan_ph#']   = $data_id['keterangan_ph'];
         $item['#mengerti_dakwaan#'] = $data_id['mengerti_dakwaan'];
         $item['#keterangan_hasil_putusan_sela#']=$data_id['keterangan_hasil_putusan_sela'];
         $item['#looping_tanya_jawab_saksi#']= $final;
         // print_r($final);exit();
         return $item;
    }


    function var_diversi(){
         $item['------ diversi --------- ']="";
         return $item;
    }


    function var_bukti(){
        $barbuk = $this->m_new_template->get_var_bukti();
        if ($barbuk->num_rows() > 0 ) {
            $redaksi=' \\par \\tab Kemudian Hakim Ketua memerintahkan kepada Penuntut Umum untuk mengajukan barang bukti di sidang  sebagai berikut : \\par ';
            $barang_bukti= $barbuk->result()[0]->jenis_barang_bukti;
        }else{
            $redaksi=' \\falt ';
            $barang_bukti=' \\falt ';
        }

        $item['#keterangan_barang_bukti#'] = $redaksi.$barang_bukti;
        $item['#barang_bukti']=$barang_bukti;
        return $item;
    }

    function var_data_sidang(){
        $perkara = $this->m_new_template->get_var_data_sidang();
        // print_r($perkara->result());exit();
        foreach ($perkara->result() as $row) {
            if ($row->uraian==''){
                $item["#".$row->nama_kolom."#"]='';
            }else{
                $item["#".$row->nama_kolom."#"]=$this->templatehelper->cleanHtmlTagSpecial($row->uraian).';';
            }
        }
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        return $item;
    }

    function var_hasil_relaas(){
        $perkara = $this->m_new_template->get_var_hasil_relaas();
        // print_r($perkara->result());exit();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        foreach ($perkara->result() as $row) {
            $item["#tanggal_relaas_".$row->pihak_ke."#"]=$row->tanggal_relaas;
        }
        // print_r($item);exit();
        return $item;
    }


    function var_dismissal(){
        $perkara = $this->m_new_template->get_var_dismissal();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }

        $perkara = $this->m_new_template->get_var_jadwal_dismissal();
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }
        return $item;
    }

    function var_penetapan_persiapan(){
        $perkara = $this->m_new_template->get_var_penetapan_persiapan();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }

        $perkara = $this->m_new_template->get_var_penetapan_persiapan_proses();
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }
        return $item;
    }

    function var_mediasi(){
       $item['------ medi asi --------- ']="";
        return $item;
    }



    function var_jadwal_sidang(){
        $perkara = $this->m_new_template->get_var_jadwal_sidang();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
                $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
                if(substr($field_perkara[$i], 0,5)=='ruang'){
                        $item["#".$field_perkara[$i]."#"] = $this->templatehelper->standradnaming($row->$field_perkara[$i]);
                }
            }
            
        }
        return $item;
    }
    
    function var_penetapan_hari_sidang(){
        $perkara = $this->m_new_template->get_var_penetapan_hari_sidang();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
            }
            
        }
        $item['#tanggal_penetapan_phs#']=$item['#tanggal_phs#'];
        return $item;
    }

    public function var_ikrar_talak(){
        $var = $this->m_new_template->get_var_ikrar_talak();
        if ($var->num_rows() == 0 )  $var['#variabel_kres#']=":D";
        $field_var = array_keys($var->result_array()[0]);
        foreach ($var->result() as $row) {
            for($i = 0; $i <count($field_var) ; $i++) {
                if (!empty($row->$field_var[$i]))
                    $item["#".$field_var[$i]."#"]=$row->$field_var[$i];    
                else
                    $item["#".$field_var[$i]."#"]='..............';    
            }
            
        }
        return $item;
    }

    function var_putusan_sela(){
        $perkara = $this->m_new_template->get_var_putusan_sela();
        if ($perkara->num_rows() == 0 ){
            $item['#variabel_kres#']="ga ada datanya";
            $item['#putusan_sela#']='';
        }else{
            $putusan_sela = $perkara->result();
            $redaksi=" Menimbang, bahwa terhadap dakwaan Penuntut Umum, #terdakwa_para_terdakwa# dan atau Penasihat Hukum #terdakwa_para_terdakwa# telah mengajukan keberatan dan telah diputus dengan Putusan Sela Nomor ".$putusan_sela[0]->tanggal_putusan_sela." tanggal ".$putusan_sela[0]->tanggal_putusan_sela." yang amarnya sebagai berikut: \\par".
            $putusan_sela[0]->amar_putusan_sela;
            $item['#putusan_sela#']=$redaksi;
        }
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              if (!empty($row->$field_perkara[$i]))
                    $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];    
                else
                    $item["#".$field_perkara[$i]."#"]='..............'; 
            }
            
        }
        $item["#tanggal_putusan_sela_hijriah#"]=$this->templatehelper->convertToHijriah($item["#tanggal_putusan_sela_hijriah#"]);
        return $item;
    }

    function var_putusan_akhir($data_id){
        $jenisdakwaan=($data_id['jenis_dakwaan']);

        $perkara = $this->m_new_template->get_var_putusan_akhir();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              if (!empty($row->$field_perkara[$i])){
                    $item["#".$field_perkara[$i]."#"]=$row->$field_perkara[$i];
                    $this->numpang[$field_perkara[$i]]=$row->$field_perkara[$i];    
                }else{
                    $item["#".$field_perkara[$i]."#"]='..............'; 
                }
            }
            
        }
        $item['#jenis_dakwaan#']=$this->jenis_dakwaan($jenisdakwaan);
        $item["#tanggal_putusan_hijriah#"]=$this->templatehelper->convertToHijriah($item["#tanggal_putusan_hijriah#"]);
        return $item;
    }

    function jenis_dakwaan($jenisdakwaan){
        switch ($jenisdakwaan) {
                    case 1: 
                        $isi_jenis_dakwaan ='\b DAKWAAN TUNGGAL\b0\\par Menimbang, bahwa #terdakwa_para_terdakwa# telah didakwa oleh Penuntut Umum dengan dakwaan tunggal sebagaimana diatur dalam Pasal  .............., yang unsur-unsurnya adalah sebagai berikut :\\par
                1. ................ \\par
                2. ................ \\par
                3. ................, dst. \\par Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim# mempertimbangkan sebagai berikut: \\par 
                Ad.1. .................. \\par
                Ad.2. .................. \\par
                Ad.3. .................., dst. \\par Menimbang, bahwa oleh karena salah satu unsur dari Pasal ............. tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan tunggal, sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut; \\par
                Menimbang, bahwa .............; (apabila diperlukan tanggapi pembelaan penasihat hukum dan/atau tuntutan penuntut umum)                         
                        ';
                    break;
                    case 2: 
                        $isi_jenis_dakwaan ='\b DAKWAAN ALTERNATIF \b0 \\par
                Menimbang, bahwa #terdakwa_para_terdakwa# telah didakwa oleh Penuntut Umum dengan dakwaan yang berbentuk alternatif, sehingga #majelis_hakim_atau_hakim# dengan memperhatikan fakta-fakta hukum tersebut diatas mempertimbangkan terlebih dahulu dakwaan alternatif ke ............. sebagaimana diatur dalam Pasal  ............., yang unsur-unsurnya adalah sebagai berikut : \\par 
                1. ................ \\par
                2. ................ \\par
                3. ................, dst. \\par Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim_atau_hakim# mempertimbangkan sebagai berikut: \\par
                Ad.1. .................. \\par
                Ad.2. .................. \\par
                Ad.3. .................., dst. \\par Menimbang, bahwa oleh karena salah satu unsur dari Pasal ......................... tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan alternatif ke ............... sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut; \\par
                Menimbang, bahwa oleh karena dakwaan alternatif ke ............. (yang sudah dipertimbangkan)* tidak terbukti, #majelis_hakim_atau_hakim# mempertimbangkan dakwaan alternatif ke ..........  (yang belum dipertimbangkan)* sebagaimana diatur dalam Pasal .............., yang unsur-unsurnya adalah sebagai berikut: \\par
                1. ................ \\par
                2. ................ \\par
                3. ................, dst. \\par Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim_atau_hakim# mempertimbangkan sebagai berikut: \\par
                Ad.1. .................. \\par
                Ad.2. .................. \\par
                Ad.3. .................., dst. \\par Menimbang, bahwa oleh karena salah satu unsur dari Pasal ............... tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan alternatif ke ............. sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut;
                (apabila dakwaan alternatif lebih dari dua selanjutnya akan dipertimbangkan sebagaimana diatas)*
                ';
                    break;
                    case 3:
                        $isi_jenis_dakwaan ='\b DAKWAAN SUBSIDERITAS \b0 \\par
                Menimbang, bahwa #terdakwa_para_terdakwa# telah didakwa oleh Penuntut Umum dengan dakwaan subsideritas, maka #majelis_hakim_atau_hakim# terlebih dahulu mempertimbangkan dakwaan primer sebagaimana diatur dalam Pasal  ............., yang unsur-unsurnya adalah sebagai berikut: \\par 
                1.  ............. \\par
                2.  ............. \\par
                3.  ............., dst. \\par
                Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim_atau_hakim# mempertimbangkan sebagai berikut: \\par
                Ad.1. ............. \\par
                Ad.2. ............. \\par
                Ad.3. ............., dst. \\par
                Menimbang, bahwa oleh karena salah satu unsur dari Pasal ............. tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan primer, sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut; \\par
                (jika dakwaan primer tidak terbukti, selanjutnya pertimbangkan dakwaan subsider dan seterusnya)* \\par
                Menimbang, bahwa .............; (apabila diperlukan tanggapi pembelaan penasihat hukum dan/atau tuntutan penuntut umum) \\par
                ';
                    break;
                    case 4: 
                        $isi_jenis_dakwaan ='\b DAKWAAN KUMULATIF \b0 \\par 
                Menimbang, bahwa #terdakwa_para_terdakwa# telah didakwa oleh Penuntut Umum dengan dakwaan kumulatif, maka #majelis_hakim_atau_hakim# terlebih dahulu mempertimbangkan dakwaan kesatu/pertama sebagaimana diatur dalam Pasal  ............., yang unsur-unsurnya adalah sebagai berikut: \\par 
                1.  ............. \\par
                2.  ............. \\par
                3.  ............., dst. \\par
                Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim_atau_hakim# mempertimbangkan sebagai berikut: \\par
                Ad.1. ............. \\par
                Ad.2. ............. \\par
                Ad.3. ............., dst. \\par
                Menimbang, bahwa oleh karena salah satu unsur dari Pasal ............. tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan kesatu/pertama, sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut; \\par 
                Menimbang, bahwa oleh karena dakwaan Penuntut Umum disusun secara kumulatif maka selanjutnya #majelis_hakim_atau_hakim# mempertimbangkan dakwaan kedua sebagaimana diatur dalam Pasal  ............., yang unsur- unsurnya adalah sebagai berikut: \\par
                1.  ............. \\par
                2.  ............. \\par
                3.  ............., dst. \\par
                Menimbang, bahwa terhadap unsur-unsur tersebut #majelis_hakim_atau_hakim# mempertimbangkan sebagai berikut: \\par
                Ad.1. ............. \\par
                Ad.2. ............. \\par
                Ad.3. ............., dst. \\par
                Menimbang, bahwa oleh karena salah satu unsur dari Pasal ............. tidak terpenuhi, maka #terdakwa_para_terdakwa# haruslah dinyatakan tidak terbukti secara sah dan meyakinkan melakukan tindak pidana sebagaimana didakwakan dalam dakwaan kedua, sehingga #terdakwa_para_terdakwa# haruslah dibebaskan dari dakwaan tersebut; \\par
                (dipertimbangkan lebih lanjut apabila ada dakwaan kumulatif ketiga dst)* \\par
                Menimbang, bahwa .............; (apabila diperlukan tanggapi pembelaan penasihat hukum dan/atau tuntutan penuntut umum) \\par
                ';
                    break;
                    case 5: 
                        $isi_jenis_dakwaan ='\b DAKWAAN GABUNGAN \b0 \\par
                (untuk dakwaan gabungan, dipertimbangkan dengan memperhatikan pertimbangan dakwaan alternatif, subsideritas dan kumulatif tersebut diatas)\\par
                Menimbang, bahwa .............; (apabila diperlukan tanggapi pembelaan penasihat hukum dan/atau tuntutan penuntut umum)\\par
                ';
                    break;
                }
                return  $isi_jenis_dakwaan;

    }

    function var_pihak(){
        $item = array();
        for ($i=1; $i <=5 ; $i++) { 
            $item = array_merge($item,$this->looping_pihak($i));
            $item = array_merge($item,$this->looping_pihak_dkk($i));
            $item = array_merge($item,$this->looping_nama_pihak($i));
            $item = array_merge($item,$this->looping_pihak_tt($i));
        }
        $item = array_merge($item,$this->get_terdakwa());
        $item = array_merge($item,$this->looping_terdakwa_dkk());
        $item = array_merge($item,$this->looping_terdakwa());    
        $item = array_merge($item,$this->looping_prapid(1));
        $item = array_merge($item,$this->looping_prapid(2));
        $item = array_merge($item,$this->var_pihak_tok());
        $item = array_merge($item,$this->terdakwa_mil());
        $item['#is_kuasa_pihak2#']            = '';
        $item['#is_kuasa_pihak1#']            = '';
        return $item;
    }

    function var_keuangan(){
       $item['------ keuangan --------- ']="";
         return $item;
    }
    
    function var_global($data_id){
        $tmp=$this->numpang['alur_perkara_id'];
        switch (true) {
            case ($tmp==15 || $tmp==9 || $tmp==1 || $tmp==7 || $tmp==8):
                $tmp1=' Penggugat';
                $tmp2=' Tergugat';
                if($this->numpang['jenis_perkara_id']==346){
                    $tmp1=' Pemohon';
                    $tmp2=' Termohon';
                }
                break;

            case ($tmp==16 || $tmp==10 || ($tmp>=2 && $tmp<=6)):
                $tmp1=' Pemohon';
                $tmp2=' Termohon';
                break;

            case ($tmp==16 || $tmp==11):
                $tmp1=' Pemohon Keberatan';
                $tmp2=' Termohon Keberatan';
                break;
            default:
                $tmp1=' Pemohon';
                $tmp2=' Termohon';
                break;
        }

        $item["#SEBAGAI_PIHAK1#"]   = strtoupper($tmp1);
        $item["#sebagai_pihak1#"]   = $tmp1;
        $item["#SEBAGAI_P#"]        = strtoupper($tmp1);
        $item["#sebagai_p#"]        = $tmp1;
        $item["#SEBAGAI_PIHAK2#"]   = strtoupper($tmp2);
        $item["#sebagai_pihak2#"]   = $tmp2;
        $item["#SEBAGAI_T#"]        = strtoupper($tmp2);
        $item["#sebagai_t#"]        = $tmp2;
        return $item;    
    }

    function penetapan_jaksa($var){
        $dataPihak = $this->m_new_template->get_var_pihak(1);    
        foreach($dataPihak->result() as $row){
            $jaksa .= $this->templatehelper->standradnaming($row->nama)." "." \\tab ".$row->pekerjaan." \\par ";
        }
        return $jaksa;

    }

    function get_terdakwa(){
        $dataPihak = $this->m_new_template->get_var_pihak(2);
        if ($dataPihak->num_rows > 1 ) {
            $para_or_terdakwa=" Para Terdakwa ";
            $dkk=" Dkk ";
        } else {
            $para_or_terdakwa=" Terdakwa ";
            $dkk=" ";
        }    
        
        $terdakwa_dkk = $this->templatehelper->standradnaming($dataPihak->result()[0]->nama)." ".$dkk;
        $item['#terdakwa_dkk#'] = $terdakwa_dkk;
        $item['#terdakwa_para_terdakwa#'] =  $para_or_terdakwa;
        return $item;
    }

    function looping_terdakwa(){
    	$no_terdakwa=1;
        $dataterdakwa = $this->m_new_template->get_var_pihak(2);
        
        if($dataterdakwa->num_rows > 1){
           $no=1;     
        }else{
           $no=" ";
        }
            foreach ($dataterdakwa->result() as $row){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = $this->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = $row->tempat_lahir;   
                
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = $this->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = $row->alamat;

                    if(empty($row->agama)){
                        $row->agama = '......'; 
                    }
                    $agama = $this->templatehelper->standradnaming($row->agama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = $this->templatehelper->standradnaming($row->pekerjaan);
                    
                    // fix zeno 05Jan2018
					// result query jenis_kelamin sudah lengkap
					if ( strtolower($row->jenis_kelamin) == 'p' || strtolower($row->jenis_kelamin) == 'perempuan') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
					// end fix zeno
                    $identitas .= $this->templatehelper->converToAngkaRomawi($no)." ".
                                             'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '. 
                                             'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                                             'Umur/tanggal lahir    \\tab :\\tab '.$row->umur.' Tahun / '.$row->tgllahir.'; \\par '.
                                             'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                                             'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                                             'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                                             'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                                             'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';
                    $identitas_mil .= 
                            'Nama lengkap \\tab :\\tab '.$namaterdakwa.'; \\par '.
                            'Pangkat/NRP \\tab :\\tab '.$row->pangkat.'/'.$row->nrp.'; \\par '.
                            'Jabatan \\tab :\\tab '.$row->jabatan.'; \\par '.
                            'Kesatuan \\tab :\\tab '.$row->kesatuan.'; \\par '.
                            'Tempat, Tanggal Lahir \\tab :\\tab '.$row->tempat_lahir.', '.$row->tanggal_lahir.'; \\par '.
                            'Jenis Kelamin \\tab :\\tab '.$sex.'; \\par '.
                            'Kewarganegaraan \\tab :\\tab '.$row->warga_negara.'; \\par '.
                            'Agama \\tab :\\tab '.$row->agama.'; \\par '.
                            'Tempat Tinggal \\tab :\\tab '.$alamat.'; \\par ';
                    $terdakwa_nama .= $this->templatehelper->converToAngkaRomawi($no)." \\tab ".$namaterdakwa;
                    if($no>1){
                        $nama_terdakwa_mil .= ', ';    
                    }
                    $nama_terdakwa_mil .= $this->templatehelper->standradnaming($row->nama).' '.$row->pangkat.' NRP. '.$row->nrp;
                    $penahanan = $this->m_new_template->get_var_penahanan();
                    $perkara   = $this->m_new_template->get_var_perkara()->result_object();
			        if ($penahanan->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
			        foreach ($penahanan->result() as $p) {
			        	if ($p->pihak_id==$row->pihak_id){
			        		 if ($p->pihak_id!= $tmp_pihak){
                                if ($perkara[0]->alur_perkara_id == 118){
                                    $jenis_terdakwa="Anak ";
                                }else{
                                    $jenis_terdakwa="Terdakwa ";
                                }
                                 $b = $jenis_terdakwa.$this->templatehelper->converToAngkaRomawi($no).' ditahan dalam '.$p->jenis_tahanan.', oleh : \\par ';
				        	 }else{
				        	 	$b='';
				        	 }
                             if($this->numpang['jenis_pengadilan']==2){
                                $mil = ' selaku ';
                             }
				        	 $tmp_pihak=$row->pihak_id;
				             $val .= $b.$no_terdakwa.'. '.$mil. $p->jenis_penahanan.' sejak tanggal '.$p->mulai_ditahan.' sampai dengan tanggal '.$p->sampai_ditahan.' \\par ';
                    		 $no_terdakwa++;
						}else{
							  $no_terdakwa=1;
						}
						$item['#hadap_hadir#']=$p->hadap_hadir;			              
			        }
			        
                    $no++;
            }
            if($this->numpang['jenis_pengadilan']==2){
                $identitas=$identitas_mil;
            }
			$item['#looping_penahanan#'] = $val;
            $item['#looping_terdakwa#']  = $identitas;
            $item['#looping_terdakwa_nama#']  = $terdakwa_nama;
            $item['#looping_nama_terdakwa_mil#']  = $nama_terdakwa_mil;
            return $item;
    }

    
    function looping_terdakwa_dkk(){ 
        $counter = 1;
        $dataterdakwa = $this->m_new_template->get_var_pihak(2);
        if($dataterdakwa->num_rows > 0){
            $dkk='; Dan kawan-kawan';
        }else{
            $dkk='';
        }
        foreach ($dataterdakwa->result() as $row){
                if($counter==1){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = $this->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = $row->tempat_lahir;   
                    if(empty($row->tanggal_lahir) OR $row->tanggal_lahir==NULL){
                        $tgllahir="................";
                        $umur=".............";
                    }else{
                        $tgllahir = ' '.$row->hari_lahir." ".$this->templatehelper->convertKeTglIndo($row->tanggal_lahir);
                        $umur = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
                    }
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = $this->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = $row->alamat;

                    if(empty($row->agama)){
                        $row->agama = '......'; 
                    }
                    $agama = $this->templatehelper->standradnaming($row->agama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = $this->templatehelper->standradnaming($row->pekerjaan);
                    
                     // fix zeno 05Jan2018
					// result query jenis_kelamin sudah lengkap
					if ( strtolower($row->jenis_kelamin) == 'p' || strtolower($row->jenis_kelamin) == 'perempuan') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
					// end fix zeno
                }
                $counter++;
            }

            $namaKejaksaan =  ((!empty($namaKejaksaan)) ? $this->templatehelper->standradnaming($namaKejaksaan) : 'Kejaksaan ...........' );
            $identitas = 'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '.
                         'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                         'Umur/tanggal lahir    \\tab :\\tab '.$umur.' Tahun / '.$tgllahir.'; \\par '.
                         'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                         'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                         'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                         'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                         'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';

            $item['#looping_terdakwa_dkk#'] = $identitas;
            return $item;
    }

    function looping_prapid($pihak_ke){ 
        $counter = 1;
        $dataterdakwa = $this->m_new_template->get_var_pihak($pihak_ke);
        if($dataterdakwa->num_rows > 1){
            $dkk='; Dan kawan-kawan';
            $lawan='Lawan:';
        }else{
            $dkk='';
            $lawan='Lawan';
        }
        foreach ($dataterdakwa->result() as $row){
                if($counter==1){
                    if(empty($row->nama)){
                        $row->nama = '......'; 
                    }

                    $namaterdakwa = $this->templatehelper->standradnaming($row->nama);

                    if(empty($row->tempat_lahir)){
                        $row->tempat_lahir = '......'; 
                    }

                    $tempatlahir = $row->tempat_lahir;   
                    if(empty($row->tanggal_lahir) OR $row->tanggal_lahir==NULL){
                        $tgllahir="................";
                        $umur=".............";
                    }else{
                        $tgllahir = ' '.$row->hari_lahir." ".$this->templatehelper->convertKeTglIndo($row->tanggal_lahir);
                        $umur = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
                    }
                    

                    if(empty($row->warga_negara)){
                        $row->warga_negara = '......'; 
                    }

                    $kebangsaan = $this->templatehelper->standradnaming($row->warga_negara);

                    if(empty($row->alamat)){
                        $row->alamat = '......'; 
                    }
                    $alamat = $row->alamat;

                    if(empty($row->agama)){
                        $row->agama = '......'; 
                    }
                    $agama = $this->templatehelper->standradnaming($row->agama);
                    
                    if(empty($row->pekerjaan)){
                        $row->pekerjaan = '......'; 
                    }

                    $pekerjaan = $this->templatehelper->standradnaming($row->pekerjaan);
                    
                     // fix zeno 05Jan2018
					// result query jenis_kelamin sudah lengkap
					if ( strtolower($row->jenis_kelamin) == 'p' || strtolower($row->jenis_kelamin) == 'perempuan') {
                        $sex = 'Perempuan';
                    } else{
                        $sex = 'Laki-laki';
                    }
					// end fix zeno
                }
                $counter++;
            }

            $namaKejaksaan =  ((!empty($namaKejaksaan)) ? $this->templatehelper->standradnaming($namaKejaksaan) : 'Kejaksaan ...........' );
            if ($pihak==1){
                $identitas = 'Nama lengkap          \\tab :\\tab '.$namaterdakwa.$dkk.'; \\par '.
                             'Tempat lahir          \\tab :\\tab '.$tempatlahir.'; \\par '.
                             'Umur/tanggal lahir    \\tab :\\tab '.$umur.' Tahun / '.$tgllahir.'; \\par '.
                             'Jenis Kelamin         \\tab :\\tab '.$sex.'; \\par '.
                             'Kebangsaan            \\tab :\\tab '.$kebangsaan.'; \\par '.
                             'Tempat tinggal        \\tab :\\tab '.$alamat.'; \\par '.
                             'Agama                 \\tab :\\tab '.$agama.'; \\par '.
                             'Pekerjaan             \\tab :\\tab '.$pekerjaan.'; \\par ';

            }else{
                $identitas = ' '.$namaterdakwa.$dkk.', beralamat di '.$alamat.' ; \\par ';
            }
            if ($pihak_ke==1) {
            	$item ['#pemohon_prapid#']             =  $identitas;
            } else {
            	$item ['#termohon_prapid#']             =  $identitas;
            }
            return $item;
    }

    function looping_pihak_dkk($pihak_ke=1){
        $perkara = $this->m_new_template->get_var_pihak_dkk();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              if (!empty($row->$field_perkara[$i]))
                    $item["#".$field_perkara[$i]."#"]=$this->templatehelper->standradnaming($row->$field_perkara[$i]).';';    
                else
                    $item["#".$field_perkara[$i]."#"]='..............'; 
            }
            
        }
        return $item;
    }   

    function var_pihak_tok(){
        $perkara = $this->m_new_template->get_var_pihak_tok();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field) ; $i++) {
              if (!empty($row->$field[$i])){
                    $item["#".$field[$i]."#"]=$row->$field[$i];
                    if(substr($field[$i], 0,4)=='nama'){
                        $item["#".$field[$i]."#"] = $this->templatehelper->standradnaming($row->$field[$i]);
                    }
                    $item["#".strtoupper($field[$i])."#"]=strtoupper($row->$field[$i]);
                }else{
                    $item["#".$field[$i]."#"]='..............'; 
                }
            }
            
        }
        return $item;
    } 


    function looping_pihak_tt($pihak_ke=1){
         $dataPihak = $this->m_new_template->get_var_pihak($pihak_ke);
        switch ($pihak_ke) {
                case '1':
                    $sebagai="#sebagai_p#";
                    break;
                case '2':
                    $sebagai="#sebagai_t#";
                    break;
                default:
                    # code...
                    break;
            }
       $no=0;
        $pihak_array='';
        if($dataPihak->num_rows>0){
            foreach ($dataPihak->result() as $row) {
                if ($dataPihak->num_rows()<=1){
                        $pihak_array.=' '.$this->templatehelper->standradnaming($row->nama).' \\par \\par \\par \\par';  
                }else{
                        $pihak_array.=' '.++$no.'. '.$row->nama.' \\par \\par \\par \\par';  
                }
            }
        }else{
            $pihak_array = "Data Pihak Tidak Ada dalam Database!!!";
        }
        $item['#looping_pihak1_tt#'] = $pihak_array;
        return $item;
    }

    function terdakwa_mil(){
        $perkara = $this->m_new_template->get_var_pihak(2);
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field = array_keys($perkara->result_array()[0]);
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field) ; $i++) {
              if (!empty($row->$field[$i])){
                    $item["#".$field[$i]."_terdakwa#"]=$row->$field[$i];
                    if(substr($field[$i], 0,4)=='nama'){
                        $item["#".$field[$i]."_terdakwa#"] = $this->templatehelper->standradnaming($row->$field[$i]);
                    }
                }else{
                    $item["#".$field[$i]."#"]='..............'; 
                }
            }
            
        }
        // print_r($perkara);exit();
        return  $item;
    }

    function looping_pihak($pihak_ke){
            $dataPihak = $this->m_new_template->get_var_pihak($pihak_ke);
            $data_pihak_relaas = $this->m_new_template->get_var_pihak($pihak_ke,1);
            $data_kuasa = $this->m_new_template->get_var_kuasa($pihak_ke);
            switch ($pihak_ke) {
                case '1':
                    $sebagai="#SEBAGAI_P#";
                    break;
                case '2':
                    $sebagai="#SEBAGAI_T#";
                    break;
            }
            if($this->numpang['jenis_pengadilan']==4){
                $sebagai = strtolower($sebagai);
            }

        
            $i=0;
            $temp_pihak='';
            $temp_kuasa='';
            $pihak_array='';
          
            if($dataPihak->num_rows>0){
                foreach ($dataPihak->result() as $row) {
                    if($temp_pihak !=  $row->pihak_id){
                        $temp_pihak = $row->pihak_id;
                        if($i>0){
                            $pihak_array = str_replace(" #ke# ",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
                        }
                        $nama_pihak .=$this->templatehelper->standradnaming($row->nama);
                        $pihak_array.=$this->templatehelper->standradnaming($row->nama);
                        if($row->jenis_pihak_id==1){
                            switch ($this->numpang['jenis_pengadilan']) {
                                case 1:
                                    $pihak_array.=', bertempat tinggal di ';            
                                    break;
                                case 3:
                                    $pihak_array.=' kewarganegaraan '.$row->warga_negara.', pekerjaan '.$row->pekerjaan.', tempat tinggal ';            
                                    break;
                                case 4:
                                    $pihak_array.=', tempat dan tanggal lahir '.$row->tempat_lahir.', '.$row->tanggal_lahir.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.', tempat kediaman di ';            
                                    break;
                            }
                        }else{
                            $pihak_array.=', tempat kedudukan ';
                        }
                        $pihak_array.=$row->alamat;
                        if($row->id_kuasa != ''){
                            if($this->numpang['jenis_pengadilan']!=3){
                                $arr_pengacara_pihak1='--';
                                if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
                                $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$this->templatehelper->standradnaming($row->nama_kuasa).$row->dkk.
                                    ', #DKK# advokat/penasehat hukum dari '.$this->templatehelper->standradnaming($row->nama).
                                    ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->templatehelper->convertKeTglIndo($row->tgl_kuasa).
                                    ' sebagai '.$sebagai.' #ke# #par#';
                                $item['#didampingi_kuasa_hukum#']=" serta didampingi Penasihat Hukumnya "; 
                                $item['#penasihat_hukum#']=" Penasihat Hukum ";           
                            }
                        }else{
                            $pihak_array.=' sebagai '.$sebagai.' #ke# #par# '; 
                             $item['#didampingi_kuasa_hukum#']= " ";   
                             $item['#penasihat_hukum#']=" ";
                        }
                        $i++;
                       
                    }else{
                         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
                    }
                    if($pihak_ke==1){
                        $item['#nama_oditur#'] = $this->templatehelper->standradnaming($row->nama); 
                        $item['#pangkat_oditur#'] = $row->pangkat_jaksa; 
                        $item['#nrp_oditur#'] = $row->nip_jaksa; 
                    }
                }
                if($i>1){
                    $pihak_array = str_replace(" #ke#",' '.$this->templatehelper->converToAngkaRomawi($i).'; ', $pihak_array);
                    $pihak_array = str_replace("#par#",' \\par ', $pihak_array);
                }else{
                    $pihak_array = str_replace(" #ke#",'', $pihak_array);
                    $pihak_array = str_replace("#par#",'', $pihak_array);
                }
                $pihak_array = str_replace(" #DKK#",'', $pihak_array);
            }else{
                $pihak_array = "Data Pihak Tidak Ada dalam Database!!!";
            }

            if($data_pihak_relaas->num_rows>0){
                foreach ($data_pihak_relaas->result() as $row) {
                    if($this->numpang['pihak_id']==$row->pihak_id){
                        if($row->id_kuasa==''){
                            $pihak_relaas = $pihak_array;
                        }else{
                            $pihak_relaas=$this->templatehelper->standradnaming($row->nama_kuasa).' beralamat di '.$row->alamat_kuasa.' kuasa dari ';
                            if($row->jumlah_pihak==1){
                                $pihak_relaas.=$this->templatehelper->standradnaming($row->nama);
                                if($row->jenis_pihak_id==1){
                                    switch ($this->numpang['jenis_pengadilan']) {
                                        case 1:
                                            $pihak_relaas.=', bertempat tinggal di ';            
                                            break;
                                        case 3:
                                            $pihak_relaas.=' kewarganegaraan '.$row->warga_negara.', tempat tinggal ';            
                                            break;
                                        case 4:
                                            $pihak_relaas.=', tempat dan tanggal lahir '.$row->tempat_lahir.', '.$row->tanggal_lahir.', agama '.$row->agama.', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.', tempat kediaman di ';            
                                            break;
                                    }
                                }else{
                                    $pihak_relaas.=', tempat kedudukan ';
                                }
                                $pihak_relaas.=$row->alamat;  
                                switch ($this->numpang['jenis_pengadilan']) {
                                    case 1:
                                        $pihak_relaas.=' berdasarkan Surat Kuasa Khusus Nomor '.$row->nomor_kuasa.' tanggal '.$row->tanggal_kuasa;
                                        break;
                                    case 3:
                                        $pihak_relaas.=', pekerjaan '.$row->pekerjaan;
                                        break;
                                }
                                $pihak_relaas.=' sebagai '.$sebagai;
                            }else{
                                $pihak_relaas.=$this->templatehelper->standradnaming($row->nama).' dan kawan-kawan sebagai '.$sebagai; 
                            }
                        }
                    }
                }
            }
            $i=0;
            $pihak_tun_bap='\\pard\\sl360\\slmult1\\fs24\\tx567\\qj\\fi-2126\\li2126 ';
            $par_put='\\pard\\sl360\\slmult1\\fs24\\tx567\\tx2835\\tx3119\\qj\\fi-2552\\li3119 ';
            $pihak_tun_putusan=$par_put;
            if($dataPihak->num_rows>0){
                foreach ($dataPihak->result() as $row) {
                    $i++;
                    if($i>1){
                        $pihak_tun_bap .= ' \\par ';   
                        $pihak_tun_putusan .= ' \\par ';   
                    }
                    if($dataPihak->num_rows()>1){
                        $pihak_tun_bap .= $i.'. \\tab';
                        $pihak_tun_putusan .= '\\fi-3119 '.$i.'. \\tab ';
                    }
                    $pihak_tun_putusan .= 'Nama \\tab : \\tab\\b '.strtoupper($row->nama).'\\b0 '.'; \\par ';
                    $pihak_tun_putusan .= $par_put;
                    if($row->jenis_pihak_id==1){
                        $pihak_tun_putusan .= 'Kewarganegaraan \\tab : \\tab '.$row->warga_negara.'; \\par ';
                    }
                    if($row->jenis_pihak_id==1){
                        $pihak_tun_putusan .= 'Tempat Tinggal';
                    }else{
                        $pihak_tun_putusan .= 'Tempat Kedudukan';
                    }
                    $pihak_tun_putusan .= ' \\tab : \\tab '.$row->alamat.'; \\par ';
                    if($row->jenis_pihak_id==1){
                        $pihak_tun_putusan .= 'Pekerjaan \\tab : \\tab '.$row->pekerjaan.';';
                    }
                    $pihak_tun_bap .=' \\ul\\b ';
                    $pihak_tun_bap .=$this->templatehelper->standradnaming($row->nama);
                    $pihak_tun_bap .='\\ulnone\\b0  ';
                    if($row->jenis_pihak_id==1){
                        $pihak_tun_bap.=' kewarganegaraan '.$row->warga_negara.', pekerjaan '.$row->pekerjaan.', tempat tinggal ';            
                    }else{
                        $pihak_tun_bap.=', tempat kedudukan ';
                    }
                    $pihak_tun_bap.=$row->alamat.';';
                }
            }else{
                $pihak_tun_putusan .= "";
                $pihak_tun_bap = "";
            }
            $par_put=' \\pard\\sl360\\slmult1\\fs24\\tx567\\tx1152\\qj\\fi567\\li567 ';
            if($data_kuasa->num_rows()>0){
                $pihak_tun_putusan .= '\\par '.$par_put.' dalam hal ini diwakili oleh kuasanya:';
                $pihak_tun_bap.=' \\par\\fi0\\li2126 dalam hal ini diwakili oleh kuasanya:';
            }
            
            $i=0;
            foreach ($data_kuasa->result() as $row) {
                $i++;
                $pihak_tun_bap.= ' \\par ';
                $pihak_tun_putusan .=' \\par ';
                if($data_kuasa->num_rows()>0){
                    $pihak_tun_putusan .= $i.'. \\tab ';
                    $pihak_tun_bap.= $i.'. \\tab ';
                }
                $pihak_tun_putusan .= strtoupper($row->nama);
                $pihak_tun_bap .= ' \\ul\\b ';
                $pihak_tun_bap .= $this->templatehelper->standradnaming($row->nama);
                $pihak_tun_bap .= '\\ulnone\\b0 ';
            }   
            
            if($data_kuasa->num_rows()>0){
                $pihak_tun_bap .=', \\par  ';
                if($data_kuasa->num_rows()>1){
                    $pihak_tun_bap .= 'masing-masing ber';
                }
                $pihak_tun_putusan .='\\par Kesemuanya Warga Negara Indonesia, Advokat pada Kantor Hukum .....,  alamat di '.$data_kuasa->result()[0]->alamat.', berdasarkan Surat Kuasa Khusus Nomor '.$data_kuasa->result()[0]->nomor_kuasa.' tanggal '.$data_kuasa->result()[0]->tanggal_kuasa.';';
                $pihak_tun_bap .='kewarganegaraan Indonesia, pekerjaan Advokat, beralamat di '.$data_kuasa->result()[0]->alamat.', berdasarkan Surat Kuasa Khusus tanggal '.$data_kuasa->result()[0]->tanggal_kuasa;
            }
            $pihak_tun_bap .=' \\par\\fi0\\li2126 untuk selanjutnya disebut sebagai\\b '.$sebagai.'\\b0';
            $tmp='';
            if($dataPihak->num_rows>1){
                $tmp='PARA';
            }
            $pihak_tun_putusan .=' \\par Selanjutnya disebut sebagai \\b '.$tmp.strtoupper($sebagai).'\\b0\\par ';
            // print_r($pihak_tun_bap);exit();
            $item['#looping_pihak'.$pihak_ke.'_tun_putusan#'] = $pihak_tun_putusan;
            $item['#looping_pihak'.$pihak_ke.'_tun_bap#'] = $pihak_tun_bap.';';
            $item['#looping_pihak'.$pihak_ke.'_relaas#'] = $pihak_relaas.';';
          	$item['#looping_pihak'.$pihak_ke.'#'] = $pihak_array;
            $item['#nama_pihak'.$pihak_ke.'#'] = $nama_pihak; 
          	return $item;
    }

    function looping_nama_pihak($pihak_ke=1){
            $dataPihak = $this->m_new_template->get_var_pihak($pihak_ke);
            switch ($pihak_ke) {
                case '1':
                    $sebagai="#sebagai_p#";
                    break;
                case '2':
                    $sebagai="#sebagai_t#";
                    break;
                default:
                    # code...
                    break;
            }
            $i=1;
            $pihak_array='';
            foreach ($dataPihak->result() as $row) {
                if ($dataPihak->num_rows>1){
                    $no=$i++;
                    $ke= $this->templatehelper->converToAngkaRomawi($no);    
                }else{
                    $no="";
                    $ke="";
                }
                 $pihak_array.= $no.'. '.$this->templatehelper->standradnaming($row->nama)." \\tab ".$sebagai.$ke."\\par \\tab \\tab ".$dkk.PHP_EOL;

            }
            $item['#looping_nama_pihak'.$pihak_ke.'#'] = $pihak_array;
            return $item;
       
    }

    function var_biaya(){
        $perkara = $this->m_new_template->get_var_biaya();
        if ($perkara->num_rows() == 0 ) $item['#variabel_kres#']="ga ada datanya";
        $field_perkara = array_keys($perkara->result_array()[0]);
        $c=0;
        $total=0;
        foreach ($perkara->result() as $row) {
            for($i = 0; $i <count($field_perkara) ; $i++) {
              $item["#".$field_perkara[$i]."#"]=number_format($row->$field_perkara[$i], 2, ',', '.');
              $$field_perkara[$i]=number_format($row->$field_perkara[$i], 2, ',', '.');
              if($field_perkara[$i]=='biaya_pemeriksaan' or $field_perkara[$i]=='biaya_sita'){
                if($this->numpang['jenis_pengadilan']==1){
                    $total+=intval($row->$field_perkara[$i]);  
                }
              }elseif($field_perkara[$i]=='biaya_leges'){
                if($this->numpang['jenis_pengadilan']==3){
                    $total+=intval($row->$field_perkara[$i]);  
                }
              }else{
                $total+=intval($row->$field_perkara[$i]);  
              }
              if($c<strlen($row->$field_perkara[$i])){
                $c=strlen($row->$field_perkara[$i]);
              }
            } 
        }
        $item['#total_jumlah#']=number_format($total, 2, ',', '.');
        $item['#jumlah_terbilang#']=$this->templatehelper->Terbilang($total).' rupiah';

        $tr     = "{ \\trowd\\cellx567\\cellx6237\\cellx8505 "; 
        $tr_e   = " \\row }";
        $td     = "{ \\intbl "; 
        $td_e   = " \\cell }";
                    
        $biaya.='\\pard'.$tr.$td.'\\qc 1.'.$td_e.$td.'\\qj Pendaftaran'.$td_e.$td.'\\qr Rp'.$biaya_pendaftaran.$td_e.$tr_e;
        $biaya.=$tr.$td.'\\qc 2.'.$td_e.$td.'\\qj ';
        $biaya.=$this->numpang['jenis_pengadilan']==3?'A T K':'Proses';
        $biaya.=$td_e.$td.'\\qr Rp'.$biaya_proses.''.$td_e.$tr_e;
        $biaya.=$tr.$td.'\\qc 3.'.$td_e.$td.'\\qj ';
        $biaya.=$this->numpang['jenis_pengadilan']==3?'Panggilan-Panggilan':'Panggilan';
        $biaya.=$td_e.$td.'\\qr Rp'.$biaya_panggilan.$td_e.$tr_e;
        $biaya.=$tr.$td.'\\qc 4.'.$td_e.$td.'\\qj ';
        $biaya.=$this->numpang['jenis_pengadilan']==3?'Meterai':'Redaksi';
        $biaya.=$td_e.$td.'\\qr Rp';
        $biaya.=$this->numpang['jenis_pengadilan']==3?$biaya_meterai:$biaya_redaksi;
        $biaya.=$td_e.$tr_e;
        
        if($this->numpang['jenis_pengadilan']==4){
            $biaya.='{ \\trowd\\cellx567\\cellx6237\\clbrdrb\\brdrw10\\brdrs \\cellx8505 ';
        }else{
            $biaya.=$tr;
        }
        
        $biaya.=$td.'\\qc 5.'.$td_e.$td.'\\qj ';
        $biaya.=$this->numpang['jenis_pengadilan']==3?'Redaksi':'Meterai';
        $biaya.=$td_e.$td.'\\qr Rp';
        $biaya.=$this->numpang['jenis_pengadilan']==3?$biaya_redaksi:$biaya_meterai;
        $biaya.=$td_e.$tr_e;
        if($this->numpang['jenis_pengadilan']==3){
            $biaya.='{ \\trowd\\cellx567\\cellx6237\\clbrdrb\\brdrw10\\brdrs \\cellx8505 ';
            $biaya.=$tr.'\\intbl\\qc 6.'.$td_e.$td.'\\qj Leges'.$td_e.$td.'\\qr Rp'.$biaya_leges.$td_e.$tr_e;
        }
        $biaya.=$tr.$td.$td_e.$td.'\\qj ';
        $biaya.='\\b Jumlah\\cell\\intbl\\qr Rp'.$item['#total_jumlah#'].'\\b0'.$td_e.$tr_e;
        $biaya.='{ \\trowd\\cellx567\\cellx8505 ';
        $biaya.=$td.$td_e.$td.'\\qj ('.$item['#jumlah_terbilang#'].' )'.$td_e.$tr_e;
        $item['#biaya_perkara_putusan#']='#perkara_biaya_putusan#';
        $item['#perkara_biaya_putusan#']=$biaya;
        return $item;
    }
}