<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal_perkara_list extends CI_Controller {
	function parseParam($params){
		$data = array();
		$idalurperkara = '';
		$tahapan_id = '';
		$tmp = explode(";", $params);
		if(count($tmp)>0){
			$tmp_var = explode("=", $tmp[0]);
			if(count($tmp_var)>0){
				$data['idalurperkara'] = $tmp_var[1];
			}
			$tmp_var = explode("=", $tmp[1]);
			if(count($tmp_var)>0){
				$data['tahapan_id'] = $tmp_var[1];
			}
		}
		return $data;
	}
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$this->load->model('default/defaults');
		$segment = $this->uri->segment_array();
		$pagenumber = 0;
		$keyword = "";$where='';
		$col ="";
		//$this->nativesession->set('url_requested', current_url());
		if($this->uri->segment(2)=='page'){
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$pagenumber = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$this->nativesession->set_flash_session('page', $pagenumber);
			$this->nativesession->set_flash_session('enc', $param);
			$tmp = explode("=", $this->uri->segment(5));
			if($tmp>0 AND $tmp[0]=="col"){
				$col = $tmp[1];
				$this->nativesession->set_flash_session('col', $col);
				$this->nativesession->set_flash_session('keyword','');
			}else{
				$keyword = rawurldecode($this->uri->segment(5));
				$keyword = $this->encrypt->decode(base64_decode($keyword));
				$col = $this->uri->segment(6);
				$tmp=explode("=", $col);
				$col=($tmp[1]);
				$this->nativesession->set_flash_session('keyword', $keyword);
				$this->nativesession->set_flash_session('col', $col);
			}
		}elseif($this->uri->segment(2)=='search'){
			if($this->input->post('search')){
				$this->nativesession->set_flash_session('keyword', $this->input->post('search'));
				$keyword = $this->input->post('search');
			}else{
				$this->nativesession->set_flash_session('keyword', rawurldecode($this->uri->segment(3)));
				$keyword = ($this->uri->segment(3));
				$keyword = $this->encrypt->decode(base64_decode($keyword));
			}
			if($this->input->post('enc')){
				$this->nativesession->set_flash_session('enc', $this->input->post('enc'));
				$param=$this->input->post('enc');
			}else{
				$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
				$param=$this->uri->segment(4);
			}
			$this->nativesession->set_flash_session('page', '');
			$this->session->set_userdata('total_rows',-1);
			$this->nativesession->set_flash_session('where', $where);
		}elseif($this->uri->segment(2)=='search_detail'){
			$keyword = 'search_detail';
			if($this->input->post('enc')){
				$param = $this->input->post('enc');
				$this->nativesession->set_flash_session('enc', $param);
			}else{
				$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
				$param = $this->uri->segment(4);
			}
			$this->nativesession->set_flash_session('page', '');
			$where=$this->parsePostValue();
			$this->nativesession->set_flash_session('where', $where);
			$this->session->set_userdata('total_rows',-1);
		}elseif($this->uri->segment(2)=='sort'){
			$col = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$this->nativesession->set_flash_session('col', $col);
			$this->nativesession->set_flash_session('enc', $param);
			$keyword = rawurldecode($this->uri->segment(5));
			$keyword = $this->encrypt->decode(base64_decode($keyword));
			$this->nativesession->set_flash_session('keyword', $keyword);
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$this->sort($col,$param,$keyword,$where);
			return;
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$param = $this->uri->segment(4);
			$this->session->set_userdata('total_rows',-1);
		}
		
		$this->showData($param,$pagenumber,$keyword,$col, $where);
	}

	function sort($col=null,$enc=null,$keyword=null,$where){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($enc,0,$keyword,$col,$where);
	}

	function showData($param,$pagenumber=0,$keyword='',$col=2, $where=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($pagenumber>0){
			$begin_limit = ($pagenumber-1)*50;
		}else{
			$begin_limit = 0;
			$pagenumber = 1;
		}

		$params = $this->encrypt->decode(base64_decode($param));
		$data = $this->parseParam($params);
		$enc = base64_encode($this->encrypt->encode($data['idalurperkara']));
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('jurnal/jurnal');
		$data['params'] = $params;
		$data['enc'] = $param;
		$data['idalurperkara'] = $idalurperkara;
		
		//$data['back_jurnal_perkara']=current_url();
		if($data['tahapan_id']==10 OR $data['tahapan_id']==20){
			if($idalurperkara==1 OR $idalurperkara==7){
				$idalurperkara = '1,7';
			}
		}
		if($data['tahapan_id']==30 OR $data['tahapan_id']==40){
			if($idalurperkara==1 OR $idalurperkara==2 OR $idalurperkara==7){
				$idalurperkara = '1,2,7';
			}
		}
		if($data['tahapan_id']==50){
			if($idalurperkara==1 OR $idalurperkara==7 OR $idalurperkara==8){
				$idalurperkara = '1,7,8';
			}
		}
		if ($where=='' && $keyword!='search_detail'){
			$data['list_jurnal_perkara'] = $this->jurnal->getJurnalList($idalurperkara,$data['tahapan_id'],$begin_limit,$keyword,$col,$asc_desc);
		}else{
			$data['list_jurnal_perkara'] = $this->jurnal->getJurnalListDetail($idalurperkara,$data['tahapan_id'],$begin_limit,$where,$col,$asc_desc);			
		}
		
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->jurnal->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->jurnal->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit+1;
		$data['page_number'] = $pagenumber;

		$title_perkara = ''; 
		$tmp = explode(",", $data['idalurperkara']);
		if(count($tmp)>0){
			for ($i=0; $i < count($tmp); $i++) {
				if($i>0){
					$title_perkara .= " DAN ";
				}
				$title_perkara .= strtoupper($this->defaults->getJenisPerkara($tmp[$i]));
			}
		}else{
			$title_perkara = strtoupper($this->defaults->getJenisPerkara($data['idalurperkara']));
		}
		# tri add
		if($data['tahapan_id']==10){
			$tahapanName = 'PERKARA ';
		}elseif($data['tahapan_id']==20){
			$tahapanName = 'PERMOHONAN BANDING PERKARA ';
		}elseif($data['tahapan_id']==30){
			$tahapanName = 'PERMOHONAN KASASI PERKARA ';
		}elseif($data['tahapan_id']==40){
			$tahapanName = 'PERMOHONAN PENINJAUAN KEMBALI PERKARA ';
		}elseif($data['tahapan_id']==50){
			$tahapanName = 'PERMOHONAN EKSEKUSI ';
		}
		$data['page_title'] = 'JURNAL KEUANGAN '.$tahapanName.$title_perkara;
		$data['main_body'] = 'jurnal_perkara/jurnal_perkara';
		$data['page_url'] = 'jurnal_perkara_list';
		$data['keyword'] = base64_encode($this->encrypt->encode($keyword));
		if ($keyword!=''){
			$this->nativesession->set('main_url_requested', base_url(uri_string().'/'.$data['keyword'].'/'.$param));
		}else{
			$this->nativesession->set('main_url_requested', base_url(uri_string()));	
		}
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
	function add_biaya($idperkara){
		$this->load->view('add_biaya');
	}
	function parsePostValue(){
		$where = '';
		if($this->input->post('from_tgl_pendaftaran',TRUE)){
			$where .= $this->parseWhereOnTanggal($where,'from_tgl_pendaftaran','to_tgl_pendaftaran','tgl_pendaftaran_select','tanggal_pendaftaran');
		}
		if($this->input->post('klasifikasi_perkara',TRUE)){
			if(!empty($where) AND $this->input->post('klasifikasi_perkara',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('klasifikasi_perkara',TRUE) != -1){
				$where .= " (jenis_perkara_id ='".$this->input->post('klasifikasi_perkara',TRUE)."') ";
			}
		}
		if ($this->input->post('no_perkara',TRUE)!=''){
			if(!empty($where) AND $this->input->post('no_perkara',TRUE)!=''){
				$where .= ' AND ';
			}
			if($this->input->post('no_perkara_select',TRUE)==8){
				$where .= " (nomor_perkara LIKE '%".$this->input->post('no_perkara',TRUE)."%') ";
			}else{
				$where .= " (nomor_perkara ='".$this->input->post('no_perkara',TRUE)."') ";
			}
		}

		if($this->input->post('pihak1',TRUE)){
			$where .= $this->parseWhereOnPihak($where,'pihak1','pihak1_text');
		}

		if($this->input->post('pihak2',TRUE)){
			$where .= $this->parseWhereOnPihak($where,'pihak2','pihak2_text');
		}

		if($this->input->post('pihak3',TRUE)){
			$where .= $this->parseWhereOnPihak($where,'pihak3','pihak3_text');
		}

		if($this->input->post('id_tahapan',TRUE)){
			if(!empty($where) AND $this->input->post('id_tahapan',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('id_tahapan',TRUE) != -1){
				$cond = $this->getSimbolValue($this->input->post('tahapan_select',TRUE));
				$where .= " (tahapan_terakhir_id ".$cond." '".$this->input->post('id_tahapan',TRUE)."') ";
			}
		}

		if($this->input->post('id_proses',TRUE)){
			if(!empty($where) AND $this->input->post('id_proses',TRUE)!=-1){
				$where .= ' AND ';
			}
			if($this->input->post('id_proses',TRUE) != -1){
				$cond = $this->getSimbolValue($this->input->post('proses_select',TRUE));
				$where .= " (proses_terakhir_id ".$cond." '".$this->input->post('id_proses',TRUE)."') ";
			}
		}
		if($this->input->post('jml_penerimaan',TRUE)){
			if(!empty($where) AND $this->input->post('jml_penerimaan',TRUE)!=''){
				$where .= ' AND ';
			}
			$cond = $this->getSimbolValue($this->input->post('penerimaan_select',TRUE));
			$where .= " (pemasukan ".$cond." '".$this->input->post('jml_penerimaan',TRUE)."') ";
		}
		if($this->input->post('jml_pengeluaran',TRUE)){
			if(!empty($where) AND $this->input->post('jml_pengeluaran',TRUE)!=''){
				$where .= ' AND ';
			}
			$cond = $this->getSimbolValue($this->input->post('pengeluaran_select',TRUE));
			$where .= " (pengeluaran ".$cond." '".$this->input->post('jml_pengeluaran',TRUE)."') ";
		}
		if($this->input->post('jml_sisa',TRUE)){
			if(!empty($where) AND $this->input->post('jml_sisa',TRUE)!=''){
				$where .= ' AND ';
			}
			$cond = $this->getSimbolValue($this->input->post('sisa_select',TRUE));
			$where .= " ((pemasukan-pengeluaran) ".$cond." '".$this->input->post('jml_sisa',TRUE)."') ";
		}
		
		return $where;
	}

	function parseWhereOnPihak($where,$pihakNo,$col){
		if($this->input->post($pihakNo,TRUE)){
			$wheres='';
			if(!empty($where) AND $this->input->post($pihakNo,TRUE)!=''){
				$wheres .= ' AND ';
			}
			if($this->input->post($pihakNo,TRUE) != ''){
				$wheres .= " (".$col." LIKE '%".$this->input->post($pihakNo,TRUE)."%') ";
			}
		}
		return $wheres;
	}

	function parseWhereOnTanggal($where,$from,$to,$select,$col){
		if($this->input->post($from,TRUE)){
			$wheres='';
			if(!empty($where) AND $this->input->post($from,TRUE)!=''){
				$wheres .= ' AND ';
			}
			if($this->input->post($select,TRUE)==6){
				if($this->input->post($to,TRUE)==''){
					$date = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
					$wheres .= " (".$col." ='".$date."') ";
				}else{
					$dateFrom = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
					$dateTo = $this->tanggalhelper->convertToMysqlDate($this->input->post($to,TRUE));
					$wheres .= " (".$col." >='".$dateFrom."' AND ".$col." <= '".$dateTo."') ";
				}
			}else{
				$date = $this->tanggalhelper->convertToMysqlDate($this->input->post($from,TRUE));
				$cond = $this->getSimbolValue($this->input->post($select,TRUE));
				$wheres .= " (".$col." ".$cond." '".$date."') ";
			}
		}
		return $wheres;
	}

	function getColumnName($val){
		if($val=='alur'){
			return "alur_perkara_id";
		}elseif($val=='klasifikasi_perkara'){
			return "jenis_perkara_id";
		}elseif($val=='prodeo'){
			return "prodeo";
		}elseif($val=='id_proses'){
			return "proses_terakhir_id";
		}elseif($val=='id_tahapan'){
			return "tahapan_terakhir_id";
		}elseif($val=='pihak1'){
			return "pihak1_text";
		}elseif($val=='pihak2'){
			return "pihak2_text";
		}elseif($val=='pihak3'){
			return "pihak3_text";
		}
	}

	function getSimbolValue($val){
		if($val<0 OR $val>8 OR $val==1){
			return " = ";
		}elseif ($val==2) {
			return " > ";
		}elseif ($val==3) {
			return " >= ";
		}elseif ($val==4) {
			return " < ";
		}elseif ($val==5) {
			return " <= ";
		}elseif ($val==6) {
			return " AND ";
		}elseif ($val==7) {
			return " != ";
		}elseif ($val==8) {
			return " LIKE ";
		}
	}

	


}

