<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Update_database extends CI_Model{
	function __construct(){
		$this->run_this();
	}

	function isColumnExist($table_name,$column_name){
		try {
			$result = $this->db->query('
				SELECT COLUMN_NAME AS colname
			    FROM information_schema.columns 
			    WHERE TABLE_NAME = "'.$table_name.'"
			    AND COLUMN_NAME = "'.$column_name.'" AND TABLE_SCHEMA = "'.$this->db->database.'" 
			    GROUP BY column_name;
				');
			if($result->num_rows>0){
				return $result->row()->colname;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function run_this(){
		//script update database disini

        
        $this->db->query("SET FOREIGN_KEY_CHECKS=0;");
        $this->db->query("SET SQL_MODE='ALLOW_INVALID_DATES';");

        $this->db->query("CREATE TABLE IF NOT EXISTS `delegasi_file_keluar`(
						  `id` bigint(20) NOT NULL  auto_increment , 
						  `delegasi_id` bigint(11) unsigned NOT NULL  DEFAULT 0 , 
						  `id_pn_asal` int(11) NOT NULL  COMMENT 'Identitas Pengadilan' , 
						  `id_pn_tujuan` int(11) NULL  , 
						  `perkara_id` bigint(20) unsigned NOT NULL, 
						  `file` varchar(255) NOT NULL  , 
						  `status_file` char(1) NULL  COMMENT '1: file pengajuan; 2:file pelaksanaan' , 
						  `diinput_oleh` varchar(30) NULL  , 
						  `diinput_tanggal` date NULL  , 
						  `diperbaharui_oleh` varchar(30) NULL  , 
						  `diperbaharui_tanggal` date NULL  , 
						  PRIMARY KEY (`id`,`delegasi_id`,`id_pn_asal`,`perkara_id`,`file`) 
						) ENGINE=InnoDB;");

        $this->db->query("CREATE TABLE IF NOT EXISTS `delegasi_file_masuk`(
						  `id` bigint(20) NOT NULL  auto_increment , 
						  `delegasi_id` bigint(11) unsigned NOT NULL  DEFAULT 0 , 
						  `id_pn_asal` int(11) NOT NULL  COMMENT 'Identitas Pengadilan' , 
						  `id_pn_tujuan` int(11) NULL  , 
						  `perkara_id` bigint(20) unsigned NOT NULL  , 
						  `file` varchar(255) NOT NULL  , 
						  `status_file` char(1) NULL  COMMENT '1: file pengajuan; 2:file pelaksanaan' , 
						  `diinput_oleh` varchar(30) NULL  , 
						  `diinput_tanggal` date NULL  , 
						  `diperbaharui_oleh` varchar(30) NULL  , 
						  `diperbaharui_tanggal` date NULL  , 
						  PRIMARY KEY (`id`,`delegasi_id`,`id_pn_asal`,`perkara_id`,`file`) 
						) ENGINE=InnoDB;");
 		
 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_penetapan_hari_sidang` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) unsigned NOT NULL,
						  `tahapan_id` tinyint(4) NOT NULL DEFAULT 10 COMMENT 'Mengacu ke Table Tahapan',
						  `jadwalsidang_id` bigint(20) unsigned NOT NULL COMMENT 'Mengacu ke tabel perkara_jadwal_sidang',
						  `tanggal_penetapan` date NOT NULL,
						  `tanggal_sidang` date NOT NULL,
						  `keterangan` varchar(500) DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_barang_bukti_perdata` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) unsigned NOT NULL,
						  `jadwal_sidang_id` bigint(20) unsigned NOT NULL,
						  `pihak_id` bigint(20) unsigned NOT NULL COMMENT 'refer ke table pihak kolom ID',
						  `jenis_barang_bukti` varchar(500)NOT NULL,
						  `nomor_barang_bukti` varchar(100)DEFAULT NULL COMMENT 'Nomor surat barang bukti. Ex. No kutipan akta nikah',
						  `tanggal_barang_bukti` date DEFAULT NULL COMMENT 'Tanggal yang tertera di barang bukti. ex. Tanggal kutipan akta nikah',
						  `dikeluarkan_oleh` varchar(500)DEFAULT NULL COMMENT 'instansi yang membuat barang bukti tersebut. ex. KUA Kecamatan .....',
						  `catatan_barang_bukti` text,
						  `diinput_oleh` varchar(30)DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30)DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`),
						  UNIQUE KEY `perkara_id` (`perkara_id`,`jadwal_sidang_id`,`jenis_barang_bukti`),
						  CONSTRAINT `perkara_barang_bukti_perdata_ibfk_1` FOREIGN KEY (`perkara_id`) REFERENCES `perkara` (`perkara_id`) ON DELETE CASCADE ON UPDATE CASCADE
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `template_amar_putusan` (
						  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
						  `alur_perkara_id` int(11) DEFAULT NULL,
						  `jenis_perkara_id` int(11) DEFAULT NULL,
						  `sela` tinyint(1) DEFAULT '0' COMMENT '0:sela; 1:sela;',
						  `nama` varchar(255) DEFAULT NULL,
						  `template` text,
						  `aktif` char(1) DEFAULT 'Y',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `template_keterangan_saksi_m` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `nama` varchar(250) DEFAULT NULL COMMENT 'refer perkara_pihak_5',
						  `aktif` char(1) DEFAULT 'Y',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `template_keterangan_saksi_d` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `m_id` int(11) NOT NULL COMMENT 'refer to table template_keterangan_Saksi m field id',
						  `urutan_pertanyaan` int(11) DEFAULT NULL,
						  `pertanyaan` text,
						  `jawaban` text,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `referensi_amar_putusan` (
						  `id` INT(11) NOT NULL,
						  `jenis_perkara_id` INT(11) UNSIGNED NOT NULL,
						  `amar` TEXT,
						  `keterangan` VARCHAR(255) DEFAULT NULL,
						  `diinput_oleh` VARCHAR(30) DEFAULT NULL,
						  `diinput_tanggal` DATETIME DEFAULT NULL,
						  `diperbaharui_oleh` VARCHAR(30) DEFAULT NULL,
						  `diperbaharui_tanggal` DATETIME DEFAULT NULL,
						  PRIMARY KEY (`id`,`jenis_perkara_id`)
						) ENGINE=INNODB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_keterangan_saksi`(  
						  `id` BIGINT NOT NULL AUTO_INCREMENT,
						  `perkara_id` BIGINT,
						  `sidang_id` BIGINT,
						  `penanya_id` CHAR(1) COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
						  `saksi_id` INT COMMENT 'refer perkara_pihak_5',
						  `urutan_pertanyaan` INT,
						  `pertanyaan` TEXT,
						  `jawaban` TEXT,
						  `diinput_oleh` VARCHAR(30),
						  `diinput_tanggal` DATETIME,
						  `diperbaharui_oleh` VARCHAR(30),
						  `diperbaharui_tanggal` DATETIME,
						  PRIMARY KEY (`id`),
						  UNIQUE INDEX (`perkara_id`, `sidang_id`, `saksi_id`, `urutan_pertanyaan`)
						) ENGINE=INNODB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_data_template_sidang` (
						  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
						  `perkara_id` BIGINT(20) UNSIGNED NOT NULL,
						  `sidang_id` INT(11) NOT NULL COMMENT 'id dari kolom jenis_tahapan',
						  `kolom_id` INT(11) NOT NULL COMMENT 'id table referensi_kolom_data_template',
						  `uraian` LONGTEXT,
						  `diinput_oleh` VARCHAR(30) DEFAULT NULL,
						  `diinput_tanggal` DATETIME DEFAULT NULL,
						  `diperbaharui_oleh` VARCHAR(30) DEFAULT NULL,
						  `diperbaharui_tanggal` DATETIME DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=INNODB;");

 		$cekkolum = $this->isColumnExist('perkara','posita');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara`   
  						ADD COLUMN `posita` TEXT NULL AFTER `pihak_dipublikasikan`;");
 		}

 		$this->db->query("CREATE TABLE IF NOT EXISTS `referensi_kolom_data_template` (
						  `id` INT(11) NOT NULL,
						  `nama_kolom` VARCHAR(255) DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=INNODB;");
 		$this->db->query("REPLACE INTO `referensi_kolom_data_template` (`id`, `nama_kolom`) values
						('1','Pembelaan'),('2','Replik'),('3','Duplik'),('4','Pertimbangan'),('5','Rereplik'),('6','Reduplik'),
						('7','Pendapat Penuntut Umum'),('8','Keterangan Terdakwa'),('9','Keberatan Terhadap Dakwaan'),('10','Eksepsi Tergugat'),
						('11','Bukti Surat Penggugat'),('12','Bukti Surat Tergugat'),('13','Kesimpulan Penggugat'),('14','Kesimpulan Tergugat'),
						('15','Berita Acara Sita Revindicatoir');");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_data_template_penahanan` (
						  `id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
						  `perkara_id` BIGINT(20) UNSIGNED NOT NULL,
						  `penahanan_id` BIGINT(20) NOT NULL,
						  `pihak_id` BIGINT(20) DEFAULT NULL,
						  `pihak_penjamin_id` BIGINT(20) DEFAULT NULL,
						  `nomor_permohonan` VARCHAR(50) DEFAULT NULL,
						  `tanggal_permohonan` DATE DEFAULT NULL,
						  `alasan` VARCHAR(255) DEFAULT NULL,
						  `tanggal_mulai` DATE DEFAULT NULL,
						  `tanggal_sampai` DATE DEFAULT NULL,
						  `mulai_jam` TIME DEFAULT NULL,
						  `sampai_jam` TIME DEFAULT NULL,
						  `tanggal_keluar` DATE DEFAULT NULL,
						  `rumah_sakit` VARCHAR(100) DEFAULT NULL,
						  `nama_dokter` VARCHAR(50) DEFAULT NULL,
						  `nomor_perjanjian` VARCHAR(50) DEFAULT NULL,
						  `tanggal_perjanjian` DATE DEFAULT NULL,
						  `uang_jaminan` DECIMAL(16,2) DEFAULT NULL,
						  `nomor_bukti_setoran` VARCHAR(50) DEFAULT NULL,
						  `tanggal_bukti_setoran` DATE DEFAULT NULL,
						  `diinput_oleh` VARCHAR(20) DEFAULT NULL,
						  `diinput_tanggal` DATETIME DEFAULT NULL,
						  `diperbaharui_oleh` VARCHAR(20) DEFAULT NULL,
						  `diperbaharui_tanggal` DATETIME DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=INNODB;");

 		$cekkolum = $this->isColumnExist('perkara_jadwal_sidang','sifat_sidang');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_jadwal_sidang`   
  							ADD COLUMN `sifat_sidang` CHAR(1) DEFAULT 'Y'   NULL  COMMENT 'Y: Dibuka Untuk Umum, T: Tertutup Untuk Umum' AFTER `sidang_ditempat`;");
 		}

 		$cekkolum = $this->isColumnExist('perkara_pengacara','nomor_kuasa');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_pengacara`   
						  ADD COLUMN `nomor_kuasa` VARCHAR(50) NULL AFTER `masa_aktif`,
						  ADD COLUMN `tanggal_kuasa` DATE NULL AFTER `nomor_kuasa`;");
 		}

 		$cekkolum = $this->isColumnExist('perkara','nomor_dakwaan');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara`   
						  ADD COLUMN `nomor_dakwaan` VARCHAR(50) NULL AFTER `petitum_dok`,
						  ADD COLUMN `tanggal_dakwaan` DATE NULL AFTER `nomor_dakwaan`; ");
 		}
 		$cekkolum = $this->isColumnExist('perkara_pihak2','ghaib');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_pihak2` ADD COLUMN `ghaib` TINYINT(1) UNSIGNED DEFAULT 0 NOT NULL COMMENT 'Apakah pihak tidak diketahui alamatnya? 1(ya), 0(tidak)' AFTER `jenis_tahanan_id`;");
 		}

 		$cekkolum = $this->isColumnExist('perkara_pihak5','jenis_saksi');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_pihak5`   
  						ADD COLUMN `jenis_saksi` CHAR(1) DEFAULT '1'   NULL  COMMENT '1. Saksi, 2. Ahli' AFTER `jenis_pihak_id`;");
 		}

 		$cekkolum = $this->isColumnExist('perkara_jadwal_sidang','edoc_bas');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_jadwal_sidang` ADD COLUMN `edoc_bas` VARCHAR(250) NULL AFTER `keterangan`; ");
 		}

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_keterangan_terdakwa` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) NOT NULL,
						  `sidang_id` bigint(20) NOT NULL,
						  `penanya_id` char(1) DEFAULT NULL COMMENT '1: Ketua Majelis; 2:Hakim Anggota 1; 3: Hakim Anggota 2; 4; Hakim Anggota :3; 5 Hakim Anggota 4',
						  `pihak_id` bigint(20) NOT NULL COMMENT 'refer ke id perkara_pihak_2',
						  `urutan_pertanyaan` int(11) DEFAULT NULL,
						  `pertanyaan` text,
						  `jawaban` text,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`),
						  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`pihak_id`,`urutan_pertanyaan`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_pelaksanaan_relaas` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) unsigned NOT NULL,
						  `sidang_id` int(11) NOT NULL COMMENT 'id dari kolom jenis_tahapan',
						  `jurusita_id` int(11) NOT NULL COMMENT 'id table referensi_kolom_data_template',
						  `pihak_id` bigint(20) DEFAULT NULL COMMENT 'Pihak yg dipanggil',
						  `tanggal_relaas` date DEFAULT NULL,
						  `ket_temu` char(1) DEFAULT 'Y' COMMENT 'Y / T',
						  `ket_hasil_relaas` text,
						  `doc_relaas` VARCHAR(255) DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_pendapat_terdakwa` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) unsigned NOT NULL,
						  `sidang_id` bigint(20) NOT NULL,
						  `pihak_id` bigint(20) NOT NULL COMMENT 'refer ke id perkara_pihak2',
						  `saksi_id` bigint(20) NOT NULL COMMENT 'refer ke id perkara_pihak5',
						  `urutan` int(11) DEFAULT NULL,
						  `pendapat` text,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`),
						  UNIQUE KEY `perkara_id` (`perkara_id`,`sidang_id`,`saksi_id`,`urutan`)
						) ENGINE=InnoDB;");

 		$this->db->query("REPLACE INTO `template_dokumen` (`id`, `alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) values
						('2111','0',NULL,NULL,'111','8_1_PEN_IJIN_PENGGELEDAHAN','Blanko Penetapan Ijin Penggeledahan'),
						('2112','0',NULL,NULL,'111','8_2_PEN_PERSETUJUAN_PENGGELEDAHAAN','Blanko Penetapan Persetujuan Penggeledahan'),
						('2113','0',NULL,NULL,'111','8_3_PEN_PENOLAKAN_IJIN_PENGELEDAHAN','Blanko Penetapan Penolakan Ijin Penggeledahan'),
						('2114','0',NULL,NULL,'111','9_1_PEN_IJIN_PENYITAAN_KHUSUS_PASAL_43','Blanko Penetapan Ijin Penyitaan Khusus Pasal 43'),
						('2115','0',NULL,NULL,'111','9_2_PEN_IJIN_PENYITAAN','Blanko Penetapan Ijin Penyitaan'),
						('2116','0',NULL,NULL,'111','9_3_PEN_PERSETUJUAN_PENYITAAN','Blanko Penetapan Persetujuan Penyitaan'),
						('2117','0',NULL,NULL,'111','9_4_PEN_PENOLAKAN_IJIN_PENYITAAN','Blanko Penetapan Penolakan Ijin Penyitaan'),
						('2118','0',NULL,NULL,'111','10_2_PEN_IJIN_LELANG_BB_KEHUTANAN_KABUL','Blanko Penetapan Ijin Lelang Barang Bukti Kehutanan Kabul'),
						('2119','0',NULL,NULL,'111','10_3_PEN_IJIN_LELANG_BB_KEHUTANAN_TOLAK','Blanko Penetapan Ijin Lelang Barang Bukti Kehutanan Tolak'),
						('2120','0',NULL,NULL,'111','10_4_PEN_IJIN_LELANG_BB_TEMUAN_KABUL','Blanko Penetapan Ijin Lelang Barang Bukti Temuan Kehutanan Kabul'),
						('2121','0',NULL,NULL,'111','10_5_PEN_IJIN_UTK_BB_TEMUAN_TOLAK','Blanko Penetapan Ijin Peruntukan Barang Bukti Temuan Tolak'),
						('2122','0',NULL,NULL,'111','12_1_PEN_PENANGKAPAN_PENAHANAN_ITE','Blanko Penetapan Penangkapan Dan Penahanan ITE'),
						('2123','0',NULL,NULL,'111','7_9_PENETAPAN','Blanko Penetapan Penolakan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29'),
						('2124','0',NULL,NULL,'111','7_10_PENETAPAN','Blanko Penetapan Penolakan Perpanjangan Penahanan KPN Permintaan PU Pasal 29'),
						('2125','0',NULL,NULL,'111','7_12_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29 I'),
						('2126','0',NULL,NULL,'111','7_13_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29 II'),
						('2127','0',NULL,NULL,'111','7_14_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penuntut Umum Pasal 25'),
						('2128','0',NULL,NULL,'111','7_15_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permimntaan Penuntut Umum Pasal 29 I'),
						('2129','0',NULL,NULL,'111','7_16_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penuntut Umum Pasal 29 II');");
 		
 		$this->db->query("REPLACE INTO `sys_menus` (`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) values('6011','mainmenu','108','0','Blanko Template','blanko_template_pidana','','1','12');");
 		$this->db->query("REPLACE INTO `sys_config` (`id`, `category`, `name`, `value`, `ordering`) values('91','System','token_delegasi','','0');");
 		
 		$cekkolum = $this->isColumnExist('perkara_akta_cerai','tgl_penyerahan_akta_cerai_pihak2');  		
        if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_akta_cerai`   
   						ADD COLUMN `tgl_penyerahan_akta_cerai_pihak2` DATE NULL AFTER `tgl_penyerahan_akta_cerai`;");
 		}

 		$cekkolum = $this->isColumnExist('delegasi_masuk','status_kirim');  		
        if(!$cekkolum){
 		$this->db->query("ALTER TABLE `delegasi_masuk` 
						  CHANGE `namadokumen` `namadokumen` text  NULL after `tgl_sidang`, 
						  ADD COLUMN `status_kirim` char(1) NULL DEFAULT '0' COMMENT '1 proses, 2 kirim pelaksanaan & dokumen' after `biaya`, 
						  CHANGE `pihak` `pihak` varchar(1000) NULL after `status_kirim`, 
						  CHANGE `catatan` `catatan` varchar(100) NULL after `pihak`, 
						  CHANGE `diinput_oleh` `diinput_oleh` varchar(30) NULL after `catatan`, 
						  CHANGE `diinput_tanggal` `diinput_tanggal` date NULL after `diinput_oleh`, 
						  CHANGE `diperbaharui_oleh` `diperbaharui_oleh` varchar(30) NULL after `diinput_tanggal`, 
						  CHANGE `diperbaharui_tanggal` `diperbaharui_tanggal` date NULL after `diperbaharui_oleh`;");
 		}

 		$cekkolum = $this->isColumnExist('delegasi_keluar','status_kirim');  		
        if(!$cekkolum){
		$this->db->query("ALTER TABLE `delegasi_keluar` 
						  ADD COLUMN `status_kirim` char(1) NULL DEFAULT '0' COMMENT '0=blm terkirim 1=sudah terkirim 2=dilaksanakan' after `catatan`, 
						  CHANGE `diinput_oleh` `diinput_oleh` varchar(30)  NULL after `status_kirim`, 
						  CHANGE `diinput_tanggal` `diinput_tanggal` date   NULL after `diinput_oleh`, 
						  CHANGE `diperbaharui_oleh` `diperbaharui_oleh` varchar(30)  NULL after `diinput_tanggal`, 
						  CHANGE `diperbaharui_tanggal` `diperbaharui_tanggal` date   NULL after `diperbaharui_oleh`;");
        }

        $cekkolum = $this->isColumnExist('delegasi_proses_keluar','namadokumen');  		
        if($cekkolum){
 		$this->db->query("ALTER TABLE `delegasi_proses_keluar` 
  						CHANGE `namadokumen` `namadokumen` text DEFAULT NULL after `status_delegasi`;");
 		}

 		$cekkolum = $this->isColumnExist('delegasi_proses_masuk','namadokumen');  		
        if($cekkolum){
 		$this->db->query("ALTER TABLE `delegasi_proses_masuk` 
  						CHANGE `namadokumen` `namadokumen` text DEFAULT NULL after `status_delegasi`;");
 		}

 		$cekkolum = $this->isColumnExist('jenis_penahanan','urutan');  		
        if(!$cekkolum){
 		$this->db->query("ALTER TABLE `jenis_penahanan` ADD COLUMN `urutan` INT(11) NULL AFTER `kode`;");
 		}

 		$this->db->query("REPLACE INTO `jenis_penahanan` (`id`, `kode`, `urutan`, `nama`, `batas_waktu`, `batas_waktu_anak`, `keterangan`, `jenis_pengadilan`, `aktif`, `diinput_oleh`, `diinput_tanggal`, `diperbaharui_oleh`, `diperbaharui_tanggal`) values
						('1','PNY','1','Penyidik','20','7','Penahanan oleh Penyidik','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('2','PNY_PU','2','Penyidik Perpanjangan Oleh PU','40','8','Penahanan oleh Penyidik dengan perpanjangan oleh Penuntut Umum','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('3','PNY_KPN','3','Penyidik Perpanjangan Pertama Oleh Ketua PN','30','15','Penahanan oleh Penyidik dengan perpanjangan oleh Ketua PN','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('4','PU','5','Penuntut','20','5','Penahanan oleh Penuntut Umum','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('5','PU_KPN','6','Penuntut Perpanjangan Pertama Oleh Ketua PN','30','5','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua PN','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('6','PU_KPT','7','Penuntut Perpanjangan Kedua Oleh Ketua PN','30','15','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua PT','1','Y','admin',NULL,NULL,'2017-05-05 11:01:32'),
						('7','HKPN','8','Hakim PN','30','10','Penahanan oleh Hakim PN','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('8','HKPN_KPN','9','Hakim PN Perpanjangan Pertama Oleh Ketua PN','60','15','Penahanan oleh Hakim PN dengan perpanjangan oleh Ketua PN','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('9','HKPN_KPT','11','Hakim PN Perpanjangan Oleh Ketua PT','30','15','Penahanan oleh Hakim PN dengan perpanjangan oleh Ketua PT','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('10','HKPT','12','Hakim PT','30','10','Penahanan oleh Hakim PT (Banding)','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('11','HKPT_KPT','13','Hakim PT Perpanjangan Oleh Ketua PT','60','15','Penahanan oleh Hakim PT (Banding) dengan perpanjangan oleh Ketua PT','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('12','HKPT_KMA','14','Hakim PT Perpanjangan Oleh Ketua MA','30','15','Penahanan oleh Hakim PT (Banding) dengan perpanjangan oleh Ketua MA','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('13','HKMA','15','Hakim Agung','50','15','Penahanan oleh Hakim Agung (Kasasi)','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('14','HKMA_KMA','16','Hakim Agung Perpanjangan Oleh Ketua MA','60','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','1','Y','admin',NULL,'admin','2017-05-05 11:01:32'),
						('15',NULL,'1','Atasan Yang Berhak Menghukum','20',NULL,'Penahanan oleh Atasan Yang Berhak Menghukum','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('16',NULL,'2','ANKUM Perpanjangan I oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke I oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('17',NULL,'3','ANKUM Perpanjangan II oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke II oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('18',NULL,'4','ANKUM Perpanjangan III oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke III oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('19',NULL,'5','ANKUM Perpanjangan IV oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke IV oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('20',NULL,'6','ANKUM Perpanjangan V oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke V oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('21',NULL,'7','ANKUM Perpanjangan VI oleh Perwira Penyerah Perkara','30',NULL,'Penahanan oleh ANKUM dengan perpanjangan ke VI oleh Perwira Penyerah Perkara (PAPERA)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('22',NULL,'8','Hakim Ketua','30',NULL,'Penahanan oleh Hakim Ketua','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('23',NULL,'9','Hakim Ketua Perpanjangan Oleh Kadilmil','60',NULL,'Penahanan oleh Hakim Ketua dengan perpanjangan oleh Kadilmil','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('24',NULL,'10','Hakim Ketua Perpanjangan Oleh Kadilmilti','60',NULL,'Penahanan oleh Hakim Ketua dengan perpanjangan oleh Kadilmilti','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('25',NULL,'11','Hakim TK Banding','30',NULL,'Penahanan oleh Hakim Ketua TK Banding','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('26',NULL,'12','Hakim TK Banding Perpanjangan Oleh Kadilmilti','60',NULL,'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Kadilmilti','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('27',NULL,'13','Hakim TK Banding Perpanjangan Oleh Kadilmiltama','60',NULL,'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Kadilmiltama','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('28',NULL,'14','Hakim TK Banding Perpanjangan Oleh Ketua MA','60',NULL,'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Ketua MA','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('29',NULL,'15','Hakim Agung','50',NULL,'Penahanan oleh Hakim Agung (Kasasi)','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('30',NULL,'16','Hakim Agung Perpanjangan Oleh Ketua MA','60',NULL,'Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('31',NULL,'17','Kadilmil',NULL,NULL,'Pembebasan oleh Kadilmil','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('32',NULL,'18','Kadilmilti',NULL,NULL,'Pembebasan oleh Kadilmilti','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('33',NULL,'19','Kadilmiltama',NULL,NULL,'Pembebasan oleh Kadilmiltama','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('34',NULL,'20','Ketua MA',NULL,NULL,'Pembebasan oleh Ketua MA','2','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('35','PNY','1','Penyidik','20','7','Penahanan oleh Penyidik','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('36','PNY_PU','2','Penyidik Perpanjangan Oleh PU','40','8','Penahanan oleh Penyidik dengan perpanjangan oleh Penuntut Umum','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('37','PNY_KPN','3','Penyidik Perpanjangan Pertama Oleh Ketua MS','30','15','Penahanan oleh Penyidik dengan perpanjangan oleh Ketua MS','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('38','PU','5','Penuntut','20','5','Penahanan oleh Penuntut Umum','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('39','PU_KPN','6','Penuntut Perpanjangan Pertama Oleh Ketua MS','30','5','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua MS','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('40','PU_KPT','7','Penuntut Perpanjangan Kedua Oleh Ketua MS','30','15','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua MS Aceh','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('41','HKPN','8','Hakim MS','30','10','Penahanan oleh Hakim MS','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('42','HKPN_KPN','9','Hakim MS Perpanjangan Pertama Oleh Ketua MS','60','15','Penahanan oleh Hakim MS dengan perpanjangan oleh Ketua MS','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('43','HKPN_KPT','11','Hakim MS Perpanjangan Oleh Ketua MS Aceh','30','15','Penahanan oleh Hakim MS dengan perpanjangan oleh Ketua MS Aceh','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('44','HKPT','12','Hakim MS Aceh','30','10','Penahanan oleh Hakim MS Aceh (Banding)','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('45','HKPT_KPT','13','Hakim MS Aceh Perpanjangan Oleh Ketua MS Aceh','60','15','Penahanan oleh Hakim MS Aceh (Banding) dengan perpanjangan oleh Ketua MS Aceh','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('46','HKPT_KMA','14','Hakim MS Aceh Perpanjangan Oleh Ketua MA','30','15','Penahanan oleh Hakim MS Aceh (Banding) dengan perpanjangan oleh Ketua MA','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('47','HKMA','15','Hakim Agung','50','15','Penahanan oleh Hakim Agung (Kasasi)','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('48','HKMA_KMA','16','Hakim Agung Perpanjangan Oleh Ketua MA','60','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','4','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('49',NULL,'4','Penyidik Perpanjangan Kedua Oleh Ketua PN','30','15','Penahanan oleh Penyidik dengan perpanjangan kedua oleh Ketua PN','1','Y','admin',NULL,'system','2017-05-05 11:01:32'),
						('50',NULL,'10','Hakim PN Perpanjangan kedua Oleh Ketua PN','30','15','Penahanan oleh Hakim PN dengan perpanjangan kedua oleh Ketua PT','1','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('51',NULL,'17','Hakim Agung Perpanjangan Pertama Oleh Ketua MA','30','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','1','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('52',NULL,'18','Hakim Agung Perpanjangan Kedua Oleh Ketua MA','30','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','1','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('53',NULL,'4','Penyidik Perpanjangan Kedua Oleh Ketua MS','30','15','Penahanan oleh Penyidik dengan perpanjangan kedua oleh Ketua MS','4','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('54',NULL,'10','Hakim MS Perpanjangan kedua Oleh Ketua MS','30','15','Penahanan oleh Hakim MS dengan perpanjangan kedua oleh Ketua MS Aceh','4','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('55',NULL,'17','Hakim Agung Perpanjangan Pertama Oleh Ketua MA','30','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','4','Y','admin',NULL,'','2017-05-05 11:01:32'),
						('56',NULL,'18','Hakim Agung Perpanjangan Kedua Oleh Ketua MA','30','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','4','Y','admin',NULL,'','2017-05-05 11:01:32');
						");

 		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '5';");
 		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '143';");
 		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '6';");
		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/Cipta/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '164';");
		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/Merek/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '165';"); 			
		$this->db->query("UPDATE `jenis_perkara` SET `format_nomor` = '#nomor_urut_perkara#/#kode_alur_perkara#/Paten/#tahun#/PN Niaga #kode_pn#' WHERE `id` = '166';");
 		
 		$this->db->query("REPLACE INTO `sys_config` (`id`, `category`, `name`, `value`, `ordering`) values
						('93','Site','PlhKetua','','0'),
						('94','Site','PlhKetuaNip','','0'),
						('95','Site','PlhPanitera','','0'),
						('96','Site','PlhPaniteraNip','','0'),
						('97','Site','PltKetua','','0'),
						('98','Site','PltKetuaNip','','0'),
						('99','Site','PltPanitera','','0'),
						('100','Site','PltPaniteraNip','','0');");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_dokumen_ref` (
						  `dokumen_ref_id` int(11) NOT NULL AUTO_INCREMENT,
						  `jenis_pengadilan` double DEFAULT NULL,
						  `alur_perkara_id` double DEFAULT NULL,
						  `pengajuan_id` double DEFAULT NULL,
						  `keterangan_file` varchar(255) DEFAULT NULL,
						  `urutan` double DEFAULT NULL,
						  `format` varchar(255) DEFAULT NULL,
						  PRIMARY KEY (`dokumen_ref_id`)
						) ENGINE=InnoDB;");

 		$this->db->query("REPLACE INTO `dirput_dokumen_ref`(`dokumen_ref_id`,`jenis_pengadilan`,`alur_perkara_id`,`pengajuan_id`,`keterangan_file`,`urutan`,`format`) values
						 (1,1,1,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (2,1,1,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (3,1,1,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (4,1,1,3,'Memori Kasasi',4,'rtf'),
						 (5,1,1,3,'Kontra Memori Kasasi',5,'rtf'),
						 (6,1,1,3,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (7,1,1,3,'Putusan Pengadilan Tingkat Banding',7,'rtf'),
						 (8,4,15,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (9,4,15,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (10,4,15,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (11,4,15,3,'Memori Kasasi',4,'rtf'),
						 (12,4,15,3,'Kontra Memori Kasasi',5,'rtf'),
						 (13,4,15,3,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (14,4,15,3,'Putusan Pengadilan Tingkat Banding',7,'rtf'),
						 (15,3,9,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (16,3,9,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (17,3,9,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (18,3,9,3,'Memori Kasasi',4,'rtf'),
						 (19,3,9,3,'Kontra Memori Kasasi',5,'rtf'),
						 (20,3,9,3,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (21,3,9,3,'Putusan Pengadilan Tingkat Banding',7,'rtf'),
						 (22,1,111,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (23,1,111,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (24,1,111,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (25,1,111,3,'Memori Kasasi',4,'rtf'),
						 (26,1,111,3,'Kontra Memori Kasasi',5,'rtf'),
						 (27,1,111,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (28,1,111,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (29,1,111,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (30,1,115,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (31,1,115,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (32,1,115,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (33,1,115,3,'Memori Kasasi',4,'rtf'),
						 (34,1,115,3,'Kontra Memori Kasasi',5,'rtf'),
						 (35,1,115,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (36,1,115,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (37,1,115,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (38,1,116,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (39,1,116,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (40,1,116,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (41,1,116,3,'Memori Kasasi',4,'rtf'),
						 (42,1,116,3,'Kontra Memori Kasasi',5,'rtf'),
						 (43,1,116,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (44,1,116,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (45,1,116,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (46,1,117,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (47,1,117,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (48,1,117,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (49,1,117,3,'Memori Kasasi',4,'rtf'),
						 (50,1,117,3,'Kontra Memori Kasasi',5,'rtf'),
						 (51,1,117,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (52,1,117,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (53,1,117,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (54,1,118,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (55,1,118,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (56,1,118,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (57,1,118,3,'Memori Kasasi',4,'rtf'),
						 (58,1,118,3,'Kontra Memori Kasasi',5,'rtf'),
						 (59,1,118,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (60,1,118,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (61,1,118,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (62,1,119,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (63,1,119,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (64,1,119,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (65,1,119,3,'Memori Kasasi',4,'rtf'),
						 (66,1,119,3,'Kontra Memori Kasasi',5,'rtf'),
						 (67,1,119,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (68,1,119,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (69,1,119,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (70,2,120,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (71,2,120,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (72,2,120,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (73,2,120,3,'Memori Kasasi',4,'rtf'),
						 (74,2,120,3,'Kontra Memori Kasasi',5,'rtf'),
						 (75,2,120,3,'Surat Dakwaan Jaksa',6,'rtf'),
						 (76,2,120,3,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (77,2,120,3,'Putusan Pengadilan Tingkat Banding',8,'rtf'),
						 (78,1,1,1,'Putusan Anonimasi',100,'pdf'),
						 (79,4,15,1,'Putusan Anonimasi',100,'pdf'),
						 (80,3,9,1,'Putusan Anonimasi',100,'pdf'),
						 (81,1,111,1,'Putusan Anonimasi',100,'pdf'),
						 (82,1,115,1,'Putusan Anonimasi',100,'pdf'),
						 (83,1,116,1,'Putusan Anonimasi',100,'pdf'),
						 (84,1,117,1,'Putusan Anonimasi',100,'pdf'),
						 (85,1,118,1,'Putusan Anonimasi',100,'pdf'),
						 (86,1,119,1,'Putusan Anonimasi',100,'pdf'),
						 (87,2,120,1,'Putusan Anonimasi',100,'pdf'),
						 (88,1,1,1,'Putusan Published',99,'pdf'),
						 (89,4,15,1,'Putusan Published',99,'pdf'),
						 (90,3,9,1,'Putusan Published',99,'pdf'),
						 (91,1,111,1,'Putusan Published',99,'pdf'),
						 (92,1,115,1,'Putusan Published',99,'pdf'),
						 (93,1,116,1,'Putusan Published',99,'pdf'),
						 (94,1,117,1,'Putusan Published',99,'pdf'),
						 (95,1,118,1,'Putusan Published',99,'pdf'),
						 (96,1,119,1,'Putusan Published',99,'pdf'),
						 (97,2,120,1,'Putusan Published',99,'pdf'),
						 (100,1,2,1,'Putusan Published',99,'pdf'),
						 (101,1,1,2,'Surat Pengantar Berkas',11,'pdf'),
						 (102,4,15,2,'Surat Pengantar Berkas',11,'pdf'),
						 (103,3,9,2,'Surat Pengantar Berkas',11,'pdf'),
						 (104,1,111,2,'Surat Pengantar Berkas',11,'pdf'),
						 (105,1,115,2,'Surat Pengantar Berkas',11,'pdf'),
						 (106,1,116,2,'Surat Pengantar Berkas',11,'pdf'),
						 (107,1,117,2,'Surat Pengantar Berkas',11,'pdf'),
						 (108,1,118,2,'Surat Pengantar Berkas',11,'pdf'),
						 (109,1,119,2,'Surat Pengantar Berkas',11,'pdf'),
						 (110,2,120,2,'Surat Pengantar Berkas',11,'pdf'),
						 (111,1,2,2,'Surat Pengantar Berkas',11,'pdf'),
						 (112,1,1,3,'Surat Pengantar Berkas',11,'pdf'),
						 (113,4,15,3,'Surat Pengantar Berkas',11,'pdf'),
						 (114,3,9,3,'Surat Pengantar Berkas',11,'pdf'),
						 (115,1,111,3,'Surat Pengantar Berkas',11,'pdf'),
						 (116,1,115,3,'Surat Pengantar Berkas',11,'pdf'),
						 (117,1,116,3,'Surat Pengantar Berkas',11,'pdf'),
						 (118,1,117,3,'Surat Pengantar Berkas',11,'pdf'),
						 (119,1,118,3,'Surat Pengantar Berkas',11,'pdf'),
						 (120,1,119,3,'Surat Pengantar Berkas',11,'pdf'),
						 (121,2,120,3,'Surat Pengantar Berkas',11,'pdf'),
						 (122,1,2,3,'Surat Pengantar Berkas',11,'pdf'),
						 (124,1,1,4,'Surat Pengantar Berkas',11,'pdf'),
						 (125,4,15,4,'Surat Pengantar Berkas',11,'pdf'),
						 (126,3,9,4,'Surat Pengantar Berkas',11,'pdf'),
						 (127,1,111,4,'Surat Pengantar Berkas',11,'pdf'),
						 (128,1,115,4,'Surat Pengantar Berkas',11,'pdf'),
						 (129,1,116,4,'Surat Pengantar Berkas',11,'pdf'),
						 (130,1,117,4,'Surat Pengantar Berkas',11,'pdf'),
						 (131,1,118,4,'Surat Pengantar Berkas',11,'pdf'),
						 (132,1,119,4,'Surat Pengantar Berkas',11,'pdf'),
						 (133,2,120,4,'Surat Pengantar Berkas',11,'pdf'),
						 (134,1,2,4,'Surat Pengantar Berkas',11,'pdf'),
						 (135,1,1,2,'Relas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (136,1,1,2,'Akta Permohonan Banding',2,'pdf'),
						 (137,1,1,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (138,1,1,2,'Memori Banding',4,'rtf'),
						 (139,1,1,2,'Kontra Memori Banding',5,'rtf'),
						 (140,1,1,2,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (141,4,15,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (142,4,15,2,'Akta Permohonan Banding',2,'pdf'),
						 (143,4,15,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (144,4,15,2,'Memori Banding',4,'rtf'),
						 (145,4,15,2,'Kontra Memori Banding',5,'rtf'),
						 (146,4,15,2,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (147,3,9,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (148,3,9,2,'Akta Permohonan Banding',2,'pdf'),
						 (149,3,9,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (150,3,9,2,'Memori Banding',4,'rtf'),
						 (151,3,9,2,'Kontra Memori Banding',5,'rtf'),
						 (152,3,9,2,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (153,1,111,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (154,1,111,2,'Akta Permohonan Banding',2,'pdf'),
						 (155,1,111,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (156,1,111,2,'Memori Banding',4,'rtf'),
						 (157,1,111,2,'Kontra Memori Banding',5,'rtf'),
						 (158,1,111,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (159,1,111,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (160,1,115,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (161,1,115,2,'Akta Permohonan Banding',2,'pdf'),
						 (162,1,115,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (163,1,115,2,'Memori Banding',4,'rtf'),
						 (164,1,115,2,'Kontra Memori Banding',5,'rtf'),
						 (165,1,115,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (166,1,115,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (167,1,116,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (168,1,116,2,'Akta Permohonan Banding',2,'pdf'),
						 (169,1,116,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (170,1,116,2,'Memori Banding',4,'rtf'),
						 (171,1,116,2,'Kontra Memori Banding',5,'rtf'),
						 (172,1,116,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (173,1,116,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (174,1,117,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (175,1,117,2,'Akta Permohonan Banding',2,'pdf'),
						 (176,1,117,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (177,1,117,2,'Memori Banding',4,'rtf'),
						 (178,1,117,2,'Kontra Memori Banding',5,'rtf'),
						 (179,1,117,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (180,1,117,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (181,1,118,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (182,1,118,2,'Akta Permohonan Banding',2,'pdf'),
						 (183,1,118,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (184,1,118,2,'Memori Banding',4,'rtf'),
						 (185,1,118,2,'Kontra Memori Banding',5,'rtf'),
						 (186,1,118,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (187,1,118,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (188,1,119,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (189,1,119,2,'Akta Permohonan Banding',2,'pdf'),
						 (190,1,119,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (191,1,119,2,'Memori Banding',4,'rtf'),
						 (192,1,119,2,'Kontra Memori Banding',5,'rtf'),
						 (193,1,119,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (194,1,119,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (195,2,120,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (196,2,120,2,'Akta Permohonan Banding',2,'pdf'),
						 (197,2,120,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (198,2,120,2,'Memori Banding',4,'rtf'),
						 (199,2,120,2,'Kontra Memori Banding',5,'rtf'),
						 (200,2,120,2,'Surat Dakwaan Jaksa',6,'rtf'),
						 (201,2,120,2,'Putusan Pengadilan Tingkat Pertama',7,'rtf'),
						 (202,1,1,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (203,1,1,4,'Berita Acara Sumpah Bukti Baru/Novum',2,'pdf'),
						 (204,1,1,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (205,1,1,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (206,1,1,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (207,1,1,4,'Puusan Pengadilan Tingkat Banding',6,'rtf'),
						 (208,1,1,4,'Putusan Pengadilan Kasasi',7,'rtf'),
						 (209,4,15,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (210,4,15,4,'Berita Acara Sumpah Bukti Baru/Novum',2,'pdf'),
						 (211,4,15,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (212,4,15,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (213,4,15,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (214,4,15,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (215,4,15,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (216,3,9,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (217,3,9,4,'Berita Acara Sumpah Bukti Baru/Novum',2,'pdf'),
						 (218,3,9,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (219,3,9,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (220,3,9,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (221,3,9,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (222,3,9,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (223,1,111,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (224,1,111,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (225,1,111,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (226,1,111,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (227,1,111,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (228,1,111,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (229,1,111,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (230,1,115,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (231,1,115,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (232,1,115,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (233,1,115,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (234,1,115,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (235,1,115,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (236,1,115,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (237,1,116,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (238,1,116,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (239,1,116,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (240,1,116,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (241,1,116,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (242,1,116,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (243,1,116,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (244,1,117,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (245,1,117,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (246,1,117,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (247,1,117,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (248,1,117,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (249,1,117,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (250,1,117,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (251,1,118,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (252,1,118,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (253,1,118,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (254,1,118,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (255,1,118,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (256,1,118,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (257,1,118,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (258,1,119,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (259,1,119,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (260,1,119,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (261,1,119,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (262,1,119,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (263,1,119,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (264,1,119,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (265,2,120,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (266,2,120,4,'Berita Acara Pendapat Hakim',2,'pdf'),
						 (267,2,120,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (268,2,120,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (269,2,120,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (270,2,120,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (271,2,120,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (272,1,3,2,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Pertama',1,'pdf'),
						 (273,1,3,2,'Akta Permohonan Banding',2,'pdf'),
						 (274,1,3,2,'Tanda Terima Memori Banding',3,'pdf'),
						 (275,1,3,2,'Memori Banding',4,'rtf'),
						 (276,1,3,2,'Kontra Memori Banding',5,'rtf'),
						 (277,1,3,2,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (278,1,3,3,'Relaas Pemberitahuan Putusan Pengadilan Tingkat Banding',1,'pdf'),
						 (279,1,3,3,'Akta Permohonan Kasasi',2,'pdf'),
						 (280,1,3,3,'Tanda Terima Memori Kasasi',3,'pdf'),
						 (281,1,3,3,'Memori  Kasasi',4,'rtf'),
						 (282,1,3,3,'Kontra Memori Kasasi',5,'rtf'),
						 (283,1,3,3,'Putusan Pengadilan Tingkat Pertama',6,'rtf'),
						 (284,1,3,3,'Putusan Pengadilan Tingkat Banding',7,'rtf'),
						 (285,1,3,4,'Akta Permohonan Peninjauan Kembali',1,'pdf'),
						 (286,1,3,4,'Berita Acara Sumpah Bukti Baru/Novum',2,'pdf'),
						 (287,1,3,4,'Memori Peninjauan Kembali',3,'rtf'),
						 (288,1,3,4,'Kontra Memori Peninjauan Kembali',4,'rtf'),
						 (289,1,3,4,'Putusan Pengadilan Tingkat Pertama',5,'rtf'),
						 (290,1,3,4,'Putusan Pengadilan Tingkat Banding',6,'rtf'),
						 (291,1,3,4,'Putusan Tingkat Kasasi',7,'rtf'),
						 (292,1,3,2,'Surat Pengantar Berkas',11,'pdf'),
						 (293,1,3,3,'Surat Pengantar Berkas',11,'pdf'),
						 (294,1,3,4,'Surat Pengantar Berkas',11,'pdf');");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_ref` (
						  `guid` varchar(100) NOT NULL COMMENT 'id kategori di dirput',
						  `title` varchar(255) NOT NULL COMMENT 'nama kategori di dirput',
						  `category` varchar(100) NOT NULL COMMENT 'root klasifikasi perkara di dirput',
						  `alur_perkara_id` int(11) NOT NULL COMMENT 'sesuai dengan alur perkara id sipp',
						  `sub_category` varchar(100) DEFAULT NULL COMMENT 'jenis perkara di dirput',
						  `description` varchar(255) DEFAULT NULL,
						  `parentguid` varchar(100) NOT NULL COMMENT 'root kategori di dirput',
						  PRIMARY KEY (`guid`)
						) ENGINE=InnoDB;");
 		
 		$this->db->query("REPLACE INTO `dirput_ref`(`guid`,`title`,`category`,`alur_perkara_id`,`sub_category`,`description`,`parentguid`) values 
						('00c4b833fc6257d4c0f0deeed98f8951','Merek','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('018979af188b020807fa9d63fb2e2adc','Illegal Logging','PIDANA KHUSUS',111,NULL,'Illegal Logging','d92c02366ae91966e4cdbe6279fc36eb'),
						('027991f69ede91fc1d0a6bbe438b63c9','Disersi','PIDANA MILITER',120,NULL,NULL,'8ee521983e235a9701a4c3577185bd2d'),
						('02875c9ca3db2f48a688ecb515b32ec5','Sengketa Perkawinan Lainnya','PERDATA AGAMA',15,NULL,'Sengketa Perkawinan Lainnya','a28ae04e55e1f8c13005da77edbee894'),
						('02fc09e4c8b0b773cd3a09cbc2b38d7e','Pajak Penghasilan Pasal 23_PPh_23','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('056b2c3581242bd7e82a7c31c1b6b488','Waris Islam','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('08afe47c06368656e57ba80665a4143a','Persaingan Usaha','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('0964c9d934e32054cc598cc32dc8c29f','Kejahatan terhadap asal usul perkawinan','PIDANA UMUM',111,NULL,'kejahatan terhadap asal usul perkawinan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('0b45819ea1d4ba00f8af948f331792c9','Pajak Pemanfaatan Air Bawah Tanah & Air Permukaan','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('0b9eec4587904ed48724c3886d009d29','Farmasi','PIDANA KHUSUS',111,NULL,'Farmasi','d92c02366ae91966e4cdbe6279fc36eb'),
						('0cfd1c8a1e785166c0663821392a1c96','Perwalian','PERDATA AGAMA',15,NULL,'Perwalian','a28ae04e55e1f8c13005da77edbee894'),
						('0ddbcc4cbd4d7cbc383beac92bd0ae69','Kepabeanan','PIDANA KHUSUS',111,NULL,'Kepabeanan','d92c02366ae91966e4cdbe6279fc36eb'),
						('12d263c8436c8bd4c1347e1f3b78f2a0','Kejahatan terhadap Keteriban Umum','PIDANA UMUM',111,NULL,'Kejahatan terhadap Ketertiban Umum','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('13bc5b91b75b0bf00a166f8b0ec9f2dd','Konservasi SDA','PIDANA KHUSUS',111,NULL,'Konservasi SDA','d92c02366ae91966e4cdbe6279fc36eb'),
						('1656b9576222d28f7e4fcc0d76f41abf','Pendidikan','TUN',9,NULL,'Pendidikan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('1671deb29f955e3feff2027405118cb4','Pidsus Pra Peradilan','PIDANA KHUSUS',119,NULL,'Pra Peradilan','d92c02366ae91966e4cdbe6279fc36eb'),
						('18c43c54ddb985c7839e2e61c6463665','Desain Industri','PERDATA KHUSUS',6,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('1a59bb11a47015a853efd4e9d5e2c513','Migas','PIDANA KHUSUS',111,NULL,'Minyak dan Gas','d92c02366ae91966e4cdbe6279fc36eb'),
						('1abe7fb50d266e97321ca5307f67369b','Paten','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('1cf3c4780d86b4779609fd1e1a4c55fa','Penempatan dan Perlindungan TKI','PIDANA KHUSUS',111,NULL,'Penempatan dan Perlindungan TKI','d92c02366ae91966e4cdbe6279fc36eb'),
						('1dbb3feb3db9a274f95c2438f3eaee05','KIP','TUN',9,NULL,'KIP','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('1e1b6491de132b06fb19c24eb1dd40d4','Perijinan','TUN',9,NULL,'Perijinan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('20b9031c89f699d59202fe933a3a58af','Lingkungan Hidup','PIDANA KHUSUS',111,NULL,'Lingkungan Hidup','d92c02366ae91966e4cdbe6279fc36eb'),
						('21a9d310a93ac34aaa68d1bbe457d56b','Pilkada','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('243b24077fc8b2083cc5d4a664bb9e99','Pajak Pembangunan I_PPb_I','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('27d35e7a70d38e8959a2af8102d7f46b','Subordinasi','PIDANA MILITER',120,NULL,NULL,'8ee521983e235a9701a4c3577185bd2d'),
						('28bd01299a9b99609e60d9b2db1e0fca','Kehutanan','PIDANA UMUM',111,NULL,'Kehutanan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('2bcd1c4e27f1e4383f27c9279eea7f27','Pidsus Terorisme','PIDANA KHUSUS',111,NULL,'Terorisme yang tergolong pada Pidana Khusus','d92c02366ae91966e4cdbe6279fc36eb'),
						('2bd551ad045b575d1f9fecba8b9b30c0','Pajak Bahan Bakar Kendaraan Bermotor','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('2c1ba6dc960f638b991a87475ede3d4c','Pencurian','PIDANA UMUM',111,NULL,'Pencurian','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('2dbffce62f32d382b70ee772bb3c3c44','Kependudukan Kewarganegaraan','TUN',9,NULL,'Kependudukan Kewarganegaraan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('2de4b6fa673f48c4cc4c669d8f0f418a','Pemerasan dan Pengancaman','PIDANA UMUM',111,NULL,'Pemerasan dan Pengancaman','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('2e43da4ffbd3f7803cb80cce91ad8866','Wanprestasi','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('2ece168ff66dd58321e9494a3b82fa13','Kejahatan terhadap Keamanan Negara','PIDANA UMUM',111,NULL,'Kejahatan Terhadap Keamanan Negara','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('30a73203fcdbcf1fcef82e871217de76','Hak Uji Materiil','TUN',9,NULL,NULL,'6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('355fc1baa4f336c44cb93f2d7edd8032','Lelang','TUN',9,NULL,'Lelang','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('35ba6ef3a483c9085cd94932ea0ada61','Kepailitan','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('3a2df562e498458e768d5cf102161eea','Pajak Penghasilan Pasal 21_PPh21','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('3ad17c1b065126649d4f84a2e1f109f9','Hibah','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('3c40e48bbab311301a21c445b3c7fe57','Narkotika & Psikotropika','PIDANA KHUSUS',111,NULL,'Narkotika & Psikotropika','d92c02366ae91966e4cdbe6279fc36eb'),
						('3d7f3c735e618b69dca7c8554cebd8c8','Pengelolaan Wilayah Pesisir','PIDANA KHUSUS',111,NULL,'Pengelolaan Wilayah Pesisir','d92c02366ae91966e4cdbe6279fc36eb'),
						('4006bb0b3d860524467270a51f84cb58','Pornografi','PIDANA KHUSUS',111,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('40aa743c507290ab9526c8bb75131a34','Cukai','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('40db4e17e40047f1bf0237f8d2ab5cc1','Perceraian','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('40ef1c22708b9e43e818eb930ca83853','Persaingan Usaha','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('40f43beaf6b7083776dd97502882a02c','Pajak Penghasilan Pasal 21 Final','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('4210395c07581866de499a7b125ea4bc','Penganiayaan','PIDANA UMUM',111,NULL,'Penganiayaan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('42f05b028a094ed9e736cc76fdbdd7ec','Pembagian Harta','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('440f32d10c676ad90503fa1b57ec1eec','Perumahan','TUN',9,NULL,'Perumahan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('473d684ed97c72809151a996688bc38a','Mata Uang','PIDANA KHUSUS',111,NULL,'Mata Uang','d92c02366ae91966e4cdbe6279fc36eb'),
						('49aa5b785040b433899e4efc4ffb3877','Paten','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('4b4a43bf378ec8efe9eb61b41ca232a5','Pajak Penghasilan Pasal 25 Final','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('4c310c6f2a0f804af0a8644829b80b29','Senjata Api','PIDANA KHUSUS',111,NULL,'Senjata Api','d92c02366ae91966e4cdbe6279fc36eb'),
						('4c665b31316bdc614a6d07539b8a5ddf','Penistaan','PIDANA KHUSUS',111,NULL,'Penistaan','d92c02366ae91966e4cdbe6279fc36eb'),
						('4d2012854964e26eb35c39c07e315995','Kesusilaan','PIDANA MILITER',120,NULL,'Kesusilaan','8ee521983e235a9701a4c3577185bd2d'),
						('4d88fcc4f35395470bd80f19f776d242','Perdata','PERDATA',1,NULL,'Hukum Perdata','r'),
						('4f47f4f78ac52c3ffc30b03dee91e124','Pajak Penghasilan Pasal 15 Final','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('5075830a91a075755bda4222224447e0','Harta Bersama','PERDATA AGAMA',15,NULL,'Harta Bersama','a28ae04e55e1f8c13005da77edbee894'),
						('531460ffeba0a5f1d93a8502ede1c66c','Gugatan Atas Keputusan','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('55a5f907a6fb1fe8513fc540765438a7','Pajak','PAJAK',0,NULL,NULL,'r'),
						('562aeacdb35a01c9a8aaea3b9b252a13','Pajak Hiburan_PHi','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('58f4421adc0c68a23562874c6f26f98a','Pilkada','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('591c725c9658703f62846dd5ad0a5443','Perdagangan Orang','PIDANA KHUSUS',111,NULL,'Perdagangan Orang','d92c02366ae91966e4cdbe6279fc36eb'),
						('5b3b183b41bc6ab3764cab235b9a3f8a','Perbankan','PIDANA KHUSUS',111,NULL,'Perbankan','d92c02366ae91966e4cdbe6279fc36eb'),
						('5da80613c6c60bcdaa05cbdd4df6d3c5','Lingkungan Hidup','TUN',9,NULL,'Lingkungan Hidup','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('5dc631a1c0318c606f8835603566c948','Perbuatan Melawan Hukum','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('5f7055f696397b2e588b6bb3bb2005c2','Kejahatan Merek','PIDANA KHUSUS',111,NULL,'Kejahatan Merek','d92c02366ae91966e4cdbe6279fc36eb'),
						('6028ddec9d91dba286cde3fe13bf7b00','Kejahatan terhadap keamanan negara','',0,NULL,'Hukum Pidana','6028ddec9d91dba286cde3fe13bf7b00'),
						('6063e97a29fc8ddd64c29db3686ad5a1','Uang Palsu','PIDANA KHUSUS',111,NULL,'Uang Palsu','d92c02366ae91966e4cdbe6279fc36eb'),
						('620f4cc570bb70cf968651c5cb507135','Izin Poligami','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('6234978ce3bdbbd2d44193778def96c1','Kealfaan mengakibatkan kematian/luka','PIDANA UMUM',111,NULL,'kealfaan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('62395453c4006e656c9648c30323f682','Pajak Penerangan Jalan_PPJ','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('63303f1c498ad0665cef0b12d522830e','Pidsus Kehutanan','PIDANA KHUSUS',111,NULL,'Kehutanan yang tergolong Pidana Khusus','d92c02366ae91966e4cdbe6279fc36eb'),
						('668547fce23f14622aad9583cf196435','Kejahatan Hak Cipta','PIDANA KHUSUS',111,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('6720f9cd2255df3b2c0f49f868efac44','KDRT','PIDANA KHUSUS',111,NULL,'Kekerasan Dalam Rumah Tangga','d92c02366ae91966e4cdbe6279fc36eb'),
						('67286de849c882ed7412e51bbd79ac89','Penggelapan','PIDANA UMUM',111,NULL,'Penggelapan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('680b36cef49bf8a9122d7e1a3748e2f4','Fidusia','PIDANA KHUSUS',111,NULL,'Fidusia','d92c02366ae91966e4cdbe6279fc36eb'),
						('69e5900e42c984e8659993ef3f07220a','Pajak Penghasilan Orang Pribadi_PPh_Pers','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('6c8fc8c06e43caf9e5483c92b15dc835','Ketenagakerjaan','PIDANA KHUSUS',111,NULL,'Ketenagakerjaan','d92c02366ae91966e4cdbe6279fc36eb'),
						('6ccf9ad6c4d6e9ab8fbc1f8b252cec81','TUN','TUN',9,NULL,'TUN','r'),
						('6dfbf4f5d78760d4d3c7655b295859bf','Lain lain termasuk Piutang','TUN',9,NULL,'Lain lain termasuk Piutang','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('6f5068aaa5515f46e4aeafca2f48dfa2','Pidana Umum','PIDANA UMUM',111,NULL,'Pidana Umum','r'),
						('6fc019505f570f3e09536941d492e717','Badan Hukum','TUN',9,NULL,'Badan Hukum','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('7070b096037b478705f308f0592ed587','Rahasia Dagang','PIDANA KHUSUS',111,NULL,'Rahasia Dagang','d92c02366ae91966e4cdbe6279fc36eb'),
						('720019806a7048ddb474cdfdd309352d','Peradilan Anak / ABH','PIDANA KHUSUS',118,NULL,'Peradilan Anak / ABH','d92c02366ae91966e4cdbe6279fc36eb'),
						('72978dc6cdc4a7f1721c86c5e6a1f624','Pelanggaran Administrasi Pemilihan','TUN',9,NULL,'Pelanggaran Administrasi Pemilihan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('72ad007bdb08c14033b593604e8b2cdf','Perceraian','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('738477533355663d2fb5ec8476ccf6df','Anak','PIDANA KHUSUS',118,NULL,'Perlindungan Anak','d92c02366ae91966e4cdbe6279fc36eb'),
						('7434f5ad5d48dfc54f7bbab167d4181e','HAM','PIDANA KHUSUS',117,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('75d2c54ea4cb6d96d9314955bb46ba07','Kejahatan terhadap Kesusilaan','PIDANA UMUM',111,NULL,NULL,'6f5068aaa5515f46e4aeafca2f48dfa2'),
						('77e1b8594fe1b109d44f5a13120cc296','Pembunuhan','PIDANA UMUM',111,NULL,'Pembunuhan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('7cbe5d63d99a3916509f4e5cf0a0a895','Asuransi','TUN',9,NULL,'Asuransi','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('7d456c8578c45f35eac4617e4059e22b','Pelayaran','PIDANA KHUSUS',111,NULL,'Pelayaran','d92c02366ae91966e4cdbe6279fc36eb'),
						('7f341f26317e022cb37e38d2c0e382df','Perumahan dan Pemukiman','PIDANA KHUSUS',111,NULL,'Perumahan dan Pemukiman','d92c02366ae91966e4cdbe6279fc36eb'),
						('827aeca979ce86a9de5219175b88a920','Bea Balik Nama Kendaraan Bermotor','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('831e9b81731822f84869929d684e4a2c','Pemalsuan','PIDANA UMUM',111,NULL,'Pemalsuan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('83835a274d4d5f5cc9d950fbcc61b49f','Perkeretaapian','PIDANA KHUSUS',111,NULL,'Perkeretaapian','d92c02366ae91966e4cdbe6279fc36eb'),
						('85b3eb3e939c0ea335fd983c82801c65','Pilkada','TUN',9,NULL,'Pilkada','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('863c1a828caf7e2572f8064097b760fd','Kepegawaian','TUN',9,NULL,'Kepegawaian','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('885b282b57bbdba71f3e124861e26ebb','Pajak Penghasilan Pasal 22 Final','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('8a759a52d314f695d4c76a34f455439b','Pajak Reklame_PRek','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('8dff1a19444a2f2d63becf72c08c2fdd','Penipuan','PIDANA UMUM',111,NULL,'Penipuan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('8eb1593d07073615fb533c1c5abb95d6','Penghinaan','PIDANA UMUM',111,NULL,'Penghinaan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('8ee521983e235a9701a4c3577185bd2d','Pidana Militer','PIDANA MILITER',0,NULL,NULL,'r'),
						('8f109891f370dc8cec67acf3c927061c','Bea Perolehan Hak Atas Tanah dan atau Bangunan','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('900381ebfb17ec007ed05023cc339343','Wasiat','PERDATA AGAMA',15,NULL,'Wasiat','a28ae04e55e1f8c13005da77edbee894'),
						('9193f27284227702ac439a0366f99c79','PHI','PERDATA KHUSUS',0,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('91bddb5d7177876be19b10a24d349829','Sumpah Palsu dan Keterangan Palsu','PIDANA UMUM',111,NULL,NULL,'6f5068aaa5515f46e4aeafca2f48dfa2'),
						('921fe31876bd4d4fc6e5003a685c0e63','Lain-lain/Tidak ada dalam tabel','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('954dc084c5961fc0f70c6603da2a35df','Perpajakan','PIDANA KHUSUS',111,NULL,'Perpajakan','d92c02366ae91966e4cdbe6279fc36eb'),
						('97dca8a6e0cb92ed7a0cefca3a861154','Senjata Api','PIDANA UMUM',111,NULL,'Senjata Api','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('981383503b3af1a65c2c2a40eb2b47e2','Perdata Khusus','PERDATA KHUSUS',1,NULL,NULL,'r'),
						('98821d8a4bc63aff3a81f66c37934f56','ITE','PIDANA KHUSUS',111,NULL,'Informasi dan Transaksi Elektronik','d92c02366ae91966e4cdbe6279fc36eb'),
						('98d7b2d72756f94ec845d83e87f75bcc','Lain-lain','PIDANA KHUSUS',111,NULL,'Lain-Lain','d92c02366ae91966e4cdbe6279fc36eb'),
						('998d4654534cd10f2a599f34b9fd2965','Waris','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('99a20278a1f42d455218b9ec4ad48a1d','Pidsus Cukai','PIDANA KHUSUS',111,NULL,'Cukai','d92c02366ae91966e4cdbe6279fc36eb'),
						('9a49acde4116f41729db232e7979515b','Pertambangan','PIDANA KHUSUS',111,NULL,'Pertambangan','d92c02366ae91966e4cdbe6279fc36eb'),
						('9af03cbe4dbe727d1bb86d66cc4cd4fe','Merek','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('9b386891789e1c4bf1765ea4f968fc5e','Pidsus Perkebunan','PIDANA KHUSUS',111,NULL,'Perkebunan','d92c02366ae91966e4cdbe6279fc36eb'),
						('9cb2ba52c8da1d2d37186651d06a9b57','Hak Cipta','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('9cf79f9082462feae5f1baed6c83b271','Arbitrase','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('9e127d49a242716992debbea4dbbfad8','Merek','TUN',9,NULL,'Merek','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('9fc546a40ea4905ee2648a525b4adf5a','STP Bunga Penagihan','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('9fcc62ba8d2d250a740060c56d3d79d7','Bea Masuk','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('a28ae04e55e1f8c13005da77edbee894','Perdata Agama','PERDATA AGAMA',15,NULL,NULL,'r'),
						('a294135c19169a89d1d6b8d9ac21e718','Perikanan','PIDANA KHUSUS',116,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('a3cc311a35d6413859bc91ca1e851e1b','Lalu Lintas','PIDANA UMUM',114,NULL,'Lalu Lintas','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('a4449cb4bc0557855464308fc241def6','Penadahan','PIDANA UMUM',111,NULL,'Penadahan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('a94db7b74daa342a93cc828479bd5829','Desain Industri','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('aa523b2e6939e143a48256eec408daf1','Pra Peradilan','PIDANA UMUM',119,NULL,NULL,'6f5068aaa5515f46e4aeafca2f48dfa2'),
						('ab24357e9d3f55d53fee3258a2c32f28','Pajak Pertambahan Nilai_PPN','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('abdcf7b26c04c72f7fda1b4fa3bc540e','Pengesahan Nikah','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('ad8a71df3b238eb93d8c99e66b072a4c','Perusakan','PIDANA UMUM',111,NULL,'Perusakan','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('adb58a7c42c83d5889227fbae64f462e','Perlindungan Konsumen','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('aee42778f834144e541c7bd0c6b17c37','Keimigrasian','PIDANA KHUSUS',111,NULL,'Keimigrasian','d92c02366ae91966e4cdbe6279fc36eb'),
						('b568862cdaa87e4a8c208d84906779db','Pertanahan','TUN',9,NULL,'Pertanahan','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('b58eda4c2be248d31a3ebaed5accb899','Kejahatan terhadap kemerdekaan orang lain','PIDANA UMUM',111,NULL,'kejahatan terhadap kemerdekaan orang lain','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('b66b9c71152b22278ddd65457df1a2a1','Pidana Perlindungan Konsumen','PIDANA KHUSUS',111,NULL,'Pidana Perlindungan Konsumen','d92c02366ae91966e4cdbe6279fc36eb'),
						('b93696c2df052bba824527c8492509a9','Ketenagalistrikan','PIDANA KHUSUS',111,NULL,'Ketenagalistrikan','d92c02366ae91966e4cdbe6279fc36eb'),
						('bb398daf5c142c48be1105e6c46535f2','Penyiaran','PIDANA KHUSUS',111,NULL,'Penyiaran','d92c02366ae91966e4cdbe6279fc36eb'),
						('bc75a1e4698f3c0b99288a0f8847cccd','Pajak Penghasilan Pasal 26_PPh26','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('bfa5809fc342e6a6ef5d3d9de5ec7075','Korupsi','PIDANA KHUSUS',115,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('c1770964237115a9dc9c8bbf5e8df25e','Pajak Bumi dan Bangunan_PBB','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('c2783b0db75a45ee589669c95ede021a','Pajak Pengambilan & Pengolahan bahan Galian Golongan C','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('c2851dab9fd3b5367bd8e82073619d0f','Hak Cipta','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('c2c176a3719dea1baffe0610689cebf5','Pidsus Industri','PIDANA KHUSUS',111,NULL,'Industri','d92c02366ae91966e4cdbe6279fc36eb'),
						('c3113bb2a3ccfa91ad348cb34dce6a42','Parpol','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('c55a90e6a573d9dc53d89d3aee624816','Pencucian Uang','PIDANA KHUSUS',111,NULL,NULL,'d92c02366ae91966e4cdbe6279fc36eb'),
						('c8489f564bf9b70625c43abeb3d5adf2','Pemerasaan dan Pengancaman','PIDANA UMUM',111,NULL,NULL,'6f5068aaa5515f46e4aeafca2f48dfa2'),
						('c867b27e93d5685f1804fdb183e65086','Tender','TUN',9,NULL,'Tender','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('c8905029717f3489154cf36b372acbe1','Perdata Khusus','',0,NULL,'Perdata Khusus','c8905029717f3489154cf36b372acbe1'),
						('cdc79f14bf84675b0e13c6de12633c3e','Partai Politik','TUN',9,NULL,'Partai Politik','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('d119830957dd50e48179c4f5b8e8e921','Tindak Pidana Ekonomi','PIDANA KHUSUS',111,NULL,'Tindak Pidana Ekonomi','d92c02366ae91966e4cdbe6279fc36eb'),
						('d595a98e3871f45e7b4e502d422a8a65','Tanah','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('d6aad19f357bc6e124c28b551cdb0c97','Wakaf','PERDATA AGAMA',15,NULL,'Wakaf','a28ae04e55e1f8c13005da77edbee894'),
						('d70b014e1c45531f9969cf3e0d61d025','Perdata Permohonan','PERDATA',2,NULL,'Permohonan','4d88fcc4f35395470bd80f19f776d242'),
						('d7ba6e357df1542a8a115d4ad3de69b1','Dispensasi Nikah','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('d92c02366ae91966e4cdbe6279fc36eb','Pidana Khusus','PIDANA KHUSUS',0,NULL,NULL,'r'),
						('d9ecdbba1a4d4fbd785a562425f28def','Pembatalan Nikah','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('dad8807c899ed488fabbb9a5e2063e83','Pemerintah Daerah','PIDANA KHUSUS',111,NULL,'Pemerintah Daerah','d92c02366ae91966e4cdbe6279fc36eb'),
						('db0ca252ff27185a75988e7311a48a9a','PHI','',0,NULL,NULL,'c8905029717f3489154cf36b372acbe1'),
						('dc77d5e7f5cd9c2f088b4c0959da0b44','Paten','',0,NULL,'Paten','dc77d5e7f5cd9c2f088b4c0959da0b44'),
						('e249b812a0a98e1a72072054581a5569','Perjudian','PIDANA UMUM',111,NULL,'Perjudian','6f5068aaa5515f46e4aeafca2f48dfa2'),
						('e5a3631b30c3d836ad1f1a9fca10b0d7','Sengketa Kewenangan Mengadili','Sengketa Kewenangan Mengadili',0,NULL,'Sengketa Kewenangan Mengadili','r'),
						('e5d95307e12260f5246dcce8128588c2','Pajak Penghasilan Pasal 22_PPh22','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('e6aed07fd2bed44b8591dac56a708e8e','Arbitrase','PERDATA KHUSUS',1,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('e7ba7a43c03cf527ca70e12f4798d315','Ekonomi Syariah','PERDATA AGAMA',15,NULL,NULL,'a28ae04e55e1f8c13005da77edbee894'),
						('e95a24c62e4dd7fb912bede8d14c027d','Pajak','TUN',9,NULL,NULL,'6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						('e991049c6218bb231d41e0a0bbcccb94','Pajak Penjualan Barang Mewah_PPnBM','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('e9ca9b0edcabb52bcd42b17c62d38972','KIP','PERDATA KHUSUS',1,NULL,'KIP','981383503b3af1a65c2c2a40eb2b47e2'),
						('eba563e8dd2e0c890f8254bd397d1b38','Pidsus Pendidikan','PIDANA KHUSUS',111,NULL,'Pendidikan','d92c02366ae91966e4cdbe6279fc36eb'),
						('f0db0cd4ccd2c100ee7fd1cc3d980d6d','Perjanjian','PERDATA',1,NULL,NULL,'4d88fcc4f35395470bd80f19f776d242'),
						('f41a9742664732c6db7e64f73719302c','Pemilu','PIDANA KHUSUS',111,NULL,'Pemilu','d92c02366ae91966e4cdbe6279fc36eb'),
						('f576afb6cb9f61d0478dba5385641e7d','Kepailitan','PERDATA KHUSUS',3,NULL,NULL,'981383503b3af1a65c2c2a40eb2b47e2'),
						('f99e2691199f794936891a6eab7b21ab','Pajak Penghasilan Pasal 4 ayat 2 Final','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('fc08d7ce92e806537adeeb8719b6d666','Pidsus Terorisme','PIDANA KHUSUS',111,NULL,'Terorisme','d92c02366ae91966e4cdbe6279fc36eb'),
						('fcb5bbc21f96a4cc4692af1d2be72421','Pangan','PIDANA KHUSUS',111,NULL,'Pangan','d92c02366ae91966e4cdbe6279fc36eb'),
						('fdcc254aae2dc23f5360c85aaec89319','Pajak Kendaraan Bermotor_PKB','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('fea0b102ba106b5eaf4ec160fdb35ebe','Pajak Penghasilan Badan_PPhBd','PAJAK',0,NULL,NULL,'55a5f907a6fb1fe8513fc540765438a7'),
						('ffd9d1c9d5ba45dfe31ac121ff487111','Pemalsuan Uang','',0,NULL,'Hukum Pidana','ffd9d1c9d5ba45dfe31ac121ff487111');");

		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_sipp_ref` (
						  `id` int(4) NOT NULL AUTO_INCREMENT,
						  `alur_perkara_id` int(11) NOT NULL COMMENT 'sesuai dengan sipp',
						  `jenis_perkara_id` int(11) NOT NULL COMMENT 'sesuai dengan sipp',
						  `nama_alur` varchar(100) DEFAULT NULL COMMENT 'sesuai dengan sipp',
						  `jenis_perkara` varchar(255) DEFAULT NULL COMMENT 'sesuai dengan SIPP',
						  `guid` varchar(100) DEFAULT NULL COMMENT 'id kategori di dirput',
						  `parentguid` varchar(100) DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

		$this->db->query("REPLACE INTO `dirput_sipp_ref`(`id`,`alur_perkara_id`,`jenis_perkara_id`,`nama_alur`,`jenis_perkara`,`guid`,`parentguid`) VALUES 
						(1,15,368,'Perdata Gugatan','','','4d88fcc4f35395470bd80f19f776d242'),
						(2,9,6029,'Gugatan','','','4d88fcc4f35395470bd80f19f776d242'),
						(3,111,209,'Pidana Biasa','Administrasi Kependudukan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(4,118,209,'Pidana Anak','Administrasi Kependudukan','','720019806a7048ddb474cdfdd309352d'),
						(5,2,242,'Permohonan','Akta Cerai',NULL,'4d88fcc4f35395470bd80f19f776d242'),
						(6,2,94,'Permohonan','Akta Kematian','','4d88fcc4f35395470bd80f19f776d242'),
						(7,1,123,'Gugatan','Anjak Piutang/Cessie','','4d88fcc4f35395470bd80f19f776d242'),
						(8,7,123,'Perlawanan/Bantahan (derden verzet)','Anjak Piutang/Cessie','','4d88fcc4f35395470bd80f19f776d242'),
						(9,16,358,'Perdata Permohonan','Asal Usul Anak','','a28ae04e55e1f8c13005da77edbee894'),
						(10,1,71,'Gugatan','Asuransi','','4d88fcc4f35395470bd80f19f776d242'),
						(11,7,71,'Perlawanan/Bantahan (derden verzet)','Asuransi','','4d88fcc4f35395470bd80f19f776d242'),
						(12,9,325,'Gugatan','Badan Hukum','6fc019505f570f3e09536941d492e717','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(13,111,207,'Pidana Biasa','Badan Pemeriksa Keuangan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(14,118,207,'Pidana Anak','Badan Pemeriksa Keuangan','','720019806a7048ddb474cdfdd309352d'),
						(15,111,229,'Pidana Biasa','Bendera, Bahasa, Dan Lambang Negara Serta Lagu Kebangsaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(16,118,229,'Pidana Anak','Bendera, Bahasa, Dan Lambang Negara Serta Lagu Kebangsaan','','720019806a7048ddb474cdfdd309352d'),
						(17,1,140,'Gugatan','BPSK','adb58a7c42c83d5889227fbae64f462e','4d88fcc4f35395470bd80f19f776d242'),
						(18,7,140,'Perlawanan/Bantahan (derden verzet)','BPSK','','4d88fcc4f35395470bd80f19f776d242'),
						(19,15,347,'Perdata Gugatan','Cerai Gugat','72ad007bdb08c14033b593604e8b2cdf','a28ae04e55e1f8c13005da77edbee894'),
						(20,15,346,'Perdata Gugatan','Cerai Talak','72ad007bdb08c14033b593604e8b2cdf','a28ae04e55e1f8c13005da77edbee894'),
						(21,120,271,'Pidana Kejahatan','Dengan Sengaja Dengan Tindakan Nyata Menyerang Seorang Atasan','','8ee521983e235a9701a4c3577185bd2d'),
						(22,120,278,'Pidana Kejahatan','Dengan Sengaja Memaki-memaki Seorang Bawahan','','8ee521983e235a9701a4c3577185bd2d'),
						(23,120,280,'Pidana Kejahatan','Dengan Sengaja Memukul Seorang Bawahan','','8ee521983e235a9701a4c3577185bd2d'),
						(24,120,275,'Pidana Kejahatan','Dengan Sengaja Menarik Diri dari Suatu Dinas','','8ee521983e235a9701a4c3577185bd2d'),
						(25,120,265,'Pidana Kejahatan','Desersi','027991f69ede91fc1d0a6bbe438b63c9','8ee521983e235a9701a4c3577185bd2d'),
						(26,16,362,'Perdata Permohonan','Dispensasi Kawin','','a28ae04e55e1f8c13005da77edbee894'),
						(27,15,370,'Perdata Gugatan','Ekonomi Syariah','e7ba7a43c03cf527ca70e12f4798d315','a28ae04e55e1f8c13005da77edbee894'),
						(28,2,163,'Permohonan','Eksekusi','','4d88fcc4f35395470bd80f19f776d242'),
						(29,1,66,'Gugatan','Gadai/Hipotik/Fiducia','','4d88fcc4f35395470bd80f19f776d242'),
						(30,7,66,'Perlawanan/Bantahan (derden verzet)','Gadai/Hipotik/Fiducia','','4d88fcc4f35395470bd80f19f776d242'),
						(31,119,255,'Pidana Praperadilan','Ganti kerugian','','d92c02366ae91966e4cdbe6279fc36eb'),
						(32,123,255,'Praperadilan Jinayat','Ganti kerugian','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(33,119,254,'Pidana Praperadilan','Ganti kerugian dan rehabilitasi','','d92c02366ae91966e4cdbe6279fc36eb'),
						(34,123,254,'Praperadilan Jinayat','Ganti kerugian dan rehabilitasi','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(35,1,76,'Gugatan','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(36,1,131,'Gugatan','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(37,1,136,'Gugatan','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(38,7,76,'Perlawanan/Bantahan (derden verzet)','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(39,7,131,'Perlawanan/Bantahan (derden verzet)','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(40,7,136,'Perlawanan/Bantahan (derden verzet)','Ganti Rugi','','4d88fcc4f35395470bd80f19f776d242'),
						(41,15,357,'Perdata Gugatan','Ganti Rugi terhadap Wali','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(42,16,357,'Perdata Permohonan','Ganti Rugi terhadap Wali','','a28ae04e55e1f8c13005da77edbee894'),
						(43,2,241,'Permohonan','Gezeling','','4d88fcc4f35395470bd80f19f776d242'),
						(44,1,389,'Gugatan','Gugatan Terhadap Aktivis Lingkungan Hidup/Warga/Masyarakat yang memperjuangkan lingkungan hidup','','4d88fcc4f35395470bd80f19f776d242'),
						(45,7,389,'Perlawanan/Bantahan (derden verzet)','Gugatan Terhadap Aktivis Lingkungan Hidup/Warga/Masyarakat yang memperjuangkan lingkungan hidup','','4d88fcc4f35395470bd80f19f776d242'),
						(46,15,351,'Perdata Gugatan','Hak - hak bekas istri/kewajiban bekas Suami','02875c9ca3db2f48a688ecb515b32ec5','a28ae04e55e1f8c13005da77edbee894'),
						(47,117,160,'Hak Asasi Manusia','Hak Asasi Manusia','7434f5ad5d48dfc54f7bbab167d4181e','d92c02366ae91966e4cdbe6279fc36eb'),
						(48,1,137,'Gugatan','Hak Asuh Anak','','4d88fcc4f35395470bd80f19f776d242'),
						(49,7,137,'Perlawanan/Bantahan (derden verzet)','Hak Asuh Anak','','4d88fcc4f35395470bd80f19f776d242'),
						(50,5,164,'Hak Kekayaan intelektual','Hak Cipta','','981383503b3af1a65c2c2a40eb2b47e2'),
						(51,1,68,'Gugatan','Hak Ulayat/Persekutuan Adat','','4d88fcc4f35395470bd80f19f776d242'),
						(52,7,68,'Perlawanan/Bantahan (derden verzet)','Hak Ulayat/Persekutuan Adat','','4d88fcc4f35395470bd80f19f776d242'),
						(53,9,324,'Gugatan','HAKI','9e127d49a242716992debbea4dbbfad8','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(54,1,390,'Gugatan','Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','','4d88fcc4f35395470bd80f19f776d242'),
						(55,7,390,'Perlawanan/Bantahan (derden verzet)','Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','','4d88fcc4f35395470bd80f19f776d242'),
						(56,9,617,'Gugatan','Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(57,111,410,'Pidana Biasa','Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(58,1,65,'Gugatan','Harta Bersama','','4d88fcc4f35395470bd80f19f776d242'),
						(59,1,130,'Gugatan','Harta Bersama','','4d88fcc4f35395470bd80f19f776d242'),
						(60,7,65,'Perlawanan/Bantahan (derden verzet)','Harta Bersama','','4d88fcc4f35395470bd80f19f776d242'),
						(61,7,130,'Perlawanan/Bantahan (derden verzet)','Harta Bersama','','4d88fcc4f35395470bd80f19f776d242'),
						(62,15,348,'Perdata Gugatan','Harta Bersama','5075830a91a075755bda4222224447e0','a28ae04e55e1f8c13005da77edbee894'),
						(63,1,118,'Gugatan','Hibah','','4d88fcc4f35395470bd80f19f776d242'),
						(64,1,121,'Gugatan','Hibah','','4d88fcc4f35395470bd80f19f776d242'),
						(65,7,118,'Perlawanan/Bantahan (derden verzet)','Hibah','','4d88fcc4f35395470bd80f19f776d242'),
						(66,7,121,'Perlawanan/Bantahan (derden verzet)','Hibah','','4d88fcc4f35395470bd80f19f776d242'),
						(67,15,366,'Perdata Gugatan','Hibah','3ad17c1b065126649d4f84a2e1f109f9','a28ae04e55e1f8c13005da77edbee894'),
						(68,122,500,'Jinayat','Ikhtilath','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(69,120,315,'Pidana Kejahatan','Ilegal Logging','','8ee521983e235a9701a4c3577185bd2d'),
						(70,111,240,'Pidana Biasa','Imigrasi','aee42778f834144e541c7bd0c6b17c37','d92c02366ae91966e4cdbe6279fc36eb'),
						(71,118,240,'Pidana Anak','Imigrasi','','720019806a7048ddb474cdfdd309352d'),
						(72,111,216,'Pidana Biasa','Informasi dan Transaksi Elektronik','98821d8a4bc63aff3a81f66c37934f56','d92c02366ae91966e4cdbe6279fc36eb'),
						(73,118,216,'Pidana Anak','Informasi dan Transaksi Elektronik','','720019806a7048ddb474cdfdd309352d'),
						(74,120,272,'Pidana Kejahatan','Insubordinasi','27d35e7a70d38e8959a2af8102d7f46b','8ee521983e235a9701a4c3577185bd2d'),
						(75,16,361,'Perdata Permohonan','Izin Kawin','','a28ae04e55e1f8c13005da77edbee894'),
						(76,15,341,'Perdata Gugatan','Izin Poligami','620f4cc570bb70cf968651c5cb507135','a28ae04e55e1f8c13005da77edbee894'),
						(77,120,313,'Pidana Kejahatan','Jaminan Fidusia','','8ee521983e235a9701a4c3577185bd2d'),
						(78,1,62,'Gugatan','Jual Beli','','4d88fcc4f35395470bd80f19f776d242'),
						(79,7,62,'Perlawanan/Bantahan (derden verzet)','Jual Beli','','4d88fcc4f35395470bd80f19f776d242'),
						(80,1,56,'Gugatan','Jual Beli Tanah','d595a98e3871f45e7b4e502d422a8a65','4d88fcc4f35395470bd80f19f776d242'),
						(81,7,56,'Perlawanan/Bantahan (derden verzet)','Jual Beli Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(82,1,127,'Gugatan','Jual Gadai','','4d88fcc4f35395470bd80f19f776d242'),
						(83,1,129,'Gugatan','Jual Gadai','','4d88fcc4f35395470bd80f19f776d242'),
						(84,7,127,'Perlawanan/Bantahan (derden verzet)','Jual Gadai','','4d88fcc4f35395470bd80f19f776d242'),
						(85,7,129,'Perlawanan/Bantahan (derden verzet)','Jual Gadai','','4d88fcc4f35395470bd80f19f776d242'),
						(86,111,237,'Pidana Biasa','Kearsipan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(87,118,237,'Pidana Anak','Kearsipan','','720019806a7048ddb474cdfdd309352d'),
						(88,1,378,'Gugatan','Kebakaran Hutan','','4d88fcc4f35395470bd80f19f776d242'),
						(89,7,378,'Perlawanan/Bantahan (derden verzet)','Kebakaran Hutan','','4d88fcc4f35395470bd80f19f776d242'),
						(90,9,605,'Gugatan','Kebakaran Hutan','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(91,111,398,'Pidana Biasa','Kebakaran Hutan','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(92,1,622,'Gugatan','Keberatan atas ganti kerugian pengadaan tanah bagi pembangunan untuk kepentingan umum','','4d88fcc4f35395470bd80f19f776d242'),
						(93,9,326,'Gugatan','Kehutanan','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(94,111,167,'Pidana Biasa','Kejahatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(95,112,167,'Pidana Singkat','Kejahatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(96,113,167,'Pidana Cepat','Kejahatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(97,118,167,'Pidana Anak','Kejahatan','','720019806a7048ddb474cdfdd309352d'),
						(98,111,40,'Pidana Biasa','Kejahatan Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(99,112,40,'Pidana Singkat','Kejahatan Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(100,113,40,'Pidana Cepat','Kejahatan Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(101,118,40,'Pidana Anak','Kejahatan Jabatan','','720019806a7048ddb474cdfdd309352d'),
						(102,120,307,'Pidana Kejahatan','Kejahatan Jabatan','','8ee521983e235a9701a4c3577185bd2d'),
						(103,111,41,'Pidana Biasa','Kejahatan Pelayaran','7d456c8578c45f35eac4617e4059e22b','d92c02366ae91966e4cdbe6279fc36eb'),
						(104,112,41,'Pidana Singkat','Kejahatan Pelayaran','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(105,113,41,'Pidana Cepat','Kejahatan Pelayaran','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(106,118,41,'Pidana Anak','Kejahatan Pelayaran','','720019806a7048ddb474cdfdd309352d'),
						(107,120,308,'Pidana Kejahatan','Kejahatan Pelayaran','','8ee521983e235a9701a4c3577185bd2d'),
						(108,120,262,'Pidana Kejahatan','Kejahatan Penerbangan dan Kejahatan Terhadap Sarana/Prasarana Penerbangan','','8ee521983e235a9701a4c3577185bd2d'),
						(109,111,26,'Pidana Biasa','Kejahatan Perjudian','e249b812a0a98e1a72072054581a5569','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(110,118,26,'Pidana Anak','Kejahatan Perjudian','','720019806a7048ddb474cdfdd309352d'),
						(111,120,292,'Pidana Kejahatan','Kejahatan Terhadap Asal Usul dan Perkawinan','','8ee521983e235a9701a4c3577185bd2d'),
						(112,111,24,'Pidana Biasa','Kejahatan terhadap Asal Usul Perkawinan','0964c9d934e32054cc598cc32dc8c29f','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(113,112,24,'Pidana Singkat','Kejahatan terhadap Asal Usul Perkawinan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(114,113,24,'Pidana Cepat','Kejahatan terhadap Asal Usul Perkawinan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(115,118,24,'Pidana Anak','Kejahatan terhadap Asal Usul Perkawinan','','720019806a7048ddb474cdfdd309352d'),
						(116,111,13,'Pidana Biasa','Kejahatan Terhadap Keamanan Negara','2ece168ff66dd58321e9494a3b82fa13','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(117,112,13,'Pidana Singkat','Kejahatan Terhadap Keamanan Negara','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(118,113,13,'Pidana Cepat','Kejahatan Terhadap Keamanan Negara','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(119,118,13,'Pidana Anak','Kejahatan Terhadap Keamanan Negara','','720019806a7048ddb474cdfdd309352d'),
						(120,120,282,'Pidana Kejahatan','Kejahatan Terhadap Keamanan Negara','','8ee521983e235a9701a4c3577185bd2d'),
						(121,111,30,'Pidana Biasa','Kejahatan terhadap Kemerdekaan Orang','b58eda4c2be248d31a3ebaed5accb899','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(122,112,30,'Pidana Singkat','Kejahatan terhadap Kemerdekaan Orang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(123,113,30,'Pidana Cepat','Kejahatan terhadap Kemerdekaan Orang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(124,118,30,'Pidana Anak','Kejahatan terhadap Kemerdekaan Orang','','720019806a7048ddb474cdfdd309352d'),
						(125,120,297,'Pidana Kejahatan','Kejahatan Terhadap Kemerdekaan Orang','','8ee521983e235a9701a4c3577185bd2d'),
						(126,111,25,'Pidana Biasa','Kejahatan terhadap Kesusilaan','75d2c54ea4cb6d96d9314955bb46ba07','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(127,112,25,'Pidana Singkat','Kejahatan terhadap Kesusilaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(128,113,25,'Pidana Cepat','Kejahatan terhadap Kesusilaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(129,118,25,'Pidana Anak','Kejahatan terhadap Kesusilaan','','720019806a7048ddb474cdfdd309352d'),
						(130,120,293,'Pidana Kejahatan','Kejahatan Terhadap Kesusilaan','4d2012854964e26eb35c39c07e315995','8ee521983e235a9701a4c3577185bd2d'),
						(131,111,17,'Pidana Biasa','Kejahatan Terhadap Ketertiban Umum','12d263c8436c8bd4c1347e1f3b78f2a0','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(132,112,17,'Pidana Singkat','Kejahatan Terhadap Ketertiban Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(133,113,17,'Pidana Cepat','Kejahatan Terhadap Ketertiban Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(134,118,17,'Pidana Anak','Kejahatan Terhadap Ketertiban Umum','','720019806a7048ddb474cdfdd309352d'),
						(135,120,284,'Pidana Kejahatan','Kejahatan Terhadap Ketertiban Umum','','8ee521983e235a9701a4c3577185bd2d'),
						(136,111,14,'Pidana Biasa','Kejahatan terhadap Martabat Presiden dan Wakil Presiden','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(137,112,14,'Pidana Singkat','Kejahatan terhadap Martabat Presiden dan Wakil Presiden','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(138,113,14,'Pidana Cepat','Kejahatan terhadap Martabat Presiden dan Wakil Presiden','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(139,118,14,'Pidana Anak','Kejahatan terhadap Martabat Presiden dan Wakil Presiden','','720019806a7048ddb474cdfdd309352d'),
						(140,111,16,'Pidana Biasa','Kejahatan terhadap Melakukan Kewajiban dan Hak Kenegaraan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(141,112,16,'Pidana Singkat','Kejahatan terhadap Melakukan Kewajiban dan Hak Kenegaraan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(142,113,16,'Pidana Cepat','Kejahatan terhadap Melakukan Kewajiban dan Hak Kenegaraan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(143,118,16,'Pidana Anak','Kejahatan terhadap Melakukan Kewajiban dan Hak Kenegaraan','','720019806a7048ddb474cdfdd309352d'),
						(144,120,283,'Pidana Kejahatan','Kejahatan Terhadap Melakukan Kewajiban dan Hak Kenegaraan','','8ee521983e235a9701a4c3577185bd2d'),
						(145,111,15,'Pidana Biasa','Kejahatan terhadap Negara Sahabat dan terhadap Kepala Negara Sahabat serta Wakil-Wakilnya','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(146,112,15,'Pidana Singkat','Kejahatan terhadap Negara Sahabat dan terhadap Kepala Negara Sahabat serta Wakil-Wakilnya','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(147,113,15,'Pidana Cepat','Kejahatan terhadap Negara Sahabat dan terhadap Kepala Negara Sahabat serta Wakil-Wakilnya','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(148,118,15,'Pidana Anak','Kejahatan terhadap Negara Sahabat dan terhadap Kepala Negara Sahabat serta Wakil-Wakilnya','','720019806a7048ddb474cdfdd309352d'),
						(149,111,31,'Pidana Biasa','Kejahatan terhadap Nyawa','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(150,112,31,'Pidana Singkat','Kejahatan terhadap Nyawa','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(151,113,31,'Pidana Cepat','Kejahatan terhadap Nyawa','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(152,118,31,'Pidana Anak','Kejahatan terhadap Nyawa','','720019806a7048ddb474cdfdd309352d'),
						(153,120,298,'Pidana Kejahatan','Kejahatan Terhadap Nyawa','','8ee521983e235a9701a4c3577185bd2d'),
						(154,111,19,'Pidana Biasa','Kejahatan Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(155,112,19,'Pidana Singkat','Kejahatan Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(156,113,19,'Pidana Cepat','Kejahatan Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(157,118,19,'Pidana Anak','Kejahatan Terhadap Penguasa Umum','','720019806a7048ddb474cdfdd309352d'),
						(158,120,287,'Pidana Kejahatan','Kejahatan Terhadap Penguasa Umum','','8ee521983e235a9701a4c3577185bd2d'),
						(159,120,286,'Pidana Kejahatan','Kejahatan yang Membahayakan Keamanan Umum bagi Orang atau Barang','','8ee521983e235a9701a4c3577185bd2d'),
						(160,111,18,'Pidana Biasa','Kejahatan yang Membahayakan Keamananan Umum Bagi Orang atau Barang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(161,112,18,'Pidana Singkat','Kejahatan yang Membahayakan Keamananan Umum Bagi Orang atau Barang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(162,113,18,'Pidana Cepat','Kejahatan yang Membahayakan Keamananan Umum Bagi Orang atau Barang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(163,118,18,'Pidana Anak','Kejahatan yang Membahayakan Keamananan Umum Bagi Orang atau Barang','','720019806a7048ddb474cdfdd309352d'),
						(164,111,98,'Pidana Biasa','Kekerasan Dalam Rumah Tangga','6720f9cd2255df3b2c0f49f868efac44','d92c02366ae91966e4cdbe6279fc36eb'),
						(165,118,98,'Pidana Anak','Kekerasan Dalam Rumah Tangga','','720019806a7048ddb474cdfdd309352d'),
						(166,15,345,'Perdata Gugatan','Kelalaian Atas Kewajiban Suami / Istri','02875c9ca3db2f48a688ecb515b32ec5','a28ae04e55e1f8c13005da77edbee894'),
						(167,2,81,'Permohonan','Kepailitan Badan Hukum','','4d88fcc4f35395470bd80f19f776d242'),
						(168,2,82,'Permohonan','Kepailitan Untuk Orang','','4d88fcc4f35395470bd80f19f776d242'),
						(169,9,319,'Gugatan','Kepegawaian','863c1a828caf7e2572f8064097b760fd','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(170,1,382,'Gugatan','Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','','4d88fcc4f35395470bd80f19f776d242'),
						(171,7,382,'Perlawanan/Bantahan (derden verzet)','Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','','4d88fcc4f35395470bd80f19f776d242'),
						(172,9,610,'Gugatan','Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(173,111,403,'Pidana Biasa','Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(174,1,377,'Gugatan','Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','','4d88fcc4f35395470bd80f19f776d242'),
						(175,7,377,'Perlawanan/Bantahan (derden verzet)','Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','','4d88fcc4f35395470bd80f19f776d242'),
						(176,9,604,'Gugatan','Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(177,111,397,'Pidana Biasa','Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(178,111,235,'Pidana Biasa','Kesehatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(179,118,235,'Pidana Anak','Kesehatan','','720019806a7048ddb474cdfdd309352d'),
						(180,111,233,'Pidana Biasa','Ketenagalistrikan','b93696c2df052bba824527c8492509a9','d92c02366ae91966e4cdbe6279fc36eb'),
						(181,118,233,'Pidana Anak','Ketenagalistrikan','','720019806a7048ddb474cdfdd309352d'),
						(182,1,623,'Gugatan','Keterbukaan Informasi Publik','e9ca9b0edcabb52bcd42b17c62d38972','981383503b3af1a65c2c2a40eb2b47e2'),
						(183,111,219,'Pidana Biasa','Keterbukaan Informasi Publik','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(184,118,219,'Pidana Anak','Keterbukaan Informasi Publik','','720019806a7048ddb474cdfdd309352d'),
						(185,11,335,'Gugatan Keberatan (KIP)','Keterbukaan Informasi Publik (KIP)','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(186,120,621,'Pidana Kejahatan','Ketidakhadiran Tanpa Ijin','','8ee521983e235a9701a4c3577185bd2d'),
						(187,111,206,'Pidana Biasa','Kewarganegaraan Republik Indonesia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(188,118,206,'Pidana Anak','Kewarganegaraan Republik Indonesia','','720019806a7048ddb474cdfdd309352d'),
						(189,15,364,'Perdata Gugatan','Kewarisan','056b2c3581242bd7e82a7c31c1b6b488','a28ae04e55e1f8c13005da77edbee894'),
						(190,122,502,'Jinayat','Khalwat','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(191,122,501,'Jinayat','Khamar','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(192,1,383,'Gugatan','Konservasi Sumber Daya Alam','','4d88fcc4f35395470bd80f19f776d242'),
						(193,7,383,'Perlawanan/Bantahan (derden verzet)','Konservasi Sumber Daya Alam','','4d88fcc4f35395470bd80f19f776d242'),
						(194,9,611,'Gugatan','Konservasi Sumber Daya Alam','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(195,111,404,'Pidana Biasa','Konservasi Sumber Daya Alam','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(196,1,126,'Gugatan','Koperasi','','4d88fcc4f35395470bd80f19f776d242'),
						(197,7,126,'Perlawanan/Bantahan (derden verzet)','Koperasi','','4d88fcc4f35395470bd80f19f776d242'),
						(198,1,139,'Gugatan','KPPU','','4d88fcc4f35395470bd80f19f776d242'),
						(199,7,139,'Perlawanan/Bantahan (derden verzet)','KPPU','','4d88fcc4f35395470bd80f19f776d242'),
						(200,6,156,'Pengadilan Hubungan Industrial','Lain - Lain','','981383503b3af1a65c2c2a40eb2b47e2'),
						(201,1,77,'Gugatan','Lain-Lain','','4d88fcc4f35395470bd80f19f776d242'),
						(202,2,95,'Permohonan','Lain-Lain','','4d88fcc4f35395470bd80f19f776d242'),
						(203,7,77,'Perlawanan/Bantahan (derden verzet)','Lain-Lain','','4d88fcc4f35395470bd80f19f776d242'),
						(204,9,330,'Gugatan','Lain-Lain','6dfbf4f5d78760d4d3c7655b295859bf','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(205,15,369,'Perdata Gugatan','Lain-Lain','','a28ae04e55e1f8c13005da77edbee894'),
						(206,16,369,'Perdata Permohonan','Lain-Lain','','a28ae04e55e1f8c13005da77edbee894'),
						(207,111,55,'Pidana Biasa','Lain-Lain','98d7b2d72756f94ec845d83e87f75bcc','d92c02366ae91966e4cdbe6279fc36eb'),
						(208,112,55,'Pidana Singkat','Lain-Lain','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(209,113,55,'Pidana Cepat','Lain-Lain','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(210,118,55,'Pidana Anak','Lain-Lain','','720019806a7048ddb474cdfdd309352d'),
						(211,119,260,'Pidana Praperadilan','Lain-lain','','d92c02366ae91966e4cdbe6279fc36eb'),
						(212,120,339,'Pidana Kejahatan','Lain-Lain','','8ee521983e235a9701a4c3577185bd2d'),
						(213,123,260,'Praperadilan Jinayat','Lain-lain','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(214,120,276,'Pidana Kejahatan','Lalai Untuk Meneruskan Suatu Pemberitahuan','','8ee521983e235a9701a4c3577185bd2d'),
						(215,111,97,'Pidana Biasa','Lalu Lintas','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(216,118,97,'Pidana Anak','Lalu Lintas','','720019806a7048ddb474cdfdd309352d'),
						(217,121,340,'Pidana Pelanggaran','Lalu lintas dan Angkutan Jalan ','','8ee521983e235a9701a4c3577185bd2d'),
						(218,120,317,'Pidana Kejahatan','Lalu-Lintas','','8ee521983e235a9701a4c3577185bd2d'),
						(219,1,122,'Gugatan','Leasing/Sewa Beli','','4d88fcc4f35395470bd80f19f776d242'),
						(220,7,122,'Perlawanan/Bantahan (derden verzet)','Leasing/Sewa Beli','','4d88fcc4f35395470bd80f19f776d242'),
						(221,9,322,'Gugatan','Lelang','355fc1baa4f336c44cb93f2d7edd8032','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(222,111,226,'Pidana Biasa','Lembaga Pembiayaan Ekspor Indonesia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(223,118,226,'Pidana Anak','Lembaga Pembiayaan Ekspor Indonesia','','720019806a7048ddb474cdfdd309352d'),
						(224,1,384,'Gugatan','Limbah Bahan Beracun Berbahaya (B3)','','4d88fcc4f35395470bd80f19f776d242'),
						(225,7,384,'Perlawanan/Bantahan (derden verzet)','Limbah Bahan Beracun Berbahaya (B3)','','4d88fcc4f35395470bd80f19f776d242'),
						(226,9,612,'Gugatan','Limbah Bahan Beracun Berbahaya (B3)','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(227,111,405,'Pidana Biasa','Limbah Bahan Beracun Berbahaya (B3)','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(228,122,503,'Jinayat','Liwath','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(229,122,504,'Jinayat','Maisir','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(230,120,264,'Pidana Kejahatan','Mangkir','','8ee521983e235a9701a4c3577185bd2d'),
						(231,111,108,'Pidana Biasa','Melaksanakan Jasa Transportasi Ilegal','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(232,118,108,'Pidana Anak','Melaksanakan Jasa Transportasi Ilegal','','720019806a7048ddb474cdfdd309352d'),
						(233,111,29,'Pidana Biasa','Membuka Rahasia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(234,112,29,'Pidana Singkat','Membuka Rahasia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(235,113,29,'Pidana Cepat','Membuka Rahasia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(236,118,29,'Pidana Anak','Membuka Rahasia','','720019806a7048ddb474cdfdd309352d'),
						(237,120,296,'Pidana Kejahatan','Membuka Rahasia','','8ee521983e235a9701a4c3577185bd2d'),
						(238,120,268,'Pidana Kejahatan','Menantang Atasan Untuk Berkelahi Sehubungan Dengan Kedinasan','','8ee521983e235a9701a4c3577185bd2d'),
						(239,120,270,'Pidana Kejahatan','Mengancam dengan Kekerasan Terhadap Atasan','','8ee521983e235a9701a4c3577185bd2d'),
						(240,111,107,'Pidana Biasa','Mengedarkan Barang-barang Ilegal','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(241,118,107,'Pidana Anak','Mengedarkan Barang-barang Ilegal','','720019806a7048ddb474cdfdd309352d'),
						(242,111,106,'Pidana Biasa','Mengedarkan Uang Palsu','6063e97a29fc8ddd64c29db3686ad5a1','d92c02366ae91966e4cdbe6279fc36eb'),
						(243,118,106,'Pidana Anak','Mengedarkan Uang Palsu','','720019806a7048ddb474cdfdd309352d'),
						(244,120,306,'Pidana Kejahatan','Menghancurkan atau Merusak Barang','','8ee521983e235a9701a4c3577185bd2d'),
						(245,120,281,'Pidana Kejahatan','Menghilangkan Suatu Barang Keperluan Perang','','8ee521983e235a9701a4c3577185bd2d'),
						(246,120,267,'Pidana Kejahatan','Menghina Atasan','','8ee521983e235a9701a4c3577185bd2d'),
						(247,111,100,'Pidana Biasa','Menghuni rumah tanpa izin','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(248,118,100,'Pidana Anak','Menghuni rumah tanpa izin','','720019806a7048ddb474cdfdd309352d'),
						(249,111,27,'Pidana Biasa','Meninggalkan Orang Yang Perlu Ditolong','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(250,112,27,'Pidana Singkat','Meninggalkan Orang Yang Perlu Ditolong','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(251,113,27,'Pidana Cepat','Meninggalkan Orang Yang Perlu Ditolong','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(252,118,27,'Pidana Anak','Meninggalkan Orang Yang Perlu Ditolong','','720019806a7048ddb474cdfdd309352d'),
						(253,120,294,'Pidana Kejahatan','Meninggalkan Orang yang Perlu Ditolong','','8ee521983e235a9701a4c3577185bd2d'),
						(254,111,33,'Pidana Biasa','Menyebabkan Mati atau Luka-Luka karena Kealpaan','6234978ce3bdbbd2d44193778def96c1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(255,112,33,'Pidana Singkat','Menyebabkan Mati atau Luka-Luka karena Kealpaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(256,113,33,'Pidana Cepat','Menyebabkan Mati atau Luka-Luka karena Kealpaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(257,118,33,'Pidana Anak','Menyebabkan Mati atau Luka-Luka karena Kealpaan','','720019806a7048ddb474cdfdd309352d'),
						(258,120,300,'Pidana Kejahatan','Menyebabkan Mati atau Luka-luka Karena Kealpaan','','8ee521983e235a9701a4c3577185bd2d'),
						(259,5,165,'Hak Kekayaan intelektual','Merek','','981383503b3af1a65c2c2a40eb2b47e2'),
						(260,111,231,'Pidana Biasa','Meteorologi, Klimatologi dan Geofisika','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(261,118,231,'Pidana Anak','Meteorologi, Klimatologi dan Geofisika','','720019806a7048ddb474cdfdd309352d'),
						(262,122,505,'Jinayat','Musahaqah','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(263,15,350,'Perdata Gugatan','Nafkah Anak Oleh Ibu karena Ayah tidak mampu','02875c9ca3db2f48a688ecb515b32ec5','a28ae04e55e1f8c13005da77edbee894'),
						(264,111,47,'Pidana Biasa','Narkotika','3c40e48bbab311301a21c445b3c7fe57','3c40e48bbab311301a21c445b3c7fe57'),
						(265,118,47,'Pidana Anak','Narkotika','','720019806a7048ddb474cdfdd309352d'),
						(266,120,310,'Pidana Kejahatan','Narkotika','','8ee521983e235a9701a4c3577185bd2d'),
						(267,1,119,'Gugatan','Objek Sengketa Bukan Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(268,7,119,'Perlawanan/Bantahan (derden verzet)','Objek Sengketa Bukan Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(269,1,115,'Gugatan','Objek Sengketa Tanah','d595a98e3871f45e7b4e502d422a8a65','4d88fcc4f35395470bd80f19f776d242'),
						(270,7,115,'Perlawanan/Bantahan (derden verzet)','Objek Sengketa Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(271,16,371,'Perdata Permohonan','P3HP/Penetapan Ahli Waris','','a28ae04e55e1f8c13005da77edbee894'),
						(272,9,320,'Gugatan','Pajak','e95a24c62e4dd7fb912bede8d14c027d','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(273,111,230,'Pidana Biasa','Pajak Daerah dan Retribusi Daerah','954dc084c5961fc0f70c6603da2a35df','d92c02366ae91966e4cdbe6279fc36eb'),
						(274,118,230,'Pidana Anak','Pajak Daerah dan Retribusi Daerah','','720019806a7048ddb474cdfdd309352d'),
						(275,1,141,'Gugatan','Partai Politik','c3113bb2a3ccfa91ad348cb34dce6a42','981383503b3af1a65c2c2a40eb2b47e2'),
						(276,7,141,'Perlawanan/Bantahan (derden verzet)','Partai Politik','','4d88fcc4f35395470bd80f19f776d242'),
						(277,9,329,'Gugatan','Partai Politik','cdc79f14bf84675b0e13c6de12633c3e','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(278,5,166,'Hak Kekayaan intelektual','Paten','','981383503b3af1a65c2c2a40eb2b47e2'),
						(279,2,243,'Permohonan','Pelaksanaan Arbitrase Internasional','','4d88fcc4f35395470bd80f19f776d242'),
						(280,2,244,'Permohonan','Pelaksanaan Arbitrase Nasional','','4d88fcc4f35395470bd80f19f776d242'),
						(281,111,168,'Pidana Biasa','Pelanggaran','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(282,112,168,'Pidana Singkat','Pelanggaran','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(283,113,168,'Pidana Cepat','Pelanggaran','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(284,118,168,'Pidana Anak','Pelanggaran','','720019806a7048ddb474cdfdd309352d'),
						(285,120,338,'Pidana Kejahatan','Pelanggaran','','8ee521983e235a9701a4c3577185bd2d'),
						(286,111,202,'Pidana Biasa','Pelanggaran Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(287,112,202,'Pidana Singkat','Pelanggaran Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(288,113,202,'Pidana Cepat','Pelanggaran Jabatan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(289,118,202,'Pidana Anak','Pelanggaran Jabatan','','720019806a7048ddb474cdfdd309352d'),
						(290,111,195,'Pidana Biasa','Pelanggaran Keamanan Umum Bagi Orang atau Barang dari Kesehatan Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(291,112,195,'Pidana Singkat','Pelanggaran Keamanan Umum Bagi Orang atau Barang dari Kesehatan Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(292,113,195,'Pidana Cepat','Pelanggaran Keamanan Umum Bagi Orang atau Barang dari Kesehatan Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(293,118,195,'Pidana Anak','Pelanggaran Keamanan Umum Bagi Orang atau Barang dari Kesehatan Umum','','720019806a7048ddb474cdfdd309352d'),
						(294,111,200,'Pidana Biasa','Pelanggaran Kesusilaan','75d2c54ea4cb6d96d9314955bb46ba07','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(295,112,200,'Pidana Singkat','Pelanggaran Kesusilaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(296,113,200,'Pidana Cepat','Pelanggaran Kesusilaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(297,118,200,'Pidana Anak','Pelanggaran Kesusilaan','','720019806a7048ddb474cdfdd309352d'),
						(298,111,196,'Pidana Biasa','Pelanggaran Ketertiban Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(299,112,196,'Pidana Singkat','Pelanggaran Ketertiban Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(300,113,196,'Pidana Cepat','Pelanggaran Ketertiban Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(301,118,196,'Pidana Anak','Pelanggaran Ketertiban Umum','','720019806a7048ddb474cdfdd309352d'),
						(302,111,198,'Pidana Biasa','Pelanggaran Mengenai Asal Usul dan Perkawinan','0964c9d934e32054cc598cc32dc8c29f','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(303,112,198,'Pidana Singkat','Pelanggaran Mengenai Asal Usul dan Perkawinan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(304,113,198,'Pidana Cepat','Pelanggaran Mengenai Asal Usul dan Perkawinan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(305,118,198,'Pidana Anak','Pelanggaran Mengenai Asal Usul dan Perkawinan','','720019806a7048ddb474cdfdd309352d'),
						(306,111,201,'Pidana Biasa','Pelanggaran Mengenai Tanah, Tanaman, dan Pekarangan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(307,112,201,'Pidana Singkat','Pelanggaran Mengenai Tanah, Tanaman, dan Pekarangan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(308,113,201,'Pidana Cepat','Pelanggaran Mengenai Tanah, Tanaman, dan Pekarangan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(309,118,201,'Pidana Anak','Pelanggaran Mengenai Tanah, Tanaman, dan Pekarangan','','720019806a7048ddb474cdfdd309352d'),
						(310,111,203,'Pidana Biasa','Pelanggaran Pelayanan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(311,112,203,'Pidana Singkat','Pelanggaran Pelayanan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(312,113,203,'Pidana Cepat','Pelanggaran Pelayanan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(313,118,203,'Pidana Anak','Pelanggaran Pelayanan','','720019806a7048ddb474cdfdd309352d'),
						(314,111,247,'Pidana Biasa','Pelanggaran Pramuwisata','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(315,118,247,'Pidana Anak','Pelanggaran Pramuwisata','','720019806a7048ddb474cdfdd309352d'),
						(316,111,199,'Pidana Biasa','Pelanggaran Terhadap Orang Yang Memerlukan Pertolongan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(317,112,199,'Pidana Singkat','Pelanggaran Terhadap Orang Yang Memerlukan Pertolongan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(318,113,199,'Pidana Cepat','Pelanggaran Terhadap Orang Yang Memerlukan Pertolongan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(319,118,199,'Pidana Anak','Pelanggaran Terhadap Orang Yang Memerlukan Pertolongan','','720019806a7048ddb474cdfdd309352d'),
						(320,111,197,'Pidana Biasa','Pelanggaran Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(321,112,197,'Pidana Singkat','Pelanggaran Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(322,113,197,'Pidana Cepat','Pelanggaran Terhadap Penguasa Umum','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(323,118,197,'Pidana Anak','Pelanggaran Terhadap Penguasa Umum','','720019806a7048ddb474cdfdd309352d'),
						(324,111,220,'Pidana Biasa','Pelayaran','7d456c8578c45f35eac4617e4059e22b','d92c02366ae91966e4cdbe6279fc36eb'),
						(325,118,220,'Pidana Anak','Pelayaran','','720019806a7048ddb474cdfdd309352d'),
						(326,122,506,'Jinayat','Pelecehan Seksual','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(327,111,21,'Pidana Biasa','Pemalsuan Mata Uang dan Uang Kertas','473d684ed97c72809151a996688bc38a','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(328,112,21,'Pidana Singkat','Pemalsuan Mata Uang dan Uang Kertas','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(329,113,21,'Pidana Cepat','Pemalsuan Mata Uang dan Uang Kertas','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(330,118,21,'Pidana Anak','Pemalsuan Mata Uang dan Uang Kertas','','720019806a7048ddb474cdfdd309352d'),
						(331,120,289,'Pidana Kejahatan','Pemalsuan Mata Uang dan Uang Kertas','','8ee521983e235a9701a4c3577185bd2d'),
						(332,111,22,'Pidana Biasa','Pemalsuan Materai dan Merek','831e9b81731822f84869929d684e4a2c','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(333,112,22,'Pidana Singkat','Pemalsuan Materai dan Merek','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(334,113,22,'Pidana Cepat','Pemalsuan Materai dan Merek','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(335,118,22,'Pidana Anak','Pemalsuan Materai dan Merek','','720019806a7048ddb474cdfdd309352d'),
						(336,120,290,'Pidana Kejahatan','Pemalsuan Meterai dan Merk','','8ee521983e235a9701a4c3577185bd2d'),
						(337,111,23,'Pidana Biasa','Pemalsuan Surat','831e9b81731822f84869929d684e4a2c','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(338,112,23,'Pidana Singkat','Pemalsuan Surat','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(339,113,23,'Pidana Cepat','Pemalsuan Surat','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(340,118,23,'Pidana Anak','Pemalsuan Surat','','720019806a7048ddb474cdfdd309352d'),
						(341,120,266,'Pidana Kejahatan','Pemalsuan Surat','','8ee521983e235a9701a4c3577185bd2d'),
						(342,120,291,'Pidana Kejahatan','Pemalsuan Surat','','8ee521983e235a9701a4c3577185bd2d'),
						(343,1,138,'Gugatan','Pembatalan Arbitrase','','4d88fcc4f35395470bd80f19f776d242'),
						(344,7,138,'Perlawanan/Bantahan (derden verzet)','Pembatalan Arbitrase','','4d88fcc4f35395470bd80f19f776d242'),
						(345,2,87,'Permohonan','Pembatalan Perkawinan','','4d88fcc4f35395470bd80f19f776d242'),
						(346,15,344,'Perdata Gugatan','Pembatalan Perkawinan','d9ecdbba1a4d4fbd785a562425f28def','a28ae04e55e1f8c13005da77edbee894'),
						(347,2,245,'Permohonan','Pembatalan Putusan Arbitrase Internasional','','4d88fcc4f35395470bd80f19f776d242'),
						(348,120,314,'Pidana Kejahatan','Pemberantasan Tindak Pidana Korupsi','','8ee521983e235a9701a4c3577185bd2d'),
						(349,111,111,'Pidana Biasa','Pemberantasan Tindak Pidana Perdagangan Orang','591c725c9658703f62846dd5ad0a5443','d92c02366ae91966e4cdbe6279fc36eb'),
						(350,118,111,'Pidana Anak','Pemberantasan Tindak Pidana Perdagangan Orang','','720019806a7048ddb474cdfdd309352d'),
						(351,6,154,'Pengadilan Hubungan Industrial','Pemberhentian Karena Tanpa Adanya SKB (Surat Kesepakatan Bersama)','','981383503b3af1a65c2c2a40eb2b47e2'),
						(352,120,263,'Pidana Kejahatan','Pemberontakan Militer','','8ee521983e235a9701a4c3577185bd2d'),
						(353,1,386,'Gugatan','Pembuangan Limbah','','4d88fcc4f35395470bd80f19f776d242'),
						(354,7,386,'Perlawanan/Bantahan (derden verzet)','Pembuangan Limbah','','4d88fcc4f35395470bd80f19f776d242'),
						(355,9,614,'Gugatan','Pembuangan Limbah','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(356,111,407,'Pidana Biasa','Pembuangan Limbah','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(357,2,80,'Permohonan','Pembubaran/Likuidasi Badan hukum','','4d88fcc4f35395470bd80f19f776d242'),
						(358,111,103,'Pidana Biasa','Pembunuhan','77e1b8594fe1b109d44f5a13120cc296','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(359,118,103,'Pidana Anak','Pembunuhan','','720019806a7048ddb474cdfdd309352d'),
						(360,111,35,'Pidana Biasa','Pemerasan dan Pengancaman','2de4b6fa673f48c4cc4c669d8f0f418a','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(361,112,35,'Pidana Singkat','Pemerasan dan Pengancaman','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(362,113,35,'Pidana Cepat','Pemerasan dan Pengancaman','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(363,118,35,'Pidana Anak','Pemerasan dan Pengancaman','','720019806a7048ddb474cdfdd309352d'),
						(364,120,302,'Pidana Kejahatan','Pemerasan dan Pengancaman','','8ee521983e235a9701a4c3577185bd2d'),
						(365,122,507,'Jinayat','Pemerkosaan','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(366,111,215,'Pidana Biasa','Pemilihan Umum Anggota Dewan Perwakilan Rakyat, Dewan Perwakilan Daerah, dan Dewan Perwakilan Rakyat','f41a9742664732c6db7e64f73719302c','d92c02366ae91966e4cdbe6279fc36eb'),
						(367,118,215,'Pidana Anak','Pemilihan Umum Anggota Dewan Perwakilan Rakyat, Dewan Perwakilan Daerah, dan Dewan Perwakilan Rakyat','','720019806a7048ddb474cdfdd309352d'),
						(368,111,222,'Pidana Biasa','Pemilihan Umum Presiden dan Wakil Presiden','f41a9742664732c6db7e64f73719302c','d92c02366ae91966e4cdbe6279fc36eb'),
						(369,118,222,'Pidana Anak','Pemilihan Umum Presiden dan Wakil Presiden','','720019806a7048ddb474cdfdd309352d'),
						(370,9,328,'Gugatan','Pemilukada','85b3eb3e939c0ea335fd983c82801c65','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(371,6,146,'Pengadilan Hubungan Industrial','Pemutusan Hubungan Kerja Tanpa Memperhatikan Hak Pekerja','','981383503b3af1a65c2c2a40eb2b47e2'),
						(372,120,309,'Pidana Kejahatan','Penadahan, Pencetakan dan Penerbitan','','8ee521983e235a9701a4c3577185bd2d'),
						(373,111,42,'Pidana Biasa','Penadahan, Penerbitan, dan Pencetakan','a4449cb4bc0557855464308fc241def6','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(374,112,42,'Pidana Singkat','Penadahan, Penerbitan, dan Pencetakan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(375,113,42,'Pidana Cepat','Penadahan, Penerbitan, dan Pencetakan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(376,118,42,'Pidana Anak','Penadahan, Penerbitan, dan Pencetakan','','720019806a7048ddb474cdfdd309352d'),
						(377,1,387,'Gugatan','Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','','4d88fcc4f35395470bd80f19f776d242'),
						(378,7,387,'Perlawanan/Bantahan (derden verzet)','Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','','4d88fcc4f35395470bd80f19f776d242'),
						(379,9,615,'Gugatan','Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(380,111,408,'Pidana Biasa','Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(381,111,211,'Pidana Biasa','Penataan Ruang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(382,118,211,'Pidana Anak','Penataan Ruang','','720019806a7048ddb474cdfdd309352d'),
						(383,15,353,'Perdata Gugatan','Pencabutan Kekuasaan Orang Tua','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(384,15,355,'Perdata Gugatan','Pencabutan Kekuasaan Wali','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(385,16,342,'Perdata Permohonan','Pencegahan Perkawinan','','a28ae04e55e1f8c13005da77edbee894'),
						(386,1,373,'Gugatan','Pencemaran Air','','4d88fcc4f35395470bd80f19f776d242'),
						(387,7,373,'Perlawanan/Bantahan (derden verzet)','Pencemaran Air','','4d88fcc4f35395470bd80f19f776d242'),
						(388,9,600,'Gugatan','Pencemaran Air','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(389,111,393,'Pidana Biasa','Pencemaran Air','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(390,1,376,'Gugatan','Pencemaran Laut','','4d88fcc4f35395470bd80f19f776d242'),
						(391,7,376,'Perlawanan/Bantahan (derden verzet)','Pencemaran Laut','','4d88fcc4f35395470bd80f19f776d242'),
						(392,9,603,'Gugatan','Pencemaran Laut','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(393,111,396,'Pidana Biasa','Pencemaran Laut','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(394,111,105,'Pidana Biasa','Pencemaran Nama Baik','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(395,118,105,'Pidana Anak','Pencemaran Nama Baik','','720019806a7048ddb474cdfdd309352d'),
						(396,1,375,'Gugatan','Pencemaran Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(397,7,375,'Perlawanan/Bantahan (derden verzet)','Pencemaran Tanah','','4d88fcc4f35395470bd80f19f776d242'),
						(398,111,395,'Pidana Biasa','Pencemaran Tanah','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(399,1,374,'Gugatan','Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','','4d88fcc4f35395470bd80f19f776d242'),
						(400,7,374,'Perlawanan/Bantahan (derden verzet)','Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','','4d88fcc4f35395470bd80f19f776d242'),
						(401,9,601,'Gugatan','Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(402,111,394,'Pidana Biasa','Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(403,111,34,'Pidana Biasa','Pencurian','2c1ba6dc960f638b991a87475ede3d4c','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(404,112,34,'Pidana Singkat','Pencurian','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(405,113,34,'Pidana Cepat','Pencurian','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(406,118,34,'Pidana Anak','Pencurian','','720019806a7048ddb474cdfdd309352d'),
						(407,120,301,'Pidana Kejahatan','Pencurian','','8ee521983e235a9701a4c3577185bd2d'),
						(408,120,279,'Pidana Kejahatan','Pencurian dan Penadahan','','8ee521983e235a9701a4c3577185bd2d'),
						(409,120,273,'Pidana Kejahatan','Pencurian pada Suatu Tempat Dibawah Penjagaan atau Pengamanannya','','8ee521983e235a9701a4c3577185bd2d'),
						(410,2,93,'Permohonan','Pendaftaran Pernikahan Terlambat','','4d88fcc4f35395470bd80f19f776d242'),
						(411,1,379,'Gugatan','Penebangan Kayu','','4d88fcc4f35395470bd80f19f776d242'),
						(412,7,379,'Perlawanan/Bantahan (derden verzet)','Penebangan Kayu','','4d88fcc4f35395470bd80f19f776d242'),
						(413,9,606,'Gugatan','Penebangan Kayu','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(414,111,399,'Pidana Biasa','Penebangan Kayu','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(415,111,225,'Pidana Biasa','Penerbangan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(416,118,225,'Pidana Anak','Penerbangan','','720019806a7048ddb474cdfdd309352d'),
						(417,2,79,'Permohonan','Penerimaan/Penolakan Warisan','','4d88fcc4f35395470bd80f19f776d242'),
						(418,9,332,'Gugatan','Pengadaan Tanah Untuk Kepentingan Umum','b568862cdaa87e4a8c208d84906779db','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(419,14,332,'Permohonan Pertanahan','Pengadaan Tanah Untuk Kepentingan Umum','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(420,2,162,'Permohonan','Pengampuan','','4d88fcc4f35395470bd80f19f776d242'),
						(421,111,112,'Pidana Biasa','Pengancaman','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(422,118,112,'Pidana Anak','Pengancaman','','720019806a7048ddb474cdfdd309352d'),
						(423,2,84,'Permohonan','Pengangkatan Pengampu Bagi Orang Dewasa Yang Kurang Ingatan','','4d88fcc4f35395470bd80f19f776d242'),
						(424,2,83,'Permohonan','Pengangkatan Wali Bagi Anak','','4d88fcc4f35395470bd80f19f776d242'),
						(425,111,32,'Pidana Biasa','Penganiayaan','4210395c07581866de499a7b125ea4bc','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(426,112,32,'Pidana Singkat','Penganiayaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(427,113,32,'Pidana Cepat','Penganiayaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(428,118,32,'Pidana Anak','Penganiayaan','','720019806a7048ddb474cdfdd309352d'),
						(429,120,299,'Pidana Kejahatan','Penganiayaan','','8ee521983e235a9701a4c3577185bd2d'),
						(430,111,212,'Pidana Biasa','Pengelolaan Wilayah Pesisir Dan Pulau-Pulau Kecil','3d7f3c735e618b69dca7c8554cebd8c8','d92c02366ae91966e4cdbe6279fc36eb'),
						(431,118,212,'Pidana Anak','Pengelolaan Wilayah Pesisir Dan Pulau-Pulau Kecil','','720019806a7048ddb474cdfdd309352d'),
						(432,111,104,'Pidana Biasa','Pengeroyokan yang menyebabkan kematian','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(433,118,104,'Pidana Anak','Pengeroyokan yang menyebabkan kematian','','720019806a7048ddb474cdfdd309352d'),
						(434,111,102,'Pidana Biasa','Pengeroyokan yang menyebabkan luka ringan, luka berat','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(435,118,102,'Pidana Anak','Pengeroyokan yang menyebabkan luka ringan, luka berat','','720019806a7048ddb474cdfdd309352d'),
						(436,15,352,'Perdata Gugatan','Pengesahan Anak','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(437,15,360,'Perdata Gugatan','Pengesahan Perkawinan/Istbat Nikah','abdcf7b26c04c72f7fda1b4fa3bc540e','a28ae04e55e1f8c13005da77edbee894'),
						(438,16,360,'Perdata Permohonan','Pengesahan Perkawinan/Istbat Nikah','','a28ae04e55e1f8c13005da77edbee894'),
						(439,120,303,'Pidana Kejahatan','Penggelapan','','8ee521983e235a9701a4c3577185bd2d'),
						(440,111,36,'Pidana Biasa','Penggelapan ','67286de849c882ed7412e51bbd79ac89','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(441,112,36,'Pidana Singkat','Penggelapan ','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(442,113,36,'Pidana Cepat','Penggelapan ','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(443,118,36,'Pidana Anak','Penggelapan ','','720019806a7048ddb474cdfdd309352d'),
						(444,111,214,'Pidana Biasa','Penggunaan Bahan Kimia dan Larangan Penggunaan Bahan Kimia sebagai Senjata Kimia','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(445,118,214,'Pidana Anak','Penggunaan Bahan Kimia dan Larangan Penggunaan Bahan Kimia sebagai Senjata Kimia','','720019806a7048ddb474cdfdd309352d'),
						(446,111,39,'Pidana Biasa','Penghancuran atau Perusakan Barang','ad8a71df3b238eb93d8c99e66b072a4c','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(447,112,39,'Pidana Singkat','Penghancuran atau Perusakan Barang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(448,113,39,'Pidana Cepat','Penghancuran atau Perusakan Barang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(449,118,39,'Pidana Anak','Penghancuran atau Perusakan Barang','','720019806a7048ddb474cdfdd309352d'),
						(450,120,311,'Pidana Kejahatan','Penghapusan Kekerasan Dalam Rumah Tangga','','8ee521983e235a9701a4c3577185bd2d'),
						(451,111,28,'Pidana Biasa','Penghinaan','8eb1593d07073615fb533c1c5abb95d6','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(452,112,28,'Pidana Singkat','Penghinaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(453,113,28,'Pidana Cepat','Penghinaan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(454,118,28,'Pidana Anak','Penghinaan','','720019806a7048ddb474cdfdd309352d'),
						(455,120,295,'Pidana Kejahatan','Penghinaan','','8ee521983e235a9701a4c3577185bd2d'),
						(456,15,349,'Perdata Gugatan','Penguasaan Anak','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(457,10,334,'Permohonan UU AP','Pengujian Penyalahgunaan Wewenang','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(458,13,334,'Permohonan Penyalahgunaan Wewenang','Pengujian Penyalahgunaan Wewenang','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(459,111,37,'Pidana Biasa','Penipuan','8dff1a19444a2f2d63becf72c08c2fdd','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(460,118,37,'Pidana Anak','Penipuan','','720019806a7048ddb474cdfdd309352d'),
						(461,120,304,'Pidana Kejahatan','Penipuan','','8ee521983e235a9701a4c3577185bd2d'),
						(462,120,274,'Pidana Kejahatan','Penjaga Meninggalkan Pos','','8ee521983e235a9701a4c3577185bd2d'),
						(463,16,343,'Perdata Permohonan','Penolakan Perkawinan','','a28ae04e55e1f8c13005da77edbee894'),
						(464,4,143,'Penundaan Kewajiban Pembayaran Utang','Penundaan Kewajiban Pembayaran Utang','','981383503b3af1a65c2c2a40eb2b47e2'),
						(465,15,356,'Perdata Gugatan','Penunjukan orang lain sebagai Wali oleh Pengadilan','0cfd1c8a1e785166c0663821392a1c96','a28ae04e55e1f8c13005da77edbee894'),
						(466,1,72,'Gugatan','Penyalahgunaan Hak','','4d88fcc4f35395470bd80f19f776d242'),
						(467,7,72,'Perlawanan/Bantahan (derden verzet)','Penyalahgunaan Hak','','4d88fcc4f35395470bd80f19f776d242'),
						(468,120,277,'Pidana Kejahatan','Penyalahgunaan Keuasaan dan wewenang','','8ee521983e235a9701a4c3577185bd2d'),
						(469,111,218,'Pidana Biasa','Penyelenggaraan Ibadah Haji','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(470,118,218,'Pidana Anak','Penyelenggaraan Ibadah Haji','','720019806a7048ddb474cdfdd309352d'),
						(471,1,132,'Gugatan','Penyerobotan','','4d88fcc4f35395470bd80f19f776d242'),
						(472,7,132,'Perlawanan/Bantahan (derden verzet)','Penyerobotan','','4d88fcc4f35395470bd80f19f776d242'),
						(473,2,78,'Permohonan','Perbaikan Kesalahan Dalam Akta Kelahiran','','4d88fcc4f35395470bd80f19f776d242'),
						(474,111,109,'Pidana Biasa','Perbankan Syariah Negara','5b3b183b41bc6ab3764cab235b9a3f8a','d92c02366ae91966e4cdbe6279fc36eb'),
						(475,118,109,'Pidana Anak','Perbankan Syariah Negara','','720019806a7048ddb474cdfdd309352d'),
						(476,111,193,'Pidana Biasa','Perbuatan Curang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(477,112,193,'Pidana Singkat','Perbuatan Curang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(478,113,193,'Pidana Cepat','Perbuatan Curang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(479,118,193,'Pidana Anak','Perbuatan Curang','','720019806a7048ddb474cdfdd309352d'),
						(480,1,75,'Gugatan','Perbuatan Melawan Hukum','5dc631a1c0318c606f8835603566c948','4d88fcc4f35395470bd80f19f776d242'),
						(481,1,117,'Gugatan','Perbuatan Melawan Hukum','5dc631a1c0318c606f8835603566c948','4d88fcc4f35395470bd80f19f776d242'),
						(482,7,75,'Perlawanan/Bantahan (derden verzet)','Perbuatan Melawan Hukum','','4d88fcc4f35395470bd80f19f776d242'),
						(483,7,117,'Perlawanan/Bantahan (derden verzet)','Perbuatan Melawan Hukum','','4d88fcc4f35395470bd80f19f776d242'),
						(484,8,75,'Gugatan Sederhana','Perbuatan Melawan Hukum','','4d88fcc4f35395470bd80f19f776d242'),
						(485,111,38,'Pidana Biasa','Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(486,112,38,'Pidana Singkat','Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(487,113,38,'Pidana Cepat','Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(488,118,38,'Pidana Anak','Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak','','720019806a7048ddb474cdfdd309352d'),
						(489,120,305,'Pidana Kejahatan','Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak','','8ee521983e235a9701a4c3577185bd2d'),
						(490,111,101,'Pidana Biasa','Perbuatan Tidak Menyenangkan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(491,118,101,'Pidana Anak','Perbuatan Tidak Menyenangkan','','720019806a7048ddb474cdfdd309352d'),
						(492,1,64,'Gugatan','Perceraian','40db4e17e40047f1bf0237f8d2ab5cc1','4d88fcc4f35395470bd80f19f776d242'),
						(493,7,64,'Perlawanan/Bantahan (derden verzet)','Perceraian','','4d88fcc4f35395470bd80f19f776d242'),
						(494,111,232,'Pidana Biasa','Perfilman','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(495,118,232,'Pidana Anak','Perfilman','','720019806a7048ddb474cdfdd309352d'),
						(496,9,321,'Gugatan','Perijinan','1e1b6491de132b06fb19c24eb1dd40d4','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(497,1,124,'Gugatan','Perjanjian Borongan','','4d88fcc4f35395470bd80f19f776d242'),
						(498,7,124,'Perlawanan/Bantahan (derden verzet)','Perjanjian Borongan','','4d88fcc4f35395470bd80f19f776d242'),
						(499,114,161,'Perkara Lalu-Lintas','Perkara Lalu-Lintas','a3cc311a35d6413859bc91ca1e851e1b','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(500,15,359,'Perdata Gugatan','Perkawinan Campuran','','a28ae04e55e1f8c13005da77edbee894'),
						(501,111,194,'Pidana Biasa','Perkelahian Tanding','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(502,112,194,'Pidana Singkat','Perkelahian Tanding','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(503,113,194,'Pidana Cepat','Perkelahian Tanding','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(504,118,194,'Pidana Anak','Perkelahian Tanding','','720019806a7048ddb474cdfdd309352d'),
						(505,120,285,'Pidana Kejahatan','Perkelahian Tanding','','8ee521983e235a9701a4c3577185bd2d'),
						(506,111,210,'Pidana Biasa','Perkeretaapian','83835a274d4d5f5cc9d950fbcc61b49f','d92c02366ae91966e4cdbe6279fc36eb'),
						(507,118,210,'Pidana Anak','Perkeretaapian','','720019806a7048ddb474cdfdd309352d'),
						(508,111,248,'Pidana Biasa','Perlindungan Anak','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(509,112,248,'Pidana Singkat','Perlindungan Anak','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(510,118,248,'Pidana Anak','Perlindungan Anak','720019806a7048ddb474cdfdd309352d','d92c02366ae91966e4cdbe6279fc36eb'),
						(511,120,312,'Pidana Kejahatan','Perlindungan Anak','','8ee521983e235a9701a4c3577185bd2d'),
						(512,111,234,'Pidana Biasa','Perlindungan dan Pengelolaan Lingkungan Hidup','20b9031c89f699d59202fe933a3a58af','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(513,118,234,'Pidana Anak','Perlindungan dan Pengelolaan Lingkungan Hidup','','720019806a7048ddb474cdfdd309352d'),
						(514,111,236,'Pidana Biasa','Perlindungan Lahan Pertanian Pangan Berkelanjutan','fcb5bbc21f96a4cc4692af1d2be72421','d92c02366ae91966e4cdbe6279fc36eb'),
						(515,118,236,'Pidana Anak','Perlindungan Lahan Pertanian Pangan Berkelanjutan','','720019806a7048ddb474cdfdd309352d'),
						(516,111,53,'Pidana Biasa','Perlindungan Saksi Dan Korban','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(517,118,53,'Pidana Anak','Perlindungan Saksi Dan Korban','','720019806a7048ddb474cdfdd309352d'),
						(518,2,90,'Permohonan','Permohonan Akte Kelahiran Terlambat ','','4d88fcc4f35395470bd80f19f776d242'),
						(519,2,85,'Permohonan','Permohonan Dispensasi Nikah ','','4d88fcc4f35395470bd80f19f776d242'),
						(520,10,333,'Permohonan UU AP','Permohonan Fiktif Positif','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(521,12,333,'Permohonan Fiktif Positif','Permohonan Fiktif Positif','','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(522,2,91,'Permohonan','Permohonan Ganti Nama','','4d88fcc4f35395470bd80f19f776d242'),
						(523,2,86,'Permohonan','Permohonan Ijin Nikah','','4d88fcc4f35395470bd80f19f776d242'),
						(524,2,88,'Permohonan','Permohonan Pengangkatan Anak','','4d88fcc4f35395470bd80f19f776d242'),
						(525,3,5,'Kepailitan','Permohonan Pernyataan Pailit','f576afb6cb9f61d0478dba5385641e7d','981383503b3af1a65c2c2a40eb2b47e2'),
						(526,2,89,'Permohonan','Permohonan Untuk Menunjuk Wasit','','4d88fcc4f35395470bd80f19f776d242'),
						(527,6,155,'Pengadilan Hubungan Industrial','Perselisihan Antar Pekerja Dalam 1 ( satu ) Perusahaan','','981383503b3af1a65c2c2a40eb2b47e2'),
						(528,6,149,'Pengadilan Hubungan Industrial','Perselisihan Hak Pekerja Karena Upah Tidak Dibayar','','981383503b3af1a65c2c2a40eb2b47e2'),
						(529,6,150,'Pengadilan Hubungan Industrial','Perselisihan Hak Pekerja Yang Sudah Diperjanjikan Tidak Dipenuhi','','981383503b3af1a65c2c2a40eb2b47e2'),
						(530,6,147,'Pengadilan Hubungan Industrial','Perselisihan Hubungan Kerja Karena Pekerja Indisipliner','','981383503b3af1a65c2c2a40eb2b47e2'),
						(531,6,152,'Pengadilan Hubungan Industrial','Perselisihan Kepentingan Karena Keahlian Pekerja','','981383503b3af1a65c2c2a40eb2b47e2'),
						(532,6,153,'Pengadilan Hubungan Industrial','Perselisihan Kepentingan Karena Mutasi Pekerja','','981383503b3af1a65c2c2a40eb2b47e2'),
						(533,6,148,'Pengadilan Hubungan Industrial','Perselisihan Pemutusan Hubungan Kerja Karena Pekerja Melakukan Tindak Pidana','','981383503b3af1a65c2c2a40eb2b47e2'),
						(534,6,145,'Pengadilan Hubungan Industrial','Perselisihan Pemutusan Hubungan Kerja Massal','','981383503b3af1a65c2c2a40eb2b47e2'),
						(535,6,144,'Pengadilan Hubungan Industrial','Perselisihan Pemutusan Hubungan Kerja Sepihak','','981383503b3af1a65c2c2a40eb2b47e2'),
						(536,6,151,'Pengadilan Hubungan Industrial','Perselisihan Upah Yang Tidak Sesuai','','981383503b3af1a65c2c2a40eb2b47e2'),
						(537,1,67,'Gugatan','Perseroan','','4d88fcc4f35395470bd80f19f776d242'),
						(538,7,67,'Perlawanan/Bantahan (derden verzet)','Perseroan','','4d88fcc4f35395470bd80f19f776d242'),
						(539,111,227,'Pidana Biasa','Pertambangan Mineral dan Batubara','9a49acde4116f41729db232e7979515b','d92c02366ae91966e4cdbe6279fc36eb'),
						(540,118,227,'Pidana Anak','Pertambangan Mineral dan Batubara','','720019806a7048ddb474cdfdd309352d'),
						(541,9,318,'Gugatan','Pertanahan','b568862cdaa87e4a8c208d84906779db','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(542,111,228,'Pidana Biasa','Perternakan Dan Kesehatan Hewan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(543,118,228,'Pidana Anak','Perternakan Dan Kesehatan Hewan','','720019806a7048ddb474cdfdd309352d'),
						(544,111,208,'Pidana Biasa','Perubahan Atas Undang-Undang Nomor 10 Tahun 1995 Tentang Kepabeanan','0ddbcc4cbd4d7cbc383beac92bd0ae69','d92c02366ae91966e4cdbe6279fc36eb'),
						(545,118,208,'Pidana Anak','Perubahan Atas Undang-Undang Nomor 10 Tahun 1995 Tentang Kepabeanan','','720019806a7048ddb474cdfdd309352d'),
						(546,111,239,'Pidana Biasa','Perubahan atas Undang-Undang Nomor 31 tahun 2004 tentang Perikanan','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(547,118,239,'Pidana Anak','Perubahan atas Undang-Undang Nomor 31 tahun 2004 tentang Perikanan','','720019806a7048ddb474cdfdd309352d'),
						(548,111,217,'Pidana Biasa','Perubahan atas Undang-Undang Nomor 32 Tahun 2004 tentang Pemerintahan Daerah','dad8807c899ed488fabbb9a5e2063e83','d92c02366ae91966e4cdbe6279fc36eb'),
						(549,118,217,'Pidana Anak','Perubahan atas Undang-Undang Nomor 32 Tahun 2004 tentang Pemerintahan Daerah','','720019806a7048ddb474cdfdd309352d'),
						(550,1,388,'Gugatan','Perubahan Iklim','','4d88fcc4f35395470bd80f19f776d242'),
						(551,7,388,'Perlawanan/Bantahan (derden verzet)','Perubahan Iklim','','4d88fcc4f35395470bd80f19f776d242'),
						(552,9,616,'Gugatan','Perubahan Iklim','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(553,111,409,'Pidana Biasa','Perubahan Iklim','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(554,1,380,'Gugatan','Perubahan Kawasan Alam/Tata Ruang','','4d88fcc4f35395470bd80f19f776d242'),
						(555,7,380,'Perlawanan/Bantahan (derden verzet)','Perubahan Kawasan Alam/Tata Ruang','','4d88fcc4f35395470bd80f19f776d242'),
						(556,9,607,'Gugatan','Perubahan Kawasan Alam/Tata Ruang','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(557,111,400,'Pidana Biasa','Perubahan Kawasan Alam/Tata Ruang','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(558,111,213,'Pidana Biasa','Perubahan Ketiga atas Undang-Undang Nomor 6 Tahun 1983 Tentang Ketentuan Umum Dan Tata Cara Perpajak','954dc084c5961fc0f70c6603da2a35df','d92c02366ae91966e4cdbe6279fc36eb'),
						(559,118,213,'Pidana Anak','Perubahan Ketiga atas Undang-Undang Nomor 6 Tahun 1983 Tentang Ketentuan Umum Dan Tata Cara Perpajak','','720019806a7048ddb474cdfdd309352d'),
						(560,9,327,'Gugatan','Perumahan','440f32d10c676ad90503fa1b57ec1eec','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(561,16,354,'Perdata Permohonan','Perwalian','','a28ae04e55e1f8c13005da77edbee894'),
						(562,111,224,'Pidana Biasa','Pornografi','4006bb0b3d860524467270a51f84cb58','d92c02366ae91966e4cdbe6279fc36eb'),
						(563,118,224,'Pidana Anak','Pornografi','','720019806a7048ddb474cdfdd309352d'),
						(564,1,135,'Gugatan','PPAT','','4d88fcc4f35395470bd80f19f776d242'),
						(565,7,135,'Perlawanan/Bantahan (derden verzet)','PPAT','','4d88fcc4f35395470bd80f19f776d242'),
						(566,118,249,'Pidana Anak','Praperadilan','','720019806a7048ddb474cdfdd309352d'),
						(567,1,133,'Gugatan','Pusaka Tinggi/Pusaka Rendah','','4d88fcc4f35395470bd80f19f776d242'),
						(568,7,133,'Perlawanan/Bantahan (derden verzet)','Pusaka Tinggi/Pusaka Rendah','','4d88fcc4f35395470bd80f19f776d242'),
						(569,122,508,'Jinayat','Qadzaf','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(570,119,256,'Pidana Praperadilan','Rehabilitasi','','d92c02366ae91966e4cdbe6279fc36eb'),
						(571,123,256,'Praperadilan Jinayat','Rehabilitasi','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(572,1,385,'Gugatan','Reklamasi Pantai','','4d88fcc4f35395470bd80f19f776d242'),
						(573,7,385,'Perlawanan/Bantahan (derden verzet)','Reklamasi Pantai','','4d88fcc4f35395470bd80f19f776d242'),
						(574,9,613,'Gugatan','Reklamasi Pantai','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(575,111,406,'Pidana Biasa','Reklamasi Pantai','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(576,111,238,'Pidana Biasa','Rumah Sakit','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(577,118,238,'Pidana Anak','Rumah Sakit','','720019806a7048ddb474cdfdd309352d'),
						(578,119,251,'Pidana Praperadilan','Sah atau tidaknya penahanan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(579,123,251,'Praperadilan Jinayat','Sah atau tidaknya penahanan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(580,119,250,'Pidana Praperadilan','Sah atau tidaknya penangkapan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(581,123,250,'Praperadilan Jinayat','Sah atau tidaknya penangkapan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(582,119,257,'Pidana Praperadilan','Sah atau tidaknya penetapan tersangka','','d92c02366ae91966e4cdbe6279fc36eb'),
						(583,123,257,'Praperadilan Jinayat','Sah atau tidaknya penetapan tersangka','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(584,119,259,'Pidana Praperadilan','Sah atau tidaknya penggeledahan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(585,123,259,'Praperadilan Jinayat','Sah atau tidaknya penggeledahan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(586,119,253,'Pidana Praperadilan','Sah atau tidaknya penghentian penuntutan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(587,123,253,'Praperadilan Jinayat','Sah atau tidaknya penghentian penuntutan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(588,119,252,'Pidana Praperadilan','Sah atau tidaknya penghentian penyidikan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(589,123,252,'Praperadilan Jinayat','Sah atau tidaknya penghentian penyidikan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(590,119,258,'Pidana Praperadilan','Sah atau tidaknya penyitaan','','d92c02366ae91966e4cdbe6279fc36eb'),
						(591,123,258,'Praperadilan Jinayat','Sah atau tidaknya penyitaan','4fe35cb00a7f37c83b743c6b7b67bd0f','d92c02366ae91966e4cdbe6279fc36'),
						(592,1,391,'Gugatan','Satwa Liar (Penangkapan,Perdagangan dll)','','4d88fcc4f35395470bd80f19f776d242'),
						(593,7,391,'Perlawanan/Bantahan (derden verzet)','Satwa Liar (Penangkapan,Perdagangan dll)','','4d88fcc4f35395470bd80f19f776d242'),
						(594,9,608,'Gugatan','Satwa Liar (Penangkapan,Perdagangan dll)','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(595,111,401,'Pidana Biasa','Satwa Liar (Penangkapan,Perdagangan dll)','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(596,120,316,'Pidana Kejahatan','Senjata Api','','8ee521983e235a9701a4c3577185bd2d'),
						(597,1,134,'Gugatan','Sertifikat/Girik','','4d88fcc4f35395470bd80f19f776d242'),
						(598,7,134,'Perlawanan/Bantahan (derden verzet)','Sertifikat/Girik','','4d88fcc4f35395470bd80f19f776d242'),
						(599,1,61,'Gugatan','Sewa Menyewa','','4d88fcc4f35395470bd80f19f776d242'),
						(600,1,128,'Gugatan','Sewa Menyewa','','4d88fcc4f35395470bd80f19f776d242'),
						(601,7,61,'Perlawanan/Bantahan (derden verzet)','Sewa Menyewa','','4d88fcc4f35395470bd80f19f776d242'),
						(602,7,128,'Perlawanan/Bantahan (derden verzet)','Sewa Menyewa','','4d88fcc4f35395470bd80f19f776d242'),
						(603,111,204,'Pidana Biasa','Sistem Keolahragaan Nasional','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(604,118,204,'Pidana Anak','Sistem Keolahragaan Nasional','','720019806a7048ddb474cdfdd309352d'),
						(605,111,205,'Pidana Biasa','Sistem Resi Gudang','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(606,118,205,'Pidana Anak','Sistem Resi Gudang','','720019806a7048ddb474cdfdd309352d'),
						(607,2,246,'Permohonan','Somasi','','4d88fcc4f35395470bd80f19f776d242'),
						(608,111,20,'Pidana Biasa','Sumpah Palsu dan Keterangan Palsu','91bddb5d7177876be19b10a24d349829','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(609,112,20,'Pidana Singkat','Sumpah Palsu dan Keterangan Palsu','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(610,113,20,'Pidana Cepat','Sumpah Palsu dan Keterangan Palsu','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(611,118,20,'Pidana Anak','Sumpah Palsu dan Keterangan Palsu','','720019806a7048ddb474cdfdd309352d'),
						(612,120,288,'Pidana Kejahatan','Sumpah Palsu dan Keterangan Palsu','','8ee521983e235a9701a4c3577185bd2d'),
						(613,1,69,'Gugatan','Surat Berharga','','4d88fcc4f35395470bd80f19f776d242'),
						(614,7,69,'Perlawanan/Bantahan (derden verzet)','Surat Berharga','','4d88fcc4f35395470bd80f19f776d242'),
						(615,111,221,'Pidana Biasa','Surat Berharga Syariah Negara','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(616,118,221,'Pidana Anak','Surat Berharga Syariah Negara','','720019806a7048ddb474cdfdd309352d'),
						(617,1,381,'Gugatan','Tanaman Yang Dilindungi','','4d88fcc4f35395470bd80f19f776d242'),
						(618,7,381,'Perlawanan/Bantahan (derden verzet)','Tanaman Yang Dilindungi','','4d88fcc4f35395470bd80f19f776d242'),
						(619,9,609,'Gugatan','Tanaman Yang Dilindungi','5da80613c6c60bcdaa05cbdd4df6d3c5','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(620,111,402,'Pidana Biasa','Tanaman Yang Dilindungi','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(621,111,99,'Pidana Biasa','Tanpa hak mengambil atau memiliki suatu barang milik orang lain','2c1ba6dc960f638b991a87475ede3d4c','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(622,118,99,'Pidana Anak','Tanpa hak mengambil atau memiliki suatu barang milik orang lain','','720019806a7048ddb474cdfdd309352d'),
						(623,9,323,'Gugatan','Tender','c867b27e93d5685f1804fdb183e65086','6ccf9ad6c4d6e9ab8fbc1f8b252cec81'),
						(624,120,269,'Pidana Kejahatan','Tidak Mentaati Perintah Dinas','','8ee521983e235a9701a4c3577185bd2d'),
						(625,115,45,'Tindak Pidana Korupsi','Tindak Pidana Korupsi','bfa5809fc342e6a6ef5d3d9de5ec7075','d92c02366ae91966e4cdbe6279fc36eb'),
						(626,111,51,'Pidana Biasa','Tindak Pidana Lingkungan Hidup','20b9031c89f699d59202fe933a3a58af','d92c02366ae91966e4cdbe6279fc36eb'),
						(627,118,51,'Pidana Anak','Tindak Pidana Lingkungan Hidup','','720019806a7048ddb474cdfdd309352d'),
						(628,116,159,'Pidana Perikanan','Tindak Pidana Perikanan','a294135c19169a89d1d6b8d9ac21e718','d92c02366ae91966e4cdbe6279fc36eb'),
						(629,111,46,'Pidana Biasa','Tindak Pidana Senjata Api atau Benda Tajam','4c310c6f2a0f804af0a8644829b80b29','d92c02366ae91966e4cdbe6279fc36eb'),
						(630,118,46,'Pidana Anak','Tindak Pidana Senjata Api atau Benda Tajam','','720019806a7048ddb474cdfdd309352d'),
						(631,15,367,'Perdata Gugatan','Wakaf','d6aad19f357bc6e124c28b551cdb0c97','a28ae04e55e1f8c13005da77edbee894'),
						(632,16,363,'Perdata Permohonan','Wali Adhol','','a28ae04e55e1f8c13005da77edbee894'),
						(633,2,92,'Permohonan','Wali Dan Ijin  Jual','','4d88fcc4f35395470bd80f19f776d242'),
						(634,1,116,'Gugatan','Wanprestasi','2e43da4ffbd3f7803cb80cce91ad8866','4d88fcc4f35395470bd80f19f776d242'),
						(635,1,120,'Gugatan','Wanprestasi','2e43da4ffbd3f7803cb80cce91ad8866','4d88fcc4f35395470bd80f19f776d242'),
						(636,7,116,'Perlawanan/Bantahan (derden verzet)','Wanprestasi','','4d88fcc4f35395470bd80f19f776d242'),
						(637,7,120,'Perlawanan/Bantahan (derden verzet)','Wanprestasi','','4d88fcc4f35395470bd80f19f776d242'),
						(638,8,120,'Gugatan Sederhana','Wanprestasi','','4d88fcc4f35395470bd80f19f776d242'),
						(639,1,63,'Gugatan','Warisan/Wasiat','998d4654534cd10f2a599f34b9fd2965','4d88fcc4f35395470bd80f19f776d242'),
						(640,7,63,'Perlawanan/Bantahan (derden verzet)','Warisan/Wasiat','','4d88fcc4f35395470bd80f19f776d242'),
						(641,15,365,'Perdata Gugatan','Wasiat','900381ebfb17ec007ed05023cc339343','a28ae04e55e1f8c13005da77edbee894'),
						(642,111,223,'Pidana Biasa','Wilayah Negara','','6f5068aaa5515f46e4aeafca2f48dfa2'),
						(643,118,223,'Pidana Anak','Wilayah Negara','','720019806a7048ddb474cdfdd309352d'),
						(644,1,125,'Gugatan','Yayasan','','4d88fcc4f35395470bd80f19f776d242'),
						(645,7,125,'Perlawanan/Bantahan (derden verzet)','Yayasan','','4d88fcc4f35395470bd80f19f776d242'),
						(646,122,509,'Jinayat','Zina','149fc12364fae0de53cb887b8de030f1','6f5068aaa5515f46e4aeafca2f48dfa2');");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_antrian` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) NOT NULL COMMENT 'sesuai dengan sipp',
						  `status` tinyint(1) DEFAULT NULL COMMENT '1 = berhasil, 0 = belum upload, -1 = error',
						  `last_tried` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'menunjukkan waktu percobaan terakhir',
						  `keterangan` varchar(500) DEFAULT NULL COMMENT 'sebagai log transaksi',
						  `tgl_masuk` timestamp NULL DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_dokumen` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) NOT NULL,
						  `dokumen_ref_id` bigint(20) NOT NULL,
						  `filename` varchar(255) NOT NULL,
						  `path_filename` varchar(355) NOT NULL,
						  `created_by` varchar(255) NOT NULL,
						  `created_date` date NOT NULL,
						  `updated_by` varchar(255) DEFAULT NULL,
						  `updated_date` date DEFAULT NULL,
						  `pihak_detil_id` bigint(20) NOT NULL DEFAULT '0' COMMENT 'merujuk ke tabel banding_detil, kasasi_detil, pk_detil pada kolom id',
						  `keterangan` varchar(255) DEFAULT NULL,
						  `flag_sync` tinyint(1) DEFAULT NULL COMMENT 'penanda antrian sudah terupload atau belum',
						  `pengajuan_id` tinyint(1) unsigned NOT NULL COMMENT '1 = tidak diajukan, 2 = banding, 3 = kasasi, 4 = pk, 5 = grasi',
						  PRIMARY KEY (`perkara_id`,`dokumen_ref_id`,`pihak_detil_id`,`pengajuan_id`),
						  KEY `id` (`id`)
						) ENGINE=InnoDB;");

		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_perkara` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id perkara di dirput',
						  `perkara_id` bigint(20) DEFAULT NULL COMMENT 'perkara id sesuai sipp',
						  `putusan_id` varchar(100) NOT NULL COMMENT 'putusan id didapat dari tarik data dirput',
						  `nomor_perkara` varchar(50) NOT NULL COMMENT 'no perkara sesuai sipp',
						  `pengajuan_id` tinyint(1) unsigned DEFAULT NULL COMMENT '1 = tdk mengajukan, 2 = banding, 3 = kasasi, 4 = pk, 5 = grasi',
						  `nomor_perkara_key` varchar(50) DEFAULT NULL COMMENT 'nomor perkara dari dirput',
						  PRIMARY KEY (`id`),
						  UNIQUE KEY `nomor_perkara` (`nomor_perkara`),
						  UNIQUE KEY `putusan_id` (`putusan_id`),
						  UNIQUE KEY `perkara_id` (`perkara_id`)
						) ENGINE=InnoDB;");

		$this->db->query("CREATE TABLE IF NOT EXISTS `dirput_pengajuan` (
						  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
						  `perkara_id` bigint(20) NOT NULL COMMENT 'sesuai dengan sipp',
						  `pengajuan_guid` varchar(100) DEFAULT NULL COMMENT 'id pengajuan dari dirput',
						  `nomor_perkara` varchar(50) DEFAULT NULL COMMENT 'sesuai dengan sipp',
						  `nomor_surat_pengantar` varchar(100) DEFAULT NULL COMMENT 'sesuai dengan sipp',
						  `tgl_surat_pengantar` date DEFAULT NULL COMMENT 'diisi sesuai dengan tanggal surat pengantar',
						  `no_resi_pos` varchar(100) DEFAULT NULL COMMENT 'diisi sesuai dengan no resi pos',
						  `status_pengajuan` varchar(100) DEFAULT NULL COMMENT 'keterangan = sampai, telah di download, telah diregister, diperiksa, putus, dikirim kembali',
						  `tgl_status_pengajuan` date DEFAULT NULL COMMENT 'tanggal status pengajuan',
						  `barcode` varchar(150) DEFAULT NULL COMMENT 'link barcode',
						  `pengajuan_id` tinyint(1) unsigned NOT NULL COMMENT '1 = tidak diajukan, 2 = banding, 3 = kasasi, 4 = pk, 5 = grasi',
						  `id_surat_pengantar` varchar(100) DEFAULT NULL COMMENT 'id surat pengantarnya yang di dirput',
						  PRIMARY KEY (`perkara_id`,`pengajuan_id`),
						  KEY `perkara_id` (`perkara_id`),
						  KEY `nomor_perkara` (`nomor_perkara`)
						) ENGINE=InnoDB;");

		$this->db->query("REPLACE INTO `sys_config` (`id`, `category`, `name`, `value`, `ordering`) VALUES
						('88','System','user_dirput','','0'),
						('89','System','pwd_dirput','','0'), 
						('90','System','pengadilan_id','000000000','0'), 
						('91','System','token_delegasi','5ff1dadefbab82646895192b84ea0f20',0),
						('92','System','Index_perkara','',0),
						('93','Site','PlhKetua',NULL,0),('94','Site','PlhKetuaNip',NULL,0),
						('95','Site','PlhPanitera',NULL,0),('96','Site','PlhPaniteraNip',NULL,0),('97','Site','PltKetua',NULL,0),
						('98','Site','PltKetuaNip',NULL,0),('99','Site','PltPanitera',NULL,0),('100','Site','PltPaniteraNip',NULL,0);");

		$this->db->query("UPDATE `delegasi_keluar` SET `namadokumen` = NULL ,`document` = NULL ,`document_size` = NULL ,`document_mime` = NULL;");	
		$this->db->query("UPDATE `delegasi_masuk` SET `namadokumen` = NULL ,`document` = NULL ,`document_size` = NULL ,`document_mime` = NULL;");
		$this->db->query("UPDATE `delegasi_proses_masuk` SET `namadokumen` = NULL ,`document` = NULL ,`document_size` = NULL ,`document_mime` = NULL;");
		$this->db->query("UPDATE `delegasi_proses_keluar` SET `namadokumen` = NULL ,`document` = NULL ,`document_size` = NULL ,`document_mime` = NULL;");		
		
		$this->db->query("DROP FUNCTION IF EXISTS `nama_bulan`");
		$this->db->query("CREATE FUNCTION `nama_bulan`(bln INT(2)) RETURNS VARCHAR(10) CHARSET latin1
							RETURN
							  CASE
							WHEN bln = 1 THEN 'Januari'
							    WHEN bln = 2 THEN 'Februari'
							    WHEN bln = 3 THEN 'Maret'
							    WHEN bln = 4 THEN 'April'
							    WHEN bln = 5 THEN 'Mei'
							    WHEN bln = 6 THEN 'Juni'
							    WHEN bln = 7 THEN 'Juli'
							    WHEN bln = 8 THEN 'Agustus'
							    WHEN bln = 9 THEN 'September'
							    WHEN bln = 10 THEN 'Oktober'
							    WHEN bln = 11 THEN 'November'
							    WHEN bln = 12 THEN 'Desember'
							    END;");
		
		$this->db->query("DROP FUNCTION IF EXISTS `convert_tanggal_indonesia`;");
		$this->db->query("CREATE FUNCTION `convert_tanggal_indonesia`(tmp DATE) RETURNS VARCHAR(18) CHARSET latin1
							RETURN
							  CONCAT_WS(' ',RIGHT(tmp,2),nama_bulan(SUBSTRING(tmp,6,2)),LEFT(tmp,4));");
		
		$this->db->query("DROP FUNCTION IF EXISTS `nama_hari`;");
		$this->db->query("CREATE FUNCTION `nama_hari`(tanggal DATE) RETURNS VARCHAR(10) CHARSET latin1
							RETURN
							  CASE WEEKDAY(tanggal)
							    WHEN 0 THEN 'Senin'
							    WHEN 1 THEN 'Selasa'
							    WHEN 2 THEN 'Rabu'
							    WHEN 3 THEN 'Kamis'
							    WHEN 4 THEN 'Jumat'
							    WHEN 5 THEN 'Sabtu'
							    WHEN 6 THEN 'Minggu'
							    END;");
		
		$this->db->query("DROP FUNCTION IF EXISTS `bulan_romawi`;");
		$this->db->query("CREATE FUNCTION `bulan_romawi`(bln INT(2)) RETURNS VARCHAR(4) CHARSET latin1
							RETURN
							  CASE
							    WHEN bln = 1 THEN 'I'
							    WHEN bln = 2 THEN 'II'
							    WHEN bln = 3 THEN 'III'
							    WHEN bln = 4 THEN 'IV'
							    WHEN bln = 5 THEN 'V'
							    WHEN bln = 6 THEN 'VI'
							    WHEN bln = 7 THEN 'VII'
							    WHEN bln = 8 THEN 'VIII'
							    WHEN bln = 9 THEN 'IX'
							    WHEN bln = 10 THEN 'X'
							    WHEN bln = 11 THEN 'XI'
							    WHEN bln = 12 THEN 'XII'
							    END;");
		
		$this->db->query("REPLACE INTO dirput_ref (guid, title, category, alur_perkara_id, sub_category, description, parentguid)
		VALUES ('772c9abf5316d920ae871459a979fc48','aHR0cDovL3B1dHVzYW4ubWFoa2FtYWhhZ3VuZy5nby5pZC9hcGk=','c2lwcA==','9999999','U0lQUDIwMTYh',NULL,'ZGlnZXN0');");
		
		$this->db->query("REPLACE  INTO updates_catatan(id,update_id,deskripsi) values 
							(324,13,'<b>Peningkatan Fungsi template 4 Lingkungan Peradilan : </b><li>Pendaftaran </li><li>Penetapan</li><li>Persidangan (BAS)</li><li>Relaas</li><li>Putusan</li><li>Instrumen Panggilan</li><li>Amplop Relaas</li>'),
							(325,13,'Pada Jurnal Perdata ditambahkan fitur Cetak Jurnal Harian.'),
							(326,13,'Pada Tab Data Umum untuk peradilan umum ditambahkan kolom Pasal dakwaan'),
							(327,13,'Pada Tab Data Umum ditambahkan kolom Posita 4 lingkungan peradilan'),
							(328,13,'Pada Tab Data Umum untuk Data Penasehat Hukum/Pengacara ditambahkan kolom Nomor dan Tanggal Kuasa.'),
							(329,13,'Pada Detil Penahanan ditambahkan Data Dibantarkan untuk peradilan umum.'),
							(330,13,'Pada Tab Penetapan ditambahkan alasan Penetapan Kembali Majelis Hakim dan Panitera Pengganti untuk 4 lingkungan peradilan.'),
							(331,13,'Pada Tab Penetapan (PHS) ditambahkan pilihan ruang sidang pada peradilan agama.'),
							(332,13,'Pada Jurnal Perkara ditambahkan fitur rubah jenis pembiayaan (Prodeo/Tidak) untuk 4 lingkungan peradilan.'),
							(333,13,'Pada Tab Jadwal Sidang ditambahkan fitur Data Relaas untuk input data relaas yang telah dilaksanakan oleh Jurusita/Jurusita Pengganti untuk 3 lingkungan peradilan.'),
							(334,13,'Pada Tab Jadwal Sidang ditambahkan kolom Sifat Sidang pada edit/tunda jadwal sidang 4 Lingkungan Peradilan.'),
							(335,13,'Pada Tab Jadwal Sidang ditambahkan Fitur Upload BAS 4 Lingkungan Peradilan.'),
							(336,13,'Pada Tab Jadwal Sidang ditambahkan fitur Data Persidangan 4 Lingkungan Peradilan.'),
							(337,13,'Pada Tab saksi ditambahkan kolom Jenis Saksi 4 Lingkungan Peradilan.'),
							(338,13,'Pada Tab Putusan ditambahkan fitur Referensi Amar Putusan 4 Lingkungan Peradilan.'),
							(339,13,'Optimalisasi Menu Delegasi pada 3 lingkungan peradilan.'),
							(340,13,'Integrasi SIPP dengan Direktori Putusan dan SIAP MARI.'),
							(341,13,'Penambahan fitur Monitoring Upload Direktori Putusan 4 lingkungan Peradilan.'),
							(342,13,'Perbaikan Akta Cerai untuk peradilan agama.'),
							(343,13,'Penambahan fitur Upload Dokumen Anonimisasi ke Direktori Putusan 4 lingkungan Peradilan.'),
							(344,13,'Penambahan Fitur Cetak SKUM untuk peradilan Umum.'),
							(345,13,'Penambahan Fitur Teguran Biaya Perkara untuk peradilan Umum.'),
							(346,13,'Penambahan Fitur Outo Complete Pengisian Nomor Perkara pada Tambah Banding/Kasasi/PK.'),
							(347,13,'Penambahan Fitur Ubah Alur Perdata Gugatan ke Bantahan dan sebaliknya untuk Peradilan Umum.'),
							(348,13,'Perbaikan Tahapan Diversi Pada Pidana Khusus Anak untuk Peradilan Umum.'),
							(349,13,'Penambahan 3 Register yaitu Register Diversi, Register Anak Belum 12 Tahun dan Register Anak Korban dan Anak Saksi untuk Peradilan Umum.'),
							(350,13,'Penambahan Fitur Reminder perkara Diversi untuk Peradilan Umum.'),
							(351,13,'Penambahan Fitur PHS Kembali.'),
							(352,13,'Penambahan Pihak Anak Korban dan Anak Saksi di Pidana Biasa,Singkat dan Cepat untuk Peradilan Umum.'),
							(353,13,'Penambahan Data Referensi Biaya Perkara untuk Permohonan dan KIP untuk Peradilan Tata Usaha Negara'),
							(354,13,'Penambahan Fitur Replik dan Duplik pada Data Persidangan untuk Peradilan Militer.'),
							(355,13,'Penambahan Fitur User Online pada 4 lingkungan Peradilan.'),
							(356,13,'Perbaikan Error pada Upload E-doc dan antrian upload direktori putusan untuk Putusan Gugatan Sederhana untuk Peradilan Umum'),
							(357,13,'Penambahan Kewenangan Pada User Panitera Muda Agama Gugatan dan Permohonan Pada Menu Delegasi untuk Peradilan Agama'),
							(358,13,'Penambahan Fitur Sifat Sidang Pada Edit Data Sidang, Otomatis mengikuti Jenis Perkara untuk 4 Lingkungan Peradilan'),
							(359,13,'Perbaikan Error Tambah Diversi pada register diversi untuk Peradilan Umum'),
							(360,13,'Perbaikan Error Tambah Saksi untuk 4 Lingkungan Peradilan'),
							(361,13,'Perbaikan Error Tidak Tampilnya Tanggal Sampai dan Jumlah Hari Minus Pada Penahanan Penangguhan untuk Peradilan Umum'),
							(362,13,'Perbaikan Error Tab Putusan Hilang Ketik Edit Jadwal Sidang dengan Status Perkara Sudah Putusan untuk 4 Lingkungan Peradilan'),
							(363,13,'Perbaikan Error Tab Putusan Hilang Ketik Edit Jadwal Sidang dengan Status Perkara Sudah Putusan untuk 4 Lingkungan Peradilan'),
							(364,13,'Perbaikan Error Duplikasi Amar Putusan di Perkara Tab Putusan Akhir untuk 4 lingkungan Peradilan'),
							(365,13,'Optimalisasi Fitur Tab Putusan Akhir pada Kolom Amar Putusan Menjadi 1 (satu) kolom saja yang dimunculkan untu Peradilan Umum.'),
							(366,13,'Perbaikan Error pada Tombol Unduh/tambah Formulir Perkara Pidana Tilang yang tidak muncul untuk Peradilan Umum'),
							(367,13,'Perbaikan Error pada Pilihan Jenis Saksi Pada Data Saksi untuk 4 Lingkungan Peradilan'),
							(368,13,'Perbaikan Error Tambah klasifikasi Lain-lain Perkara Pidana Cepat yang berubah menjadi Pid.Sus untuk Peradilan Umum'),
							(369,13,'Perbaikan Error Tombol Pencarian Detil pada Arsip Perkara untuk 4 Lingkungan Peradilan'),
							(370,13,'Perbaikan Error pada Perkara yang ditangani ketika klik Status Perkara untuk 4 Lingkungan Peradilan'),
							(371,13,'Perbaikan Error Tombol Batal Minutasi yang tidak muncul untuk Perkara yang Telah Minutasi Diversi (dari versi sebelumnya) pada Peradilan Umum.'),
							(372,13,'Perbaikan Error pada Keterangan Saksi Hakim Ketua dan Anggota 1 untuk 4 Lingkungan Peradilan'),
							(373,13,'Perbaikan Error Saat Hapus Delegasi Keluar Sebelum Dikirim untuk 4 Lingkungan Peradilan'),
							(374,13,'Perbaikan Error Cetak Dokumen PMH Ikrar untuk Peradilan Agama'),
							(375,13,'Perbaikan Fitur pada Kolom Pilihan Pengadilan Tinggi Tambah Delegasi Keluar untuk 4 Lingkungan Peradilan'),
							(376,13,'Perbaikan Error pada Sys Auditrail dengan Pesan Error Data too long for title untuk 4 Lingkungan Peradilan '),
							(377,13,'Perbaikan Fitur pada Cetak Penunjukan Jurusita, Muncul Nama Panitera Pengganti dimana Seharusnya Hanya Nama Jurusita untuk Peradilan Agama'),
							(378,13,'Perbaikan Fitur pada Tanggal Musyawarah Diversi Pertama Tidak Bisa Melebihi Tanggal Penetapan Diversi untuk Peradilan Umum'),
							(379,13,'Perbaikan Error Pada saat Tambah Data Anak Belum 12 Tahun pada Perkara Diversi untuk Peradilan Umum'),
							(380,13,'Perbaikan Error Tanggal BHT Yang Hanya Muncul di Pidana Anak untuk Peradilan Umum'),
							(381,13,'Perbaikan Error Tombol Kembali pada Fitur Tambah Jurnal di Detil Jurnal Eksekusi dan Eksekusi Hak Tanggungan untuk Peradilan Umum'),
							(382,13,'Perbaikan Error Tambah Mediasi pada Tab Mediasi Tidak Muncul untuk 4 Lingkungan Peradilan'),
							(383,13,'Perbaikan Error Cetak PMH pada Urutan Majelis untuk Peradilan Umum dan Peradilan Tata Usaha Negara'),
							(384,13,'Perbaikan Error Blangko Dokumen Jadwal Mediasi yang Tidak Muncul untuk 4 Lingkungan Peradilan'),
							(385,13,'Perbaikan Error Tanggal Penetapan pada Cetak Dokumen Template Penetapan Hari Sidang Kembali untuk 4 Lingkungan Peradilan'),
							(386,13,'Perbaikan Error pada Beberapa Dokumen Template Data Hasil Mediasi yang Tidak Dapat dicetak untuk 4 Lingkungan Peradilan'),
							(387,13,'Perbaikan Error Tambah Perkara Lalu Lintas Jika di Klik Tombol Tambah Perkara Yang Muncul Download Format Tilang Excel untuk Peradilan Umum'),
							(388,13,'Perbaikan Error Cetak Blangko Putusan Pada Tab Putusan Akhir Data, Nama Pihak dan Nama pengadilan Tidak Muncul untuk 4 Lingkungan Peradilan'),
							(389,13,'Perbaikan Error Tambah Nama Jurusita yang ditunjuk pada Tab Ikrar Talak, Nama Yang disimpan kedalam Database dan ditampilkan Bukan Nama Jurisita melainkan Nama Panitera pengganti untuk Peradilan Agama'),
							(390,13,'Perbaikan Error Tab Jadwal Sidang Tidak Muncul pada Saat Proses Penetapan Kembali Majelis Hakim untuk Status Perkara Persidangan untuk 4 Lingkungan Peradilan'),
							(391,13,'Perbaikan Error Tab Penetapan Tidak Muncul Saat Proses Penetapan Kembali Majelis Hakim untuk Status Perkara Persidangan untuk 4 Lingkungan Peradilan'),
							(392,13,'Perbaikan Error Cetak dokumen putusan, khusus Verstek datanya kosong/Blank untuk Peradilan Umum dan Peradilan Agama '),
							(393,13,'Perbaikan Error Menu Antrian Direktori Putusan Hilang Saat Update 3.2.0, Login Dengan Admin untuk 4 Lingkungan Peradilan'),
							(394,13,'Perbaikan Error Penetapan Hari Sidang Kembali pada Edit Jadwal Sidang Tidak Dapat Hapus Data Untuk Peradilan Agama'),
							(395,13,'Perbaikan Error Tambah BHT Tidak Dapat Refresh untuk 4 Lingkungan Peradilan'),
							(396,13,'Perbaikan Template Instrumen Panggilan untuk 4 Lingkungan Peradilan'),
							(397,13,'Perbaikan Error Cetak Excel Jadwal Sidang, Seluruh Data Tampil Ketika difilter Tanggal 4 Lingkungan Peradilan'),
							(398,13,'Perbaikan Error Jurnal Banding, Warna Merah pada Saldo Nol (0) untuk 4 Lingkungan Peradilan'),
							(399,13,'Perbaikan Error Template Perkara Itsbat Nikah untuk Peradilan Agama'),
							(400,13,'Perbaikan Error Surat Pengantar Delegasi Keluar untuk 4 Lingkungan Peradilan'),
							(401,13,'Perbaikan Perlakuan Riwayat Perkara dan Status Perkara Terhadap : <ul><li>Penunjukan Majelis Hakim</li><li>Penetapan Majelis Hakim Kembali</li><li>Penunjukan PP</li><li>Penunjukan kembali PP</li>'),
							(402,13,'Perbaikan Error pada Tab dan Link/Tombol pada Detail Perkara yang Hilang untuk 4 Lingkungan Peradilan'),
							(403,13,'Perbaikan Error link/tombol penetapan Jurusita dan Penetapan Hari Sidang Akibat Sistem Riwayat Perkara Baru untuk 4 lingkungan Peradilan'),
							(404,13,'Penambahan Fitur Gugatan Intervensi untuk Peradilan Umum'),
							(405,13,'Perbaikan Error Hasil Edit Alamat Pihak Pada Tab Data Umum Tidak Tampil untuk 4 Lingkungan Peradilan'),
							(406,13,'Penambahan Dokumen Template Untuk Relaas Pemberitahuan Upaya Hukum Banding, Kasasi Maupun Peninjauan Kembali untuk 4 Lingkungan Peradilan'),
							(407,13,'Perbaikan Fitur Informasi Untuk Pengguna (Red Ribbon) Pada Tab Diversi untuk Peradilan Umum'),
							(408,13,'Perbaikan Error pada proses Penghapusan Data Sidang pada Tab Jadwal Sidang untuk 4 Lingkungan Peradilan'),
							(409,13,'Penambahan Fitur Link Draf Menu Putusan Sela Dan Putusan Akhir untuk Pengadilan Tata Usaha Negara'),
							(410,13,'Penambahan Template Berita Acara Persidangan Peradilan Tata Usaha Negara'),
							(401,13,'Penambahan Template BAP Pemeriksaan Persiapan Peradilan Tata Usaha Negara'),
							(411,13,'Penambahan Template Penetapan Dismissal/Pemberitahuan Peradilan Tata Usaha Negara'),
							(412,13,'Penambahan Template PMH, PP, JSP, PHS Peradilan Tata Usaha Negara'),
							(413,13,'Penambahan Template Penetapan Pemeriksaan Persiapan Peradilan Tata Usaha Negara'),
							(414,13,'Penambahan Template Relaas Panggilan Dismissal Peradilan Tata Usaha Negara'),
							(415,13,'Penambahan Template Relaas Panggilan Pemeriksaan Persiapan Peradilan Tata Usaha Negara'),
							(416,13,'Penambahan Template Pemberitahuan Putusan Peradilan Tata Usaha Negara'),
							(417,13,'Penambahan Template Relaas Panggilan Sidang Peradilan Tata Usaha Negara'),
							(418,13,'Penambahan Template Penetapan Perlawanan (PMH, PPJSP, PHS) Peradilan Tata Usaha Negara'),
							(419,13,'Perbaikan Error Blangko Cetak Akta Cerai Tidak Muncul untuk Peradilan Agama'),
							(420,13,'Perbaikan Error paada Penunjukan Jurusita Jika Terdapat Penetapan Kembali Majelis Hakim Atau Penetapan Kembali Panitera Pengganti 4 Lingkungan Peradilan'),
							(421,13,'Perubahan Riwayat Perkara dan Status Perkara Belum Sempurna di Tambah-edit-Hapus Penunjukan Jurusita untuk 4 Lingkungan Peradilan'),
							(422,13,'Perbaikan Referensi Amar untuk 4 Lingkungan Peradilan'),
							(423,13,'Perbaikan Variabel #panggilan_angka# Dan #panggilan_terbilang# Pada Instrumen Panggilan untuk Peradilan Umum dan Peradilan Agama'),
							(424,13,'Perbaikan Referensi Amar di Filter Sesuai Dengan Jenis Perkara untuk 4 Lingkungan Peradilan'),
							(425,13,'Perbaikan Cetak Pengantar Delegasi Masuk,identitas Pihak Tidak Bisa Tampil Sehingga Template Belum Bisa Digunakan pada Peradilan Umum dan Peradilan Agama'),
							(426,13,'Perbaikan Error Penahanan untuk Peradilan Umum'),
							(427,13,'Perbaikan Error Penyidik Perpanjangan Kedua Oleh Ketua PN dilist penahanan urutannya di paling bawah padahal tanggal dan inputnya setelah Penyidik Perpanjangan Pertama'),
							(428,13,'Perbaikan Error Cetak template juga Penyidik Perpanjangan Kedua tidak muncul di list penahanannya untuk Peradilan Umum.'),
							(429,13,'Perbaikan Error Cetak Pencarian Dengan Kombinasi Tanggal untuk 4 Lingkungan Peradilan'),
							(430,13,'Perbaikan Error Pada Form Pengisian Pelaksanaan Delegasi Masuk oleh Jurusita Ada Upload Relass untuk Peradilan Umum dan Peradilan Agama'),
							(431,13,'Perbaikan Error Pada Delegasi, Ada Warning Delegasi Belum Dilaksanakan Peradilan Umum dan Peradilan Agama'),
							(432,13,'Perbaikan Error Register Perkara Banding Pada Form Detail 4 Lingkungan Peradilan'),
							(433,13,'Perbaikan Error Edit Nomor Register Penyidik Pada Register Diversi untuk Peradilan Umum'),
							(433,13,'Penambahan Fitur Kewenangan Pihak pada Detil Register Diversi untuk Peradilan Umum'),
							(433,13,'Perbaikan Error Tambah Pihak Badan Hukum/pemerintah Pada Eksekusi Hak Tanggungan untuk Peradilan Umum'),
							(433,13,'Perbaikan Status Penahanan Bila Terdakwa tidak Ditahan Akan Muncul Di Dashboard untuk Peradilan Umum'),
							(433,13,'Perbaikan Cetak Surat Panggilan Dismissal Tergugat Untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Cetak Surat Panggilan Dismissal Penggugat Untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Cetak Surat Panggilan Pemeriksaan Persiapan Tergugat Untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Cetak Surat Panggilan Pemeriksaan Persiapan Penggugat Untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Upload File Putusan Publish/tidak disesuaikan dengan Jenis Perkaranya Untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Slide Sidang Tambah Pemeriksaan Persiapan untuk Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaiakan list Sidang Tambah Pemeriksaan Persiapan Pengadilan Tata Usaha Negara'),
							(433,13,'Perbaikan Penyebutan Nama Pansek di Pemberitahuan Pernyataan Banding untuk 4 Lingkungan Peradilan'),
							(433,13,'Perbaikan Cetak Surat Pemberitahuan Pernyataan Banding Kepada Penggugat/Terbanding untuk 4 Lingkungan Peradilan');");

		$this->db->query("REPLACE INTO `sys_menus` (`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) VALUES('38','mainmenu','2','1','Antrian Direktori Putusan','antrian_dirput','','1','6');");	
		$this->db->query("REPLACE INTO sys_menu_rule (menuid,ruleid) VALUES (38,1);");
		$this->db->query("REPLACE INTO sys_menus(`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) VALUES (2016,'mainmenu',NULL,2,'Delegasi','delegasi','',1,6);");

		$this->db->query("UPDATE `sys_menus` SET `published` = '0' WHERE `id` = '2017';");
		$this->db->query("UPDATE `sys_menus` SET `published` = '0' WHERE `id` = '2018';");

		//diversi
		
		$this->db->query("REPLACE INTO `proses` (`id`, `tahapan_id`, `kode`, `nama`, `keterangan`, `nama_tabel`, `nama_kolom`, `status`, `aktif`, `diedit_oleh`, `diedit_tanggal`, `diinput_oleh`, `diinput_tanggal`, `diperbaharui_oleh`, `diperbaharui_tanggal`) values
('10','10','10','Pendaftaran Perkara','Pendaftaran Perkara','perkara','tanggal_pendaftaran','Pendaftaran Perkara','Y','',NULL,NULL,NULL,NULL,NULL),
('15','12','12','Panggilan Pihak','Panggilan Para Pihak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('16','12','12','Penetapan Dismissal Diterima','Penetapan Dismissal Diterima',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('17','15','15','Putusan Perlawanan Diterima','Putusan Perlawanan Diterima',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('20','12','20','Penetapan Majelis Hakim/Hakim','Penetapan Majelis Hakim/Hakim','perkara_penetapan','penetapan_majelis_hakim','Penetapan Majelis Hakim/Hakim','Y','system','2012-11-06 14:01:16',NULL,NULL,NULL,'2012-11-06 14:01:16'),
('21','12','21','Penetapan Kembali Majelis Hakim/Hakim','Penetapan Kembali Majelis Hakim/HakimPenunjukan Kembali Majelis Hakim/Hakim','','','','Y','system','2012-10-22 12:29:19',NULL,NULL,NULL,'2012-10-22 12:29:19'),
('30','12','30','Penunjukan Panitera Pengganti','Penunjukan Panitera Pengganti','perkara_penetapan','penetapan_panitera_pengganti','Penunjukan Panitera Pengganti','Y','system','2012-10-22 12:30:24',NULL,NULL,NULL,'2012-10-22 12:30:24'),
('31','12','31','Penunjukan Kembali Panitera Pengganti','Penunjukan Kembali Panitera Pengganti','','','','Y','system','2012-10-07 14:53:23',NULL,NULL,NULL,'2012-10-07 14:53:23'),
('40','12','40','Penunjukan Jurusita','Penunjukan Jurusita','perkara_penetapan','penetapan_jurusita','Penunjukan Jurusita','Y','system','2012-10-22 12:31:00',NULL,NULL,NULL,'2012-10-22 12:31:00'),
('41','12','41','Penunjukan Kembali Jurusita','Penunjukan Kembali Jurusita','','','','Y','system','2012-10-07 14:53:12',NULL,NULL,NULL,'2012-10-07 14:53:12'),
('42','17','42','Pemeriksaan Persiapan','Pemeriksaan Persiapan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('65','12','65','Penetapan Musyawarah Diversi','Penetapan Musyawarah Diversi','perkara_diversi','tgl_penetapan_musyawarah','Penetapan Musyawarah Diversi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('66','12','66','Kesepakatan Pelaksanaan Diversi','Kesepakatan Pelaksanaan Diversi',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('68','12','68','Musyawarah Diversi','Musyawarah Diversi','perkara_diversi','tgl_musyawarah','Musyawarah Diversi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('70','12','70','Hasil Musyawarah Diversi','Hasil Musyawarah Diversi',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('72','12','72','Pelaksanaan Kesepakatan Diversi','Pelaksanaan Kesepakatan Diversi','','','','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('74','12','74','Hasil Pelaksanaan Kesepakatan Diversi','Hasil Pelaksanaan Kesepakatan Diversi','perkara_diversi','tgl_lap_pembimbing_masyarakat','Hasil Pelaksanaan Kesepakatan Diversi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('75','12','75','Penghentian Pemeriksaan Perkara','Penghentian Pemeriksaan Perkara',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('80','12','80','Penetapan Hari Sidang Pertama','Penetapan Hari Sidang Pertama','perkara_penetapan','penetapan_hari_sidang','Penetapan Hari Sidang Pertama','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('81','12','81','Sidang pertama','Sidang pertama','perkara_penetapan','sidang_pertama','','Y','system','2012-10-07 14:24:34',NULL,NULL,NULL,'2012-10-07 14:24:34'),
('110','13','13','Pendaftaran Perlawanan','Pendaftaran Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('111','13','13','Penetapan Majelis Hakim Perlawanan','Penetapan Majelis Hakim Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('112','13','13','Penetapan Panitera Pengganti Perlawanan','Penetapan Panitera Pengganti Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('113','13','13','Penetapan Jurusita Perlawanan','Penetapan Jurusita Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('114','13','13','Penetapan Jadwal Sidang Perlawanan','Penetapan Jadwal Sidang Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('115','13','13','Sidang Pertama Perlawanan','Sidang Pertama Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('116','13','13','Persidangan Perlawanan','Persidangan Perlawanan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('120','13','120','Penetapan Tanggal Mediasi','Penetapan Tanggal Mediasi','perkara_mediasi','penetapan_tanggal_mediasi','Mediasi','Y','system','2012-10-22 12:32:29',NULL,NULL,NULL,'2012-10-22 12:32:29'),
('121','13','121','Mulai Mediasi','Mulai Mediasi','perkara_mediasi','dimulai_mediasi','Mediasi','Y','system','2012-10-07 14:28:06',NULL,NULL,NULL,'2012-10-07 14:28:06'),
('130','13','130','Kesepakatan Mediasi','Kesepakatan Mediasi','perkara_mediasi','keputusan_mediasi','Putusan Mediasi','Y','',NULL,NULL,NULL,NULL,'2012-10-01 18:56:11'),
('140','13','13','Penetapan Akta Perdamaian','Penetapan Akta Perdamaian',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('150','13','150','Mediasi Tidak Berhasil','Mediasi Tidak Berhasil','perkara_mediasi','mediasi_gagal','Putusan Mediasi','Y','system','2012-10-07 14:28:45',NULL,NULL,NULL,'2012-10-07 14:28:45'),
('151','13','151','Mediasi Tidak Dapat Dilaksanakan','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('180','13','180','Mediasi Berhasil','Mediasi Berhasil','perkara_mediasi','mediasi_berhasil','Putusan Mediasi','Y','system','2012-10-07 14:28:53',NULL,NULL,NULL,'2012-10-07 14:28:53'),
('181','13','181','Mediasi Berhasil Sebagian','Mediasi Berhasil Sebagian',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('190','13','190','Penetapan Akta Perdamaian','Penetapan Akta Perdamaian','perkara_mediasi','akta_perdamaian','Putusan Mediasi','Y','system','2012-10-07 14:29:06',NULL,NULL,NULL,'2012-10-07 14:29:06'),
('191','13','13','Tidak Mediasi','Tidak Mediasi',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('200','14','200','Persidangan','Persidangan','','','','Y','system','2012-10-22 12:40:39','system',NULL,'system','2012-10-22 12:40:39'),
('203','14','203','Putusan Sela','Putusan Sela','perkara_putusan_sela','tanggal_putusan_sela','Putusan Sela','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('206','14','206','Tuntutan','Tuntutan','perkara_penuntutan','tanggal_penuntutan','Tuntutan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('210','15','210','Putusan','Putusan','perkara_putusan','tanggal_putusan','Putusan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('211','15','211','Pencabutan Perkara','Pencabutan Perkara','perkara_putusan','tanggal_cabut','Perkara Dicabut','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('212','15','212','Pernyataan Gugur','Pernyataan Gugur','perkara_putusan','tanggal_gugur','Perkara Gugur','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('213','15','213','Penghentian Pemeriksaan Perkara','Penghentian Pemeriksaan Perkara','perkara_putusan','tanggal_putusan','Penghentian Pemeriksaan Perkara','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('214','15','214','Dismissal','Dismissal',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('215','15','215','Penetapan/Putusan Tidak Berwenang','Penetapan/Putusan Tidak Berwenang','perkara_putusan','tanggal_putusan','Penetapan/Putusan Tidak Berwenang','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('217','15','15','Putusan Perlawanan Ditolak','Putusan Perlawanan Ditolak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('218','15','218','Pemberitahuan Putusan','Pemberitahuan Putusan','perkara_putusan','pemberitahuan_putusan','Pemberitahuan Putusan Kepada Para Pihak','Y','',NULL,NULL,NULL,NULL,NULL),
('219','15','219','Kirim Salinan Putusan','Kirim Salinan Putusan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('220','15','220','Minutasi','Minutasi','perkara_putusan','tanggal_minutasi','Minutasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('230','15','15','Pemberitahuan Putusan','Pemberitahuan Putusan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('231','15','231','Pemberitahuan Putusan Kepada Pihak Pertama','Pemberitahuan Putusan Kepada Pihak Pertama','perkara_putusan','pemberitahuan_putusan_pihak1','Pemberitahuan Putusan Kepada Para Pihak','N','system','2012-11-06 13:55:40',NULL,NULL,NULL,'2012-11-06 13:55:40'),
('232','15','232','Pemberitahuan Putusan Kepada Pihak Kedua','Pemberitahuan Putusan Kepada Pihak Kedua','perkara_putusan','pemberitahuan_putusan_pihak2','Pemberitahuan Putusan Kepada Para Pihak','N','system','2012-11-06 13:55:57',NULL,NULL,NULL,'2012-11-06 13:55:57'),
('233','15','233','Pemberitahuan Putusan Kepada Pihak Ketiga','Pemberitahuan Putusan Kepada Pihak Ketiga','perkara_putusan','pemberitahuan_putusan_pihak3','Pemberitahuan Putusan Kepada Para Pihak','N','system','2012-11-06 13:56:03',NULL,NULL,NULL,'2012-11-06 13:56:03'),
('234','15','234','Pihak Pertama (Penggugat/Pemohon/Penuntut) Menerima Baik Putusan','Pihak Pertama (Penggugat/Pemohon/Penuntut) Menerima Baik Putusan','perkara_putusan','menerima_putusan_pihak1','Pihak Pertama (Penggugat/Pemohon/Penuntut) Menerima Baik Putusan','N','system','2012-11-06 13:56:37',NULL,NULL,NULL,'2012-11-06 13:56:37'),
('235','15','235','Pihak Kedua (Tergugat/Termohon/Terdakwa) Menerima Baik Putusan','Pihak Kedua (Tergugat/Termohon/Terdakwa) Menerima Baik Putusan','perkara_putusan','menerima_putusan_pihak2','Pihak Kedua (Tergugat/Termohon/Terdakwa) Menerima Baik Putusan','N','system','2012-11-06 13:56:51',NULL,NULL,NULL,'2012-11-06 13:56:51'),
('236','15','236','Kirim Salinan Putusan Ke Pihak Pertama','Kirim Salinan Putusan Ke Pihak Pertama','perkara_putusan','kirim_salinan_putusan_pihak1','Kirim Salinan Putusan Kepada Para Pihak','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('237','15','237','Kirim Salinan Putusan Ke Pihak Kedua','Kirim Salinan Putusan Ke Pihak Kedua','perkara_putusan','kirim_salinan_putusan_pihak2','Kirim Salinan Putusan Kepada Para Pihak','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('238','15','238','Kirim Salinan Putusan Ke Pihak Ketiga','Kirim Salinan Putusan Ke Pihak Ketiga','perkara_putusan','kirim_salinan_putusan_pihak3','Kirim Salinan Putusan Kepada Para Pihak','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('240','16','240','Pendaftaran Perlawanan(Verzet)','Pendaftaran Perlawanan(Verzet)','perkara_verzet','tanggal_pendaftaran_verzet','Pendaftaran Perlawanan(Verzet)','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('241','16','241','Penetapan Majelis Hakim Verzet','Penetapan Majelis Hakim Verzet','perkara_verzet','penetapan_majelis_hakim','Penetapan Majelis Hakim Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('242','16','242','Penetapan Panitera Pengganti Verzet','Penetapan Panitera Pengganti Verzet','perkara_verzet','penetapan_panitera_pengganti','Penetapan Panitera Pengganti Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('243','16','243','Penetapan Jurusita Verzet','Penetapan Jurusita Verzet','perkara_verzet','penetapan_jurusita','Penetapan Jurusita Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('250','16','250','Penetapan Jadwal Sidang Verzet','Penetapan Jadwal Sidang Verzet','perkara_verzet','tanggal_penetapan_sidang_verzet','Penetapan Jadwal Sidang Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('260','16','260','Sidang Pertama Perlawanan','Sidang Pertama Perlawanan','perkara_verzet','tanggal_sidang_pertama_verzet','Sidang Pertama Perlawanan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('261','16','261','Persidangan Verzet','Persidangan Verzet',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('270','16','270','Putusan Perlawanan  Verzet','Putusan Perlawanan  Verzet','perkara_verzet','putusan_verzet','Putusan Perlawanan  Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('280','16','280','Pemberitahuan Hasil Putusan Verzet','Pemberitahuan Hasil Putusan Verzet','perkara_verzet','pemberitahuan_putusan_verzet','Pemberitahuan Hasil Putusan Verzet','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('281','17','281','Pendaftaran Keberatan','Pendaftaran Keberatan','perkara_keberatan','tanggal_pendaftaran_keberatan','Permohonan Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('282','17','282','Penetapan Majelis Hakim Keberatan','Penetapan Majelis Hakim Keberatan','perkara_keberatan','penetapan_majelis_hakim','Penetapan Majelis Hakim Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('283','17','283','Penunjukan Panitera Pengganti Keberatan','Penunjukan Panitera Pengganti Keberatan','perkara_keberatan','penetapan_panitera_pengganti','Penunjukan Panitera Pengganti Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('284','17','284','Penunjukan Juru Sita Keberatan','Penunjukan Juru Sita Keberatan','perkara_keberatan','penetapan_jurusita','Penunjukan Juru Sita Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('285','17','285','Penetapan Jadwal Sidang Pertama Keberatan','Penetapan Jadwal Sidang Pertama Keberatan','perkara_keberatan','tanggal_penetapan_sidang_keberatan','Penetapan Jadwal Sidang Pertama Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('286','17','286','Sidang Pertama Keberatan','Sidang Pertama Keberatan','perkara_keberatan','tanggal_sidang_pertama_keberatan','Sidang Pertama Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('287','17','287','Persidangan Keberatan','Persidangan Keberatan',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('288','17','288','Putusan Keberatan','Putusan Keberatan','perkara_keberatan','putusan_keberatan','Putusan Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('289','17','289','Pemberitahuan Putusan Keberatan','Pemberitahuan Putusan Keberatan','perkara_keberatan','pemberitahuan_putusan_keberatan','Pemberitahuan Putusan Keberatan','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('290','18','290','Penetapan Majelis Hakim Ikrar Talak','Penetapan Majelis Hakim Ikrar Talak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('291','18','291','Penunjukan Panitera Pengganti Ikrar Talak','Penunjukan Panitera Pengganti Ikrar Talak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('292','18','292','Penunjukan Jurusita','Penunjukan Jurusita',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('293','18','293','Penetapan Hari Sidang Ikrar Talak','Penetapan Hari Sidang Ikrar Talak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('294','18','294','Panggilan Sidang Ikrar Talak','Panggilan Sidang Ikrar Talak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('295','18','295','Penetapan Ikrar Talak','Penetapan Ikrar Talak',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('296','19','296','Pembuatan Akta Cerai','Pembuatan Akta Cerai',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('297','19','297','Penyerahan Akta Cerai','Penyerahan Akta Cerai',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('300','20','300','Permohonan Banding','Permohonan Banding','perkara_banding','permohonan_banding','Permohonan Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('301','20','301','Pemberitahuan Permohonan Banding','Pemberitahuan Permohonan Banding','perkara_banding','pemberitahuan_permohonan_banding','Pemberitahuan Permohonan Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('310','20','310','Penerimaan Memori Banding','Penerimaan Memori Banding','perkara_banding','penerimaan_memori_banding','Penerimaan Memori Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('320','20','320','Penyerahan Memori Banding','Penyerahan Memori Banding','perkara_banding','penyerahan_memori_banding','Penyerahan Memori Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('330','20','330','Penerimaan Kontra Memori Banding','Penerimaan Kontra Memori Banding','perkara_banding','penerimaan_kontra_banding','Penerimaan Kontra Memori Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('340','20','340','Penyerahan Kontra Memori Banding','Penyerahan Kontra Memori Banding','perkara_banding','penyerahan_kontra_banding','Penyerahan Kontra Memori Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('350','20','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)','Permberitahuan Untuk Memeriksa Berkas(Inzage)','perkara_banding_detil','pemberitahuan_inzage','Permberitahuan Untuk Memeriksa Berkas(Inzage) Kepada Para Pihak Banding','Y','system','2012-06-01 15:40:38','system',NULL,'system','2012-06-01 15:40:38'),
('360','20','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)','Pelaksanaan Untuk Memeriksa Berkas(Inzage) ','perkara_banding_detil','pelaksanaan_inzage','Pelaksanaan Untuk Memeriksa Berkas(Inzage) ','Y','system','2012-08-05 01:23:08','system',NULL,'system','2012-08-05 01:23:08'),
('370','20','370','Pengiriman Berkas  Banding','Pengiriman Berkas  Banding','perkara_banding','pengiriman_berkas_banding','Pengiriman Berkas  Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('380','20','380','Penerimaan Kembali Berkas Banding','Penerimaan Kembali Berkas Banding','perkara_banding','penerimaan_kembali_berkas_banding','Penerimaan Kembali Berkas Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('390','20','390','Putusan Banding','Putusan Banding','perkara_banding','putusan_banding','Putusan Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('391','20','20','Pencabutan Perkara Banding','Pencabutan Perkara Banding',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('400','20','400','Pemberitahuan Putusan Banding','Pemberitahuan Putusan Banding','perkara_banding','pemberitahuan_putusan_banding','Pemberitahuan Putusan Banding','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('410','30','410','Permohonan Kasasi','Permohonan Kasasi','perkara_kasasi','permohonan_kasasi','Permohonan Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('420','30','420','Pemberitahuan Permohonan Kasasi','Pemberitahuan Permohonan Kasasi','perkara_kasasi','pemberitahuan_kasasi','Pemberitahuan Permohonan Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('430','30','430','Penerimaan Memori Kasasi','Penerimaan Memori Kasasi','perkara_kasasi','penerimaan_memori_kasasi','Penerimaan Memori Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('440','30','440','Penyerahan Memori Kasasi','Penyerahan Memori Kasasi','perkara_kasasi','penyerahan_memori_kasasi','Penyerahan Memori Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('450','30','450','Penerimaan Kontra Memori Kasasi','Penerimaan Kontra Memori Kasasi','perkara_kasasi','penerimaan_kontra_kasasi','Penerimaan Kontra Memori Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('460','30','460','Penyerahan Kontra Memori Kasasi','Penyerahan Kontra Memori Kasasi','perkara_kasasi','penyerahan_kontra_kasasi','Penyerahan Kontra Memori Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('461','30','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)','Permberitahuan Untuk Memeriksa Berkas(Inzage)','perkara_kasasi','pemberitahuan_inzage_kasasi','Permberitahuan Untuk Memeriksa Berkas(Inzage)','Y','system','2012-09-25 01:34:54','system',NULL,'system','2012-09-25 01:34:54'),
('464','30','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)','Pelaksanaan Untuk Memeriksa Berkas(Inzage)','perkara_kasasi','pelaksanaan_inzage_kasasi','Pelaksanaan Untuk Memeriksa Berkas(Inzage)','Y','system','2012-09-25 01:34:03','system',NULL,'system','2012-09-25 01:34:03'),
('470','30','470','Pengiriman Berkas Kasasi','Pengiriman Berkas Kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Pengiriman Berkas Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('480','30','480','Penerimaan Kembali Berkas Kasasi','Penerimaan Kembali Berkas Kasasi','perkara_kasasi','penerimaan_berkas_kasasi','Penerimaan Kembali Berkas Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('490','30','490','Putusan Kasasi','Putusan Kasasi','perkara_kasasi','putusan_kasasi','Putusan Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('491','30','491','Pencabutan Perkara Kasasi','Pencabutan Perkara Kasasi',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('492','30','492','Tidak Memenuhi Syarat Formil','Tidak Memenuhi Syarat Formil',NULL,NULL,NULL,'Y',NULL,NULL,NULL,NULL,NULL,NULL),
('500','30','500','Pemberitahuan Putus Kasasi','Pemberitahuan Putus Kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Pemberitahuan Putus Kasasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('510','40','510','Permohonan PK','Permohonan PK','perkara_pk','permohonan_pk','Permohonan PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('520','40','520','Pemberitahuan PK','Pemberitahuan PK','perkara_pk','pemberitahuan_pk','Pemberitahuan PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('521','40','521','Penerimaan Memori PK','Penerimaan Memori PK','perkara_pk','penerimaan_memori_pk','Penerimaan Memori PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('522','40','522','Penyerahan Memori PK','Penyerahan Memori PK','perkara_pk','penyerahan_memori_pk','Penyerahan Memori PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('523','40','523','Penerimaan Kontra Memori PK','Penerimaan Kontra Memori PK','perkara_pk','penerimaan_kontra_pk','Penerimaan Kontra Memori PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('524','40','524','Penyerahan Kontra Memori PK','Penyerahan Kontra Memori PK','perkara_pk','penyerahan_kontra_pk','Penyerahan Kontra Memori PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('530','40','530','Penerimaan Jawaban PK','Penerimaan Jawaban PK','perkara_pk','penerimaan_kontra_pk','Penerimaan Jawaban PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('540','40','540','Penyerahan Jawaban PK','Penyerahan Jawaban PK','perkara_pk','penyerahan_kontra_pk','Penyerahan Jawaban PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('550','40','550','Pengiriman Berkas PK','Pengiriman Berkas PK','perkara_pk','pengiriman_berkas_pk','Pengiriman Berkas PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('560','40','560','Penerimaan Kembali Berkas PK','Penerimaan Kembali Berkas PK','perkara_pk','penerimaan_berkas_pk','Penerimaan Kembali Berkas PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('570','40','570','Putusan PK','Putusan PK','perkara_pk','putusan_pk','Putusan PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('571','40','571','Pemberitahuan Putusan PK','Pemberitahuan Putusan PK','perkara_pk','pemberitahuan_putusan_pk','Pemberitahuan Putusan PK','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('580','40','580','Pemberitahuan Putusan PK Kepada Pemohon','Pemberitahuan Putusan PK Kepada Pemohon','perkara_pk','pemberitahuan_putusan_pk_pihak1','Pemberitahuan Putusan PK','N','system','2012-11-06 14:00:26',NULL,NULL,NULL,'2012-11-06 14:00:26'),
('590','40','590','Pemberitahuan Putusan PK Kepada Termohon','Pemberitahuan Putusan PK Kepada Termohon','perkara_pk','pemberitahuan_putusan_pk_pihak2','Pemberitahuan Putusan PK','N','system','2012-11-06 14:00:35',NULL,NULL,NULL,'2012-11-06 14:00:35'),
('600','50','600','Permohonan Eksekusi','Permohonan Eksekusi','perkara_eksekusi','permohonan_eksekusi','Permohonan Eksekusi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('605','50','605','Penetapan Teguran Eksekusi','Penetapan Teguran Eksekusi','perkara_eksekusi','penetapan_teguran_eksekusi','Penetapan Teguran Eksekusi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('610','50','610','Pelaksaan Penegoran(Aanmaning)','Pelaksaan Penegoran(Aanmaning)','perkara_eksekusi','pelaksanaan_teguran_eksekusi','Pelaksaan Penegoran(Aanmaning)','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('615','50','615','Penetapan Sita Eksekusi','Penetapan Sita Eksekusi','perkara_eksekusi','penetapan_sita_eksekusi','Penetapan Sita Eksekusi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('620','50','620','Pelaksanaan Sita Eksekusi','Pelaksanaan Sita Eksekusi','perkara_eksekusi','pelaksanaan_sita_eksekusi','Pelaksanaan Sita Eksekusi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('622','50','622','Penetapan Perintah Eksekusi Lelang','Penetapan Perintah Eksekusi Lelang','perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Penetapan Perintah Eksekusi Lelang','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('624','50','624','Pelaksanaan Eksekusi Lelang','Pelaksanaan Eksekusi Lelang','perkara_eksekusi','pelaksanaan_eksekusi_lelang','Pelaksanaan Eksekusi Lelang','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('626','50','626','Penyerahan Hasil Eksekusi Lelang','Penyerahan Hasil Eksekusi Lelang','perkara_eksekusi','penyerahan_hasil_lelang','Penyerahan Hasil Eksekusi Lelang','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('628','50','628','Penetapan Perintah Eksekusi Rill','Penetapan Perintah Eksekusi Rill','perkara_eksekusi','penetapan_perintah_eksekusi_rill','Penetapan Perintah Eksekusi Rill','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('630','50','630','Pelaksaan Eksekusi Rill','Pelaksaan Eksekusi Rill','perkara_eksekusi','pelaksanaan_eksekusi_rill','Pelaksaan Eksekusi Rill','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('640','50','640','Penetapan Sita Non Eksekutable','Penetapan Sita Non Eksekutable','perkara_eksekusi','penetapan_noneksekusi','Penetapan Sita Non Eksekutable','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('650','60','650','Permohonan Grasi PN','Permohonan Grasi PN','perkara_grasi','permohonan_grasi','Permohonan Grasi PN','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('660','60','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','Y','system','2012-06-01 15:47:05','system',NULL,'system','2012-06-01 15:47:05'),
('662','60','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA','Y','system','2012-06-01 15:47:00','system',NULL,'system','2012-06-01 15:47:00'),
('665','60','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden','perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('670','60','670','Penerimaan Kembali Berkas Grasi','Penerimaan Kembali Berkas Grasi','perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Penerimaan Kembali Berkas Grasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('680','60','680','Putusan Grasi','Putusan Grasi','perkara_grasi','tanggal_putusan_grasi','Putusan Grasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('690','60','690','Pemberitahuan Putusan Grasi','Pemberitahuan Putusan Grasi','perkara_grasi','pemberitahuan_putusan_grasi','Pemberitahuan Putusan Grasi','Y',NULL,NULL,NULL,NULL,NULL,NULL),
('700','60','700','Pemberitahuan Tembusan Putusan Grasi','Pemberitahuan Tembusan Putusan Grasi','perkara_grasi','pemberitahuan_tembusan_grasi','Pemberitahuan Tembusan Putusan Grasi','Y',NULL,NULL,NULL,NULL,NULL,NULL);");
		
		
		$this->db->query("REPLACE INTO `proses_alur_perkara` (`id`, `alur_perkara_id`, `tahapan_id`, `tahapan_nama`, `proses_id`, `proses_nama`, `batas_waktu`, `satuan`, `dari_proses_id`, `nama_tabel_dari`, `nama_kolom_dari`, `nama_tabel_ke`, `nama_kolom_ke`, `aktif`, `reminder`, `keterangan`, `diedit_oleh`, `diedit_tanggal`, `diinput_oleh`, `diinput_tanggal`, `diperbaharui_oleh`, `diperbaharui_tanggal`) values
('1','1','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0','sadasdsad',NULL,NULL,NULL,NULL,'system','2012-11-06 14:15:20'),
('2','1','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1','',NULL,NULL,NULL,NULL,'system','2012-11-06 14:17:14'),
('3','1','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4','1','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-06 14:17:25'),
('5','1','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('6','1','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('7','1','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('8','1','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 16:02:06'),
('9','1','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-31 16:02:25'),
('10','1','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0','',NULL,NULL,NULL,NULL,NULL,NULL),
('11','1','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0','',NULL,NULL,NULL,NULL,NULL,NULL),
('12','1','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('13','1','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1','',NULL,NULL,NULL,NULL,NULL,NULL),
('14','1','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4128','1','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('15','1','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4129','1','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('16','1','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('17','1','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1','','',NULL,'system','2012-10-31 10:15:04','system','2012-10-31 10:15:47'),
('18','1','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2014-07-02 09:46:11'),
('19','1','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('20','1','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('30','1','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('22','1','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('21','1','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 16:08:26'),
('23','1','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0','',NULL,NULL,NULL,NULL,NULL,NULL),
('24','1','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('25','1','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('26','1','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('27','1','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('28','1','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('29','1','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('35','1','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('36','1','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('39','1','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:09:54'),
('40','1','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:10:36'),
('41','1','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('42','1','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('43','1','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('44','1','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('45','1','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('46','1','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0','',NULL,NULL,NULL,NULL,'system','2012-09-30 09:07:07'),
('49','1','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1','',NULL,NULL,NULL,NULL,NULL,NULL),
('50','1','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('51','1','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:29:01'),
('1320','1','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('52','1','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:29:54'),
('55','1','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:22:51'),
('56','1','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('57','1','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('58','1','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:31:36'),
('59','1','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('60','1','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('61','1','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('64','1','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('65','1','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('66','1','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('67','1','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:32:15'),
('68','1','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:32:57'),
('71','1','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:34:25'),
('72','1','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('73','1','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('74','1','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('94','1','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('95','1','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('75','1','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('76','1','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('77','1','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('78','1','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('79','1','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('80','1','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1','',NULL,NULL,NULL,NULL,'system','2012-11-05 08:21:02'),
('83','1','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('84','1','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('85','1','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('86','1','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('87','1','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('88','1','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('89','1','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('90','1','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('91','1','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('92','1','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('93','1','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('102','2','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('103','2','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('104','2','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('105','2','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('106','2','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('107','2','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('108','2','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('109','2','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('110','2','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('111','2','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1','','',NULL,'system','2012-10-31 10:16:09','system','2012-10-31 10:16:25'),
('119','2','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2014-10-16 14:56:40'),
('120','2','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('121','2','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('124','2','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('123','2','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('122','2','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('156','2','30','Kasasi','410','Permohonan Kasasi','14','2','230','perkara_putusan','pemberitahuan_putusan','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:22:57'),
('157','2','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('158','2','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('159','2','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('160','2','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('161','2','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('162','2','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-09-30 09:11:53'),
('163','2','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-09-30 09:12:53'),
('166','2','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('167','2','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('168','2','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('169','2','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('172','2','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:32:34'),
('173','2','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('174','2','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('175','2','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('182','2','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('183','2','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('176','2','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('177','2','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('178','2','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('179','2','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('180','2','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('181','2','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('203','3','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('204','3','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('205','3','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('206','3','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('207','3','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('208','3','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('209','3','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('210','3','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('211','3','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('212','3','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1','','',NULL,'system','2012-10-31 10:22:00','',NULL),
('220','3','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:02:51'),
('221','3','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('222','3','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('225','3','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('224','3','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('223','3','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('257','3','30','Kasasi','410','Permohonan Kasasi','14','2','230','perkara_putusan','pemberitahuan_putusan','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:02'),
('258','3','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('259','3','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('260','3','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('261','3','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('262','3','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('263','3','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('266','3','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('267','3','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('268','3','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('269','3','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('270','3','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('273','3','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:32:18'),
('274','3','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('275','3','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('276','3','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('283','3','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('284','3','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('277','3','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('278','3','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('279','3','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('280','3','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('281','3','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('282','3','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('285','3','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('286','3','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('287','3','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('288','3','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('289','3','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('290','3','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('291','3','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('292','3','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('293','3','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('294','3','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('295','3','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('304','4','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('305','4','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('306','4','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('307','4','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('308','4','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('309','4','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('310','4','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('311','4','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('312','4','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('313','4','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1','','',NULL,'system','2012-10-31 10:22:10','',NULL),
('321','4','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:02:59'),
('322','4','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('323','4','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('326','4','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('325','4','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('324','4','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('358','4','30','Kasasi','410','Permohonan Kasasi','14','2','230','perkara_putusan','pemberitahuan_putusan','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:08'),
('359','4','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('360','4','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('361','4','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('362','4','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('363','4','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('364','4','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('367','4','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('368','4','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('369','4','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('370','4','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('371','4','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('374','4','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:32:02'),
('375','4','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('376','4','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('377','4','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('384','4','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('385','4','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('378','4','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('379','4','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('380','4','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('381','4','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('382','4','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('383','4','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('386','4','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('387','4','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('388','4','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('389','4','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('390','4','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('391','4','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('392','4','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('393','4','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('394','4','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('395','4','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('396','4','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('405','5','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('406','5','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('407','5','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('408','5','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('409','5','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('410','5','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('411','5','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('412','5','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('413','5','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('414','5','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1','','',NULL,'system','2012-10-31 10:22:23','',NULL),
('422','5','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:07'),
('423','5','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('424','5','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('427','5','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('426','5','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('425','5','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('459','5','30','Kasasi','410','Permohonan Kasasi','14','2','230','perkara_putusan','pemberitahuan_putusan','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:14'),
('460','5','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('461','5','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('462','5','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('463','5','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('464','5','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('465','5','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('468','5','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('469','5','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('470','5','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('471','5','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('472','5','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('475','5','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:31:48'),
('476','5','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('477','5','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('478','5','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('473','5','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('474','5','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('479','5','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('480','5','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('481','5','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('482','5','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('483','5','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('484','5','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('487','5','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('488','5','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('489','5','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('490','5','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('491','5','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('492','5','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('493','5','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('494','5','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('495','5','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('496','5','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('497','5','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('506','6','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('507','6','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('508','6','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('509','6','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('510','6','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('511','6','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('512','6','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('513','6','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('514','6','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('515','6','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','0','','',NULL,'system','2012-10-31 10:26:56','',NULL),
('523','6','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:14'),
('524','6','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('525','6','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('528','6','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('527','6','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('526','6','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('560','6','30','Kasasi','410','Permohonan Kasasi','14','2','230','perkara_putusan','pemberitahuan_putusan','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:20'),
('561','6','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('562','6','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('563','6','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('564','6','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('565','6','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('566','6','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('569','6','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('570','6','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('571','6','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('572','6','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('573','6','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('576','6','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-22 22:05:02'),
('577','6','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('578','6','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('579','6','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('586','6','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('587','6','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('580','6','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('581','6','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('582','6','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('583','6','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('584','6','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('585','6','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('588','6','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('589','6','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('590','6','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('591','6','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('592','6','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('593','6','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('594','6','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('595','6','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('596','6','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('597','6','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('598','6','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1381','7','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1382','7','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1383','7','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1384','7','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1385','7','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1386','7','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1387','7','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1388','7','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1389','7','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1390','7','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1391','7','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1392','7','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1393','7','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1394','7','13','Mediasi','140','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1395','7','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4130','7','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1397','7','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4131','7','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1399','7','13','Mediasi','191','Tidak Mediasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1400','7','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1401','7','15','Putusan','210','Putusan','6','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1402','7','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1403','7','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1458','7','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1404','7','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1405','7','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1406','7','15','Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1407','7','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1408','7','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1409','7','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1410','7','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1411','7','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1412','7','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1413','7','20','Banding','300','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4239','7','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1414','7','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1415','7','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1416','7','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1417','7','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1418','7','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1419','7','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1420','7','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1421','7','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1422','7','20','Banding','390','Putusan Banding','6','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1423','7','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1424','7','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1425','7','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1426','7','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1427','7','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1428','7','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1429','7','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1430','7','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1431','7','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1432','7','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1433','7','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1434','7','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1435','7','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1436','7','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1437','7','40','Peninjauan Kembali','510','Permohonan PK',NULL,NULL,NULL,NULL,'pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1438','7','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1439','7','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1440','7','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1510','7','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1511','7','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1441','7','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1442','7','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1443','7','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1444','7','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1445','7','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1446','7','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1447','7','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1448','7','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1449','7','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1450','7','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1451','7','50','Eksekusi','620','Pelaksanaan Sita Eksekusi','80','1','0',NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1452','7','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1453','7','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1454','7','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1455','7','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1456','7','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1457','7','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4240','8','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,'0',NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1459','8','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','8','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1460','8','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1461','8','12','Penetapan','30','Penunjukan Panitera Pengganti','3','8','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1462','8','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1463','8','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1464','8','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1465','8','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','8','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1466','8','12','Penetapan','81','Sidang pertama','5','8','10',NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1467','8','13','Mediasi','110','Penetapan Mediator','8','8','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1468','8','13','Mediasi','120','Penetapan Tanggal Mediasi','2','8','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1469','8','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1470','8','13','Mediasi','130','Kesepakatan Mediasi','61','8','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1471','8','13','Mediasi','140','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1472','8','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4132','8','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1474','8','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4133','8','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1476','8','13','Mediasi','191','Tidak Mediasi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1477','8','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1478','8','15','Putusan','210','Putusan','6','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1479','8','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1480','8','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1481','8','15','Putusan','214','Dismissal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1494','8','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1482','8','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1483','8','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1484','8','15','Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1485','8','17','Keberatan','281','Pendaftaran Keberatan','14','8','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1486','8','17','Keberatan','282','Penetapan Majelis Hakim Keberatan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1487','8','17','Keberatan','283','Penetapan Panitera Pengganti Keberatan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1488','8','17','Keberatan','284','Penetapan Jurusita Keberatan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1489','8','17','Keberatan','285','Penetapan Jadwal Sidang  Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1490','8','17','Keberatan','286','Sidang Pertama Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1491','8','17','Keberatan','287','Persidangan Keberatan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1492','8','17','Keberatan','288','Putusan Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1493','8','17','Keberatan','289','Pemberitahuan Putusan Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1512','8','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1513','8','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1623','9','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1632','9','12','Penetapan','15','Panggilan Para Pihak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1633','9','12','Penetapan','16','Penetapan Dismissal Diterima',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1624','9','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1625','9','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1626','9','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1627','9','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1628','9','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1629','9','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4134','9','12','Penetapan','42','Pemeriksaan Persiapan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1630','9','12','Penetapan','80','Penetapan Hari Sidang Pertama','30','1','20','perkara_persiapan','tanggal_penetapan_persiapan','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1631','9','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1648','9','13','Perlawanan','110','Pendaftaran Perlawanan',NULL,'',NULL,'','','','','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1649','9','13','Perlawanan','111','Penetapan Majelis Hakim Perlawanan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1650','9','13','Perlawanan','112','Penetapan Panitera Pengganti Perlawanan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1651','9','13','Perlawanan','113','Penetapan Jurusita Perlawanan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1652','9','13','Perlawanan','114','Penetapan Jadwal Sidang Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1653','9','13','Perlawanan','115','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1654','9','13','Perlawanan','116','Persidangan Perlawanan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1642','9','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1634','9','15','Putusan','17','Putusan Perlawanan Diterima',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1643','9','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1644','9','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1645','9','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1635','9','15','Putusan','214','Dismissal Ditolak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4270','9','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1655','9','15','Putusan','217','Putusan Perlawanan Ditolak',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1646','9','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1647','9','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1657','9','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1658','9','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4271','9','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1659','9','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1660','9','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1661','9','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1662','9','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1663','9','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1664','9','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1665','9','20','Banding','370','Pengiriman Berkas  Banding','60','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1667','9','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1668','9','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1669','9','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1670','9','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1671','9','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1672','9','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1673','9','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1674','9','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1675','9','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1676','9','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1677','9','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1678','9','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1679','9','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1680','9','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1681','9','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1682','9','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1683','9','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1684','9','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1685','9','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1686','9','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1696','9','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1697','9','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1687','9','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1688','9','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4272','9','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1689','9','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1690','9','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1691','9','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1692','9','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1693','9','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1694','9','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1695','9','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4273','9','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1703','10','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1704','10','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1705','10','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1706','10','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1707','10','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1708','10','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1709','10','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1710','10','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4274','10','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4275','10','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1711','10','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1712','10','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1713','10','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1714','10','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1715','10','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1716','10','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1717','10','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1718','10','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1719','10','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1720','10','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1721','10','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1722','10','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4277','10','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1723','10','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1724','10','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1725','10','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1726','10','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1727','10','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1728','10','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1729','10','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1730','10','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1731','10','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1732','10','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1733','10','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1734','10','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1735','10','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4276','10','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1736','10','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1737','10','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1738','10','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1739','10','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1740','10','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1741','10','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1742','10','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1743','10','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1744','10','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1745','10','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1746','10','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1747','10','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1748','10','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1749','10','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1750','10','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1751','10','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1752','10','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1753','10','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1754','10','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1755','10','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1756','10','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1757','10','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1758','10','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1759','10','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1760','10','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1761','10','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1762','10','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1763','10','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1764','10','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1765','10','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1766','10','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1767','10','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1768','10','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1769','10','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1770','10','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1771','10','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1772','10','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1773','10','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1774','10','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1775','10','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1776','10','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1777','10','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1778','10','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1779','10','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1780','11','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1781','11','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1782','11','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1783','11','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1784','11','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1785','11','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1786','11','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1787','11','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1788','11','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1789','11','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1790','11','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1791','11','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1792','11','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1793','11','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1794','11','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1795','11','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1796','11','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1797','11','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1798','11','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1799','11','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1800','11','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1801','11','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1861','11','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1802','11','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1803','11','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1804','11','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1805','11','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1806','11','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1807','11','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1809','11','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1810','11','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1811','11','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1812','11','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1813','11','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1814','11','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1815','11','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4278','11','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1816','11','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1817','11','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1818','11','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1819','11','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1820','11','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1821','11','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1822','11','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1823','11','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1824','11','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1825','11','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1826','11','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1827','11','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1829','11','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1830','11','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1831','11','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1832','11','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1833','11','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1834','11','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1835','11','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1836','11','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1837','11','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1838','11','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1839','11','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1840','11','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1841','11','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1842','11','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1843','11','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1844','11','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1845','11','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1846','11','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1847','11','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1848','11','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1849','11','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1850','11','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1851','11','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1852','11','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1853','11','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1854','11','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1855','11','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1856','11','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1857','11','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1858','11','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1859','11','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1860','11','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4279','12','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1862','12','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1863','12','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1864','12','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1865','12','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1866','12','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1867','12','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1868','12','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1869','12','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1870','12','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1871','12','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1872','12','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1873','12','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1874','12','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1875','12','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1876','12','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1877','12','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1878','12','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1879','12','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1880','12','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1881','12','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1882','12','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1883','12','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1884','12','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1885','12','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1886','12','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1887','12','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1888','12','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1889','12','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1890','12','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1891','12','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1892','12','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1893','12','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1894','12','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1895','12','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4280','12','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1896','12','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1897','12','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1898','12','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1899','12','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1900','12','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1901','12','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1902','12','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1903','12','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1904','12','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1905','12','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1906','12','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1907','12','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1908','12','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1909','12','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1910','12','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1911','12','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1912','12','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1913','12','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1914','12','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1915','12','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1916','12','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1917','12','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1918','12','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1919','12','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1920','12','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1921','12','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1922','12','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1923','12','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1924','12','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1925','12','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1926','12','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1927','12','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1928','12','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1929','12','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1930','12','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1931','12','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1932','12','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1933','12','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1934','12','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1935','12','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1936','12','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1937','12','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1938','12','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1939','12','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1940','13','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1941','13','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1942','13','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1943','13','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1944','13','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1945','13','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1946','13','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1947','13','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1948','13','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1949','13','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1950','13','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1951','13','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1952','13','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1953','13','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1954','13','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1955','13','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1956','13','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1957','13','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1958','13','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1959','13','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1960','13','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1961','13','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1962','13','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1963','13','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1964','13','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1965','13','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1966','13','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1967','13','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1968','13','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1969','13','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1970','13','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1971','13','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1972','13','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1973','13','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1974','13','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4281','13','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1975','13','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1976','13','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1977','13','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1978','13','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1979','13','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1980','13','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1981','13','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1982','13','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1983','13','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1984','13','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1985','13','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1986','13','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1987','13','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1988','13','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1989','13','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1990','13','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1991','13','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1992','13','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1993','13','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1994','13','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1995','13','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1996','13','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1997','13','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1998','13','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1999','13','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2000','13','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2001','13','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2002','13','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2003','13','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2004','13','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2005','13','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2006','13','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2007','13','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2008','13','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2009','13','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2010','13','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2011','13','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2012','13','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2013','13','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2014','13','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2015','13','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2016','13','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2017','13','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2018','13','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2019','14','10','Pendaftaran','10','Pendaftaran Perkara',NULL,'',NULL,'','tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2020','14','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2021','14','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2022','14','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2023','14','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2024','14','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2025','14','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2026','14','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2027','14','12','Penetapan','81','Sidang pertama',NULL,'',NULL,'','penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2028','14','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2029','14','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2030','14','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2031','14','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2032','14','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2033','14','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2034','14','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2035','14','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2036','14','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2037','14','14','Persidangan','200','Persidangan',NULL,'',NULL,'','','','','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2038','14','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2039','14','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2040','14','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2041','14','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2042','14','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2043','14','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2044','14','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2045','14','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2046','14','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2047','14','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2048','14','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2049','14','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2050','14','16','Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2051','14','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2052','14','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2053','14','20','Banding','300','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4282','14','20','Banding','301','Pemberitahuan Permohonan Banding','7','2','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2054','14','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2055','14','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2056','14','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2057','14','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2058','14','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2059','14','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,'',NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2060','14','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2061','14','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2062','14','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2063','14','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2064','14','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2065','14','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2066','14','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2067','14','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2068','14','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2069','14','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2070','14','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2071','14','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2072','14','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2073','14','30','Kasasi','470','Pengiriman Berkas Kasasi','65','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','pengiriman_berkas_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2074','14','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2075','14','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2076','14','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2077','14','40','Peninjauan Kembali','510','Permohonan PK',NULL,'',NULL,'','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2078','14','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2079','14','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2080','14','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2081','14','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2082','14','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2083','14','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2084','14','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2085','14','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2086','14','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2087','14','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2088','14','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2089','14','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2090','14','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2091','14','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2092','14','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2093','14','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2094','14','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2095','14','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2096','14','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2097','14','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4000','15','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4001','15','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4002','15','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4003','15','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4004','15','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4005','15','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4006','15','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4007','15','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4008','15','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4009','15','13','Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4010','15','13','Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4011','15','13','Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4012','15','13','Mediasi','130','Kesepakatan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4013','15','13','Mediasi','150','Mediasi Tidak Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4014','15','13','Mediasi','151','Mediasi Tidak Dapat Dilaksanakan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4015','15','13','Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4016','15','13','Mediasi','181','Mediasi Berhasil Sebagian',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4017','15','13','Mediasi','190','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4018','15','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4019','15','15','Putusan','210','Putusan','5','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4020','15','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4021','15','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4022','15','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4023','15','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4024','15','16','Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4025','15','16','Verzet','241','Penetapan Majelis Hakim Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4026','15','16','Verzet','242','Penetapan Panitera Pengganti Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4027','15','16','Verzet','243','Penetapan Jurusita Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4028','15','16','Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4029','15','16','Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4030','15','16','Verzet','261','Persidangan Verzet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4031','15','16','Verzet','270','Putusan Perlawanan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4032','15','16','Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4033','15','18','Ikrar Talak','290','Penetapan Majelis Hakim Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4034','15','18','Ikrar Talak','291','Penunjukan Panitera Pengganti Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4035','15','18','Ikrar Talak','292','Penetapan Jurusita Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4036','15','18','Ikrar Talak','293','Penetapan Hari Sidang Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4037','15','18','Ikrar Talak','294','Panggilan Sidang Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4038','15','18','Ikrar Talak','295','Penetapan Ikrar Talak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4039','15','19','Akta Cerai','296','Pembuatan Akta Cerai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4040','15','19','Akta Cerai','297','Penyerahan Akta Cerai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4041','15','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4042','15','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4043','15','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4044','15','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4045','15','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4046','15','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4047','15','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4048','15','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4049','15','20','Banding','370','Pengiriman Berkas Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4050','15','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4051','15','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4052','15','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4053','15','20','Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4054','15','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4055','15','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4056','15','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4057','15','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4058','15','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4059','15','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4060','15','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4061','15','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4062','15','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4063','15','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4064','15','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4065','15','30','Kasasi','491','Pencabutan Perkara Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4066','15','30','Kasasi','492','Tidak Memenuhi Syarat Formil',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','tidak_memenuhi_syarat','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4067','15','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4068','15','40','Peninjauan Kembali','510','Permohonan PK',NULL,NULL,NULL,NULL,'pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4069','15','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4070','15','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4071','15','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4072','15','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4073','15','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4074','15','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4075','15','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4076','15','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4077','15','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4078','15','50','Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4079','15','50','Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4080','15','50','Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4081','15','50','Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4082','15','50','Eksekusi','620','Pelaksanaan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4083','15','50','Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4084','15','50','Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4085','15','50','Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4086','15','50','Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4087','15','50','Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4088','15','50','Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4089','16','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4090','16','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4091','16','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4092','16','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4093','16','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4094','16','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4095','16','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4096','16','12','Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4097','16','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4098','16','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4099','16','15','Putusan','210','Putusan','5','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4100','16','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4101','16','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4102','16','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4103','16','15','Putusan','220','Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4104','16','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4105','16','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4106','16','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4107','16','30','Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4108','16','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4109','16','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4110','16','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4111','16','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4112','16','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4113','16','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4114','16','30','Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4115','16','30','Kasasi','491','Pencabutan Perkara Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4116','16','30','Kasasi','492','Tidak Memenuhi Syarat Formil',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','tidak_memenuhi_syarat','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4117','16','30','Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4118','16','40','Peninjauan Kembali','510','Permohonan PK',NULL,NULL,NULL,NULL,'pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4119','16','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4120','16','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4121','16','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4122','16','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4123','16','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4124','16','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4125','16','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4126','16','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4127','16','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('607','111','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('608','111','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('609','111','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('610','111','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('611','111','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('612','111','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('613','111','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('614','111','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('615','111','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('623','111','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:09:53'),
('4141','111','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4152','111','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('624','111','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2014-10-16 14:57:39'),
('625','111','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('628','111','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('637','111','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('627','111','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('645','111','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('646','111','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('647','111','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('648','111','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('649','111','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('650','111','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('651','111','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('652','111','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('655','111','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('656','111','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('657','111','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1321','111','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('658','111','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('661','111','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:26'),
('662','111','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('663','111','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('664','111','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('665','111','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('666','111','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('667','111','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('670','111','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('671','111','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('672','111','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('673','111','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('674','111','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('677','111','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:31:03'),
('678','111','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('679','111','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('680','111','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('687','111','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('688','111','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('681','111','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('682','111','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('683','111','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('684','111','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('685','111','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('686','111','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('700','111','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('701','111','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1','',NULL,NULL,NULL,NULL,'system','2012-10-17 18:11:29'),
('702','111','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('703','111','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('704','111','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('705','111','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('706','111','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('707','111','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('708','112','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('709','112','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('710','112','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('711','112','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('712','112','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('713','112','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('714','112','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('715','112','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('716','112','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('724','112','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:10:18'),
('4142','112','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4153','112','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('725','112','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:20'),
('726','112','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('729','112','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('738','112','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('728','112','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('746','112','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('747','112','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('748','112','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('749','112','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('750','112','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('751','112','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('752','112','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('753','112','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('756','112','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('757','112','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('758','112','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1322','112','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('759','112','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('762','112','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:32'),
('763','112','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('764','112','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('765','112','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('766','112','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('767','112','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('768','112','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('771','112','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('772','112','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('773','112','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('774','112','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('775','112','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('778','112','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:31:27'),
('779','112','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('780','112','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('781','112','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('788','112','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('789','112','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('782','112','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('783','112','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('784','112','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('785','112','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('786','112','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('787','112','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('801','112','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('802','112','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('803','112','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('804','112','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('805','112','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('806','112','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('807','112','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('808','112','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('809','113','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('810','113','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('811','113','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('812','113','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('813','113','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('814','113','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('815','113','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('816','113','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('817','113','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('825','113','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:10:05'),
('4143','113','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4154','113','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('826','113','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:29'),
('827','113','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('830','113','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('839','113','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('829','113','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('847','113','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('848','113','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('849','113','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('850','113','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('851','113','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('852','113','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('853','113','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('854','113','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('857','113','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('858','113','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('859','113','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1323','113','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('860','113','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('863','113','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:45'),
('864','113','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('865','113','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('866','113','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('867','113','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('868','113','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('869','113','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('872','113','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('873','113','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('874','113','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('875','113','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('876','113','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('879','113','40','Peninjauan Kembali','510','Permohonan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('880','113','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('881','113','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('882','113','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('889','113','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('890','113','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('883','113','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('884','113','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('885','113','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('886','113','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('887','113','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('888','113','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('902','113','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('903','113','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('904','113','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('905','113','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('906','113','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('907','113','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('908','113','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('909','113','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('910','114','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('911','114','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('912','114','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('913','114','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('914','114','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('915','114','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('916','114','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('917','114','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('918','114','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('926','114','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:10:24'),
('4144','114','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4155','114','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('927','114','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:35'),
('928','114','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('931','114','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('940','114','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('930','114','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1324','114','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1011','115','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1012','115','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1013','115','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1014','115','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1015','115','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1016','115','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1017','115','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1018','115','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1019','115','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1027','115','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:09:21'),
('4145','115','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4156','115','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1028','115','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:46'),
('1029','115','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1032','115','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1041','115','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1031','115','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1049','115','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1050','115','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1051','115','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1052','115','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1053','115','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1054','115','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1055','115','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1056','115','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1059','115','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1060','115','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1061','115','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1325','115','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1062','115','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1065','115','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:53'),
('1066','115','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1067','115','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1068','115','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1069','115','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1070','115','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1071','115','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1074','115','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1075','115','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1076','115','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1077','115','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1078','115','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1081','115','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:29:11'),
('1082','115','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1083','115','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1084','115','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1091','115','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1092','115','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1085','115','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1086','115','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1087','115','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1088','115','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1089','115','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1090','115','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1104','115','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1105','115','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1106','115','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1107','115','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1108','115','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1109','115','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1110','115','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1111','115','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1112','116','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1113','116','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1114','116','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1115','116','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1116','116','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1117','116','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1118','116','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1119','116','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1120','116','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1128','116','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:10:30'),
('4146','116','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4157','116','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1129','116','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:03:54'),
('130','116','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1133','116','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1142','116','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1132','116','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1150','116','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1151','116','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1152','116','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1153','116','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1154','116','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1155','116','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1156','116','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1157','116','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1160','116','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1161','116','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1162','116','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1326','116','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1163','116','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1166','116','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:59'),
('1167','116','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1168','116','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1169','116','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1170','116','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1171','116','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1172','116','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1175','116','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1176','116','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1177','116','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1178','116','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1179','116','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1182','116','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:30:22'),
('1183','116','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1184','116','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1185','116','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1192','116','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1193','116','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1186','116','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1187','116','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1188','116','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1189','116','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1190','116','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1191','116','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1205','116','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1206','116','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1207','116','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1208','116','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1209','116','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1210','116','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1211','116','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1212','116','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1213','117','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1214','117','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1215','117','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1216','117','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1217','117','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1218','117','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1219','117','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1220','117','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1221','117','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1229','117','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:10:35'),
('4147','117','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4158','117','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1230','117','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-11-07 13:04:01'),
('1231','117','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1234','117','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1243','117','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1233','117','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1251','117','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1252','117','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1253','117','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1254','117','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1255','117','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1256','117','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1257','117','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1258','117','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1261','117','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1262','117','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1263','117','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1327','117','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1264','117','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1267','117','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:24:04'),
('1268','117','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1269','117','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1270','117','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1271','117','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1272','117','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1273','117','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1276','117','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1277','117','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1278','117','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1279','117','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1280','117','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1283','117','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:32:51'),
('1284','117','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1285','117','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1286','117','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1293','117','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1294','117','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1287','117','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1288','117','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1289','117','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1290','117','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1291','117','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1292','117','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1306','117','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1307','117','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1308','117','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1309','117','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1310','117','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1311','117','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1312','117','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1313','117','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1319','118','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4222','118','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4223','118','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4224','118','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4225','118','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4226','118','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4227','118','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4283','118','12','Diversi','65','Penetapan Musyawarah Diversi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4135','118','12','Diversi','66','Kesepakatan Pelaksanaan Diversi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4284','118','12','Diversi','68','Musyawarah Diversi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1328','118','12','Diversi','70','Hasil Musyawarah Diversi','30','1','65','perkara_diversi','tgl_penetapan_musyawarah','perkara_diversi','tgl_kesepakatan_diversi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4138','118','12','Diversi','71','Penetapan Kesepakatan Diversi','3','1','69','perkara_diversi','tgl_kesepakatan_diversi','perkara_diversi','tgl_penetapan_kesepakatan_diversi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1337','118','12','Diversi','72','Pelaksanaan Kesepakatan Diversi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1342','118','12','Diversi','74','Hasil Pelaksanaan Kesepakatan Diversi','3','3','72','perkara_diversi','tgl_pelaksanaan_isi_diversi','perkara_diversi','tgl_lap_pembimbing_masyarakat','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1338','118','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1339','118','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1340','118','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0','',NULL,NULL,NULL,NULL,'system','2012-10-22 12:09:53'),
('4148','118','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4159','118','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1341','118','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1','',NULL,NULL,NULL,NULL,'admin','2012-10-31 17:39:07'),
('4140','118','15','Putusan','213','Penghentian Pemeriksaan Perkara','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4238','118','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1344','118','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1345','118','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1343','118','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1346','118','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1347','118','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1348','118','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1349','118','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1350','118','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1351','118','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1352','118','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1353','118','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1354','118','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1355','118','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1356','118','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4237','118','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1357','118','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1358','118','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0','',NULL,NULL,NULL,NULL,'system','2012-11-07 13:23:26'),
('1359','118','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1360','118','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1361','118','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1362','118','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1363','118','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1364','118','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1365','118','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1366','118','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1367','118','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1368','118','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1369','118','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1370','118','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0','',NULL,NULL,NULL,NULL,'admin','2012-10-23 01:31:03'),
('1371','118','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1372','118','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1373','118','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1380','118','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4229','118','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1374','118','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1375','118','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1376','118','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1377','118','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1378','118','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1379','118','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4228','118','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4230','118','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1','',NULL,NULL,NULL,NULL,'system','2012-10-17 18:11:29'),
('4231','118','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4232','118','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4233','118','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4234','118','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4235','118','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4236','118','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4241','119','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1495','119','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1496','119','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1497','119','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1498','119','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1499','119','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1500','119','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1501','119','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1502','119','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1503','119','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1504','119','15','Putusan','210','Putusan','6','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,'admin','2012-11-07 13:02:43'),
('1505','119','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1506','119','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1507','119','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1508','119','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1509','119','15','Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2098','120','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4258','120','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4259','120','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4260','120','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4261','120','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1514','120','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1515','120','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1516','120','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1517','120','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1518','120','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4149','120','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4160','120','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1519','120','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4262','120','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1520','120','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1521','120','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1522','120','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1523','120','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1524','120','20','Banding','300','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4263','120','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1525','120','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1526','120','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1527','120','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1528','120','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1529','120','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)','0','',NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1530','120','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1531','120','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1532','120','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1533','120','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1534','120','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1535','120','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1536','120','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1537','120','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1538','120','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1539','120','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1540','120','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1541','120','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1542','120','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1543','120','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1544','120','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1545','120','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1546','120','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1547','120','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1548','120','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1549','120','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1550','120','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1551','120','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4266','120','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4267','120','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1552','120','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1553','120','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1554','120','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1555','120','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1556','120','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1557','120','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1558','120','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1559','120','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1560','120','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1561','120','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1562','120','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1563','120','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1564','120','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1565','120','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1566','121','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1567','121','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1568','121','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1569','121','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1570','121','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1571','121','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1572','121','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1573','121','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1574','121','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1575','121','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4150','121','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4161','121','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1576','121','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4264','121','15','Putusan','215','Penetapan/Putusan Tidak Berwenang',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1577','121','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1578','121','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1579','121','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1580','121','20','Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1581','121','20','Banding','300','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4265','121','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1582','121','20','Banding','310','Penerimaan Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1583','121','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1584','121','20','Banding','330','Penerimaan Kontra Memori Banding','0','',NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1585','121','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1586','121','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)','0','',NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1587','121','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1588','121','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1589','121','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1590','121','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1591','121','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1592','121','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1593','121','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1594','121','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1595','121','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1596','121','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1597','121','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1598','121','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1599','121','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1600','121','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1601','121','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1602','121','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1603','121','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1604','121','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1605','121','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1606','121','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1607','121','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1608','121','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4268','121','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4269','121','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1609','121','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1610','121','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1611','121','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1612','121','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1613','121','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1614','121','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1615','121','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1616','121','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1617','121','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1618','121','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1619','121','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1620','121','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1621','121','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('1622','121','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4162','122','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4163','122','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4164','122','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4165','122','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4166','122','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4167','122','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4168','122','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4169','122','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4170','122','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4171','122','14','Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4151','122','14','Persidangan','203','Putusan Sela',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4221','122','14','Persidangan','206','Tuntutan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4172','122','15','Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4174','122','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4175','122','15','Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4173','122','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4176','122','20','Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4177','122','20','Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4178','122','20','Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4179','122','20','Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4180','122','20','Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4181','122','20','Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4182','122','20','Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4183','122','20','Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4184','122','20','Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4185','122','20','Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4186','122','20','Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4220','122','20','Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4187','122','20','Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4188','122','30','Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4189','122','30','Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4190','122','30','Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4191','122','30','Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4192','122','30','Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4193','122','30','Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4194','122','30','Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4195','122','30','Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4196','122','30','Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4197','122','30','Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4198','122','30','Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4199','122','30','Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4200','122','40','Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4201','122','40','Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4202','122','40','Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4203','122','40','Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4210','122','40','Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4211','122','40','Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4204','122','40','Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4205','122','40','Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4206','122','40','Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4207','122','40','Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4208','122','40','Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4209','122','40','Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4212','122','60','Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4213','122','60','Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4214','122','60','Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4215','122','60','Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4216','122','60','Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4217','122','60','Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4218','122','60','Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4219','122','60','Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4242','123','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4243','123','12','Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4244','123','12','Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4245','123','12','Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4246','123','12','Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4247','123','12','Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4248','123','12','Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4249','123','12','Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4250','123','12','Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4251','123','14','Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4252','123','15','Putusan','210','Putusan','6','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4253','123','15','Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4254','123','15','Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4255','123','15','Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4256','123','15','Putusan','220','Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4257','123','15','Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);");
		
		
		$cekkolum = $this->isColumnExist('perkara_pihak5','jenis_saksi');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `perkara_pihak5`   
  						CHANGE `jenis_saksi` `jenis_saksi` CHAR(1) DEFAULT '1'   NULL  COMMENT '1. Saksi Dewasa, 2. Ahli, 3. Saksi Anak';");
 		}

 		$cekkolum = $this->isColumnExist('proses_alur_perkara','nama_tabel_dari');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `proses_alur_perkara`   
						  CHANGE `nama_tabel_dari` `nama_tabel_dari` VARCHAR(64) NULL  COMMENT 'Nama Tabel Dari: merujuk ke tabel proses kolom nama_tabel dengan id=dari_proses_id (by system)',
						  CHANGE `nama_tabel_ke` `nama_tabel_ke` VARCHAR(64) NULL  COMMENT 'Nama Tabel Ke: merujuk ke tabel proses kolom nama_tabel dengan id=proses_id (by system)';");
 		}

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_register` (
						  `id` bigint(20) NOT NULL DEFAULT '0' COMMENT 'id perkara_diversi',
						  `no_urut` varchar(20) DEFAULT NULL,
						  `no_diversi` varchar(50) DEFAULT NULL,
						  `tgl_permohonan_diversi` date DEFAULT NULL,
						  `pemohon_diversi` tinyint(4) DEFAULT NULL COMMENT '1: penyidik, 2;penuntut, 3:hakim',
						  `no_reg_penyidik` varchar(50) DEFAULT NULL,
						  `no_reg_penuntut_umum` varchar(50) DEFAULT NULL,
						  `no_perkara` varchar(50) DEFAULT NULL,
						  `perkara_id` bigint(20) DEFAULT NULL,
						  `pihak_penasihat_hukum` varchar(500) DEFAULT NULL COMMENT 'merujuk ke tabel id_pihak_pengacara',
						  `pihak_pk_bapas` varchar(500) DEFAULT NULL COMMENT 'pihak_id',
						  `pihak_penyidik` varchar(255) DEFAULT NULL COMMENT 'merujuk ke tabel id_pihak_penyidik',
						  `pihak_penuntut` varchar(255) DEFAULT NULL COMMENT 'merujuk ke tabel id_pihak_jaksa',
						  `no_berita_acara` varchar(50) DEFAULT NULL,
						  `tgl_berita_acara` date DEFAULT NULL,
						  `pasal_sangkaan_dakwaan` text,
						  `tgl_kesepakatan_diversi` date DEFAULT NULL,
						  `isi_kesepakatan_diversi` text,
						  `tanggal_penetapan_kpn` date DEFAULT NULL,
						  `tgl_pengiriman_penetapan_kpn` date DEFAULT NULL,
						  `amar` text,
						  `tgl_pelaksanaan_isi_diversi` date DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_anak_orang_tua` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pihak_anak` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `pihak_orang_tua` varchar(10) DEFAULT NULL COMMENT 'merujuk ke id_pihak',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL,
						  PRIMARY KEY (`id`,`diversi_register_id`,`pihak_anak`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_korban_orang_tua` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pihak_anak` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `pihak_orang_tua` varchar(10) DEFAULT NULL COMMENT 'merujuk ke id_pihak',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_pembimbing_kemasyarakatan` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pihak_id` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_penasihat_hukum` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pengacara_id` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `anak_id` bigint(20) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `aktif` char(1) DEFAULT NULL,
						  `aktif_mulai` date DEFAULT NULL,
						  `aktif_sampai` date DEFAULT NULL,
						  `no_surat_kuasa` varchar(50) DEFAULT NULL,
						  `tgl_surat_kuasa` date DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL,
						  PRIMARY KEY (`id`),
						  UNIQUE KEY `diversi_register_id` (`diversi_register_id`,`pengacara_id`,`anak_id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_penuntut` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pihak_id` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_penyidik` (
						  `id` bigint(20) NOT NULL,
						  `diversi_register_id` bigint(20) NOT NULL DEFAULT 0 COMMENT 'id register_diversi',
						  `urutan` varchar(20) DEFAULT NULL,
						  `pihak_id` varchar(10) NOT NULL COMMENT 'merujuk ke id_pihak',
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` date DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` date DEFAULT NULL
						) ENGINE=InnoDB;"); 		

 		$cekkolum = $this->isColumnExist('perkara_pihak_orang_tua','jenis_pihak_anak');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `perkara_pihak_orang_tua`   
  						CHANGE `jenis_pihak_anak` `jenis_pihak_anak` SMALLINT(1) NULL  COMMENT '0 = Terdakwa; 1 = Korban; 2 = Saksi';");
 		}

 		$this->db->query("REPLACE INTO status_pihak (alur_perkara_id,tahapan_id,pihak_ke,nama,urutan)VALUES
						(111,10,3,'Orang Tua',3),(111,10,6,'Anak Korban',6),(112,10,3,'Orang Tua',3),(112,10,6,'Anak Korban',6),
						(113,10,3,'Orang Tua',3),(113,10,6,'Anak Korban',6);");

 		$cekkolum = $this->isColumnExist('perkara_diversi','diversi_register_id');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_diversi`
						  ADD COLUMN `diversi_register_id` BIGINT(20) UNSIGNED NULL AFTER `perkara_id`,  
 						  ADD COLUMN `kesepakatan_melaksanakan_diversi` INT(1) UNSIGNED DEFAULT 0 NULL COMMENT '1:Sepakat; 2:Tidak Sepakat' AFTER `tgl_musyawarah`,
						  ADD COLUMN `hasil_lap_pembimbing_masyarakat` INT(1) DEFAULT 0  NULL   COMMENT '1:Dilaksanakan; 2:TidakDilaksanakan;' AFTER `tgl_lap_pembimbing_masyarakat`,
						  ADD COLUMN `nomor_laporan_pembimbing_masyarakat` VARCHAR(50) NULL AFTER `hasil_lap_pembimbing_masyarakat`,
						  ADD COLUMN `diinput_oleh` VARCHAR(30) NULL AFTER `tgl_minutasi`,
						  ADD COLUMN `diinput_tanggal` DATETIME NULL AFTER `diinput_oleh`,
						  ADD COLUMN `diperbaharui_oleh` VARCHAR(30) NULL AFTER `diinput_tanggal`,
						  ADD COLUMN `diperbaharui_tanggal` DATETIME NULL AFTER `diperbaharui_oleh`;");
 		}

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_jadwal_musyawarah_diversi` (
						  `id` bigint(20) unsigned NOT NULL,
						  `diversi_id` bigint(20) NOT NULL,
						  `urutan` int(11) unsigned NOT NULL DEFAULT '1',
						  `tanggal_musyawarah` date NOT NULL,
						  `jam_musyawarah` time DEFAULT NULL,
						  `sampai_jam` time DEFAULT NULL,
						  `tempat` varchar(500) DEFAULT NULL,
						  `dihadiri_oleh` char(1) DEFAULT NULL COMMENT '1. Semua Pihak, 2.Anak Saja, 3.Anak Korban Saja, 4.Semua Pihak Tidak Hadir',
						  `ditunda` char(1) DEFAULT 'T',
						  `diedit_oleh` varchar(30) DEFAULT NULL,
						  `diedit_tanggal` datetime DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`),
						  KEY `diversi_id` (`diversi_id`),
						  KEY `tanggal_musyawarah` (`tanggal_musyawarah`),
						  CONSTRAINT `musyawarah_jadwal` FOREIGN KEY (`diversi_id`) REFERENCES `perkara_diversi` (`id`) ON DELETE CASCADE
						) ENGINE=InnoDB;");

		$cekkolum = $this->isColumnExist('perkara_diversi','no_reg_penyidik');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `perkara_diversi` 
 							CHANGE `id` `id` BIGINT(20) NOT NULL COMMENT 'id perkara_diversi',	
 							CHANGE `no_reg_penyidik` `no_reg_penyidik` VARCHAR(50) NULL COMMENT '-- Tidak Digunakan --', 
							CHANGE `no_reg_penuntut_umum` `no_reg_penuntut_umum` VARCHAR(50) NULL COMMENT '-- Tidak Digunakan --', 
							CHANGE `tgl_musyawarah` `tgl_musyawarah` DATE NULL COMMENT 'Isi: Tgl Musyawarah Diversi Pertama', 
							CHANGE `tgl_kesepakatan_diversi` `tgl_kesepakatan_diversi` DATE NULL COMMENT 'Isi: Tgl Hasil Musyawarah Diversi', 
							CHANGE `isi_singkat_diversi` `isi_singkat_diversi` TEXT NULL COMMENT 'Isi: Isi Hasil Musyawarah Diversi',
							CHANGE `hasil_diversi` `hasil_diversi` INT(1) UNSIGNED DEFAULT NULL NULL COMMENT '1 :\'berhasil\' 0 : \'gagal\'',
							CHANGE `no_penetapan_kesepakatan` `no_penetapan_kesepakatan` VARCHAR(200) NULL COMMENT 'Ambil No Penetapan Dari Register Kesepakatan Diversi', 
							CHANGE `dibuka_kembali` `dibuka_kembali` INT(1) DEFAULT 0 NULL COMMENT '0:Tidak; 1:Ya; -- Tidak Digunakan --', 
							CHANGE `no_dibuka_kembali` `no_dibuka_kembali` VARCHAR(50) NULL COMMENT '-- Tidak Digunakan --', 
							CHANGE `tgl_dibuka_kembali` `tgl_dibuka_kembali` DATE NULL COMMENT '-- Tidak Digunakan --', 
							CHANGE `tgl_minutasi` `tgl_minutasi` DATE NULL COMMENT '-- Tidak Digunakan --';");
 		}

 		$cekkolum = $this->isColumnExist('perkara_barang_bukti','tindakan_utk_pen_kesepakatan_diversi');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_barang_bukti` 
 						ADD COLUMN `tindakan_utk_pen_kesepakatan_diversi` TEXT NULL COMMENT 'Digunakan khusus untuk keperluan penetapan kesepakatan diversi' AFTER `catatan_barang_bukti`; ");
 		} 		
 		
		$cekkolum = $this->isColumnExist('alur_perkara','jenis_pengadilan');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `alur_perkara` 
 			CHANGE `jenis_pengadilan` `jenis_pengadilan` CHAR(1) NULL COMMENT '1:Umum; 2:Mil; 3:Tun; 4:Agama;';");
 		}

 		$cekkolum = $this->isColumnExist('tahapan_proses','jenis_pengadilan');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `tahapan_proses` 
 			CHANGE `jenis_pengadilan` `jenis_pengadilan` CHAR(2) DEFAULT '1' NOT NULL COMMENT '1:Umum; 2:Mil; 3:Tun; 4:Agama;';");
 		}

 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '10' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '10' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '10' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '10' AND`jenis_pengadilan` = '4';");
 		$this->db->query("REPLACE INTO `tahapan_proses` VALUES (12,1,'Penetapan','Penetapan',2,'Y',1);");
		$this->db->query("DELETE FROM `tahapan_proses` WHERE id=12 and kode='02';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '12' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '12' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '13' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '13' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '13' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '14' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '14' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '14' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '14' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '15' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '15' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '15' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '16' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '16' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '17' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '17' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '18' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '19' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '20' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '20' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '20' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '20' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '30' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '30' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '30' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '30' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '40' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '40' AND`jenis_pengadilan` = '2';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '40' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '4' WHERE `Id` = '40' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '50' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '50' AND`jenis_pengadilan` = '3';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '3' WHERE `Id` = '50' AND`jenis_pengadilan` = '4';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '1' WHERE `Id` = '60' AND`jenis_pengadilan` = '1';");
 		$this->db->query("UPDATE `tahapan_proses` SET `kode` = '2' WHERE `Id` = '60' AND`jenis_pengadilan` = '2';");

 		$cekkolum = $this->isColumnExist('tahapan_proses','kode');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `tahapan_proses` 
 			CHANGE `kode` `kode` VARCHAR(10) NOT NULL COMMENT 'Kode Tahapan: isian bebas', DROP PRIMARY KEY, ADD PRIMARY KEY (`Id`, `jenis_pengadilan`, `kode`);");
 		}

 		$this->db->query("REPLACE INTO `tahapan_proses` (`Id`, `kode`, `nama`, `keterangan`, `urutan`) VALUES ('12', '5', 'Diversi', 'Diversi', '2'); ");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '65', 
							`proses_nama`	= 'Penetapan Musyawarah Diversi' 
						WHERE `tahapan_id`='12' AND `proses_id`='75';");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '66', 
							`proses_nama`	= 'Penetapan Musyawarah Diversi' 
						WHERE `tahapan_id`='12' AND `proses_id`='76';");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '68', 
							`proses_nama`	= 'Musyawarah Diversi' 
						WHERE `tahapan_id`='12' AND `proses_id`='77';");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '70', 
							`proses_nama`	= 'Hasil Musyawarah Diversi' 
						WHERE `tahapan_id`='12' AND `proses_id`='78';");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '72', 
							`proses_nama`	= 'Pelaksanaan Kesepakatan Diversi' 
						WHERE `tahapan_id`='12' AND `proses_id`='79';");
 		$this->db->query("UPDATE `perkara_proses` SET	`tahapan_id`	= '12', 
							`tahapan_nama`	= 'Diversi', 
							`proses_id`		= '74', 
							`proses_nama`	= 'Hasil Pelaksanaan Kesepakatan Diversi' 
						WHERE `tahapan_id`='15' AND `proses_id`='213';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
							`tahapan_terakhir_text`	= 'Diversi', 
							`proses_terakhir_id`	= '65', 
							`proses_terakhir_text`	= 'Penetapan Musyawarah Diversi' 
						WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='75';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
							`tahapan_terakhir_text`	= 'Diversi', 
							`proses_terakhir_id`	= '65', 
							`proses_terakhir_text`	= 'Penetapan Musyawarah Diversi' 
						WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='76';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
						`tahapan_terakhir_text`	= 'Diversi', 
						`proses_terakhir_id`	= '68', 
						`proses_terakhir_text`	= 'Musyawarah Diversi' 
					WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='77';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
						`tahapan_terakhir_text`	= 'Diversi', 
						`proses_terakhir_id`	= '70', 
						`proses_terakhir_text`	= 'Hasil Musyawarah Diversi' 
					WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='78';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
						`tahapan_terakhir_text`	= 'Diversi', 
						`proses_terakhir_id`	= '72', 
						`proses_terakhir_text`	= 'Pelaksanaan Kesepakatan Diversi' 
					WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='79';");
 		$this->db->query("UPDATE `perkara`	SET	`tahapan_terakhir_id`	= '12', 
						`tahapan_terakhir_text`	= 'Diversi', 
						`proses_terakhir_id`	= '74', 
						`proses_terakhir_text`	= 'Hasil Pelaksanaan Kesepakatan Diversi' 
					WHERE `alur_perkara_id`='118' AND `proses_terakhir_id`='213';");

 		$cekkolum = $this->isColumnExist('dirput_dokumen','published');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE dirput_dokumen   
			  ADD COLUMN published TINYINT(1) DEFAULT 0  NULL  COMMENT '0 = tidak dipublished, 1 = di published' AFTER pengajuan_id,
			  ADD COLUMN link_dirput VARCHAR(255) NULL AFTER published;");
 		}

 		$cekkolum = $this->isColumnExist('perkara_putusan','amar_putusan_anonimisasi_dok');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE perkara_putusan   
  			ADD COLUMN amar_putusan_anonimisasi_dok VARCHAR(250) NULL  COMMENT 'Dokumen Amar Putusan Anonimisasi: form upload' AFTER amar_putusan_dok;");
 		}

 		$this->db->query("REPLACE INTO `tingkat_pendidikan` (`id`, `kode`, `nama`) VALUES ('12', 'Belum Sekolah', 'Belum Sekolah');");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_pihak_pekerja_sosial_profesional` (
						  `id` bigint(20) unsigned NOT NULL COMMENT 'Primary key(by system)',
						  `perkara_id` bigint(20) unsigned NOT NULL COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id(by system)',
						  `urutan` int(11) unsigned DEFAULT NULL COMMENT 'Urutan: disii dengan bilangan',
						  `pihak_id` bigint(20) unsigned DEFAULT NULL COMMENT 'Id Pihak: merujuk ke tabel pihak',
						  `jenis_pihak_id` tinyint(1) unsigned DEFAULT NULL COMMENT 'Id Jenis Pihak: merujuk ke tabel pihak kolom jenis_pihak_id(by system)',
						  `nama` varchar(1500) DEFAULT NULL COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)',
						  `alamat` varchar(255) DEFAULT NULL COMMENT 'Alamat: merujuk ke tabel pihak kolom alamat(by system)',
						  `keterangan` varchar(255) DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL COMMENT 'Diinput oleh(by system)',
						  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput tanggal(by system)',
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL COMMENT 'Diperbaiki oleh(by system)',
						  `diperbaharui_tanggal` datetime DEFAULT NULL COMMENT 'Diperbaiki tanggal(by system)',
						  PRIMARY KEY (`id`),
						  KEY `nama` (`nama`(767)),
						  KEY `perkara_id` (`perkara_id`),
						  KEY `pihak_id` (`pihak_id`),
						  CONSTRAINT `perkara_pihak_pekerja_sosial_profesional_fk` FOREIGN KEY (`perkara_id`) REFERENCES `perkara` (`perkara_id`) ON DELETE CASCADE
						) ENGINE=InnoDB;");
		
 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_pihak_perwakilan_masyarakat` (
						  `id` bigint(20) unsigned NOT NULL COMMENT 'Primary key(by system)',
						  `perkara_id` bigint(20) unsigned NOT NULL COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id(by system)',
						  `urutan` int(11) unsigned DEFAULT NULL COMMENT 'Urutan: disii dengan bilangan',
						  `pihak_id` bigint(20) unsigned DEFAULT NULL COMMENT 'Id Pihak: merujuk ke tabel pihak',
						  `jenis_pihak_id` tinyint(1) unsigned DEFAULT NULL COMMENT 'Id Jenis Pihak: merujuk ke tabel pihak kolom jenis_pihak_id(by system)',
						  `nama` varchar(1500) DEFAULT NULL COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)',
						  `alamat` varchar(255) DEFAULT NULL COMMENT 'Alamat: merujuk ke tabel pihak kolom alamat(by system)',
						  `keterangan` varchar(255) DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL COMMENT 'Diinput oleh(by system)',
						  `diinput_tanggal` datetime DEFAULT NULL COMMENT 'Diinput tanggal(by system)',
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL COMMENT 'Diperbaiki oleh(by system)',
						  `diperbaharui_tanggal` datetime DEFAULT NULL COMMENT 'Diperbaiki tanggal(by system)',
						  PRIMARY KEY (`id`),
						  KEY `nama` (`nama`(767)),
						  KEY `perkara_id` (`perkara_id`),
						  KEY `pihak_id` (`pihak_id`),
						  CONSTRAINT `perkara_pihak_perwakilan_masyarakat_fk` FOREIGN KEY (`perkara_id`) REFERENCES `perkara` (`perkara_id`) ON DELETE CASCADE
						) ENGINE=InnoDB;");

 		$this->db->query("REPLACE INTO `referensi_kolom_data_template` (`id`, `nama_kolom`) values
						('16','Penjelasan Tentang Perbuatan Anak (Diversi)'),
						('17','Tanggapan Pertama Korban (Diversi)'),
						('18','Pendapat dari Pekerja Sosial Profesional (Diversi)'),
						('19','Pendapat dari Perwakilan Masyarakat (Diversi)'),
						('20','Tanggapan Kedua Korban (Diversi)'),
						('21','Tanggapan dari Anak (Diversi)'),
						('22','Hasil Kaukus (Diversi)');");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_register_blm_12tahun` (
						  `id` bigint(20) NOT NULL,
						  `no_urut` varchar(20) DEFAULT NULL,
						  `nomor_permohonan` varchar(20) DEFAULT NULL,
						  `tgl_permohonan` date DEFAULT NULL,
						  `nomor_penetapan` varchar(50) DEFAULT NULL,
						  `tgl_penetapan` date DEFAULT NULL,
						  `nomor_lap_kemasyarakatan` varchar(50) DEFAULT NULL,
						  `tgl_lap_kemasyarakatan` date DEFAULT NULL,
						  `nomor_kep_penyidik` varchar(50) DEFAULT NULL COMMENT 'Keputusan Penyidik, Pembimbing Kemasyarakatan dan Pekerja Sosial Profesional',
						  `tgl_kep_penyidik` date DEFAULT NULL COMMENT 'Keputusan Penyidik, Pembimbing Kemasyarakatan dan Pekerja Sosial Profesional',
						  `isi_kep_penyidik` text,
						  `tgl_tindak_pidana` date DEFAULT NULL COMMENT 'Tanggal anak melakukan tindak pidana',
						  `uraian_tindak_pidana` text,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$this->db->query("CREATE TABLE IF NOT EXISTS `diversi_anak_blm_12tahun` (
						  `id` bigint(20) NOT NULL AUTO_INCREMENT,
						  `urutan` int(11) DEFAULT NULL,
						  `register_id` bigint(20) NOT NULL COMMENT 'mengacu ke tabel diversi_register_blm_12tahun',
						  `pihak_anak` varchar(10) NOT NULL,
						  PRIMARY KEY (`id`,`pihak_anak`)
						) ENGINE=InnoDB;");

 		$this->db->query("DROP VIEW IF EXISTS `v_perkara`;");
 		$this->db->query("CREATE VIEW `v_perkara` AS 
SELECT 
  `perkara`.`perkara_id` AS `perkara_id`,
  `perkara`.`alur_perkara_id` AS `alur_perkara_id`,
  `alur_perkara`.`nama` AS `alur_perkara_nama`,
  `alur_perkara`.`jenis_pengadilan` AS `jenis_pengadilan`,
  YEAR(
    `perkara`.`tanggal_pendaftaran`
  ) AS `tahun_pendaftaran`,
  MONTH(
    `perkara`.`tanggal_pendaftaran`
  ) AS `bulan_pendaftaran`,
  `perkara`.`tanggal_pendaftaran` AS `tanggal_pendaftaran`,
  `perkara`.`jenis_perkara_id` AS `jenis_perkara_id`,
  `perkara`.`jenis_perkara_kode` AS `jenis_perkara_kode`,
  `perkara`.`jenis_perkara_nama` AS `jenis_perkara_nama`,
  `perkara`.`jenis_perkara_text` AS `jenis_perkara_text`,
  `perkara`.`nomor_urut_register` AS `nomor_urut_register`,
  `perkara`.`nomor_urut_perkara` AS `nomor_urut_perkara`,
  `perkara`.`nomor_perkara` AS `nomor_perkara`,
  `perkara`.`nomor_indeks` AS `nomor_indeks`,
  `perkara`.`tanggal_surat` AS `tanggal_surat`,
  `perkara`.`nomor_surat` AS `nomor_surat`,
  `perkara`.`surat_dok` AS `surat_dok`,
  `perkara`.`pihak1_text` AS `pihak1_text`,
  `perkara`.`nilai_sengketa` AS `nilai_sengketa`,
  `perkara`.`pengacara_pihak1` AS `pengacara_pihak1`,
  `perkara`.`pihak2_text` AS `pihak2_text`,
  `perkara`.`pengacara_pihak2` AS `pengacara_pihak2`,
  `perkara`.`pihak3_text` AS `pihak3_text`,
  `perkara`.`pengacara_pihak3` AS `pengacara_pihak3`,
  `perkara`.`pihak4_text` AS `pihak4_text`,
  `perkara`.`pengacara_pihak4` AS `pengacara_pihak4`,
  `perkara`.`para_pihak` AS `para_pihak`,
  `perkara`.`pihak_dipublikasikan` AS `pihak_dipublikasikan`,
  `perkara`.`posita` AS `posita`,
  `perkara`.`petitum` AS `petitum`,
  `perkara`.`petitum_dok` AS `petitum_dok`,
  `perkara`.`nomor_dakwaan` AS `nomor_dakwaan`,
  `perkara`.`tanggal_dakwaan` AS `tanggal_dakwaan`,
  `perkara`.`dakwaan` AS `dakwaan`,
  `perkara`.`pasal_dakwaan` AS `pasal_dakwaan`,
  `perkara`.`dakwaan_dok` AS `dakwaan_dok`,
  `perkara`.`catatan_pendaftaran` AS `catatan_pendaftaran`,
  `perkara`.`prodeo` AS `prodeo`,
  `perkara_penetapan`.`penetapan_majelis_hakim` AS `penetapan_majelis_hakim`,
  `perkara_penetapan`.`nomor_sk_penetapan_majelis_hakim` AS `nomor_sk_penetapan_majelis_hakim`,
  `perkara_penetapan`.`sk_penetapan_majelis_hakim_dok` AS `sk_penetapan_majelis_hakim_dok`,
  `perkara_penetapan`.`majelis_hakim_id` AS `majelis_hakim_id`,
  `perkara_penetapan`.`majelis_hakim_kode` AS `majelis_hakim_kode`,
  `perkara_penetapan`.`majelis_hakim_nama` AS `majelis_hakim_nama`,
  `perkara_penetapan`.`majelis_hakim_text` AS `majelis_hakim_text`,
  `perkara_penetapan`.`penetapan_panitera_pengganti` AS `penetapan_panitera_pengganti`,
  `perkara_penetapan`.`nomor_sk_penetapan_panitera_pengganti` AS `nomor_sk_penetapan_panitera_pengganti`,
  `perkara_penetapan`.`sk_penetapan_panitera_pengganti_dok` AS `sk_penetapan_panitera_pengganti_dok`,
  `perkara_penetapan`.`panitera_pengganti_id` AS `panitera_pengganti_id`,
  `perkara_penetapan`.`panitera_pengganti_text` AS `panitera_pengganti_text`,
  `perkara_penetapan`.`penetapan_jurusita` AS `penetapan_jurusita`,
  `perkara_penetapan`.`nomor_sk_penetapan_jurusita` AS `nomor_sk_penetapan_jurusita`,
  `perkara_penetapan`.`sk_penetapan_jurusita_dok` AS `sk_penetapan_jurusita_dok`,
  `perkara_penetapan`.`jurusita_id` AS `jurusita_id`,
  `perkara_penetapan`.`jurusita_text` AS `jurusita_text`,
  `perkara_penetapan`.`penetapan_hari_sidang` AS `penetapan_hari_sidang`,
  `perkara_penetapan`.`sidang_pertama` AS `sidang_pertama`,
  `perkara_penetapan`.`jenis_acara` AS `jenis_acara`,
  `perkara_penetapan`.`catatan_penetapan` AS `catatan_penetapan`,
  `perkara_mediasi`.`is_mediasi` AS `is_mediasi`,
  `perkara_mediasi`.`penetapan_penunjukan_mediator` AS `penetapan_penunjukan_mediator`,
  `perkara_mediasi`.`penetapan_tanggal_mediasi` AS `penetapan_tanggal_mediasi`,
  `perkara_mediasi`.`mediator_id` AS `mediator_id`,
  `perkara_mediasi`.`status_mediator` AS `status_mediator`,
  `perkara_mediasi`.`mediator_text` AS `mediator_text`,
  `perkara_mediasi`.`dimulai_mediasi` AS `dimulai_mediasi`,
  `perkara_mediasi`.`keputusan_mediasi` AS `keputusan_mediasi`,
  `perkara_mediasi`.`hasil_mediasi` AS `hasil_mediasi`,
  `perkara_mediasi`.`mediasi_berhasil` AS `mediasi_berhasil`,
  `perkara_mediasi`.`akta_perdamaian` AS `akta_perdamaian`,
  `perkara_mediasi`.`isi_akta_perdamaian` AS `isi_akta_perdamaian`,
  `perkara_mediasi`.`isi_akta_perdamaian_dok` AS `isi_akta_perdamaian_dok`,
  `perkara_mediasi`.`mediasi_gagal` AS `mediasi_gagal`,
  `perkara_mediasi`.`catatan_mediasi` AS `catatan_mediasi`,
  `perkara_penuntutan`.`tanggal_penuntutan` AS `tanggal_penuntutan`,
  `perkara_penuntutan`.`isi_penuntutan` AS `isi_penuntutan`,
  `perkara_putusan_sela`.`tanggal_putusan_sela` AS `tanggal_putusan_sela`,
  `perkara_putusan_sela`.`tanggal_minutasi_sela` AS `tanggal_minutasi_sela`,
  `perkara_putusan`.`tanggal_putusan` AS `tanggal_putusan`,
  `perkara_putusan`.`putusan_verstek` AS `putusan_verstek`,
  `perkara_putusan`.`status_putusan_id` AS `status_putusan_id`,
  `status_putusan`.`nama` AS `status_putusan_kode`,
  `perkara_putusan`.`status_putusan_nama` AS `status_putusan_nama`,
  `perkara_putusan`.`status_putusan_text` AS `status_putusan_text`,
  `perkara_putusan`.`tanggal_cabut` AS `tanggal_cabut`,
  `perkara_putusan`.`tanggal_gugur` AS `tanggal_gugur`,
  `perkara_putusan`.`amar_putusan` AS `amar_putusan`,
  `perkara_putusan`.`amar_putusan_dok` AS `amar_putusan_dok`,
  `perkara_putusan`.`tanggal_minutasi` AS `tanggal_minutasi`,
  `perkara_putusan`.`pemberitahuan_putusan` AS `pemberitahuan_putusan`,
  `perkara_putusan`.`pemberitahuan_putusan_pihak1` AS `pemberitahuan_putusan_pihak1`,
  `perkara_putusan`.`pemberitahuan_putusan_pihak2` AS `pemberitahuan_putusan_pihak2`,
  `perkara_putusan`.`menerima_putusan_pihak1` AS `menerima_putusan_pihak1`,
  `perkara_putusan`.`menerima_putusan_pihak2` AS `menerima_putusan_pihak2`,
  `perkara_putusan`.`kirim_salinan_putusan_pihak1` AS `kirim_salinan_putusan_pihak1`,
  `perkara_putusan`.`kirim_salinan_putusan_pihak2` AS `kirim_salinan_putusan_pihak2`,
  `perkara_putusan`.`kirim_salinan_putusan_pihak3` AS `kirim_salinan_putusan_pihak3`,
  `perkara_putusan`.`pemberitahuan_putusan_pihak3` AS `pemberitahuan_putusan_pihak3`,
  `perkara_putusan`.`kirim_salinan_putusan_penyidik` AS `kirim_salinan_putusan_penyidik`,
  `perkara_putusan`.`catatan_putusan` AS `catatan_putusan`,
  `perkara_putusan`.`tanggal_bht` AS `tanggal_bht`,
  `perkara_verzet`.`tanggal_pendaftaran_verzet` AS `tanggal_pendaftaran_verzet`,
  `perkara_verzet`.`tanggal_penetapan_sidang_verzet` AS `tanggal_penetapan_sidang_verzet`,
  `perkara_verzet`.`tanggal_sidang_pertama_verzet` AS `tanggal_sidang_pertama_verzet`,
  `perkara_verzet`.`putusan_verzet` AS `putusan_verzet`,
  `perkara_verzet`.`pemberitahuan_putusan_verzet` AS `pemberitahuan_putusan_verzet`,
  `perkara_verzet`.`pemberitahuan_putusan_verzet_pihak1` AS `pemberitahuan_putusan_verzet_pihak1`,
  `perkara_verzet`.`pemberitahuan_putusan_verzet_pihak2` AS `pemberitahuan_putusan_verzet_pihak2`,
  `perkara`.`tahapan_terakhir_id` AS `tahapan_terakhir_id`,
  `perkara`.`tahapan_terakhir_text` AS `tahapan_terakhir_text`,
  `perkara`.`proses_terakhir_id` AS `proses_terakhir_id`,
  `perkara`.`proses_terakhir_text` AS `proses_terakhir_text`,
  `perkara`.`diedit_oleh` AS `diedit_oleh`,
  `perkara`.`diedit_tanggal` AS `diedit_tanggal`,
  `perkara`.`diinput_oleh` AS `diinput_oleh`,
  `perkara`.`diinput_tanggal` AS `diinput_tanggal`,
  `perkara`.`diperbaharui_oleh` AS `diperbaharui_oleh`,
  `perkara`.`diperbaharui_tanggal` AS `diperbaharui_tanggal`,
  `perkara`.`terdakwa_anak` AS `terdakwa_anak`,
  `perkara_matra`.`matra` AS `matra`,
  `perkara_matra`.`berkas_dari` AS `berkas_dari`,
  `perkara_matra`.`tanggal_kejadian` AS `tanggal_kejadian`,
  `perkara_matra`.`tempat_kejadian` AS `tempat_kejadian`,
  `perkara_matra`.`tanggal_skeppera` AS `tanggal_skeppera`,
  `perkara_matra`.`nomor_skeppera` AS `nomor_skeppera`,
  `perkara_matra`.`pejabat_skeppera` AS `pejabat_skeppera`,
  `perkara_matra`.`tanggal_surat_dakwaan` AS `tanggal_surat_dakwaan`,
  `perkara_matra`.`nomor_surat_dakwaan` AS `nomor_surat_dakwaan`,
  `perkara_matra`.`penyidik_mil` AS `penyidik_mil`,
  `perkara_matra`.`no_bap_penyidik_mil` AS `no_bap_penyidik_mil`,
  `perkara_matra`.`tgl_penyidik_mil` AS `tgl_penyidik_mil`,
  `perkara_data_pernikahan`.`tgl_nikah` AS `tgl_nikah`,
  `perkara_data_pernikahan`.`tgl_kutipan_akta_nikah` AS `tgl_kutipan_akta_nikah`,
  `perkara_data_pernikahan`.`no_kutipan_akta_nikah` AS `no_kutipan_akta_nikah`,
  `perkara_data_pernikahan`.`kua_tempat_nikah` AS `kua_tempat_nikah` 
FROM
  (
    (
      (
        (
          (
            (
              (
                (
                  (
                    (
                      `perkara` 
                      LEFT JOIN `perkara_penetapan` 
                        ON (
                          `perkara`.`perkara_id` = `perkara_penetapan`.`perkara_id`
                        )
                    ) 
                    LEFT JOIN `perkara_penuntutan` 
                      ON (
                        `perkara`.`perkara_id` = `perkara_penuntutan`.`perkara_id`
                      )
                  ) 
                  LEFT JOIN `perkara_putusan_sela` 
                    ON (
                      `perkara`.`perkara_id` = `perkara_putusan_sela`.`perkara_id` 
                      AND `perkara_putusan_sela`.`urutan` = 1
                    )
                ) 
                LEFT JOIN `perkara_putusan` 
                  ON (
                    `perkara`.`perkara_id` = `perkara_putusan`.`perkara_id`
                  )
              ) 
              LEFT JOIN `status_putusan` 
                ON (
                  `status_putusan`.`id` = `perkara_putusan`.`status_putusan_id`
                )
            ) 
            LEFT JOIN `perkara_mediasi` 
              ON (
                `perkara`.`perkara_id` = `perkara_mediasi`.`perkara_id` 
                AND `perkara_mediasi`.`tahapan_id` = 10
              )
          ) 
          LEFT JOIN `alur_perkara` 
            ON (
              `perkara`.`alur_perkara_id` = `alur_perkara`.`id`
            )
        ) 
        LEFT JOIN `perkara_verzet` 
          ON (
            `perkara`.`perkara_id` = `perkara_verzet`.`perkara_id`
          )
      ) 
      LEFT JOIN `perkara_matra` 
        ON (
          `perkara`.`perkara_id` = `perkara_matra`.`perkara_id`
        )
    ) 
    LEFT JOIN `perkara_data_pernikahan` 
      ON (
        `perkara`.`perkara_id` = `perkara_data_pernikahan`.`perkara_id`
      )
  );");
	

 		$this->db->query("CREATE TABLE IF NOT EXISTS `perkara_jadwal_pemeriksaan_pk` (
						  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						  `perkara_id` bigint(20) NOT NULL,
						  `urutan` int(11) unsigned NOT NULL DEFAULT 1,
						  `tanggal_pemeriksaan` date NOT NULL,
						  `mulai_jam` time DEFAULT NULL,
						  `sampai_jam` time DEFAULT NULL,
						  `ruangan_id` int(11) DEFAULT NULL,
						  `ruangan` varchar(100) DEFAULT NULL,
						  `agenda` varchar(100) DEFAULT NULL,
						  `ditunda` char(1) DEFAULT 'T',
						  `alasan_ditunda` varchar(100) DEFAULT NULL,
						  `keterangan` varchar(100) DEFAULT NULL,
						  `diedit_oleh` varchar(30) DEFAULT NULL,
						  `diedit_tanggal` datetime DEFAULT NULL,
						  `diinput_oleh` varchar(30) DEFAULT NULL,
						  `diinput_tanggal` datetime DEFAULT NULL,
						  `diperbaharui_oleh` varchar(30) DEFAULT NULL,
						  `diperbaharui_tanggal` datetime DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");

 		$cekkolum = $this->isColumnExist('perkara_data_template_penahanan','jenis_jaminan');
 		if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_data_template_penahanan`   
						  ADD COLUMN `jenis_jaminan` CHAR(1) NULL  COMMENT '1.Jaminan Orang, 2. Jaminan Uang, 3.Tanpa Jaminan' AFTER `tanggal_permohonan`,
						  ADD COLUMN `pertimbangan` VARCHAR(255) NULL AFTER `tanggal_bukti_setoran`;");
 		}

 		$this->db->query("REPLACE INTO `status_putusan` (`id`, `jenis_perkara_id`, `nama`, `urutan`, `satuan`,jenis_pengadilan) 
						VALUES ('91', '2', 'Penghentian Pemeriksaan Perkara', '21', '3', '1');  ");

 		$this->db->query("DROP TABLE IF EXISTS `diversiweb`;");
 		$this->db->query("CREATE TABLE `diversiweb` (
						  `id` bigint(20) NOT NULL,
						  `perkara_id` bigint(20) DEFAULT NULL,
						  `diversi_register_id` bigint(20) DEFAULT NULL,
						  `pihak_diversi` varchar(1500) DEFAULT NULL,
						  `no_reg_penyidik` varchar(50) DEFAULT NULL,
						  `no_reg_penuntut_umum` varchar(50) DEFAULT NULL,
						  `tgl_penetapan_musyawarah` date DEFAULT NULL,
						  `tgl_musyawarah` date DEFAULT NULL,
						  `kesepakatan_melaksanakan_diversi` int(1) DEFAULT NULL,
						  `tgl_kesepakatan_diversi` date DEFAULT NULL,
						  `tgl_laporan_hakim` date DEFAULT NULL,
						  `tgl_penetapan_kesepakatan_diversi` date DEFAULT NULL,
						  `no_penetapan_kesepakatan` varchar(200) DEFAULT NULL,
						  `tgl_lap_pembimbing_masyarakat` date DEFAULT NULL,
						  `hasil_lap_pembimbing_masyarakat` int(1) DEFAULT NULL,
						  `nomor_laporan_pembimbing_masyarakat` varchar(50) DEFAULT NULL,
						  `hasil_diversi` varchar(50) DEFAULT NULL,
						  `dibuka_kembali` int(1) DEFAULT NULL,
						  `no_dibuka_kembali` varchar(50) DEFAULT NULL,
						  `tgl_dibuka_kembali` date DEFAULT NULL,
						  `tgl_pelaksanaan_isi_diversi` date DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=InnoDB;");
		
		$cekkolum = $this->isColumnExist('perkaralalulintasweb','ditilangOleh');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `perkaralalulintasweb`   
					  CHANGE `ditilangOleh` `ditilangOleh` VARCHAR(100) NULL,
					  CHANGE `jenisKendaraan` `jenisKendaraan` VARCHAR(100) NULL,
					  CHANGE `buktiTilang` `buktiTilang` VARCHAR(100) NULL;  ");
 		}

 		$this->db->query("DROP VIEW IF EXISTS `viewdiversiweb`;");
 		$this->db->query("CREATE VIEW `viewdiversiweb` AS 
							SELECT
							  `perkara_diversi`.`id`                                AS `id`,
							  `perkara_diversi`.`perkara_id`                        AS `perkara_id`,
							  `perkara_diversi`.`diversi_register_id` 				AS diversi_register_id,
							  `perkara_diversi`.`pihak_diversi`						AS pihak_diversi,
							  `perkara_diversi`.`no_reg_penyidik`                   AS `no_reg_penyidik`,
							  `perkara_diversi`.`no_reg_penuntut_umum`              AS `no_reg_penuntut_umum`,
							  `perkara_diversi`.`tgl_penetapan_musyawarah`          AS `tgl_penetapan_musyawarah`,
							  `perkara_diversi`.`tgl_musyawarah`                    AS `tgl_musyawarah`,
							  `perkara_diversi`.`kesepakatan_melaksanakan_diversi`	AS kesepakatan_melaksanakan_diversi,
							  `perkara_diversi`.`tgl_kesepakatan_diversi`           AS `tgl_kesepakatan_diversi`,
							  `perkara_diversi`.`tgl_laporan_hakim`					AS tgl_laporan_hakim,
							  `perkara_diversi`.`tgl_penetapan_kesepakatan_diversi` AS `tgl_penetapan_kesepakatan_diversi`,
							  `perkara_diversi`.`no_penetapan_kesepakatan`          AS `no_penetapan_kesepakatan`,
							  `perkara_diversi`.`tgl_lap_pembimbing_masyarakat`     AS `tgl_lap_pembimbing_masyarakat`,
							  `perkara_diversi`.`hasil_lap_pembimbing_masyarakat`		AS hasil_lap_pembimbing_masyarakat,
							  `perkara_diversi`.`nomor_laporan_pembimbing_masyarakat`	AS nomor_laporan_pembimbing_masyarakat,
							  IF((`perkara_diversi`.`hasil_diversi` = 1),'Berhasil','Tidak Berhasil') AS `hasil_diversi`,
							  `perkara_diversi`.`dibuka_kembali`                    AS `dibuka_kembali`,
							  `perkara_diversi`.`no_dibuka_kembali`                 AS `no_dibuka_kembali`,
							  `perkara_diversi`.`tgl_dibuka_kembali`                AS `tgl_dibuka_kembali`,
							  perkara_diversi.`tgl_pelaksanaan_isi_diversi`			AS tgl_pelaksanaan_isi_diversi
							FROM `perkara_diversi`;"); 				

 		$this->db->query("DROP VIEW IF EXISTS `viewputusanselaweb`");
 		$this->db->query("CREATE VIEW `viewputusanselaweb` AS 
							SELECT
							  `perkara_putusan_sela`.`perkara_id`                        AS `IDPerkara`,
							  `perkara_putusan_sela`.`tanggal_putusan_sela`              AS `tglPutusanSela`,
							  (CASE 
								WHEN perkara.alur_perkara_id = 118 THEN 'Disamarkan' 
								WHEN perkara.jenis_perkara_id IN (64,98,359,346,347) THEN 'Disamarkan' 
								ELSE `perkara_putusan_sela`.`amar_sela` 
							   END) AS `amarSela`,
							  `perkara_putusan_sela`.`tanggal_minutasi_sela`             AS `tglMinutasi`,
							  `perkara_putusan_sela`.`tanggal_berita_sela`               AS `tglBerita`,
							  `perkara_putusan_sela`.`nama_media_berita_sela`            AS `namaMedia`,
							  `perkara_putusan_sela`.`tanggal_surat_kabar_sela`          AS `tglSuratKabar`,
							  `perkara_putusan_sela`.`nama_surat_kabar_sela`             AS `namaSuratKabar`,
							  `perkara_putusan_sela`.`penetapan_hakim_pengawas`          AS `tglPenetapanHakim`,
							  `perkara_putusan_sela`.`hakim_pengawas_nama`               AS `hakimPengawas`,
							  `perkara_putusan_sela`.`pengurus_nama`                     AS `pengurusNama`,
							  `perkara_putusan_sela`.`tanggal_perpanjangan`              AS `tglPerpanjangan`,
							  `perkara_putusan_sela`.`mulai_perpanjangan`                AS `mulaiPerpanjangan`,
							  `perkara_putusan_sela`.`sampai_perpanjangan`               AS `sampaiPerpanjangan`,
							  `perkara_putusan_sela`.`penetapan_sita_jaminan`            AS `penetapanSitaJaminan`,
							  `perkara_putusan_sela`.`pelaksanaan_sita_jaminan`          AS `pelaksanaanSitaJaminan`,
							  `perkara_putusan_sela`.`pemberitahuan_putusan_sela_pihak1` AS `pemberitahuanPihak1`,
							  `perkara_putusan_sela`.`pemberitahuan_putusan_sela_pihak2` AS `pemberitahuanPihak2`,
							  `perkara_putusan_sela`.`pemberitahuan_putusan_sela_pihak3` AS `pemberitahuanPihak3`,
							  `perkara_putusan_sela`.`catatan_putusan`                   AS `keterangan`
							FROM `perkara_putusan_sela`
							LEFT JOIN perkara ON (perkara_putusan_sela.`perkara_id`=perkara.`perkara_id`);");

 		$this->db->query("DROP VIEW IF EXISTS `viewpengacaraweb`;");
 		$this->db->query("CREATE VIEW `viewpengacaraweb` AS 
							SELECT
							  `pengacara`.`perkara_id`   AS `IDPerkara`,
							  `pengacara`.`pengacara_id` AS `pengacara_id`,
							  `pengacara`.`nama`         AS `nama`,
							  `pengacara`.`urutan`       AS `urutan`,
							  `pengacara`.`aktif`        AS `aktif`,
							  `pengacara`.`pihak_ke`     AS `pihak_ke`,
							  `pengacara`.`pihak_id`     AS `pihak_id`,
							  (CASE WHEN ((`per`.`alur_perkara_id` = 1) AND (`per`.`jenis_perkara_id` = 64)) THEN 'Disamarkan' WHEN ((`per`.`alur_perkara_id` = 1) AND (`per`.`jenis_perkara_id` = 137)) THEN 'Disamarkan' WHEN ((`per`.`alur_perkara_id` = 15) AND (`per`.`jenis_perkara_id` = 347)) THEN 'Disamarkan' WHEN ((`per`.`alur_perkara_id` = 15) AND (`per`.`jenis_perkara_id` = 346)) THEN 'Disamarkan' WHEN ((`per`.`pihak_dipublikasikan` = 'T') AND ((`p`.`nama` IS NOT NULL) OR (`p`.`nama` <> ''))) THEN 'Disamarkan' WHEN (`per`.`alur_perkara_id` = 118) THEN 'Anak Berhadapan Dengan Hukum' ELSE `p`.`nama` END) AS `namapihak`
							FROM ((`perkara_pengacara` `pengacara`
							    LEFT JOIN `pihak` `p`
							      ON ((`p`.`id` = `pengacara`.`pihak_id`)))
							   LEFT JOIN `perkara` `per`
							     ON ((`per`.`perkara_id` = `pengacara`.`perkara_id`)));"); 		 		

 		$this->db->query("REPLACE INTO `status_pihak` (`alur_perkara_id`, `tahapan_id`, `pihak_ke`, `nama`, `urutan`) VALUES ('1', '16', '1', 'Pelawan', '1'); ");
 		$this->db->query("REPLACE INTO `status_pihak` (`alur_perkara_id`, `tahapan_id`, `pihak_ke`, `nama`, `urutan`) VALUES ('1', '16', '2', 'Terlawan', '2');"); 
		$this->db->query("REPLACE INTO `status_pihak` (`alur_perkara_id`, `tahapan_id`, `pihak_ke`, `nama`, `urutan`) VALUES ('7', '16', '1', 'Pelawan', '1');"); 
		$this->db->query("REPLACE INTO `status_pihak` (`alur_perkara_id`, `tahapan_id`, `pihak_ke`, `nama`, `urutan`) VALUES ('7', '16', '2', 'Terlawan', '2');");  		

		$this->db->query("REPLACE INTO `sys_menus` (`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) VALUES ('244', 'mainmenu', '64', '1', 'Template Amar', 'template_amar_list', '', '1', '8');");  		

		$this->db->query("REPLACE INTO `template_dokumen` (`id`, `alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) 
						VALUES (142,1,15,210,1,'PDT_1_15_210_1','Putusan Perdata Kabul'),
							   (143,1,15,210,2,'PDT_1_15_210_2','Putusan Perdata Tolak Gugatan'),
							   (144,1,15,210,3,'PDT_1_15_210_3','Putusan Perdata Gugatan'),
							   (145,1,15,210,4,'PDT_1_15_210_4','Putusan Perdata (Format Gugur)'),
							   (146,1,15,210,5,'PDT_1_15_210_5','Putusan Perdata (Format Verstek)'),
							   (147,1,15,210,6,'PDT_1_15_210_6','Putusan Perdata (Format Verzet-Kabul Perlawanan)'),
							   (148,1,15,210,7,'PDT_1_15_210_7','Putusan Perdata (Format Rekonvensi)'),
							   (149,1,15,210,8,'PDT_1_15_210_8','Putusan Perdata (Format Rekonvensi Tidak Ada Hubungan)'),
							   (150,1,15,210,9,'PDT_1_15_210_9','Putusan Perdata (Format Intervensi Vrijwaring)'),
							   (151,1,15,210,10,'PDT_1_15_210_10','Putusan Perdata (Format Intervensi Tussenkomst)'),
							   (152,1,15,210,11,'PDT_1_15_210_11','Putusan Perdata (Format Intervensi Voeging)'),
							   (153,1,15,210,12,'PDT_1_15_210_12','Putusan Perdata (Format Putusan Provisi)'),
							   (154,1,15,210,13,'PDT_1_15_210_13','Putusan Perdata (Format Putusan Sela tentang Eksepsi Kewenangan Dikabulkan)'), 
							   (155,1,15,210,14,'PDT_1_15_210_14','Putusan Perdata - Berita Acara (Format Putusan Sela tentang Eksepsi Kewenangan Ditolak)'), 
							   (156,1,15,210,15,'PDT_1_15_210_15','Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Discoir)'), 
							   (157,1,15,210,16,'PDT_1_15_210_16','Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Supletoir)'), 
							   (158,1,15,210,17,'PDT_1_15_210_17','Putusan Perdata (Denden Verzet)'),
							   (159,1,15,210,18,'PDT_1_15_210_18','Berita Acara (Permohonan Pasal 225HIR - 295RBg)'),
							   (160,1,15,210,19,'PDT_1_15_210_19','Putusan Perdata (Permohonan Pasal 225HIR - 295RBg)'), 
							   (161,111,15,210,1,'PID_111_15_210_1','Putusan Pidana (Format Biasa Bebas)'), 
							   (162,118,15,210,2,NULL,'Putusan Pidana Anak (Format Biasa Bebas)'), 
							   (163,111,15,210,3,'PID_111_15_210_3','Putusan Pidana (Format Biasa Terbukti)'), 
							   (164,118,15,210,4,'PID_118_15_210_4','Putusan Pidana Anak (Format Biasa Terbukti)'), 
							   (165,111,15,210,5,'PID_111_15_210_5','Putusan Pidana (Format Biasa Lepas)'), 
							   (166,118,15,210,6,NULL,'Putusan Pidana Anak (Format Biasa Lepas)'), 
							   (167,111,15,210,7,'PID_111_15_210_7','Putusan Sela - Keberatan diputus bersama Putusan Akhir'), 
							   (168,111,15,210,8,'PID_111_15_210_8','Putusan Sela - Keberatan Diterima'), 
							   (169,111,15,210,9,'PID_111_15_210_9','Putusan Sela - Keberatan Tidak Diterima'), 
							   (170,111,15,210,10,'PID_111_15_210_10','Putusan (Format Penuntutan Penuntut Umum tidak dapat diterima)'), 
							   (171,115,15,210,13,NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Bebas'), 
							   (172,1,14,200,101,'PDT_1_14_200_101','Relaas Panggilan Pertama Kepada Penggugat'), 
							   (173,1,14,200,103,'PDT_1_14_200_103','Relaas Panggilan Pertama Kepada Penggugat Meninggal Dunia Bertemu Ahli Waris'), 
							   (174,1,14,200,109,'PDT_1_14_200_109','Relaas Panggilan Kepada Kuasa Penggugat'), 
							   (175,1,14,200,113,'PDT_1_14_200_113','Relaas Panggilan Kepada Ahli Waris Penggugat Bertemu'), 
							   (176,1,14,200,150,'PDT_1_14_200_150','Relaas Panggilan Kepada Saksi'), 
							   (177,1,14,200,151,'PDT_1_14_200_151','Relaas Panggilan Kepada Ahli'), 
							   (178,1,14,200,152,'PDT_1_14_200_152','Relaas Panggilan Kepada Juru Bahasa'), 
							   (179,1,14,200,153,'PDT_1_14_200_153','Relaas Panggilan Kepada Penerjemah'), 
							   (201,1,15,230,201,NULL,'Relaas Pemberitahuan Putusan Kepada Tergugat dan Verstek'), 
							   (202,1,15,230,240,NULL,'Relaas Pemberitahuan Putusan Kepada Kuasa Penggugat All'), 
							   (203,1,15,230,241,NULL,'Relaas Pemberitahuan Putusan Kepada Kuasa Tergugat All'), 
							   (205,1,14,200,115,'PDT_1_14_200_115','Relaas Panggilan Pertama Kepada Tergugat Bertemu'), 
							   (206,1,14,200,117,'PDT_1_14_200_117','Relaas Panggilan Pertama Kepada Tergugat Meninggal Bertemu Ahli Waris'), 
							   (209,1,14,200,135,'PDT_1_14_200_135','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Bertemu'), 
							   (211,1,14,200,143,'PDT_1_14_200_143','Relaas Panggilan Kepada Tergugat Tempat Tinggal Tidak Ditemukan'), 
							   (212,1,14,200,144,'PDT_1_14_200_144','Relaas Panggilan Kepada Tergugat Cerai Tempat Tinggal Tidak Ditemukan'), 
							   (213,111,20,300,251,'PID_111_20_300_251','Relaas Pemberitahuan Pernyataan Banding Kepada Penuntut Umum'), 
							   (214,111,20,300,252,'PID_111_20_300_252','Relaas Pemberitahuan Pernyataan Banding Kepada Terdakwa'), 
							   (215,111,20,340,255,'PID_111_20_340_255','Relaas Penyerahan Kontra Memori Banding Kepada Terdakwa'), 
							   (216,111,20,340,256,'PID_111_20_340_256','Relaas Penyerahan Kontra Memori Banding Kepada Penuntut Umum'), 
							   (217,111,30,420,263,'PID_111_30_420_263','Relas Pemberitahuan Permohonan Kasasi Kepada Penuntut Umum'), 
							   (218,111,30,420,264,'PID_111_30_420_264','Relas Pemberitahuan Permohonan Kasasi Kepada Terdakwa'), 
							   (219,111,30,460,267,'PID_111_30_460_267','Relaas Penyerahan Kontra Memori Kasasi Kepada Penuntut Umum'), 
							   (220,111,30,460,268,'PID_111_30_460_268','Relaas Penyerahan Kontra Memori Kasasi Kepada Terdakwa'), 
							   (221,111,40,200,275,NULL,'Relaas Panggilan Sidang Peninjauan Kembali Terdakwa'), 
							   (222,111,40,200,276,NULL,'Relaas Panggilan Sidang Peninjauan Kembali JPU'), 
							   (301,111,14,200,301,'PID_111_14_200_301','Berita Acara Persidangan Pidana Biasa'), 
							   (302,112,14,200,312,'PID_112_14_200_312','Berita Acara Persidangan Pidana Singkat'),
							   (303,113,14,200,322,'PID_113_14_200_322','Berita Acara Persidangan Pidana Cepat'), 
							   (304,111,40,510,323,'PID_111_30_410_323','Berita Acara Persidangan Peninjauan Kembali'), 
							   (305,111,30,410,326,'PID_111_30_410_326','Berita Acara Pendapat Peninjauan Kembali'), 
							   (306,1,14,200,350,'PDT_1_14_200_350','Berita Acara Persidangan Perdata Gugatan'), 
							   (307,1,14,200,360,'PDT_1_14_200_360','Berita Acara Persidangan Mediasi Gugur'), 
							   (308,1,14,200,362,'PDT_1_14_200_362','Berita Acara Persidangan Mediasi Berhasil'), 
							   (309,1,14,200,364,'PDT_1_14_200_364','Berita Acara Persidangan Tergugat Tidak Hadir'), 
							   (310,1,14,200,365,'PDT_1_14_200_365','Berita Acara Persidangan Putusan Sela Terima Tolak'), 
							   (311,1,14,200,369,'PDT_1_14_200_369','Berita Acara Persidangan Putusan Verstek'), 
							   (312,1,14,200,373,'PDT_1_14_200_373','Berita Acara Sita Revindicatoir'), 
							   (313,5,14,200,301,'PDT_5_14_200_301','Berita Acara atas Hak Kekayaan Intelektual'), 
							   (314,6,14,200,301,'PDT_6_14_200_301','Berita Acara Persidangan Pengadilan Hubungan Industrial - Verstek '), 
							   (315,3,14,200,301,'PDT_3_14_200_301','Berita Acara Persidangan Pailit'), 
							   (316,6,14,200,304,'PDT_6_14_200_304','Berita Acara Persidangan Pengadilan Hubungan Industrial'), 
							   (317,3,14,200,307,'PDT_3_14_200_307','Berita Acara Persidangan Renvoi Prosedur'), 
							   (318,4,14,200,301,'PDT_4_14_200_301','Berita Acara Persidangan PKPU Debitor'), 
							   (319,4,14,200,304,'PDT_4_14_200_304','Berita Acara Persidangan PKPU Kreditor'), 
							   (320,4,14,200,309,'PDT_4_14_200_309','Berita Acara Persidangan PKPU'), 
							   (321,3,14,200,2,'PDT_3_14_200_2','Berita Acara Persidangan Actio Pauliana'), 
							   (322,111,12,200,9,'PID_111_12_200_9','Penetapan Penolakan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri'), 
							   (323,111,12,200,10,'PID_111_12_200_10','Penetapan Penolakan Perpanjangan Tahanan Penuntut oleh Ketua Pengadilan Negeri'), 
							   (324,111,12,200,11,'PID_111_12_200_11','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Negeri'), 
							   (325,111,12,200,12,'PID_111_12_200_12','Penetapan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri Pasal 25 ayat 1'), 
							   (326,111,12,200,13,'PID_111_12_200_13','Penetapan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri Pasal 29 ayat 2'), 
							   (327,111,12,200,14,'PID_111_12_200_14','Penetapan Perpanjangan Tahanan Penuntut Umum oleh Ketua Pengadilan Negeri Pasal 25'), 
							   (328,111,12,200,15,'PID_111_12_200_15','Penetapan Perpanjangan Tahanan PU oleh Ketua Pengadilan Negeri Pasal 29 ayat 1'), 
							   (329,111,12,200,16,'PID_111_12_200_16','Penetapan Perpanjangan Tahanan PU oleh Ketua Pengadilan Negeri Pasal 29 ayat 2'), 
							   (330,111,12,200,17,'PID_111_12_200_17','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Tinggi Pasal 29 ayat 1'), 
							   (331,111,12,200,18,'PID_111_12_200_18','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Tinggi Pasal 29 ayat 2'), 
							   (333,111,12,20,1,'PID_111_12_20_1','Penetapan Penunjukan Majelis Hakim atau Hakim Tunggal'), 
							   (334,111,12,30,1,'PID_111_12_30_1','Penunjukan Panitera Pengganti'), 
							   (335,111,12,80,1,'PID_111_12_80_1','Penetapan Hari Sidang Pertama Pidana'), 
							   (336,111,12,80,2,NULL,'Penetapan Hari Sidang Pertama PU Tidak Hadir'), 
							   (337,111,12,200,2,'PID_111_12_200_2','Penetapan Penahanan Hakim Pengadilan Negeri'), 
							   (338,111,12,200,3,'PID_111_12_200_3','Penetapan Penahanan Terdakwa Hakim PN Sidang Berjalan'), 
							   (339,111,12,200,1,'PID_111_12_200_1','Penetapan Pembantaran Penahanan'), 
							   (340,111,12,200,5,'PID_111_12_200_5','Penetapan Penangguhan Penahanan Dengan Jaminan Orang'), 
							   (341,111,12,200,4,'PID_111_12_200_4','Penetapan Penangguhan Penahanan Dengan Jaminan Uang'), 
							   (342,111,12,200,6,'PID_111_12_200_6','Penetapan Penangguhan Penahanan Tanpa Jaminan'), 
							   (343,111,12,200,7,'PID_111_12_200_7','Penetapan Pengalihan Penahanan Dengan Permohonan'), 
							   (344,111,12,200,8,'PID_111_12_200_8','Penetapan Pengalihan Penahanan Tanpa Permohonan'), 
							   (345,113,12,20,1,'PID_113_12_20_1','Penetapan Hakim Tunggal Perkara Cepat'), 
							   (350,111,20,290,601,'PID_111_20_290_601','Akta Permintaan Banding Oleh Terdakwa'), 
							   (351,111,20,290,602,'PID_111_20_290_602','Akta Permintaan Banding Oleh Terdakwa Tidak Menghadap'), 
							   (352,111,20,290,603,'PID_111_20_290_603','Akta Permintaan Banding Oleh Penasihat Hukum'), 
							   (353,111,20,290,604,'PID_111_20_290_604','Akta Permintaan Banding Oleh Penuntut Umum'), 
							   (354,111,20,290,605,'PID_111_20_290_605','Akta Pencabutan Banding Oleh Terdakwa'), 
							   (355,111,20,290,606,'PID_111_20_290_606','Akta Pencabutan Banding Oleh Terdakwa Tidak Menghadap'), 
							   (356,111,20,290,607,'PID_111_20_290_607','Akta Pencabutan Banding Oleh Penasihat Hukum'), 
							   (357,111,20,290,608,'PID_111_20_290_608','Akta Pencabutan Banding Oleh Penuntut Umum'), 
							   (358,111,20,340,257,'PID_111_20_340_257','Relaas Penyerahan Kontra Memori Banding Kepada Pemohon Banding'), 
							   (359,111,20,340,258,NULL,'Relaas Penyerahan Kontra Memori Banding Kepada Pemohon Banding Delegasi'), 
							   (360,111,20,360,259,'PID_111_20_360_259','Relaas Pemberitahuan Inzage Kepada Penuntut Umum'), 
							   (361,111,20,360,260,'PID_111_20_360_260','Relaas Pemberitahuan Inzage Kepada Terdakwa'), 
							   (362,111,20,320,253,'PID_111_20_320_253','Relaas Penyerahan Memori Banding Kepada Terdakwa'), 
							   (363,111,20,320,254,'PID_111_20_320_254','Relaas Penyerahan Memori Banding Kepada Penuntut Umum'), 
							   (364,111,20,400,261,'PID_111_20_400_261','Relaas Pemberitahuan Putusan Banding Kepada Penuntut Umum'), 
							   (365,111,20,400,262,'PID_111_20_400_262','Relaas Pemberitahuan Putusan Banding Kepada Terdakwa'), 
							   (366,111,30,460,269,'PID_111_30_460_269','Relaas Penyerahan Kontra Memori Kasasi Kepada Pemohon Kasasi'), 
							   (367,111,30,460,270,NULL,'Relaas Penyerahan Kontra Memori Kasasi Kepada Pemohon Kasasi Delegasi'), 
							   (368,111,30,440,265,'PID_111_30_440_265','Relaas Penyerahan Memori Kasasi Kepada Terdakwa'), 
							   (369,111,30,440,266,'PID_111_30_440_266','Relaas Penyerahan Memori Kasasi Kepada Penuntut Umum'), 
							   (370,111,30,500,271,'PID_111_30_500_271','Relaas Pemberitahuan Putusan Kasasi Kepada Penuntut Umum'), 
							   (371,111,30,500,272,'PID_111_30_500_272','Relaas Pemberitahuan Putusan Kasasi Kepada Terdakwa'), 
							   (376,111,40,510,637,'PID_111_40_510_637','Akta Pencabutan Peninjauan Kembali Oleh Terdakwa'), 
							   (377,111,30,410,641,'PID_111_30_410_641','Akta Tidak / Terlambat Mengajukan Kasasi'), 
							   (379,111,30,430,4,'PID_111_30_430_4','Akta Penerimaan Memori Kasasi Terdakwa Tidak Menghadap'), 
							   (380,111,30,430,5,'PID_111_30_430_5','Akta Penerimaan Memori Kasasi Penasihat Hukum'), 
							   (381,111,30,430,6,'PID_111_30_430_6','Akta Penerimaan Memori Kasasi Penuntut Umum'), 
							   (382,111,40,510,638,'PID_111_40_510_638','Akta Pencabutan Peninjauan Kembali Oleh Ahli Waris'), 
							   (405,111,40,510,636,'PID_111_40_510_636','Akta Permintaan Peninjauan Kembali Oleh Penuntut Umum'),
							   (406,111,40,510,635,'PID_111_40_510_635','Akta Permintaan Peninjauan Kembali Oleh Kuasa Hukum Terpidana'), 
							   (407,111,40,510,634,'PID_111_40_510_634','Akta Permintaan Peninjauan Kembali Oleh Ahli Waris'), 
							   (408,111,40,510,633,'PID_111_40_510_633','Akta Permintaan Peninjauan Kembali Oleh Terpidana'), 
							   (409,111,30,410,999,'PID_111_30_410_999','Akta Pencabutan Permohonan Kasasi Oleh Penuntut Umum'), 
							   (410,111,30,410,998,'PID_111_30_410_998','Akta Pencabutan Permohonan Kasasi Oleh Kuasa Hukum'), 
							   (411,111,30,410,997,'PID_111_30_410_997','Akta Pencabutan Permohonan Kasasi Terdakwa Tidak Hadir'), 
							   (412,111,30,410,996,'PID_111_30_410_996','Akta Pencabutan Permohonan Kasasi Oleh Terdakwa'), 
							   (413,111,30,410,995,'PID_111_30_410_995','Akta Permohonan Kasasi Oleh Penuntut Umum'), 
							   (414,111,30,410,994,'PID_111_30_410_994','Akta Permohonan Kasasi Oleh Penasihat Hukum'), 
							   (415,111,30,410,993,'PID_111_30_410_993','Akta Permohonan Kasasi Terdakwa Tidak Menghadap'), 
							   (416,111,30,410,992,'PID_111_30_410_992','Akta Permohonan Kasasi Oleh Terdakwa'), 
							   (417,111,40,571,277,'PID_111_40_571_277','Relaas Pemberitahuan Putusan Peninjauan Kembali Kepada Penuntut Umum'), 
							   (418,111,40,571,278,'PID_111_40_571_278','Relaas Pemberitahuan Putusan Peninjauan Kembali Kepada Terpidana'), 
							   (420,111,30,430,3,'PID_111_30_430_3','Akta Penerimaan Memori Kasasi Terdakwa'), 
							   (422,111,10,10,10,'PID_111_10_10_10','Penetapan KPN Perkara Tidak Termasuk Wewenangnya'), 
							   (423,111,20,310,609,'PID_111_20_310_609','Akta Penerimaan Memori Banding Oleh Terdakwa'), 
							   (424,111,20,310,610,'PID_111_20_310_610','Akta Penerimaan Memori Banding Oleh Terdakwa Tidak Menghadap'), 
							   (425,111,20,310,611,'PID_111_20_310_611','Akta Penerimaan Memori Banding Oleh Penasihat Hukum'), 
							   (426,111,20,310,612,'PID_111_20_310_612','Akta Penerimaan Memori Banding Oleh Penuntut Umum'), 
							   (427,111,20,330,613,'PID_111_20_330_613','Akta Penerimaan Kontra Memori Banding Oleh Terdakwa'), 
							   (428,111,20,330,614,'PID_111_20_330_614','Akta Penerimaan Kontra Memori Banding Oleh Terdakwa Tidak Menghadap'), 
							   (429,111,20,330,615,'PID_111_20_330_615','Akta Penerimaan Kontra Memori Banding Oleh Penasihat Hukum'), 
							   (430,111,20,330,616,'PID_111_20_330_616','Akta Penerimaan Kontra Memori Banding Oleh Penuntut Umum'), 
							   (431,111,30,10,1,NULL,'Penetapan Kasasi Tidak Dapat Diterima'), 
							   (432,111,30,10,2,NULL,'Penetapan Terlambat Mengajukan Kasasi'), 
							   (433,111,30,10,3,NULL,'Penetapan Permohonan Kasasi Tidak Memenuhi Syarat Formal'), 
							   (434,111,12,200,19,'PID_111_12_200_19','Penetapan Ijin Meninggalkan Atau Keluar Tahanan'), 
							   (435,111,15,230,279,NULL,'Pemberitahuan Putusan Tk. I Kepada Terdakwa'), 
							   (436,4,14,200,314,'PDT_4_14_200_314','Berita Acara Counter Pailit'), 
							   (437,3,14,200,311,NULL,'Berita Rapat Kreditur Pertama'), 
							   (438,4,14,200,316,NULL,'Berita Rapat Kreditur Pertama'), 
							   (439,115,15,210,17,NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Terbukti'), 
							   (440,115,15,210,21,NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Lepas'), 
							   (441,117,15,210,12,NULL,'Putusan Pidana HAM - Format Biasa Bebas'), 
							   (442,117,15,210,16,NULL,'Putusan Pidana HAM - Format Biasa Terbukti'), 
							   (443,117,15,210,20,NULL,'Putusan Pidana HAM - Format Biasa Lepas'), 
							   (444,3,15,210,20,'PDT_3_15_210_20','Putusan Perdata Pailit - Kabul'), 
							   (445,3,15,210,21,'PDT_3_15_210_21','Putusan Perdata Pailit - Tolak'), 
							   (446,3,15,210,22,'PDT_3_15_210_22','Putusan Perdata Pailit Voluntair - Kabul'), 
							   (447,3,15,210,23,'PDT_3_15_210_23','Putusan Perdata Pailit Voluntair - Tolak'), 
							   (448,3,15,210,24,NULL,'Putusan Pembatalan Perdamaian - Kabul'), 
							   (449,3,15,210,25,NULL,'Putusan Pembatalan Perdamaian - Tolak'),
							   (450,3,15,210,26,'PDT_3_15_210_26','Putusan Perdata Pencabutan Kepailitan '), 
							   (451,3,15,210,27,'PDT_3_15_210_27','Putusan Perdata Pengakhiran Kepailitan'), 
							   (452,4,15,210,28,'PDT_4_15_210_28','Putusan Perdata PKPU Konter Pailit'), 
							   (453,4,15,210,29,'PDT_4_15_210_29','Putusan Perdata PKPU Menjadi Pailit'), 
							   (454,4,15,210,30,'PDT_4_15_210_30','Putusan Perdata PKPU Tetap - Kabul'), 
							   (455,4,15,210,31,'PDT_4_15_210_31','Putusan Perdata PKPU Yang Diajukan Debitor - Kabul'), 
							   (456,4,15,210,32,'PDT_4_15_210_32','Putusan Perdata PKPU Yang Diajukan Debitor - Tolak'), 
							   (457,4,15,210,33,'PDT_4_15_210_33','Putusan Perdata PKPU Yang Diajukan Kreditor - Kabul'), 
							   (458,4,15,210,34,'PDT_4_15_210_34','Putusan Perdata PKPU - Actio Pauliana'), 
							   (459,4,15,210,35,'PDT_4_15_210_35','Putusan Perdata PKPU - Homologasi'), 
							   (460,4,15,210,36,'PDT_4_15_210_36','Putusan Perdata PKPU - Rehabilitasi'), 
							   (461,4,15,210,37,NULL,'Putusan Perdata PKPU - Renvoi Prosedur'), 
							   (462,116,15,210,14,NULL,'Putusan Pidana Perikanan - Format Biasa Bebas'), 
							   (463,116,15,210,18,NULL,'Putusan Pidana Perikanan - Format Biasa Terbukti'), 
							   (464,116,15,210,22,NULL,'Putusan Pidana Perikanan - Format Biasa Lepas'), 
							   (466,6,15,210,45,'PDT_6_15_210_45','Putusan Perdata PHI - Kabul'), 
							   (467,6,15,210,46,'PDT_6_15_210_46','Putusan Perdata PHI - Tolak'), 
							   (468,6,15,210,47,'PDT_6_15_210_47','Putusan Perdata PHI - Gugur'), 
							   (469,111,30,450,1,'PID_111_30_450_1','Akta Penerimaan Kontra Memori Kasasi Terdakwa'), 
							   (470,111,30,450,2,'PID_111_30_450_2','Akta Penerimaan Kontra Memori Kasasi Terdakwa Tidak Menghadap'), 
							   (471,111,30,450,3,'PID_111_30_450_3','Akta Penerimaan Kontra Memori Kasasi Penasihat Hukum'), 
							   (472,111,30,450,4,'PID_111_30_450_4','Akta Penerimaan Kontra Memori Kasasi Penuntut Umum'), 
							   (473,1,12,20,1,'PDT_1_12_20_1','Penetapan Penunjukan Hakim atau Majelis Hakim'), 
							   (474,1,12,80,1,'PDT_1_12_80_1','Penetapan Hari Sidang Pertama'), 
							   (475,1,15,230,250,NULL,'Penetapan Konsinyasi'), 
							   (476,111,30,410,642,'PID_111_30_410_642','Surat Keterangan Terlambat Mengajukan Memori Kasasi'), 
							   (484,1,12,30,1,'PDT_1_12_30_1','Penetapan Penunjukan Panitera Pengganti'), 
							   (485,6,15,210,48,'PDT_6_15_210_48','Putusan Perdata PHI - Verstek'), 
							   (486,6,15,210,49,'PDT_6_15_210_49','Putusan Perdata PHI - Verzet Kabul'), 
							   (487,6,15,210,50,'PDT_6_15_210_50','Putusan Perdata PHI - Verzet Tolak'), 
							   (488,6,15,210,51,'PDT_6_15_210_51','Putusan Perdata PHI - Kewenangan Absolut Eksepsi Kabul'), 
							   (489,6,15,210,52,'PDT_6_15_210_52','Putusan Perdata PHI - Kewenangan Absolut Tolak'), 
							   (490,3,14,200,325,'PDT_3_14_200_325','Berita Acara Permohonan Pailit dari Kreditur Diajukan PKPU oleh Debitur'), 
							   (491,4,14,200,319,'PDT_4_14_200_319','Berita Acara Permohonan PKPU diajukan Debitor Dalam Permohonan Pailit'), 
							   (492,4,14,200,320,'PDT_4_14_200_320','Berita Acara Permohonan PKPU diajukan Kreditor Tidak Terbantah'), 
							   (493,4,14,200,323,NULL,'Berita Acara Permohonan PKPU Diajukan Kreditor Termohon Tidak Hadir'), 
							   (494,6,15,210,53,'PDT_6_15_210_53','Putusan Perdata PHI - Kewenangan Absolut Karena Jabatan (ambtshalve)'), 
							   (495,6,15,210,54,'PDT_6_15_210_54','Putusan Perdata PHI - Kewenangan Relatif Kabul'), 
							   (496,6,15,210,55,'PDT_6_15_210_55','Putusan Perdata PHI - Kewenangan Relatif Tolak'), 
							   (497,6,15,210,56,'PDT_6_15_210_56','Putusan Perdata PHI - Konvensi dan Rekonvensi'), 
							   (498,5,15,210,30,NULL,'Putusan Perdata Hak Kekayaan Intelektual (HAKI)'), 
							   (499,5,14,200,999,'PDT_5_14_200_999','Berita Acara Putusan HKI Eksepsi Tolak'), 
							   (500,111,15,230,280,NULL,'Pemberitahuan Putusan Tk. I Kepada Penuntut Umum'), 
							   (503,1,13,110,1,NULL,'Penetapan Hakim Mediator'), 
							   (504,1,15,640,4,NULL,'Penetapan Sita Jaminan (Conservatoir Beslag)'), 
							   (505,1,15,640,5,NULL,'Penetapan Sita Tahan Milik (Revindicatoir Beslag)'), 
							   (506,1,50,640,6,NULL,'Penetapan Sita Eksekusi (Eksecutorial Beslag)'), 
							   (507,1,50,640,7,NULL,'Penetapan Eksekusi Pengosongan'), 
							   (508,1,50,640,8,NULL,'Penetapan Eksekusi Riil Tanpa Didahului Sita Eksekusi'), 
							   (509,1,50,640,9,NULL,'Penetapan Eksekusi Riil Dengan Didahului Sita Eksekusi'), 
							   (510,1,50,640,10,NULL,'Penetapan Eksekusi Hak Tanggungan'), 
							   (511,1,50,640,11,NULL,'Penetapan Eksekusi Pengosongan oleh Pemenang Lelang'), 
							   (563,8,15,214,1,'PDT_8_15_214_1','Penetapan Perkara Dismissal'), 
							   (564,8,15,212,1,'PDT_8_15_212_1','Penetapan Perkara Gugur'), 
							   (565,8,15,210,1,'PDT_8_15_210_1','Putusan Perdata Gugatan Sederhana (Format Hakim Tunggal)'), 
							   (566,8,15,210,2,'PDT_8_15_210_2','Putusan Perdata Gugatan Sederhana (Format Majelis Hakim)'), 
							   (567,8,17,281,1,'PDT_8_17_281_1','Akta Penerimaan Memori Keberatan Oleh Pemohon'), 
							   (568,8,17,281,2,'PDT_8_17_281_2','Akta Penerimaan Kontra Memori Keberatan Oleh Termohon'),
							   (569,2,12,20,1,NULL,'Penetapan Penunjukan Hakim atau Majelis Hakim'), 
							   (1436,119,14,200,998,'PID_119_14_200_998','Berita Acara Persidangan Pra Peradilan'), 
							   (1437,1,14,200,102,'PDT_1_14_200_102','Relaas Panggilan Pertama Kepada Penggugat Tidak Bertemu'), 
							   (1438,1,14,200,104,'PDT_1_14_200_104','Relaas Panggilan Pertama Kepada Penggugat Meninggal Tidak Bertemu Ahli Waris'), 
							   (1439,1,14,200,105,'PDT_1_14_200_105','Relaas Penggilan Selanjutnya Kepada Penggugat Bertemu'), 
							   (1440,1,14,200,106,'PDT_1_14_200_106','Relaas Panggilan Selanjutnya Kepada Penggugat Tidak Bertemu'), 
							   (1441,1,14,200,107,'PDT_1_14_200_107','Relaas Panggilan Selanjutnya Kepada Penggugat Meninggal Bertemu Ahli Waris'), 
							   (1442,1,14,200,108,'PDT_1_14_200_108','Relaas Panggilan Selanjutnya Kepada Penggugat Meninggal Tidak Bertemu Ahli Waris'), 
							   (1443,1,14,200,110,'PDT_1_14_200_110','Relaas Panggilan Pertama Kepada Kuasa Penggugat Tidak Bertemu'), 
							   (1444,1,14,200,111,'PDT_1_14_200_111','Relaas Panggilan Pertama Kepada Kuasa Penggugat Meninggal Bertemu Penggugat'), 
							   (1445,1,14,200,112,'PDT_1_14_200_112','Relaas Panggilan Pertama Kepada Kuasa Penggugat Meninggal Tidak Bertemu Penggugat'), 
							   (1446,1,14,200,114,'PDT_1_14_200_114','Relaas Panggilan Kepada Ahli Waris Penggugat Tidak Bertemu'), 
							   (1447,1,14,200,116,'PDT_1_14_200_116','Relaas Panggilan Pertama Kepada Tergugat Tidak Bertemu'), 
							   (1448,1,14,200,118,'PDT_1_14_200_118','Relaas Panggilan Pertama Kepada Tergugat Meninggal Tidak Bertemu Ahli Waris'), 
							   (1449,1,14,200,119,'PDT_1_14_200_119','Relaas Panggilan Selanjutnya Kepada Tergugat Bertemu'), 
							   (1450,1,14,200,120,'PDT_1_14_200_120','Relaas Panggilan Selanjutnya Kepada Tergugat Tidak Bertemu'), 
							   (1451,1,14,200,121,'PDT_1_14_200_121','Relaas Panggilan Selanjutnya Kepada Tergugat Meninggal Bertemu Ahli Waris'), 
							   (1452,1,14,200,122,'PDT_1_14_200_122','Relaas Panggilan Selanjutnya Kepada Tergugat Meninggal Tidak Bertemu Ahli Waris'), 
							   (1453,1,14,200,131,'PDT_1_14_200_131','Relaas Panggilan Selanjutnya Kepada Ahli Waris Tergugat Bertemu'),
							   (1454,1,14,200,132,'PDT_1_14_200_132','Relaas Panggilan Selanjutnya Kepada Ahli Waris Tergugat Tidak Bertemu'), 
							   (1455,1,14,200,136,'PDT_1_14_200_136','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Tidak Bertemu'), 
							   (1456,1,14,200,137,'PDT_1_14_200_137','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Meninggal Bertemu Tergugat'), 
							   (1457,1,14,200,138,'PDT_1_14_200_138','Relaas Selanjutnya Kepada Kuasa Tergugat Meninggal Tidak Bertemu Tergugat'), 
							   (1458,1,15,230,1,'PDT_1_15_230_1','Relaas Pemberitahuan Putusan Kepada Penggugat'), 
							   (1459,1,15,230,202,'PDT_1_15_230_202','Relaas Pemberitahuan Putusan Kepada Penggugat Meninggal'), 
							   (1460,1,15,230,203,'PDT_1_15_230_203','Relaas Pemberitahuan Putusan Kepada Kuasa Penggugat'), 
							   (1461,1,15,230,204,'PDT_1_15_230_204','Relaas pemberitahuan Putusan Kepada Kuasa Penggugat Meninggal'), 
							   (1462,1,15,230,205,'PDT_1_15_230_205','Relaas Pemberitahuan Putusan Kepada Ahli Waris Penggugat'), 
							   (1463,1,15,230,220,'PDT_1_15_230_220','Relaas Pemberitahuan Putusan Kepada Tergugat'), 
							   (1464,1,15,230,221,'PDT_1_15_230_221','Relaas Pemberitahuan Putusan Kepada Tergugat Meninggal'), 
							   (1465,1,15,230,222,'PDT_1_15_230_222','Relaas Pemberitahuan Putusan Kepada Kuasa Tergugat'), 
							   (1466,1,15,230,223,'PDT_1_15_230_223','Relaas Pemberitahuan Putusan Kepada Tergugat Tempat Tinggal Tidak Ditemukan'), 
							   (1467,1,15,230,224,NULL,'Relaas pemberitahuan Putusan Kepada Kuasa Tergugat Meninggal'), 
							   (1468,1,15,230,225,'PDT_1_15_230_225','Relaas Pemberitahuan Putusan Kepada Ahli Waris Tergugat Meninggal'),  
							   (1469,1,15,230,230,'PDT_1_15_230_230','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Bertemu Atau Tidak Bertemu'), 
							   (1470,1,15,230,231,'PDT_1_15_230_231','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Prinsipal Meninggal'), 
							   (1471,1,15,230,232,'PDT_1_15_230_232','Relaas Pemberitahuan Putusan Verstek Kepada Ahli Waris Tergugat Meninggal'), 
							   (1472,1,15,230,233,'PDT_1_15_230_233','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Tempat Tinggal Tidak Ditemukan'), 
							   (1473,1,15,230,234,'PDT_1_15_230_234','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Cerai Tempat Tinggal Tidak Ditemukan'), 
							   (1474,5,15,210,38,'PDT_5_15_210_38','Putusan Perdata HKI Kabul'), 
							   (1475,5,15,210,39,'PDT_5_15_210_39','Putusan Perdata HKI Tolak'), 
							   (1476,5,15,210,40,'PDT_5_15_210_40','Putusan Perdata HKI NO'), 
							   (1477,111,40,510,639,'PID_111_40_510_639','Akta Pencabutan Peninjauan Kembali Oleh Penasihat Hukum'), 
							   (1478,111,40,510,640,'PID_111_40_510_640','Akta Pencabutan Peninjauan Kembali Oleh Penuntut Umum'), 
							   (1479,119,12,20,1,'PID_119_12_20_1','Penetapan Penunjukan Majelis Hakim atau Hakim Tunggal Tanpa Kuasa'), 
							   (1480,119,12,30,1,'PID_119_12_30_1','Penetapan Hari Sidang Pertama'), 
							   (1481,119,14,200,1,'PID_119_14_200_1','Relaas Panggilan Kepada Pemohon'), 
							   (1482,119,14,200,2,'PID_119_14_200_2','Relaas Panggilan Kepada Pemohon Tidak Bertemu'), 
							   (1483,119,14,200,3,'PID_119_14_200_3','Relaas Panggilan Kepada Termohon'), 
							   (1484,119,15,210,1,'PID_119_15_210_1','Putusan Praperadilan (Format Gugur)'), 
							   (1485,119,15,210,2,'PID_119_15_210_2','Putusan Praperadilan (Format Kabul/Tolak)'), 
							   (1486,119,15,212,1,'PID_119_15_212_1','Putusan Praperadilan (Format Penetapan Gugur)'), 
							   (1487,120,10,10,1,'K_120_10_10_1','Penetapan Pengembalian Berkas Perkara'), 
							   (1489,120,10,10,3,'K_120_10_10_3','Penetapan Pengembalian Berkas Perkara (BAP Tidak Lengkap)'), 
							   (1490,120,12,20,1,'K_120_12_20_1','Penetapan Penunjukan Majelis Hakim '), 
							   (1491,120,12,20,2,'K_120_12_20_2','Penunjukan Hakim Tunggal'), 
							   (1492,120,12,30,1,'K_120_12_30_1','Penetapan Penunjukan Panitera'), 
							   (1493,120,12,80,1,'K_120_12_80_1','Penetapan Hari Sidang'), 
							   (1494,120,12,200,1,'K_120_12_200_1','Penetapan Terdakwa Tidak Mau Didampingi Penasihat Hukum'), 
							   (1495,120,14,200,1,'K_120_14_200_1','Berita Acara Penolakan Didampingi Penasihat Hukum'), 
							   (1496,120,12,200,2,'K_120_12_200_2','Penetapan Penahanan Oleh Hakim Ketua'), 
							   (1497,120,12,200,3,'K_120_12_200_3','Penetapan Perpanjangan Penahanan Oleh Kadilmil'), 
							   (1498,120,12,200,4,'K_120_12_200_4','Penetapan Pembebasan dari Tahanan Oleh Hakim Ketua'), 
							   (1499,120,12,200,5,'K_120_12_200_5','Penetapan Pembebasan dari Tahanan Oleh Kadilmil'), 
							   (1500,120,12,200,6,'K_120_12_200_6','Penetapan Menjalani Pidana'), 
							   (1501,120,10,10,4,'K_120_10_10_4','Berita Acara Perubahan Surat Dakwaan'), 
							   (1502,120,10,10,5,'K_120_10_10_5','Akta Penerimaan Perubahan Surat Dakwaan'), 
							   (1503,120,15,210,1,'K_120_15_210_1','Putusan Sela'), 
							   (1504,120,16,240,1,'K_120_16_240_1','Akta Permohonan Perlawanan'), 
							   (1505,120,16,240,2,'K_120_16_240_2','Akta Pemberitahuan Permohonan Perlawanan'), 
							   (1506,120,16,240,3,'K_120_16_240_3','Akta Penerimaan Memori Perlawanan'), 
							   (1507,120,16,240,4,'K_120_16_240_4','Akta Pemberitahuan Isi Putusan Perlawanan Kepada Terdakwa'), 
							   (1508,120,16,240,5,'K_120_16_240_5','Akta Pemberitahuan Isi Putusan Perlawanan Kepada Oditur'), 
							   (1509,120,15,210,2,'K_120_15_210_2','Putusan (Terdakwa Tidak Hadir)'), 
							   (1510,120,10,10,6,'K_120_10_10_6','Penetapan Penggabungan Perkara Gugatan Ganti Rugi'), 
							   (1511,120,14,200,2,'K_120_14_200_2','Berita Acara Sidang'), 
							   (1512,120,14,200,3,'K_120_14_200_3','Berita Acara Sidang Lanjutan'), 
							   (1513,120,14,200,4,'K_120_14_200_4','Berita Acara Sidang Majelis'), 
							   (1514,121,15,210,1,'P_121_15_210_1','Putusan (Pelanggaran)'), 
							   (1515,120,15,210,3,'K_120_15_210_3','Putusan N.O.'), 
							   (1516,120,15,210,4,'K_120_15_210_4','Putusan (Terdakwa Meninggal Dunia)'), 
							   (1517,120,15,210,5,'K_120_15_210_5','Putusan (Susunan Dakwaan Komulatif / Variatif)'), 
							   (1518,120,15,210,6,'K_120_15_210_6','Putusan'), 
							   (1519,120,15,210,7,'K_120_15_210_7','Petikan Putusan'), 
							   (1520,120,15,210,8,'K_120_15_210_8','Putusan Perbedaan Pendapat'), 
							   (1521,120,16,240,6,'K_120_16_240_6','Akta Menerima Putusan Oleh Terdakwa'), 
							   (1522,120,16,240,7,'K_120_16_240_7','Akta Menerima Putusan Oleh Oditur'), 
							   (1523,120,16,240,8,'K_120_16_240_8','Akta Putusan Telah Memperoleh Kekuatan Hukum Tetap'), 
							   (1524,120,16,240,9,'K_120_16_240_9','Akta Putusan Telah Memperoleh Kekuatan Hukum Tetap (Putusan Bebas)'), 
							   (1525,120,20,400,1,'K_120_20_400_1','Akta Pemberitahuan Isi Putusan Banding Kepada Terdakwa'), 
							   (1526,120,20,400,2,'K_120_20_400_2','Akta Pemberitahuan Isi Putusan Banding Kepada Oditur'),
							   (1527,120,20,400,3,'K_120_20_400_3','Pengumuman Pertama'), 
							   (1528,120,20,400,4,'K_120_20_400_4','Pengumuman Terakhir'), 
							   (1529,120,14,200,5,'K_120_14_200_5','Berita Acara Pengumuman Putusan'), 
							   (1530,120,20,290,1,'K_120_20_290_1','Akta Permohonan Banding Oleh Terdakwa'), 
							   (1531,120,20,290,2,'K_120_20_290_2','Akta Permohonan Banding Oleh Oditur'), 
							   (1532,120,20,300,1,'K_120_20_300_1','Akta Pemberitahuan Permohonan Banding Untuk Oditur'), 
							   (1533,120,20,300,2,'K_120_20_300_2','Akta Pemberitahuan Permohonan Banding Untuk Terdakwa'), 
							   (1534,120,20,290,3,'K_120_20_290_3','Akta Pencabutan Permohonan Banding Untuk Terdakwa'), 
							   (1535,120,20,290,4,'K_120_20_290_4','Akta Pencabutan Permohonan Banding Untuk Oditur'), 
							   (1536,120,20,300,3,'K_120_20_300_3','Akta Pemberitahuan Pencabutan Permohonan Banding Untuk Terdakwa'), 
							   (1537,120,20,300,4,'K_120_20_300_4','Akta Pemberitahuan Pencabutan Permohonan Banding Untuk Oditur'), 
							   (1538,120,20,310,1,'K_120_20_310_1','Akta Penerimaan Memori Banding Untuk Terdakwa'), 
							   (1539,120,20,310,2,'K_120_20_310_2','Akta Penerimaan Memori Banding Untuk Oditur'), 
							   (1540,120,20,330,1,'K_120_20_330_1','Akta Penerimaan Kontra Memori Banding Untuk Terdakwa'), 
							   (1541,120,20,330,2,'K_120_20_330_2','Akta Penerimaan Kontra Memori Banding Untuk Oditur'), 
							   (1542,120,20,290,5,'K_120_20_290_5','Akta Penolakan Permohonan Banding Untuk Terdakwa'), 
							   (1543,120,20,290,6,'K_120_20_290_6','Akta Penolakan Permohonan Banding Untuk Oditur'), 
							   (1544,120,20,340,1,'K_120_20_340_1','Akta Pemberitahuan Kontra Memori Banding Untuk Terdakwa'), 
							   (1545,120,20,340,2,'K_120_20_340_2','Akta Pemberitahuan Kontra Memori Banding Untuk Oditur '), 
							   (1546,120,20,350,1,'K_120_20_350_1','Akta Telah Mempelajari Berkas Perkara Banding Untuk Terdakwa'), 
							   (1547,120,20,350,2,'K_120_20_350_2','Akta Telah Mempelajari Berkas Perkara Banding Untuk Oditur'), 
							   (1548,120,20,350,3,'K_120_20_350_3','Akta Meneliti Keaslian Berkas Perkara'), 
							   (1549,120,30,500,1,'K_120_30_500_1','Akta Pemberitahuan Isi Putusan Kasasi Untuk Terdakwa'), 
							   (1550,120,30,500,2,'K_120_30_500_2','Akta Pemberitahuan Isi Putusan Kasasi Untuk Oditur'), 
							   (1551,120,30,500,4,'K_120_30_500_4','Akta Berkekuatan Hukum Tetap Untuk Terdakwa (Kasasi)'), 
							   (1552,120,30,410,1,'K_120_30_410_1','Akta Permohonan Kasasi Untuk Terdakwa'), 
							   (1553,120,30,410,2,'K_120_30_410_2','Akta Permohonan Kasasi Untuk Oditur'), 
							   (1554,120,30,420,1,'K_120_30_420_1','Akta Pemberitahuan Permohonan Kasasi Untuk Terdakwa'), 
							   (1555,120,30,420,2,'K_120_30_420_2','Akta Pemberitahuan Permohonan Kasasi Untuk Oditur'), 
							   (1556,120,30,410,3,'K_120_30_410_3','Akta Pencabutan Permohonan Kasasi Untuk Terdakwa'), 
							   (1557,120,30,410,4,'K_120_30_410_4','Akta Pencabutan Permohonan Kasasi Untuk Oditur'), 
							   (1558,120,30,500,3,'K_120_30_500_3','Berita Acara Menolak Menandatangani Akta Pemberitahuan Isi Putusan Kasasi'), 
							   (1559,120,30,420,3,'K_120_30_420_3','Akta Pemberitahuan Pencabutan Permohonan Kasasi Untuk Terdakwa'), 
							   (1560,120,30,420,4,'K_120_30_420_4','Akta Pemberitahuan Pencabutan Permohonan Kasasi Untuk Oditur'), 
							   (1561,120,30,430,1,'K_120_30_430_1','Akta Penerimaan Memori Kasasi Untuk Terdakwa'), 
							   (1562,120,30,430,2,'K_120_30_430_2','Akta Penerimaan Memori Kasasi Untuk Oditur'), 
							   (1563,120,30,450,1,'K_120_30_450_1','Akta Penerimaan Kontra Memori Kasasi Untuk Terdakwa'), 
							   (1564,120,30,450,2,'K_120_30_450_2','Akta Penerimaan Kontra Memori Kasasi Untuk Oditur'), 
							   (1565,120,30,460,1,'K_120_30_460_1','Akta Pemberitahuan Kontra Memori Kasasi Untuk Terdakwa'), 
							   (1566,120,30,460,2,'K_120_30_460_2','Akta Pemberitahuan Kontra Memori Kasasi Untuk Oditur'), 
							   (1567,120,30,430,5,'K_120_30_430_5','Akta Penerimaan Risalah Kasasi'), 
							   (1568,120,30,410,5,'K_120_30_410_5','Akta Terlambat Mengajukan Permohonan Kasasi Untuk Terdakwa'), 
							   (1569,120,30,410,6,'K_120_30_410_6','Akta Terlambat Mengajukan Permohonan Kasasi Untuk Oditur'), 
							   (1570,120,30,430,3,'K_120_30_430_3','Akta Tidak Menyerahkan Memori Kasasi Untuk Terdakwa'), 
							   (1571,120,30,410,7,'K_120_30_410_7','Penetapan Permohonan Kasasi Tidak Dapat Diterima'), 
							   (1572,120,30,460,3,'K_120_30_460_3','Akta Tidak Menyerahkan Kontra Memori Kasasi Untuk Terdakwa'), 
							   (1573,120,30,430,4,'K_120_30_430_4','Akta Terlambat Penyerahan Memori Kasasi Untuk Terdakwa'),
							   (1574,120,40,510,1,'K_120_40_510_1','Akta Permohonan Peninjauan Kembali'), 
							   (1575,120,40,510,2,'K_120_40_510_2','Penetapan Pelimpahan Pemeriksaan Pemeriksaan Perkara Peninjauan Kembali'), 
							   (1576,120,40,520,1,'K_120_40_520_1','Akta Pemberitahuan Peninjauan Kembali'), 
							   (1577,120,40,510,3,'K_120_40_510_3','Penetapan Penunjukan Hakim Untuk Memeriksa Permohonan Peninjauan Kembali'), 
							   (1578,120,40,510,4,'K_120_40_510_4','Penetapan Hari Sidang Untuk Memeriksa Permohonan Peninjauan Kembali'), 
							   (1579,120,40,520,3,'K_120_40_520_3','Berita Acara Pemeriksaan Peninjauan Kembali'), 
							   (1580,120,40,520,2,'K_120_40_520_2','Berita Acara Pendapat Peninjauan Kembali'), 
							   (1581,120,20,320,1,'K_120_20_320_1','Akta Pemberitahuan Memori Banding Untuk Terdakwa'), 
							   (1582,120,20,320,2,'K_120_20_320_2','Akta Pemberitahuan Memori Banding Untuk Oditur'), 
							   (1583,9,13,114,1,'G_9_13_114_1','Penetapan Sidang Pertama Perlawanan'), 
							   (1585,9,10,10,1,'G_9_10_10_1','Resume Gugatan (Meja I)'), 
							   (1590,9,10,10,2,'G_9_10_10_2','Penetapan Permohonan Acara Cepat dikabulkan/Pen. Majelis Hakim Tunggal'), 
							   (1591,9,10,10,3,'G_9_10_10_3','Penetapan Permohonan Acara Cepat ditolak/Pen. Majelis Hakim Acara Biasa'), 
							   (1594,9,10,10,8,'G_9_10_10_8','Penetapan Penundaan Keputusan TUN dikabulkan oleh Ketua'), 
							   (1595,9,12,16,1,'G_9_12_16_1','Penetapan Lolos Dismissal'), 
							   (1596,9,12,16,2,'G_9_12_16_2','Penetapan Dismissal'), 
							   (1597,9,12,15,1,'G_9_12_15_1','Surat Panggilan Proses Dissmisal kepada Penggugat'), 
							   (1598,9,12,15,2,'G_9_12_15_2','Surat Panggilan Proses Dissmisal kepada Tergugat'), 
							   (1601,9,10,16,5,'G_9_10_16_5','Berita Acara Proses Dismissal Tunda'), 
							   (1602,9,10,16,6,'G_9_10_16_6','Berita Acara Proses Dismissal Pembacaan Penetapan'), 
							   (1603,9,10,16,7,'G_9_10_16_7','Penetapan Penunjukan Majelis Hakim Acara Singkat (perlawanan)'), 
							   (1604,9,10,16,8,'G_9_10_16_8','Surat Penunjukan Panitera/Panitera Pengganti Acara Singkat'), 
							   (1605,9,10,16,9,'G_9_10_16_9','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Singkat'), 
							   (1606,9,13,112,1,'G_9_13_112_1','Surat Penunjukan Panitera Pengganti Perlawanan'), 
							   (1612,9,14,115,1,'G_9_14_115_1','Berita Acara Sidang Perlawanan 1 (Acara Singkat) Tunda'), 
							   (1613,9,14,115,2,'G_9_14_115_2','Berita Acara Sidang Perlawanan 2 (Acara Singkat) Tunda'), 
							   (1614,9,14,115,3,'G_9_14_115_3','Berita Acara Sidang Perlawanan 3 (Acara Singkat) Putusan'), 
							   (1615,9,15,219,1,'G_9_15_219_1','Putusan Perlawanan Diterima'), 
							   (1616,9,15,219,1,'G_9_15_219_2','Putusan Perlawanan Ditolak'), 
							   (1617,9,15,231,1,'G_9_15_231_1','Surat Pemberitahuan Putusan Perlawanan kepada Penggugat'), 
							   (1618,9,15,232,1,'G_9_15_232_1','Surat Pemberitahuan Putusan Perlawanan kepada Tergugat'), 
							   (1620,9,12,30,1,'G_9_12_30_1','Surat Penunjukan Panitera/Panitera Pengganti Acara Cepat'), 
							   (1621,9,12,30,2,'G_9_12_30_2','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Cepat'), 
							   (1622,9,14,200,1,'G_9_14_200_27','BAP Acara Cepat 1 Tunda'), 
							   (1623,9,14,200,2,'G_9_14_200_28','BAP Acara Cepat 2 Tunda'), 
							   (1624,9,14,200,3,'G_9_14_200_29','BAP Acara Cepat 3 Putusan'), 
							   (1625,9,15,210,1,'G_9_15_210_1','Putusan Acara Cepat'), 
							   (1626,9,12,20,1,'G_9_12_20_1','Penetapan Majelis Hakim'), 
							   (1627,9,12,16,3,'G_9_12_16_3','Pemberitahuan Penetapan Dismissal Untuk Penggugat'), 
							   (1628,9,12,16,4,'G_9_12_16_4','Pemberitahuan Penetapan Dismissal Untuk Tergugat'), 
							   (1631,9,12,30,3,'G_9_12_30_3','Surat Penunjukan Panitera/Panitera Pengganti'), 
							   (1632,9,12,40,1,'G_9_12_40_1','Surat Penunjukan Juru Sita/Juru Sita Pengganti'), 
							   (1633,9,12,42,1,'G_9_12_42_1','Penetapan Hari Pemeriksaan Persiapan'), 
							   (1640,9,12,42,2,'G_9_12_42_2','Surat Panggilan Pemeriksaan Persiapan kepada Penggugat'), 
							   (1641,9,12,42,3,'G_9_12_42_3','Surat Panggilan Pemeriksaan Persiapan kepada Tergugat'), 
							   (1646,9,14,200,4,'G_9_14_200_30','Berita Acara Pemeriksaan Persiapan I'), 
							   (1647,9,14,200,5,'G_9_14_200_31','Berita Acara Pemeriksaan Persiapan II'), 
							   (1648,9,14,200,6,'G_9_14_200_6','Berita Acara Pemeriksaan Persiapan III'), 
							   (1649,9,14,200,7,'G_9_14_200_7','Berita Acara Pemeriksaan Persiapan IV '), 
							   (1650,9,14,200,8,'G_9_14_200_8','Berita Acara Pemeriksaan Persiapan V (Pembacaan Putusan Tidak Dapat Diterima) '), 
							   (1652,9,15,210,2,'G_9_15_210_2','Putusan Sela Tidak Dapat Diterima'), 
							   (1653,9,14,80,2,'G_9_14_80_2','Penetapan Hari Persidangan Pertama'), 
							   (1654,9,14,200,1,'G_9_14_200_1','Surat Panggilan Sidang kepada Penggugat'), 
							   (1655,9,14,200,2,'G_9_14_200_2','Surat Panggilan Sidang kepada Tergugat'), 
							   (1656,9,14,200,3,'G_9_14_200_3','Surat Panggilan Sidang kepada Intervensi'), 
							   (1657,9,14,200,4,'G_9_14_200_4','Surat Panggilan Saksi'), 
							   (1658,9,14,200,5,'G_9_14_200_5','Surat Panggilan Ahli'), 
							   (1659,9,14,200,9,'G_9_14_200_9','BAP  Pembacaan Gugatan'), 
							   (1660,9,14,200,10,'G_9_14_200_10','BAP  Pembacaan Jawaban'), 
							   (1665,9,14,200,11,'G_9_14_200_11','BAP Putusan Sela Penetapan Pihak Intervensi'), 
							   (1666,9,14,200,12,'G_9_14_200_12','BAP Putusan Sela Penetapan Penundaan KTUN'), 
							   (1667,9,14,200,13,'G_9_14_200_13','BAP Penyerahan Replik'),
		                       (1668,9,14,200,14,'G_9_14_200_14','BAP Penyerahan Duplik'), 
							   (1669,9,14,200,15,'G_9_14_200_15','BAP Pencabutan Gugatan'), 
							   (1670,9,12,211,1,'G_9_12_211_1','Putusan Sela Penetapan Pencabutan Gugatan Dikabulkan'), 
							   (1671,9,14,200,16,'G_9_14_200_16','BAP Penyerahan Bukti P'), 
							   (1672,9,14,200,17,'G_9_14_200_17','BAP Penyerahan Bukti T'), 
							   (1673,9,14,200,18,'G_9_14_200_18','BAP Penyerahan Bukti TII Intervensi'), 
							   (1674,9,14,200,19,'G_9_14_200_19','BAP Penyerahan Bukti P dan Bukti T'), 
							   (1675,9,14,200,20,'G_9_14_200_20','BAP Penyerahan Bukti P, Bukti T dan Bukti TII Intervensi'), 
							   (1676,9,14,200,21,'G_9_14_200_21','BAP Pemeriksaan Saksi P'), 
							   (1677,9,14,200,22,'G_9_14_200_22','BAP Pemeriksaan Saksi T'), 
							   (1678,9,14,200,23,'G_9_14_200_23','BAP Pemeriksaan Saksi P dan Saksi T'), 
							   (1679,9,14,200,24,'G_9_14_200_24','BAP Pemeriksaan Saksi P, Saksi T dan Saksi TII Intervensi'), 
							   (1680,9,14,200,25,'G_9_14_200_25','BAP Kesimpulan'), 
							   (1681,9,14,200,26,'G_9_14_200_26','BAP Putusan'), 
							   (1682,9,15,210,3,'G_9_15_210_3','Putusan Dikabulkan'), 
							   (1683,9,15,210,4,'G_9_15_210_4','Putusan Ditolak'), 
							   (1684,9,15,210,5,'G_9_15_210_5','Putusan Gugur'), 
							   (1685,9,15,218,1,'G_9_15_218_1','Surat Pemberitahuan Amar Putusan kepada Penggugat'), 
							   (1686,9,15,218,2,'G_9_15_218_2','Surat Pemberitahuan Amar Putusan kepada Tergugat'), 
							   (1687,9,15,233,1,'G_9_15_233_1','Surat Pemberitahuan Amar Putusan kepada Tergugat II Intervensi'), 
							   (1688,9,20,290,1,'G_9_20_290_1','Surat keterangan lewat waktu banding'), 
							   (1689,9,20,290,2,'G_9_20_290_2','Akta Permohonan Banding oleh Penggugat'), 
							   (1690,9,20,290,3,'G_9_20_290_3','Akta Permohonan Banding oleh Kuasa Penggugat'), 
							   (1691,9,20,290,4,'G_9_20_290_4','Akta Permohonan Banding oleh Tergugat'), 
							   (1692,9,20,290,5,'G_9_20_290_5','Akta Permohonan Banding oleh Kuasa Tergugat'), 
							   (1693,9,20,300,1,'G_9_20_300_1','Surat pemberitahuan pernyataan banding kepada penggugat/Terbanding'), 
							   (1694,9,20,300,2,'G_9_20_300_2','Surat pemberitahuan pernyataan banding kepada kuasa penggugat'), 
							   (1695,9,20,300,3,'G_9_20_300_3','Surat pemberitahuan pernyataan banding kepada Tergugat'), 
							   (1696,9,20,300,4,'G_9_20_300_4','Surat pemberitahuan pernyataan banding kepada Kuasa Tergugat atau Tergugat II Intervensi'), 
							   (1697,9,20,320,1,'G_9_20_320_1','Surat pemberitahuan memori banding kepada penggugat'), 
							   (1698,9,20,320,2,'G_9_20_320_2','Surat pemberitahuan memori banding kepada kuasa penggugat'), 
							   (1699,9,20,320,3,'G_9_20_320_3','Surat pemberitahuan memori banding kepada tergugat atau tergugat II intervensi'), 
							   (1700,9,20,320,4,'G_9_20_320_4','Surat pemberitahuan memori banding kepada kuasa tergugat atau tergugat II intervensi'), 
							   (1703,9,20,340,1,'G_9_20_340_1','Surat pemberitahuan kontra memori banding kepada penggugat'), 
							   (1704,9,20,340,2,'G_9_20_340_2','Surat pemberitahuan kontra memori banding kepada kuasa penggugat'), 
							   (1711,9,20,340,3,'G_9_20_340_3','Surat pemberitahuan kontra memori banding kepada tergugat atau tergugat II intervensi'), 
							   (1712,9,20,340,4,'G_9_20_340_4','Surat pemberitahuan kontra memori banding kepada kuasa tergugat atau tergugat II intervensi'), 
							   (1713,9,20,360,1,'G_9_20_360_1','Surat pemberitahuan melihat berkas perkara kepada penggugat'), 
							   (1714,9,20,360,2,'G_9_20_360_2','Surat pemberitahuan melihat berkas perkara kepada kuasa penggugat'), 
							   (1715,9,20,360,3,'G_9_20_360_3','Surat pemberitahuan melihat berkas perkara kepada tergugat atau tergugat II intervensi'), 
							   (1716,9,20,360,4,'G_9_20_360_4','Surat pemberitahuan melihat berkas perkara kepada kuasa tergugat atau tergugat II intervensi'), 
							   (1717,9,13,111,1,'G_9_13_111_1','Penetapan Majelis Hakim Perlawanan'), 
							   (1718,9,12,80,1,'G_9_12_80_1','Penetapan Hari Sidang Pertama'), 
							   (1720,9,12,20,2,'G_9_12_20_2','Penetapan Penunjukan Hakim Tunggal'), 
							   (1722,9,12,21,1,'G_9_12_21_1','Penetapan Kembali Majelis Hakim'), 
							   (1723,9,20,400,1,'G_9_20_400_1','Surat pemberitahuan putusan banding kepada penggugat'), 
							   (1724,9,20,400,2,'G_9_20_400_2','Surat pemberitahuan putusan banding kepada kuasa penggugat'), 
							   (1725,9,20,400,3,'G_9_20_400_3','Surat pemberitahuan putusan banding kepada tergugat atau atau Tergugat II Intervensi'), 
							   (1726,9,20,400,4,'G_9_20_400_4','Surat pemberitahuan putusan banding kepada kuasa tergugat atau atau Tergugat II Intervensi'), 
							   (1727,9,30,410,1,'G_9_30_410_1','Akta permohonan kasasi oleh penggugat'), 
							   (1728,9,30,410,2,'G_9_30_410_2','Akta permohonan kasasi oleh kuasa penggugat'), 
							   (1729,9,30,410,3,'G_9_30_410_3','Akta permohonan kasasi oleh Tergugat'), 
							   (1730,9,30,410,4,'G_9_30_410_4','Akta permohonan kasasi oleh kuasa Tergugat'), 
							   (1739,9,30,420,1,'G_9_30_420_1','Surat pemberitahuan pernyataan kasasi Kepada penggugat'), 
							   (1740,9,30,420,2,'G_9_30_420_2','Surat pemberitahuan pernyataan kasasi Kepada kuasa penggugat'), 
							   (1741,9,30,420,3,'G_9_30_420_3','Surat pemberitahuan pernyataan kasasi Kepada Tergugat'), 
							   (1742,9,30,420,4,'G_9_30_420_4','Surat pemberitahuan pernyataan kasasi Kepada kuasa Tergugat'), 
							   (1747,9,30,410,5,'G_9_30_410_5','Penetapan Tidak Memenuhi syarat Formil karena terlambat mengajukan permohonan kasasi'), 
							   (1748,9,30,410,6,'G_9_30_410_6','Penetapan Tidak Memenuhi syarat Formil karena tidak atau terlambat mengajukan memori kasasi'), 
							   (1749,9,30,410,7,'G_9_30_410_7','Penetapan Pasal 45'), 
							   (1750,9,30,430,1,'G_9_30_430_1','Surat pemberitahuan dan penyerahan memori kasasi kepada penggugat'), 
							   (1754,9,30,430,2,'G_9_30_430_2','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa penggugat'), 
							   (1755,9,30,430,3,'G_9_30_430_3','Surat pemberitahuan dan penyerahan memori kasasi kepada tergugat atau tergugat intervensi'), 
							   (1756,9,30,430,4,'G_9_30_430_4','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa tergugat atau tergugat intervensi'), 
							   (1759,9,30,460,1,'G_9_30_460_1','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada penggugat'), 
							   (1760,9,30,460,2,'G_9_30_460_2','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa penggugat'), 
							   (1761,9,30,460,3,'G_9_30_460_3','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada tergugat atau tergugat intervensi'), 
							   (1762,9,30,460,4,'G_9_30_460_4','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa tergugat atau tergugat intervensi'), 
							   (1763,9,30,500,1,'G_9_30_500_1','Surat pemberitahuan putusan kasasi kepada penggugat'), 
							   (1764,9,30,500,2,'G_9_30_500_2','Surat pemberitahuan putusan kasasi kepada kuasa penggugat'), 
							   (1765,9,30,500,3,'G_9_30_500_3','Surat pemberitahuan putusan kasasi kepada tergugat atau tergugat intervensi'), 
							   (1766,9,30,500,4,'G_9_30_500_4','Surat pemberitahuan putusan kasasi kepada kuasa tergugat atau tergugat intervensi'), 
							   (1767,9,40,510,1,'G_9_40_510_1','Akta Permohonan Peninjauan Kembali Penggugat'), 
							   (1768,9,40,520,1,'G_9_40_520_1','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Penggugat'), 
							   (1769,9,40,540,1,'G_9_40_540_1','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Penggugat'), 
							   (1770,9,40,510,6,'G_9_40_510_6','Akta pencabutan permohonan  PK Penggugat'), 
							   (1775,9,40,510,9,'G_9_40_510_9','Surat pemberitahuan pencabutan permohonan PK'), 
							   (1776,9,40,571,1,'G_9_40_571_1','Surat Pemberitahuan Putusan PK Kepada Penggugat'), 
							   (1777,9,50,600,1,'G_9_50_600_1','Surat panggilan eksekusi'), 
							   (1779,9,50,600,2,'G_9_50_600_2','Surat pengumuman eksekusi di media '), 
							   (1780,9,12,20,3,'G_9_12_20_3','Penetapan Majelis Hakim Penolakan Acara Singkat'), 
							   (1782,9,10,10,7,'G_9_10_10_7','Surat pemberitahuan perkara KIP'), 
							   (1814,9,12,200,2,'G_9_12_200_2','Surat Teguran Pelaksanaan  Penundaan Keputusan TUN'), 
							   (1815,9,10,10,6,'G_9_10_10_6','Penetapan izin kuasa insidentil'), 
							   (1817,9,50,600,3,'G_9_50_600_3','Penetapan Permohonan Eksekusi'), 
							   (1818,9,50,610,1,'G_9_50_610_1','Surat Eksekusi otomatis (Pengawasan Pelaksanaan eksekusi)'), 
							   (1819,9,50,610,2,'G_9_50_610_2','Surat meminta penjelasan (Pengawasan Pelaksanaan eksekusi)'), 
							   (1820,9,50,610,3,'G_9_50_610_3','Surat teguran (Pengawasan Pelaksanaan eksekusi)'), 
							   (1821,9,50,610,4,'G_9_50_610_4','Surat ke Presiden  (Pengawasan Pelaksanaan eksekusi)'), 
							   (1822,9,50,610,5,'G_9_50_610_5','Surat ke DPR  (Pengawasan Pelaksanaan eksekusi)'), 
							   (1825,9,12,31,1,'G_9_12_31_1','Surat Pergantian Penunjukkan Panitera Pengganti'), 
							   (1826,9,10,16,10,'G_9_10_16_10','Berita Acara Proses Dismisal Tunda 2'), 
							   (1828,9,50,615,1,'G_9_50_615_1','Penetapan Eksekusi'), 
							   (1829,9,20,290,6,'G_9_20_290_6','Akta Permohonan Banding oleh Intervensi'), 
							   (1830,9,20,290,7,'G_9_20_290_7','Akta Permohonan Banding oleh Kuasa Intervensi'), 
							   (1834,9,30,420,5,'G_9_30_420_5','Surat pemberitahuan pernyataan kasasi Kepada Intervensi'), 
							   (1835,9,40,510,2,'G_9_40_510_2','Akta Permohonan Peninjauan Kembali Kuasa Penggugat'), 
							   (1836,9,40,510,3,'G_9_40_510_3','Akta Permohonan Peninjauan Kembali Tergugat'), 
							   (1837,9,40,510,4,'G_9_40_510_4','Akta Permohonan Peninjauan Kembali Kuasa Tergugat'), 
							   (1838,9,40,520,2,'G_9_40_520_2','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Penggugat'), 
							   (1839,9,40,520,3,'G_9_40_520_3','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Tergugat'), 
							   (1840,9,40,520,4,'G_9_40_520_4','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Tergugat'), 
							   (1841,9,40,540,2,'G_9_40_540_2','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Penggugat'), 
							   (1842,9,40,540,3,'G_9_40_540_3','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Tergugat'), 
							   (1843,9,40,540,4,'G_9_40_540_4','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Tergugat'), 
							   (1844,9,40,571,2,'G_9_40_571_2','Surat Pemberitahuan Putusan PK Kepada Kuasa Penggugat'), 
							   (1845,9,40,571,3,'G_9_40_571_3','Surat Pemberitahuan Putusan PK Kepada Tegugat'), 
							   (1846,9,40,571,4,'G_9_40_571_4','Surat Pemberitahuan Putusan PK Kepada Kuasa Tergugat'), 
							   (1847,9,40,510,5,'G_9_40_510_5','Akta Permohonan Peninjauan Kembali Intervensi'), 
							   (1848,9,40,520,5,'G_9_40_520_5','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Pihak Intervensi'), 
							   (1849,9,20,290,8,'G_9_20_290_8','Akta Pencabutan Permohonan Banding Penggugat'), 
							   (1850,9,20,290,9,'G_9_20_290_9','Akta Pencabutan Permohonan Banding Kuasa Penggugat'), 
							   (1851,9,20,290,10,'G_9_20_290_10','Akta Pencabutan Permohonan Banding Tergugat'), 
							   (1852,9,20,290,11,'G_9_20_290_11','Akta Pencabutan Permohonan Banding Kuasa Tergugat'), 
							   (1853,9,20,290,12,'G_9_20_290_12','Akta Pencabutan Permohonan Banding Intervensi'), 
							   (1854,9,30,461,1,'G_9_30_461_1','Surat pemberitahuan melihat berkas perkara kepada Penggugat'), 
							   (1855,9,30,461,2,'G_9_30_461_2','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'), 
							   (1856,9,30,461,3,'G_9_30_461_3','Surat pemberitahuan melihat berkas perkara kepada Tergugat'), 
							   (1857,9,30,461,4,'G_9_30_461_4','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'), 
							   (1858,9,30,461,5,'G_9_30_260_5','Surat pemberitahuan melihat berkas perkara kepada Intervensi'), 
							   (1859,9,10,10,9,'G_9_10_10_9','Penetapan Penundaan Pelaksanaan Keputusan TUN Ditolak oleh Ketua'), 
							   (1860,9,12,211,2,'G_9_12_211_2','Putusan Sela Penetapan Pencabutan Gugatan Ditolak'), 
							   (1861,9,12,211,3,'G_9_12_211_3','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Dikabulkan oleh Majelis Hakim'), 
							   (1862,9,12,211,4,'G_9_12_211_4','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Ditolak oleh Majelis Hakim'), 
							   (1863,9,12,211,5,'G_9_12_211_5','Putusan Sela Penetapan Pihak Intervensi dikabulkan'), 
							   (1864,9,12,211,6,'G_9_12_211_6','Putusan Sela Penetapan Pihak Intervensi ditolak'), 
							   (1865,9,30,410,8,'G_9_30_410_8','Akta Pencabutan Permohonan Kasasi oleh Penggugat'), 
							   (1866,9,30,410,9,'G_9_30_410_9','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'), 
							   (1867,9,30,410,10,'G_9_30_410_10','Akta Pencabutan Permohonan Kasasi oleh  Tergugat'), 
							   (1868,9,30,410,11,'G_9_30_410_11','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'), 
							   (1869,9,30,410,12,'G_9_30_410_12','Akta Pencabutan Permohonan Kasasi oleh  Intervensi'), 
							   (1870,9,30,500,5,'G_9_30_500_5','Surat Pemberitahuan Putusan Kasasi kepada Intervensi'), 
							   (1871,9,30,430,5,'G_9_30_430_5','Surat pemberitahuan dan penyerahan memori kasasi kepda Intervensi'),
							   (1872,9,30,460,5,'G_9_30_460_5','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada Intervensi'),
							   (1873,9,40,540,5,'G_9_40_540_5','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Intervensi'),(1874,9,40,571,5,'G_9_40_571_5','Surat Pemberitahuan Putusan PK Kepada Intervensi'),(1877,120,30,430,6,'K_120_30_430_6','Akta Terlambat Penyerahan Memori Kasasi Untuk Oditur'),(1878,120,30,430,7,'K_120_30_430_7','Akta Tidak Menyerahkan Memori Kasasi Untuk Oditur'),(1879,120,30,460,4,'K_120_30_460_4','Akta Tidak Menyerahkan Kontra Memori Kasasi Untuk Oditur'),(1880,120,60,650,1,'K_120_60_650_1','Akta Permohonan Grasi'),(1881,120,60,662,1,'K_120_60_662_1','Akta Penerimaan Salinan Permohonan Grasi'),(1882,120,60,650,2,'K_120_60_650_2','Akta Penolakan Permohonan Grasi'),(1883,120,60,690,1,'K_120_60_690_1','Akta Pemberitahuan Isi Putusan Grasi Untuk Terpidana'),(1884,120,60,690,2,'K_120_60_690_2','Akta Pemberitahuan Isi Putusan Grasi Untuk Oditur'),(1885,15,12,20,1,'PDT_15_12_20_1','A.1.a Penetapan Majelis Hakim'),(1886,15,12,30,1,'PDT_15_12_30_1','A.1.d. Surat Penunjukan Panitera / Panitera Pengganti'),(1887,15,12,40,1,'PDT_15_12_40_1','A.1.e. Surat Penunjukan Jurusita/Jurusita Pengganti'),(1889,15,18,290,1,'PDT_15_18_290_1','A.1.c. Penetapan Majelis Hakim Sidang Ikrar Talak'),(1891,15,15,210,1,'07 Putusan Verstek NO OK','7 Putusan Verstek NO OK'),(1892,15,15,210,2,'03 Putusan Tolak Gugatan OK','3 Putusan Tolak Gugatan'),(1893,15,15,210,3,'04 Putusan Gugur OK','4 Putusan Gugur'),(1894,15,15,210,4,'05 Putusan Cabut OK','5 Putusan Cabut'),(1895,15,15,210,5,'06 Putusan NO OK','6 Putusan N.O.'),(1896,15,15,210,6,'01 Putusan Cerai Talak eksepsi kewenangan Rekonvensi Harta Bersama OK','1 Putusan Cerai Talak,eksepsi kewenangan  & Rekonvensi Harta Bersama OK'),(1897,15,15,210,7,'08 Putusan Batal Daftar OK','8 Putusan Batal Daftar'),(1898,16,15,210,51,'09 Penetapan Permohonan Kabul OK','09 Penetapan Permohonan Kabul OK'),(1899,16,15,210,52,'10 Penetapan Permohonan Tolak','10 Penetapan Permohonan Tolak'),(1904,15,15,210,14,'16 Penetapan saat ikrar, para pihak rukun OK','16 Penetapan saat ikrar, para pihak rukun OK'),(1905,15,15,210,15,'15 Penetapan Tentang Terjadinya Talak OK','15 Penetapan Tentang Terjadinya Talak OK'),(1907,15,14,200,2,'BAS Pertama P dan T Tidak Hadir','BAS Pertama P dan T Tidak Hadir'),(1908,15,14,200,1,'BAS Pertama Kuasa P Tidak Hadir dan T Tidak Hadir','BAS Pertama Kuasa P Tidak Hadir dan T Tidak Hadir'),(1909,15,14,200,11,'BAS Pertama P dan T Hadir Mediasi','BAS Pertama P dan T Hadir Mediasi'),(1910,15,14,200,5,'BAS Pertama P Tidak Hadir','BAS Pertama P Tidak Hadir'),(1911,15,14,200,6,'BAS Pertama P dan T Hadir Mediasi-sid Keliling','BAS Pertama P dan T Hadir Mediasi-sid Keliling'),(1912,15,14,200,7,'BAS Pertama derden verzet P hadir dan T1 T2  Tidak Hadir','BAS Pertama derden verzet P hadir dan T1 T2  Tidak Hadir'),(1913,15,14,200,10,'BAS Pertama P dan T Hadir Mediasi dg Kuasa','BAS Pertama P dan T Hadir Mediasi dg Kuasa'),(1914,15,14,200,12,'BAS Pertama darden verzet mediasi','BAS Pertama darden verzet mediasi'),(1915,15,14,200,110,'22-BAS-Lanjutan-jawaban-Lisan-pembuktian-tunda-putusan','22-BAS-Lanjutan-jawaban-Lisan-pembuktian-tunda-putusan'),(1916,15,14,200,123,'35 BAS Putus PA tidak berwenang (relatif) (hasil konsultasi)','35 BAS Putus PA tidak berwenang (relatif) (hasil konsultasi)'),(1917,15,14,200,122,'34_BAS_lanjutan_Putus_Gugur_(P_&_T_tdk_hadir)_(Ag)','34_BAS_lanjutan_Putus_Gugur_(P_&_T_tdk_hadir)_(Ag)'),(1918,15,14,200,121,'33 BAS lanjutan damai oleh meditor dan dicabut perkara (Ag)','33 BAS lanjutan damai oleh meditor dan dicabut perkara (Ag)'),(1919,15,14,200,118,'30 BAS lanjutan Sumpah Supletoir Tanpa Sela (Ag)','30 BAS lanjutan Sumpah Supletoir Tanpa Sela (Ag)'),(1920,15,14,200,116,'28 BAS lanjutan pembuktian verzet (Ag)','28 BAS lanjutan pembuktian verzet (Ag)'),(1921,15,14,200,105,'17 BAS lanjutan hasil mediasi belum siap jawaban (Ag)','17 BAS lanjutan hasil mediasi belum siap jawaban (Ag)'),(1922,15,14,200,103,'15 BAS lanjutan Cabut Belum Jawab (Ag)','15 BAS lanjutan Cabut Belum Jawab (Ag)'),(1923,15,14,200,102,'14 BAS lanjutan Biaya Habis (Ag)','14 BAS lanjutan Biaya Habis (Ag)'),(1924,15,14,200,117,'29 BAS Lanjutan derden verzet (jawaban) (Ag)','29 BAS Lanjutan derden verzet (jawaban) (Ag)'),(1925,15,14,200,101,'13 BAS lanjutan berhasil damai tanpa akta','13 BAS lanjutan berhasil damai tanpa akta'),(1926,15,14,200,113,'25 BAS lanjutan tusssenkomst putusan sela (Ag)','25 BAS lanjutan tusssenkomst putusan sela (Ag)'),(1927,15,14,200,119,'31 BAS lanjutan pemeriksaan SAKSI AHLI (Ag)','31 BAS lanjutan pemeriksaan SAKSI AHLI (Ag)'),(1928,15,14,200,104,'16 BAS lanjutan dengan akta perdamaian (Ag)','16 BAS lanjutan dengan akta perdamaian (Ag)'),(1929,15,14,200,111,'23 BAS lanjutan Pembuktian (Ag)','23 BAS lanjutan Pembuktian (Ag)'),(1930,15,14,200,114,'26 BAS lanjutan voeging putusan sela (Ag)','26 BAS lanjutan voeging putusan sela (Ag)'),(1931,15,14,200,120,'32 BAS lanjutan Jawaban-Belum Siap Replik (Ag)','32 BAS lanjutan Jawaban-Belum Siap Replik (Ag)'),(1932,15,14,200,109,'21 BAS lanjutan hasil mediasi belum siap jawab (tertulis) (Ag)','21 BAS lanjutan hasil mediasi belum siap jawab (tertulis) (Ag)'),(1933,15,14,200,132,'44 BAS Ikrar P hadir dan T tdk hadir (hasil konsultasi)','44 BAS Ikrar P hadir dan T tdk hadir (hasil konsultasi)'),(1934,15,14,200,125,'37 BAS Putus verstek (hasil konsultasi)','37 BAS Putus verstek (hasil konsultasi)'),(1935,15,14,200,126,'38 BAS putusan Contradiktur (hasil konsultasi)','38 BAS putusan Contradiktur (hasil konsultasi)'),(1936,15,14,200,127,'39 BAS Putus Gugur (hasil konsultasi)','39 BAS Putus Gugur (hasil konsultasi)'),(1937,15,14,200,128,'40 BAS Putus verstek (sid Keliling) (hasil konsultasi)','40 BAS Putus verstek (sid Keliling) (hasil konsultasi)'),(1938,15,14,200,129,'41 BA Sita Eksekusi (hasil konsultasi)','41 BA Sita Eksekusi (hasil konsultasi)'),(1939,15,14,200,124,'36 BAS Putus PA tidak berwenang (absolut) (hasil konsultasi)','36 BAS Putus PA tidak berwenang (absolut) (hasil konsultasi)'),(1940,15,14,200,130,'42 BAS Ikrar P dan T Hadir (hasil konsultasi)','42 BAS Ikrar P dan T Hadir (hasil konsultasi)'),(1941,15,14,200,131,'43 BAS Ikrar P dan T tidak hadir tunda 6 bulan (hasil konsultasi)','43 BAS Ikrar P dan T tidak hadir tunda 6 bulan (hasil konsultasi)'),(1942,15,14,200,903,'PDT_15_14_200_201','A.3.a2. Relaas Panggilan P (Kepala Desa / Lurah)'),(1943,15,14,200,900,'PDT_15_14_200_231','A.3.b2. Relaas Panggilan T (Kepala Desa / Lurah)'),(1948,15,14,200,905,'PDT_15_14_200_251','A.3.e. Relaas Panggilan Delegasi P'),(1949,15,14,200,906,'PDT_15_14_200_252','A.3.e. Relaas Panggilan Delegasi T'),(1950,15,14,200,231,'relaass_media_massa_pertama','Relaas Panggilan I Melalui Media Massa (Perceraian)'),(1951,15,14,200,230,'relaass_media_massa_kedua','Relaas Panggilan II Melalui Media Massa (Perceraian)'),(1952,15,15,210,8,'14 Penetapan Tentang Tidak Berkekuatan Hukumnya Putusan Cerai Talak OK','14 Penetapan Tentang Tidak Berkekuatan Hukumnya Putusan Cerai Talak OK'),(1953,15,18,294,203,'PDT_15_18_294_203','A.3.o. Relaas Panggilan Ikrar Talak (Termohon) Yang Tidak Diketahui Tempat Tinggalnya'),(1955,15,18,294,401,'PDT_15_18_294_204','A.3.n. Relaas Panggilan Ikrar Talak (Termohon)'),(1956,15,18,294,400,'PDT_15_18_294_205','A.3.m. Relaas Panggilan Ikrar Talak (Pemohon)'),(1957,15,18,294,410,'PDT_15_18_294_206','A.3.p. Relaas Panggilan Ikrar Talak (Pemohon Di Luar Wilayah)'),(1959,15,14,200,201,'RELAAS-SIDANG-PERTAMA PIHAK1','Relaas Sidang Pertama'),(1960,15,14,200,221,'RELAAS-SIDANG-PERTAMA PIHAK2','Relaas Sidang Pertama'),(1961,15,20,340,201,'PDT_15_20_340_201','A.6.g. Relaas Pemberitahuan dan Penyerahan Kontra Memori Banding'),(1962,15,20,340,202,'PDT_15_20_340_202','A.6.g. Relaas Pemberitahuan T dan Penyerahan Kontra Memori Banding (Langsung)'),(1963,15,15,230,201,'Relaas Pemberitahuan Putusan Verstek','A-4.b. Relaas Pemberitahuan Putusan Verstek'),(1964,15,20,350,201,'PDT_15_20_350_201','A.6.h. Relaas Pemberitahuan Inzage'),(1965,15,20,360,1,'PDT_15_20_360_1','A.6.i. Surat Keterangan Tidak Melakukan Inzage'),(1966,15,15,230,202,'Relaas Pemberitahuan Putusan Pihak T Tidak Hadir','A-4.c. Relaas Pemberitahuan Putusan Pihak T Tidak Hadir'),(1967,15,14,200,281,'relaas luar negeri','Panggilan Pihak di Luar Negeri  (Pasal 28 PP No. 9 Tahun 1975)'),(1968,15,20,301,201,'PDT_15_20_301_201','A.6.b1. Relaas Pemberitahuan Pernyataan Banding'),(1973,16,14,200,201,'RELAAS-VOLUNTEIR','Relaas Voluntaire'),(1974,16,14,200,906,'PDT_16_14_200_202','A.3.c2. Relaas Voluntaire P (Kepala Desa / Lurah)'),(1975,15,20,300,3,'PDT_15_20_300_3','A.6.a3. Akta Permohonan Banding (Melalui Kuasa Insidentil)'),(1976,15,20,300,4,'PDT_15_20_300_4','A.6.a4. Akta Permohonan Banding Secara Prodeo'),(1977,15,20,300,1,'PDT_15_20_300_1','A.6.a3. Akta Permohonan Banding (Melalui Kuasa Insidentil)'),(1978,15,20,300,2,'PDT_15_20_300_2','A.6.a2. Akta Permohonan Banding (Melalui Kuasa Hukum)'),(1979,15,14,200,3,'BAS Pertama P dan Kuasanya Tidak Hadir dan T dan Kuasanya hadir','BAS Pertama P dan Kuasanya Tidak Hadir dan T dan Kuasanya hadir'),(1980,15,14,200,4,'BAS Pertama P hadir T Tidak Hadir','BAS Pertama P hadir T Tidak Hadir'),(1981,15,14,200,8,'BAS Pertama Penolakan Hakim','BAS Pertama Penolakan Hakim'),(1982,15,14,200,9,'BAS Pertama Penolakan Panitera Pengganti dilanjutkan dgn mediasi','BAS Pertama Penolakan Panitera Pengganti Lanjut Mediasi'),(1983,15,14,200,107,'19-BAS-lanjutan-tidak-sepakat-memilih-mediator','19-BAS-lanjutan-tidak-sepakat-memilih-mediator'),(1984,15,14,200,106,'18-BAS-lanjutan-sepakat-memilih-mediator','18-BAS-lanjutan-sepakat-memilih-mediator'),(1985,15,14,200,108,'20-BAS-lanjutan-gugatan-rekonpensi-Lisan','20-BAS-lanjutan-gugatan-rekonpensi-Lisan'),(1986,15,14,200,112,'24 BAS lanjutan DECENTE (Ag)','24 BAS lanjutan DECENTE (Ag)'),(1987,15,14,200,115,'27 BAS lanjutan vrijwaring putusan sela (Ag)','27 BAS lanjutan vrijwaring putusan sela (Ag)'),(1988,15,50,615,101,'PDT_15_50_615_101','Berita Acara Sita Eksekusi'),(1989,15,50,622,101,'PDT_15_50_622_101','Berita Acara Eksekusi Lelang'),(1990,15,18,200,9,'PDT_15_18_200_9','BAS Ikrar P dan T hadir'),(1991,15,18,200,10,'PDT_15_18_200_10','BAS Ikrar P dan T tidak hadir Tunda 6 bulan (hasil konsultasi)'),(1992,15,20,301,203,'PDT_15_20_301_203','A.6.c. Surat Bantuan Penyampaian Pemberitahuan Banding'),(1993,15,15,231,201,'PDT_15_15_231_201','A.3.d. Surat Bantuan Pemberitahuan Putusan Delegasi P'),(1996,15,20,320,201,'PDT_15_20_320_201','A.6.f. Relaas Pemberitahuan dan Penyerahan Memori Banding.'),(1997,15,20,340,203,'PDT_15_20_340_203','A-6.b.Surat Bantuan Penyampaian Pemberitahuan Dan Penyerahan Kontra Memori Banding'),(1998,15,20,350,902,'PDT_15_20_350_205','A.6.h. Relaas Pemberitahuan Inzage P (Kepala Desa / Lurah)'),(1999,15,20,350,901,'PDT_15_20_350_206','A.6.h. Relaas Pemberitahuan Inzage T (Kepala Desa / Lurah)'),(2001,15,15,230,203,'Relaas Pemberitahuan Putusan Verstek Pasal 390','A-4.d. Relaas Pemberitahuan Putusan Verstek (ex Pasal 390 HIR-718 RBg)'),(2002,15,15,230,300,'Relaas Pemberitahuan Putusan Pihak P Tidak Hadir','A-4.c. Relaas Pemberitahuan Putusan Pihak P Tidak Hadir'),(2004,15,20,340,500,'PDT_15_20_340_204','A.6.e. Relaas Pemberitahuan dan Penyerahan Kontra Memori Banding P (Kepala Desa / Lurah)'),(2005,15,20,320,202,'PDT_15_20_320_202','A.6.e. Relaas Pemberitahuan dan Penyerahan Memori Banding T (Kepala Desa / Lurah)'),(2006,15,12,80,1,'phs contesius','A.2.a. Penetapan Hari Sidang (Contentieus)'),(2007,16,12,80,3,'PDT_16_12_80_3','A.2.c. Penetapan Hari Sidang Isbat Nikah'),(2008,16,12,80,2,'phs voluntaire','A.2.b. Penetepan Hari Sidang (Voluntaire)'),(2009,15,50,615,1,'PDT_15_50_615_1','A.8.p. Penetapan Perintah Sita Eksekusi untuk membayar sejumlah uang'),(2010,15,50,615,7,'PDT_15_50_615_7','A.2.k.Penetapan Perintah Sita Revindicatoir dengan disertai Penetapan Hari Sidang'),(2011,16,14,200,203,'PDT_16_14_200_203','A.3.q. Pengumuman Permohonan Isbat Nikah'),(2013,15,50,615,2,'PDT_15_50_615_2','A.2.j. Penolakan Sita disertai Penetapan Hari Sidang'),(2014,15,12,20,2,'PDT_15_12_20_2','A.1.b. Pergantian Majelis Hakim'),(2019,15,50,615,3,'PDT_15_50_615_3','A.2.f. Penetapan Hari Sidang Dengan Disertai Pengabulan Sita'),(2020,15,50,615,4,'PDT_15_50_615_4','A.2.g. Penetapan Hari Sidang Dengan Disertai Penangguhan Sita'),(2021,15,12,80,4,'phs_pasal_27_PP_9_melalui_mediamassa','A.2.d. Penetapan Hari Sidang ex Pasal 27 PP 9 Th. 75'),(2022,15,12,80,5,'phs_pasal_390_melalui_bupati','A.2.e. Penetapan Hari Sidang ex Pasal 718 (3) RBg.'),(2024,15,50,615,5,'PDT_15_50_615_5','A.2.i. Penetapan Hari Sidang Setelah Penetapan Sita.'),(2025,15,50,615,6,'PDT_15_50_615_6','A.2.h. Penetepan Sita Dikabulkan Dan Penetapan Hari Sidang Ditetapkan Tersendiri'),(2026,15,18,293,1,'PDT_15_18_293_1','A.2.n. Penetapan Hari Sidang Ikrar Talak'),(2027,15,13,121,1,'PDT_15_13_121_1','A.2.o. Penetapan Penunjukkan Mediator'),(2028,15,12,80,6,'phs_setelah_pemeriksaan_setempat','A.2.l. Penetapan Hari Sidang Setelah Pemeriksaan Setempat'),(2029,15,30,410,1,'PDT_15_30_410_1','Akta Permohonan Kasasi'),(2030,15,30,410,2,'PDT_15_30_410_2','A.7.b. Akta Permohonan Kasasi (Melalui Kuasa Hukumnya)'),(2031,15,30,410,3,'PDT_15_30_410_3','A.7.c. Akta Permohonan Kasasi (Melalui Kuasa Insidentil)'),(2032,15,30,410,4,'PDT_15_30_410_4','A.7.d. Akta Permohonan Kasasi Secara Prodeo'),(2033,15,30,420,201,'PDT_15_30_420_201','A.7.e. Relaas Pemberitahuan Pernyataan Kasasi'),(2034,15,30,420,202,'PDT_15_30_420_202','A.7.f. Surat Bantuan Penyampaian Pemberitahuan Kasasi'),(2035,15,30,430,1,'PDT_15_30_430_1','A.7.g. Tanda Terima Memori Kasasi'),(2036,15,30,450,1,'PDT_15_30_450_1','A.7.h. Tanda Terima Kontra Memori Kasasi'),(2037,15,30,440,201,'PDT_15_30_440_201','A.7.i. Relaas Pemberitahuan dan Penyerahan Memori Kasasi'),(2038,15,30,460,201,'PDT_15_30_460_201','A.7.j. Relaas Pemberitahuan dan Penyerahan Kontra Memori Kasasi'),(2039,15,30,490,1,'PDT_15_30_490_1','A.7.k. Akta Pencabutan Permohonan Kasasi, sebelum berkas perkara dikirim ke Mahkamah Agung RI'),(2040,15,30,490,2,'PDT_15_30_490_2','A.7.l. Akta Pencabutan Permohonan Kasasi, setelah berkas perkara dikirim ke Mahkamah Agung RI'),(2041,15,30,490,3,'PDT_15_30_490_3','A.7.n. Penetapan Permohonan Kasasi Tidak Memenuhi Syarat Formil'),(2042,15,30,490,4,'PDT_15_30_490_4','A.7.o. Laporan Permohonan Kasasi Yang Tidak Memenuhi Syarat Formil'),(2043,15,30,490,201,'PDT_15_30_490_201','A.7.p. Relaas Pemberitahuan dan Penyerahan Salinan Penetapan Tentang Kasasi Tidak Memenuhi Syarat Formil'),(2053,15,40,510,1,'PDT_15_40_510_1','A.8.a. Akta Permohonan Peninjauan Kembali'),(2054,15,40,510,2,'PDT_15_40_510_2','A.8.b. Akta Permohonan Peninjauan Kembali (Melalui Kuasa Hukumnya)'),(2055,15,40,510,3,'PDT_15_40_510_3','A.8.c. Akta Permohonan Peninjauan Kembali (Melalui Kuasa Insidentil)'),(2056,15,40,510,4,'PDT_15_40_510_4','A.8.d. Akta Permohonan Peninjauan Kembali Secara Prodeo'),(2057,15,40,520,201,'PDT_15_40_520_201','A.8.e. Relaas Pemberitahuan Pernyataan Peninjauan Kembali'),(2058,15,40,520,202,'PDT_15_40_520_202','A.8.f. Surat Bantuan Penyampaian Pemberitahuan Peninjauan Kembali'),(2059,15,40,521,1,'PDT_15_40_521_1','A.8.g. Tanda Terima Memori Peninjauan Kembali'),(2060,15,40,523,1,'PDT_15_40_523_1','A.8.h. Tanda Terima Kontra Memori Peninjauan Kembali'),(2061,15,40,522,201,'PDT_15_40_522_201','A.8.i. Relaas Pemberitahuan dan Penyerahan Memori Peninjauan Kembali'),(2062,15,40,524,201,'PDT_15_40_524_201','A.8.j. Relaas Pemberitahuan dan Penyerahan Kontra Memori Peninjauan Kembali'),(2063,15,40,570,1,'PDT_15_40_570_1','A.8.k. Akta Pencabutan Permohonan Peninjauan Kembali, sebelum berkas perkara dikirim ke Mahkamah Agung RI'),(2064,15,40,570,2,'PDT_15_40_570_2','A.8.l. Akta Pencabutan Permohonan Peninjauan Kembali, setelah berkas perkara dikirim ke Mahkamah Agung RI'),(2065,15,14,200,901,'PDT_15_14_200_901','A.4.a. Tegoran Untuk Tambah Panjar'),(2066,15,12,80,7,'phs_pengunduran_Hari Sidang_Majelis-Hakim-Berhalangan','A.2.m Penetapan Pengunduran Hari Sidang Dalam Hal Majelis Hakim Berhalangan'),(2070,15,20,310,1,'PDT_15_20_310_1','A.6.d. Tanda Terima Memori Banding'),(2071,15,20,330,1,'PDT_15_20_330_1','A.6.e. Tanda Terima Kontra Memori Banding.'),(2072,15,20,391,1,'PDT_15_20_391_1','A.6.j. Akta Pencabutan Permohonan Banding, sebelum berkas perkara dikirim ke PTA/MSY Aceh.'),(2073,15,20,391,2,'PDT_15_20_391_2','A.6.k. Akta Pencabutan Permohonan Banding, setelah berkas perkara dikirim ke PTA/MSY Aceh'),(2074,15,50,605,1,'PDT_15_50_605_1','A.8.m. Penetapan Aanmaning'),(2075,15,50,628,1,'PDT_15_50_628_1','A.8.n. Penetapan Eksekusi Riil'),(2076,15,50,615,8,'PDT_15_50_615_8','A.8.o. Penetapan Sita Eksekusi'),(2077,15,50,622,1,'PDT_15_50_622_1','A.8.q. Penetapan Eksekusi Lelang'),(2078,15,50,615,9,'PDT_15_50_615_9','A.8.r. Penetapan Pengangkatan Sita Jaminan (Telah dilaksanakan secara sukarela)'),(2079,15,50,615,10,'PDT_15_50_615_10','A.8.s. Penetapan Pencabutan Eksekusi'),(2080,15,50,615,11,'PDT_15_50_615_11','A.8.t. Penetapan Penghentian Eksekusi Putusan Provisi'),(2081,15,50,622,2,'PDT_15_50_622_2','A.8.u. Penetapan Harga Limit'),(2082,15,50,624,1,'PDT_15_50_624_1','A.8.v. Pengantar Lelang'),(2083,15,50,624,2,'PDT_15_50_624_2','A.8.w. Permintaan Cabut Pemblokiran Kendaraan'),(2084,15,50,640,1,'PDT_15_50_640_1','A.8.x. Penetapaan Non Ekskutabel'),(2085,15,15,231,202,'PDT_15_15_231_202','A.3.d. Surat Bantuan Pemberitahuan Putusan Delegasi T'),(2086,15,18,294,411,'PDT_15_18_294_207','A.3.p. Relaas Panggilan Ikrar Talak (Termohon Di Luar Wilayah)'),(2087,15,15,210,16,'02 b Putusan Cerai Gugat Verstek OK','2 b Putusan Cerai Gugat Verstek'),(2088,15,10,10,1,'PDT_15_10_10_1','SKUM'),(2089,0,NULL,NULL,NULL,'I_02','Pernyataan Pihak Tentang Penjelasan Mediasi'),(2090,0,NULL,NULL,NULL,'I_03','Penetapan Mediasi dan Penunjukkan Mediator'),(2091,1,14,200,363,'PDT_1_14_200_363','Berita Acara Sidang Pertama (Penjelasan Majelis Hakim tentang Mediasi)'),(2092,0,NULL,NULL,NULL,'I_05','Relaas Panggilan Mediasi Kepada Penggugat'),(2093,0,NULL,NULL,NULL,'I_06','Relaas Panggilan Mediasi Kepada Tergugat'),(2094,0,NULL,NULL,NULL,'I_07','Blanko Jadwal Mediasi'),(2095,0,NULL,NULL,NULL,'I_08','Blanko Resume Perkara'),(2096,0,NULL,NULL,NULL,'I_09','Kesepakatan Perdamaian'),(2097,0,NULL,NULL,NULL,'I_10','Kesepakatan Perdamaian Sebagian Pihak/Subjek'),(2098,0,NULL,NULL,NULL,'I_11','Kesepakatan Perdamaian Sebagian Tuntutan Hukum/Objek'),(2099,0,NULL,NULL,NULL,'I_12','Pernyataan Para Pihak Yang Diwakili Oleh Kuasa Hukum Tentang Persetujuan Atas Kesepakatan Perdamaian'),(2100,0,NULL,NULL,1,'I_13','Blanko Kesepakatan Perdamanan (diluar Pengadilan) untuk dikukuhkan dengan Akta'),(2101,0,NULL,NULL,1,'I_14','Blanko Gugatan Memperoleh Akta Perdamaian di Luar Pengadilan'),(2102,0,NULL,NULL,NULL,'I_15','Akta Perdamaian'),(2103,0,NULL,NULL,NULL,'I_16','Laporan Mediator Kepada Hakim Pemeriksa Perkara Tentang Hasil Mediasi'),(2104,0,NULL,NULL,NULL,'I_17','Pernyataan Para Pihak Tentang Hasil Mediasi'),(2105,0,NULL,NULL,NULL,'I_18','Laporan Mediator Tentang Hasil Mediasi (Pihak Beritikad Tidak Baik)'),(2106,0,NULL,NULL,NULL,'I_19','Putusan Akhir (Penggugat tidak beritikad baik)'),(2107,0,NULL,NULL,NULL,'I_20','Penetapan (Tergugat yang tidak beritikad baik)'),(2108,0,NULL,NULL,NULL,'I_21','Putusan (Gugatan ditolak tetapi Tergugat tidak beritikad baik dalam mediasi dan dihukum membayar biaya mediasi)'),(2109,0,NULL,NULL,NULL,'I_15_1','Akta Perdamaian'),(2110,0,NULL,NULL,NULL,'I_01','Formulir Kata-kata Penjelasan Mediasi oleh Ketua Majelis'),(2111,0,NULL,NULL,111,'8_1_PEN_IJIN_PENGGELEDAHAN','Blanko Penetapan Ijin Penggeledahan'),(2112,0,NULL,NULL,111,'8_2_PEN_PERSETUJUAN_PENGGELEDAHAAN','Blanko Penetapan Persetujuan Penggeledahan'),(2113,0,NULL,NULL,111,'8_3_PEN_PENOLAKAN_IJIN_PENGELEDAHAN','Blanko Penetapan Penolakan Ijin Penggeledahan'),(2114,0,NULL,NULL,111,'9_1_PEN_IJIN_PENYITAAN_KHUSUS_PASAL_43','Blanko Penetapan Ijin Penyitaan Khusus Pasal 43'),(2115,0,NULL,NULL,111,'9_2_PEN_IJIN_PENYITAAN','Blanko Penetapan Ijin Penyitaan'),(2116,0,NULL,NULL,111,'9_3_PEN_PERSETUJUAN_PENYITAAN','Blanko Penetapan Persetujuan Penyitaan'),(2117,0,NULL,NULL,111,'9_4_PEN_PENOLAKAN_IJIN_PENYITAAN','Blanko Penetapan Penolakan Ijin Penyitaan'),(2118,0,NULL,NULL,111,'10_2_PEN_IJIN_LELANG_BB_KEHUTANAN_KABUL','Blanko Penetapan Ijin Lelang Barang Bukti Kehutanan Kabul'),(2119,0,NULL,NULL,111,'10_3_PEN_IJIN_LELANG_BB_KEHUTANAN_TOLAK','Blanko Penetapan Ijin Lelang Barang Bukti Kehutanan Tolak'),(2120,0,NULL,NULL,111,'10_4_PEN_IJIN_LELANG_BB_TEMUAN_KABUL','Blanko Penetapan Ijin Lelang Barang Bukti Temuan Kehutanan Kabul'),(2121,0,NULL,NULL,111,'10_5_PEN_IJIN_UTK_BB_TEMUAN_TOLAK','Blanko Penetapan Ijin Peruntukan Barang Bukti Temuan Tolak'),(2122,0,NULL,NULL,111,'12_1_PEN_PENANGKAPAN_PENAHANAN_ITE','Blanko Penetapan Penangkapan Dan Penahanan ITE'),(2123,0,NULL,NULL,111,'7_9_PENETAPAN','Blanko Penetapan Penolakan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29'),(2124,0,NULL,NULL,111,'7_10_PENETAPAN','Blanko Penetapan Penolakan Perpanjangan Penahanan KPN Permintaan PU Pasal 29'),(2125,0,NULL,NULL,111,'7_12_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29 I'),(2126,0,NULL,NULL,111,'7_13_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penyidik Pasal 29 II'),(2127,0,NULL,NULL,111,'7_14_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penuntut Umum Pasal 25'),(2128,0,NULL,NULL,111,'7_15_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permimntaan Penuntut Umum Pasal 29 I'),(2129,0,NULL,NULL,111,'7_16_PENETAPAN','Blanko Penetapan Perpanjangan Tahanan KPN Permintaan Penuntut Umum Pasal 29 II'),(2130,15,14,200,241,'RELAAS PIHAK1 SELANJUTNYA','Relaas Panggilan selanjutnya'),(2131,16,14,200,242,'RELAAS PIHAK1 SELANJUTNYA VOLUNTEIR','Relaas Panggilan selanjutnya'),(2132,15,14,200,261,'RELAAS PIHAK2 SELANJUTNYA','Relaas Panggilan selanjutnya'),(2133,16,14,200,262,'RELAAS PIHAK2 SELANJUTNYA VOLUNTEIR','Relaas Panggilan selanjutnya'),(2134,15,14,200,13,'BAS Pertama T Tidak Hadir','BAS Pertama T Tidak Hadir'),(2135,15,14,200,14,'BAS Pertama Cabut T Tidak Hadir','BAS Pertama Cabut T Tidak Hadir (Perceraian)'),(2136,16,15,230,250,'Relaas Pemberitahuan Putusan Permohonan','Relaas Pemberitahuan Putusan Permohonan'),(2137,15,14,200,134,'46 BAS Aanmaning P & T tidak hadir (hasil konsultasi)','46 BAS Aanmaning P & T tidak hadir (hasil konsultasi)'),(2138,15,14,200,133,'45 BAS Aanmaning P & T hadir (hasil konsultasi)','45 BAS Aanmaning P & T hadir (hasil konsultasi)'),(2139,15,14,200,135,'47 BAS CABUT SEBELUM PEMBUKTIAN','47 BAS CABUT SEBELUM PEMBUKTIAN'),(2140,16,15,210,53,'11 Penetapan Gugur OK','11 Penetapan Gugur OK'),(2141,16,15,210,54,'12 Penetapanan Cabut OK','12 Penetapanan Cabut OK'),(2142,16,15,210,55,'13 Penetapan Batal Daftar OK','13 Penetapan Batal Daftar OK'),(2143,15,15,210,20,'17 Pts EKSEPSI kewenagan absolut OK','17 Pts EKSEPSI kewenagan absolut OK'),(2144,15,15,210,21,'18 Pts EKSEPSI kewenagan relatif OK','18 Pts EKSEPSI kewenagan relatif OK'),(2145,15,15,210,22,'19 Pts Derden Verzet OK','19 Pts Derden Verzet OK'),(2146,15,15,210,23,'20 Pts Verzet atas Verstek Pelawan Tidak Benar OK','20 Pts Verzet atas Verstek Pelawan Tidak Benar OK'),(2147,15,15,210,24,'21 Putusan NO P Tidak Serius OK','21 Putusan NO P Tidak Serius OK'),(2148,15,15,210,25,'22 Put Verzet atas verstek  dikabulkan','22 Put Verzet atas verstek  dikabulkan'),(2149,15,15,210,26,'23 Put verzet atas verstek ditolak','23 Put verzet atas verstek ditolak'),(2150,15,15,210,27,'02 a Putusan Cerai Talak Verstek OK','02 a Putusan Cerai Talak Verstek OK'),(2151,15,14,200,500,'sampul berkas pdt-g','SAMPUL BERKAS PERKARA PDT.G'),(2152,15,14,200,501,'sampul berkas pdt-p','SAMPUL BERKAS PERKARA PDT.P'),(2153,15,14,200,502,'instrumen relaas sidang pertama pdt-g','INSTRUMEN RELAAS PERTAMA PDT.G'),(2154,15,14,200,503,'instrumen relaas sidang pertama pdt-p','INSTRUMEN RELAAS PERTAMA PDT.P'),(2155,15,14,200,504,'Instrumen Panggilan-Tanda Terima','Instrumen Panggilan & Tanda Terima');");
		$this->db->query("REPLACE INTO template_dokumen (`id`, `alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) VALUES 
				('2156', '9', '14', '200', '100', 'BA 1a - BAP Pemeriksaan Persiapan', 'BAP Pemeriksaan Pemeriksaan'),
				('2157', '9', '14', '200', '101', 'BA 1b - BAP Pemeriksaan Persiapan Tunda karena Pihak Tidak Hadir', 'BAP Pemeriksaan Persiapan Tunda karena Pihak Tidak Hadir'),
				('2158', '9', '14', '200', '102', 'BA 2a - BAP Pembacaan Gugatan Tunda', 'BAP Pembacaan Gugatan Tunda'),
				('2159', '9', '14', '200', '103', 'BA 2b - BAP Pembacaan Gugatan Tunda untuk Jawaban', 'BAP Pembacaan Gugatan Tunda untuk Jawaban'),
				('2160', '9', '14', '200', '104', 'BA 3a - BAP Pembacaan Jawaban Tunda untuk Replik', 'BAP Pembacaan Jawaban Tunda untuk Replik'),
				('2161', '9', '14', '200', '105', 'BA 3b - BAP Pembacaan Jawaban Tunda', 'BAP Pembacaan Jawaban Tunda'),
				('2162', '9', '14', '200', '106', 'BA 4a - BAP Pembacaan Replik', 'BAP Pembacaan Replik'),
				('2163', '9', '14', '200', '107', 'BA 4b- BAP Pembacaan Replik Tunda', 'BAP Pembacaan Replik Tunda'),
				('2164', '9', '14', '200', '108', 'BA 5a - BAP Pembacaan Duplik', 'BAP Pembacaan Duplik'),
				('2165', '9', '14', '200', '109', 'BA 5b - BAP Pembacaan Duplik Tunda', 'BAP Pembacaan Duplik Tunda'),
				('2166', '9', '14', '200', '110', 'BA 6a - BAP Pemeriksaan Bukti Para Pihak', 'BAP Pemeriksaan Bukti Para Pihak'),
				('2167', '9', '14', '200', '111', 'BA 6b - BAP Pemeriksaan Bukti Para Pihak Tunda untuk Bukti Tambahan', 'BAP Pemeriksaan Bukti Para Pihak Tunda untuk Bukti Tambahan'),
				('2168', '9', '14', '200', '112', 'BA 6c - BAP Pemeriksaan Bukti Penggugat Tunda utk Bukti Tambahan', 'BAP Pemeriksaan Bukti Penggugat Tunda utk Bukti Tambahan'),
				('2169', '9', '14', '200', '113', 'BA 6d - BAP Pemeriksaan Bukti Penggugat Tunda utk Bukti Tergugat', 'BAP Pemeriksaan Bukti Penggugat Tunda utk Bukti Tergugat'),
				('2170', '9', '14', '200', '114', 'BA 6e - BAP Pemeriksaan Bukti Tergugat Tunda utk Bukti Tambahan', 'BAP Pemeriksaan Bukti Tergugat Tunda utk Bukti Tambahan'),
				('2171', '9', '14', '200', '115', 'BA 6f - BAP Pemeriksaan Bukti Tergugat Tunda utk Pemeriksaan Saksi', 'BAP Pemeriksaan Bukti Tergugat Tunda utk Pemeriksaan Saksi'),
				('2172', '9', '14', '200', '116', 'BA 7a - BAP Pemeriksaan Saksi Para Pihak Tunda utk Pembacaan Kesimpulan', 'BAP Pemeriksaan Saksi Para Pihak Tunda utk Pembacaan Kesimpulan'),
				('2173', '9', '14', '200', '117', 'BA 7b - BAP Pemeriksaan Saksi Para Pihak Tunda untuk Saksi Tambahan', 'BAP Pemeriksaan Saksi Para Pihak Tunda untuk Saksi Tambahan'),
				('2174', '9', '14', '200', '118', 'BA 7c - BAP Pemeriksaan Saksi Penggugat Tunda utk Saksi Tambahan', 'BAP Pemeriksaan Saksi Penggugat Tunda utk Saksi Tambahan'),
				('2175', '9', '14', '200', '119', 'BA 7d - BAP Pemeriksaan Saksi Penggugat Tunda utk Saksi Tergugat', 'BAP Pemeriksaan Saksi Penggugat Tunda utk Saksi Tergugat'),
				('2176', '9', '14', '200', '120', 'BA 7e - BAP Pemeriksaan Saksi Tergugat Tunda utk Saksi Tambahan', 'BAP Pemeriksaan Saksi Tergugat Tunda utk Saksi Tambahan'),
				('2177', '9', '14', '200', '121', 'BA 7f - BAP Pemeriksaan Saksi Tergugat Tunda utk Pembacaan Kesimpulan', 'BAP Pemeriksaan Saksi Tergugat Tunda utk Pembacaan Kesimpulan'),
				('2178', '9', '14', '200', '122', 'BA 8a - BAP Pembacaan Kesimpulan Tunda', 'BAP Pembacaan Kesimpulan Tunda'),
				('2179', '9', '14', '200', '123', 'BA 8b - BAP Pembacaan Kesimpulan', 'BAP Pembacaan Kesimpulan'),
				('2180', '9', '14', '200', '124', 'BA 9 - BAP Pembacaan Putusan', 'BAP Pembacaan Putusan');");

				$this->db->query("REPLACE INTO jenis_biaya (`id`, `tahapan_id`, `jenis_transaksi`, `kategori_id`, `kode`, `nama`, `keterangan`) VALUES 
				('382', '20', '-1', '3', 'KRB B2', 'Biaya Pemberkasan/Pengiriman Berkas Banding','Biaya Pemberkasan/Pengiriman Berkas Banding'),
				('383', '30', '-1', '3', 'KRB C2', 'Biaya Pemberkasan/Pengiriman Berkas Kasasi','Biaya Pemberkasan/Pengiriman Berkas Kasasi'),
				('384', '40', '-1', '3', 'KRB D2', 'Biaya Pemberkasan/Pengiriman Berkas PK','Biaya Pemberkasan/Pengiriman Berkas PK'),
				('385', '20', '-1', '6', 'PBT B10', 'Biaya Pemberitahuan Pengiriman Berkas Banding', 'Biaya Pemberitahuan Pengiriman Berkas Banding'),
				('386', '30', '-1', '6', 'PBT C8', 'Biaya Pemberitahuan Pengiriman Berkas Kasasi', 'Biaya Pemberitahuan Pengiriman Berkas Kasasi'),
				('387', '40', '-1', '6', 'PBT D6', 'Biaya Pemberitahuan Pengiriman Berkas PK', 'Biaya Pemberitahuan Pengiriman Berkas PK');");

				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '383', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Kasasi');");
				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '382', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Banding');");
				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '384', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas PK');");
				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '385', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Banding');");
				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '386', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Kasasi');");
				$this->db->query("REPLACE INTO biaya_perkara (`alur_perkara_id`, `jenis_biaya_id`, `jumlah`, `keterangan`) VALUES ('9', '387', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas PK');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('92', '1', 'KIP-Ditolak', 'KIP', '10', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('93', '1', 'KIP-Dikabul', 'KIP', '11', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('94', '1', 'FP-Kabul', 'Fiktip Positif Dikabulkan', '12', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('95', '1', 'FP-Tolak', 'Fiktip Positif Ditolak', '13', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('96', '1', 'FP-Gugur', 'Fiktip Positif Gugur', '14', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('97', '1', 'FP-NO', 'Fiktip Positif NO', '15', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('98', '1', 'PW-Kabul-Badan Pemerintah', 'PW-Kabul-Badan Pemerintah', '16', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('99', '1', 'PW-Dikabulkan-Pejabat Pemerintah', 'PW-Dikabulkan-Pejabat Pemerintah', '17', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('100', '1', 'PW-Ditolak-Badan Pemerintah', 'PW-Ditolak-Badan Pemerintah', '18', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('101', '1', 'PW-Ditolak-Pejabat Pemerintah', 'PW-Ditolak-Pejabat Pemerintah', '19', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('102', '1', 'PW-Gugur-Badan Pemerintah', 'PW-Gugur-Badan Pemerintah', '20', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('103', '1', 'PW-Gugur-Pejabat Pemerintah', 'PW-Gugur-Pejabat Pemerintah', '21', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('104', '1', 'PW-Tidak Diterima-Badan Pemerintah', 'PW-Tidak Diterima-Badan Pemerintah', '22', '3');");
				$this->db->query("REPLACE INTO status_putusan (`id`, `jenis_perkara_id`, `nama`, `keterangan`, `urutan`, `jenis_pengadilan`) VALUES ('105', '1', 'PW-Tidak Diterima-Pejabat Pemerintah', 'PW-Tidak Diterima-Pejabat Pemerintah', '23', '3');");

		$this->db->query("ALTER TABLE `perkara_dismissal` CHANGE `diinput_tanggal` `diinput_tanggal` DATETIME NULL, CHANGE `diperbaharui_tanggal` `diperbaharui_tanggal` DATETIME NULL;");

		$this->db->query("REPLACE INTO perkara_penetapan_hari_sidang(perkara_id,tahapan_id,tanggal_penetapan,tanggal_sidang,diinput_oleh,diinput_tanggal) 
							SELECT perkara_id,10,penetapan_hari_sidang,sidang_pertama,'System',CURDATE() FROM perkara_penetapan WHERE penetapan_hari_sidang IS NOT NULL AND sidang_pertama IS NOT NULL;");
		
		$this->db->query("UPDATE delegasi_keluar SET status_kirim=1 WHERE DATEDIFF(tgl_sidang,CURDATE())<7 OR id_jenis_delegasi<>1;");
		$this->db->query("UPDATE delegasi_masuk SET status_kirim=1 WHERE DATEDIFF(tgl_sidang,CURDATE())<7 OR id_jenis_delegasi<>1;");

		$this->db->query("DROP FUNCTION IF EXISTS `get_umur`;");
		$this->db->query("CREATE FUNCTION `get_umur`(tanggal_lahir DATE, tanggal_hitung DATE) RETURNS INT(4)
						BEGIN
							DECLARE i INT;
							SET i = YEAR(tanggal_hitung)-YEAR(tanggal_lahir)-(DATE_FORMAT(tanggal_hitung,'%m%d')<DATE_FORMAT(tanggal_lahir,'%m%d'));
						RETURN i;
						END ;");

		$this->db->query("DROP FUNCTION IF EXISTS `ubah_nip`;");
		$this->db->query("CREATE FUNCTION `ubah_nip`(str VARCHAR(18)) RETURNS VARCHAR(21) CHARSET latin1
    					DETERMINISTIC
						RETURN
							    CONCAT(
							    LEFT(str,8),
							    ' ',
							    SUBSTRING(str,9,6),
							    ' ',
							    SUBSTRING(str,15,1),
							    ' ',
							    RIGHT(str,3)
							    );");
		
		$this->db->query("REPLACE INTO `sys_menus` (`id`, `menutype`, `parent_id`, `level`, `title`, `link`, `params`, `published`, `ordering`) VALUES
			('6012','mainmenu','266','1','Register Diversi','register_diversi_list',NULL,'1','6'),
			('6013','mainmenu','266','1','Register Anak Belum 12 Tahun','register_anak_blm_12tahun',NULL,'1','7'),
			('6014','mainmenu','266','1','Register Anak Korban & Anak Saksi','register_anak_korban_saksi',NULL,'1','8');");		
		
		//320-1
		$this->db->query("REPLACE INTO `sys_rules` (`id`, `parent_id`, `code`, `name`, `description`, `published`, `ordering`, `level`, `lft`, `rgt`) 
					VALUES('527','1','ManageDirput','Antrian Direktori Putusan','Monitoring Direktori Putusan','1','10','0','20','21'),('528','9','RefAmarPutusan','Template Amar','Template Amar','1','28','1','76','77');");
        $this->db->query("REPLACE INTO `sys_menu_rule` (`menuid`, `ruleid`) VALUES ('38', '527'),('244','528');");
        $this->db->query("REPLACE INTO `sys_group_rule` (`groupid`, `ruleid`) 
						VALUES ('410', '527'),('420','527'),('410','1'),('420','1'),('430','527'),('430','1'),('440','527'),('440','1'),('450','527'),('450','1'),('460','527'),('460','1'),('470','527'),('470','1'),('1000','527'),('1000','1'),('1010','527'),('1010','1'),('1020','527'),('1020','1'),('1030','527'),('1030','1'),('20','528'),('20','9'),('1','528'),('10','528'),('10','9');");
        $this->db->query("DELETE FROM `sys_menu_rule` WHERE `menuid` = '1003' AND`ruleid` = '1';");

        $cekkolum = $this->isColumnExist('diversi_register_blm_12tahun','nomor_permohonan');
 		if($cekkolum){
 		$this->db->query("ALTER TABLE `diversi_register_blm_12tahun`   
  					CHANGE `nomor_permohonan` `nomor_permohonan` VARCHAR(50) CHARSET latin1 COLLATE latin1_swedish_ci NULL;");
 		}

 		//320-2
 		$this->db->query("REPLACE INTO  sys_group_rule  ( groupid ,  ruleid ) VALUES ('420', '526'),('440', '526'),('450', '526'),('460', '526'),('470', '526'),('1020', '526'),('1030', '526');");
        $this->db->query("REPLACE INTO dirput_dokumen_ref (jenis_pengadilan,alur_perkara_id,pengajuan_id,keterangan_file,urutan,FORMAT) VALUES (1,4,1,'Putusan Akhir',99,'pdf'), (1,4,1,'Putusan Anonimasi',100,'pdf'), (1,5,1,'Putusan Akhir',99,'pdf'), (1,5,1,'Putusan Anonimasi',100,'pdf'), (1,6,1,'Putusan Akhir',99,'pdf'), (1,6,1,'Putusan Anonimasi',100,'pdf'), (1,7,1,'Putusan Akhir',99,'pdf'), (1,7,1,'Putusan Anonimasi',100,'pdf'), (1,8,1,'Putusan Akhir',99,'pdf'), (1,8,1,'Putusan Anonimasi',100,'pdf'), (1,112,1,'Putusan Akhir',99,'pdf'), (1,112,1,'Putusan Anonimasi',100,'pdf'), (1,113,1,'Putusan Akhir',99,'pdf'), (1,113,1,'Putusan Anonimasi',100,'pdf'), (1,119,1,'Putusan Akhir',99,'pdf'), (1,119,1,'Putusan Anonimasi',100,'pdf'), (2,121,1,'Putusan Akhir',99,'pdf'), (2,121,1,'Putusan Anonimasi',100,'pdf'), (3,10,1,'Putusan Akhir',99,'pdf'), (3,10,1,'Putusan Anonimasi',100,'pdf'), (3,11,1,'Putusan Akhir',99,'pdf'), (3,11,1,'Putusan Anonimasi',100,'pdf'), (4,16,1,'Putusan Akhir',99,'pdf'), (4,16,1,'Putusan Anonimasi',100,'pdf'), (4,122,1,'Putusan Akhir',99,'pdf'), (4,122,1,'Putusan Anonimasi',100,'pdf'), (4,123,1,'Putusan Akhir',99,'pdf'), (4,123,1,'Putusan Anonimasi',100,'pdf');");
        $this->db->query("REPLACE INTO biaya_perkara ( alur_perkara_id ,  jenis_biaya_id ,  jumlah ,  keterangan ) VALUES ('10', '382', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Banding'), ('10', '383', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Kasasi'), ('10', '384', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas PK'), ('10', '385', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Banding'), ('10', '386', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Kasasi'), ('10', '387', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas PK'), ('11', '382', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Banding'), ('11', '383', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas Kasasi'), ('11', '384', '0.00', 'Biaya Pemberkasan/Pengiriman Berkas PK'), ('11', '385', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Banding'), ('11', '386', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas Kasasi'), ('11', '387', '0.00', 'Biaya Pemberitahuan Pengiriman Berkas PK');");
        $this->db->query("UPDATE template_dokumen SET nama ='phs_itsbat_nikah' WHERE id=2007;");
        $this->db->query("REPLACE into  template_dokumen  ( id ,  alur_perkara_id ,  tahapan_id ,  proses_id ,  nomor ,  kode ,  nama ) values('2181','15','14','200','20','BAS Itsbat Nikah Terpadu','BAS Istbat Nikah Terpadu');");
        $this->db->query("UPDATE  sys_menu_rule  SET  ruleid  = '339' WHERE  menuid  = '193' AND ruleid  = '333';");
        $this->db->query("UPDATE  sys_menu_rule  SET  ruleid  = '381' WHERE  menuid  = '193' AND ruleid  = '366';");
        $this->db->query("UPDATE  sys_menu_rule  SET  ruleid  = '382' WHERE  menuid  = '193' AND ruleid  = '367';");
        $this->db->query("UPDATE  sys_menu_rule  SET  ruleid  = '383' WHERE  menuid  = '193' AND ruleid  = '368';");
        $this->db->query("REPLACE INTO  sys_group_rule  ( groupid ,  ruleid ) VALUES ('470', '339'),('470', '381'),('470', '382'),('470', '383'), ('473', '339'),('473', '381'),('473', '382');");
        $this->db->query("UPDATE  jenis_perkara  SET  format_nomor  = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE  id  = '46';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  satuan  = '1' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '12' AND proses_id  = '20'; ");
        $this->db->query("UPDATE  proses_alur_perkara  SET  satuan  = '1' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '12' AND proses_id  = '30'; ");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = '3' , satuan  = '1' , dari_proses_id  = '10' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '12' AND proses_id  = '40';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  nama_tabel_dari  = 'perkara' , nama_kolom_dari  = 'tanggal_pendaftaran' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '12' AND proses_id  = '40';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  satuan  = '1' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '12' AND proses_id  = '80'; ");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = NULL , satuan  = NULL , dari_proses_id  = NULL , nama_tabel_dari  = NULL , nama_kolom_dari  = NULL , nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '110';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = NULL , satuan  = NULL , dari_proses_id  = NULL , nama_tabel_dari  = NULL , nama_kolom_dari  = NULL , nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '120';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '121';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = NULL , satuan  = NULL , dari_proses_id  = NULL , nama_tabel_dari  = NULL , nama_kolom_dari  = NULL , nama_tabel_ke  = NULL , nama_kolom_ke  = NULL , reminder  = '0' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '130';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '140';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '150';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  nama_tabel_ke  = NULL , nama_kolom_ke  = NULL WHERE  alur_perkara_id  = '8' AND tahapan_id  = '13' AND proses_id  = '180';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = '25' , satuan  = '1' , dari_proses_id  = '80' , nama_tabel_dari  = 'perkara_penetapan' , nama_kolom_dari  = 'sidang_pertama' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '15' AND proses_id  = '210';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  satuan  = '1' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '15' AND proses_id  = '220';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = '7' , satuan  = '1' , dari_proses_id  = '282' , nama_tabel_dari  = 'perkara_keberatan' , nama_kolom_dari  = 'penetapan_majelis_hakim' , nama_tabel_ke  = 'perkara_keberatan' , nama_kolom_ke  = 'putusan_keberatan' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '17' AND proses_id  = '288';");
        $this->db->query("UPDATE  proses_alur_perkara  SET  batas_waktu  = '3' , satuan  = '1' , dari_proses_id  = '288' , nama_tabel_dari  = 'perkara_keberatan' , nama_kolom_dari  = 'putusan_keberatan' , nama_tabel_ke  = 'perkara_keberatan' , nama_kolom_ke  = 'pemberitahuan_putusan' , reminder  = '1' WHERE  alur_perkara_id  = '8' AND tahapan_id  = '17' AND proses_id  = '289';");
        $this->db->query("DELETE FROM  proses_alur_perkara  WHERE  alur_perkara_id  = '8' AND tahapan_id  = '40' AND proses_id  = '523';");
        $this->db->query("DELETE FROM  proses_alur_perkara  WHERE  alur_perkara_id  = '8' AND tahapan_id  = '40' AND proses_id  = '524';");

        //320-3

        //320-4
        $this->db->query("DROP VIEW IF EXISTS `v_putus_pdt`;");
        $this->db->query("CREATE VIEW `v_putus_pdt` AS 
							SELECT
							  `v_perkara`.`alur_perkara_id` AS `alur_perkara_id`,
							  `v_perkara`.`perkara_id`      AS `perkara_id`,
							  10                            AS `tahapan_id`,
							  'PN'                          AS `tahapan_nama`,
							  `v_perkara`.`tanggal_putusan` AS `tanggal_putusan`,
							  `v_perkara`.`tanggal_putusan` AS `tanggal_cabut`,
							  `v_perkara`.`tanggal_putusan` AS `tanggal_tms`
							FROM `v_perkara`
							WHERE (`v_perkara`.`alur_perkara_id` < 111)
							UNION 
							SELECT
							     `perkara_banding`.`alur_perkara_id` AS `alur_perkara_id`,
							     `perkara_banding`.`perkara_id`      AS `perkara_id`,
							     20                                  AS `tahapan_id`,
							     'Banding'                           AS `tahapan_nama`,
							     `perkara_banding`.`putusan_banding` AS `tanggal_putusan`,
							     perkara_banding.`tanggal_cabut` AS tanggal_cabut,
							     perkara_banding.`tgl_minutasi` AS tanggal_tms
							FROM `perkara_banding`
							WHERE (`perkara_banding`.`alur_perkara_id` < 111)
							UNION 
							SELECT
							  `perkara_kasasi`.`alur_perkara_id`   AS `alur_perkara_id`,
							  `perkara_kasasi`.`perkara_id`        AS `perkara_id`,
							  30                                   AS `tahapan_id`,
							  'Kasasi'                             AS `tahapan_nama`,
							  `perkara_kasasi`.`putusan_kasasi`    AS `tanggal_putusan`,
							  perkara_kasasi.`minutasi_kasasi` AS tanggal_cabut,
							  perkara_kasasi.`tidak_memenuhi_syarat` AS tanggal_tms
							FROM `perkara_kasasi`
							WHERE (`perkara_kasasi`.`alur_perkara_id` < 111)
							UNION 
							SELECT  `perkara_pk`.`alur_perkara_id`        AS `alur_perkara_id`,
							 `perkara_pk`.`perkara_id`             AS `perkara_id`,
							  40                                    AS `tahapan_id`,
							 'Peninjauan Kembali'                  AS `tahapan_nama`,
							 `perkara_pk`.`putusan_pk`             AS `tanggal_putusan`,
							  perkara_pk.`tanggal_cabut` AS tanggal_cabut,
							  perkara_pk.`minutasi_pk` AS tanggal_tms
							FROM `perkara_pk`
							WHERE (`perkara_pk`.`alur_perkara_id` < 111)
							ORDER BY `perkara_id`,`tahapan_id` DESC;");

        $this->db->query("DROP VIEW IF EXISTS `v_biaya_reminder_minus`");
        $this->db->query("CREATE VIEW `v_biaya_reminder_minus` AS 
							SELECT
							  `a`.`alur_perkara_id` AS `alur_perkara_id`,
							  `a`.`perkara_id`      AS `perkara_id`,
							  `a`.`tahapan_id`      AS `tahapan_id`,
							  `a`.`tahapan_nama`    AS `tahapan_nama`,
							  `a`.`tanggal_putusan` AS `tanggal_putusan`,
							  (`b`.`pemasukan` - `b`.`pengeluaran`) AS `sisa`
							FROM (`v_putus_pdt` `a`
							   LEFT JOIN `v_sum_perkara_biaya` `b`
							     ON (((`a`.`perkara_id` = `b`.`perkara_id`)
							          AND (`a`.`tahapan_id` = `b`.`tahapan_id`))))
							WHERE ISNULL(`a`.`tanggal_putusan`) AND ISNULL(a.tanggal_cabut)
							HAVING (`sisa` < 100000);");

        $this->db->query("REPLACE INTO proses (id,tahapan_id,kode,nama,keterangan,nama_tabel,nama_kolom,STATUS)
							VALUES (645,50,645,'Pencabutan Permohonan Eksekusi','Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks','Pencabutan Permohonan Eksekusi');");

        $this->db->query("REPLACE INTO proses_alur_perkara (id,alur_perkara_id,tahapan_id,tahapan_nama,proses_id,proses_nama,nama_tabel_ke,nama_kolom_ke)
							VALUES(96,1,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(296,3,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(397,4,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(498,5,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(599,6,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(4300,7,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(4301,8,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(4302,9,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(4303,10,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),
							(4304,11,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks'),	
							(4305,15,50,'Ekseskusi',645,'Pencabutan Permohonan Eksekusi','perkara_eksekusi','tanggal_cabut_eks');");

        $cekkolum = $this->isColumnExist('perkara_eksekusi','tanggal_cabut_eks');  		
        if(!$cekkolum){
 		$this->db->query("ALTER TABLE `perkara_eksekusi`   
  							ADD COLUMN `tanggal_cabut_eks` DATE NULL  COMMENT 'tanggal cabut eksekusi' AFTER `surat_lembaga_perwakilan_rakyat`;");
 		}

        $cekkolum = $this->isColumnExist('perkara_eksekusi_ht','tanggal_cabut_ht');  		
        if(!$cekkolum){
        $this->db->query("ALTER TABLE `perkara_eksekusi_ht`   
  							ADD COLUMN `tanggal_cabut_ht` DATE NULL  COMMENT 'tanggal cabut permohonan' AFTER `no_sertifikat`;");
    	}

        $this->db->query("REPLACE INTO template_dokumen (`id`, `alur_perkara_id`, `tahapan_id`, `proses_id`, `nomor`, `kode`, `nama`) VALUES ('2182', '9', '10', '10', '15','G_9_10_10_15', 'SKUM');");

        $this->db->query("DROP VIEW IF EXISTS `viewpihakweb`;");
        $this->db->query("CREATE VIEW `viewpihakweb` AS 
							SELECT 
							  '1' AS `pihak_ke`,
							  `p1`.`pihak_id` AS `ID`,
							  `p1`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '64') 
							        AND (`p1`.`nama` IS NOT NULL) 
							        AND (`p1`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '137') 
							        AND (`p1`.`nama` IS NOT NULL) 
							        AND (`p1`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '346') 
							        AND (`p1`.`nama` IS NOT NULL) 
							        AND (`p1`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '347') 
							        AND (`p1`.`nama` IS NOT NULL) 
							        AND (`p1`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (`p`.`pihak_dipublikasikan` = 'Y') 
							      THEN `p1`.`nama` 
							      WHEN (
							        (`p`.`pihak_dipublikasikan` = 'T') 
							        AND (`p1`.`nama` IS NOT NULL) 
							        AND (`p1`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      ELSE `p1`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p1`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak1` `p1` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p1`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p1`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '2' AS `pihak_ke`,
							  `p2`.`pihak_id` AS `ID`,
							  `p2`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p`.`alur_perkara_id` = '118') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN CONVERT(
							        CONCAT(
							          'Anak Berhadapan Dengan Hukum',
							          `p2`.`urutan`
							        ) USING latin1
							      ) 
							      WHEN (
							        (`p`.`jenis_perkara_id` = '98') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Terdakwa'
							      WHEN (
							        (`p`.`jenis_perkara_id` = '293') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Terdakwa' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '64') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '137') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '346') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '347') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`pihak_dipublikasikan` = 'T') 
							        AND (`p2`.`nama` IS NOT NULL) 
							        AND (`p2`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      ELSE `p2`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p2`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak2` `p2` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p2`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p2`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '3' AS `pihak_ke`,
							  `p3`.`pihak_id` AS `ID`,
							  `p3`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '64') 
							        AND (`p3`.`nama` IS NOT NULL) 
							        AND (`p3`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '137') 
							        AND (`p3`.`nama` IS NOT NULL) 
							        AND (`p3`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '346') 
							        AND (`p3`.`nama` IS NOT NULL) 
							        AND (`p3`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '347') 
							        AND (`p3`.`nama` IS NOT NULL) 
							        AND (`p3`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`pihak_dipublikasikan` = 'T') 
							        AND (`p3`.`nama` IS NOT NULL) 
							        AND (`p3`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      ELSE `p3`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p3`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak3` `p3` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p3`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p3`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '4' AS `pihak_ke`,
							  `p4`.`pihak_id` AS `ID`,
							  `p4`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '64') 
							        AND (`p4`.`nama` IS NOT NULL) 
							        AND (`p4`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '1') 
							        AND (`p`.`jenis_perkara_id` = '137') 
							        AND (`p4`.`nama` IS NOT NULL) 
							        AND (`p4`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '346') 
							        AND (`p4`.`nama` IS NOT NULL) 
							        AND (`p4`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`alur_perkara_id` = '15') 
							        AND (`p`.`jenis_perkara_id` = '347') 
							        AND (`p4`.`nama` IS NOT NULL) 
							        AND (`p4`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      WHEN (
							        (`p`.`pihak_dipublikasikan` = 'T') 
							        AND (`p4`.`nama` IS NOT NULL) 
							        AND (`p4`.`nama` <> '')
							      ) 
							      THEN 'Disamarkan' 
							      ELSE `p4`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p4`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak4` `p4` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p4`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p4`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '5' AS `pihak_ke`,
							  `p5`.`pihak_id` AS `ID`,
							  `p5`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p5`.`jenis_saksi` = '3') 
							        AND (`p5`.`nama` IS NOT NULL) 
							        AND (`p5`.`nama` <> '')
							      ) 
							      THEN 'Saksi Anak' 
							      ELSE `p5`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p5`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak5` `p5` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p5`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p5`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '6' AS `pihak_ke`,
							  `p6`.`pihak_id` AS `ID`,
							  `p6`.`perkara_id` AS `IDPerkara`,
							  (
							    CASE
							      WHEN (
							        (`p6`.`jenis_pihak_id` = '1') 
							        AND (`p6`.`nama` IS NOT NULL) 
							        AND (`p6`.`nama` <> '')
							      ) 
							      THEN 'Korban' 
							      ELSE `p6`.`nama` 
							    END
							  ) AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p6`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak_korban` `p6` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p6`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p6`.`pihak_id`))
							  ) 
							UNION
							ALL 
							SELECT 
							  '7' AS `pihak_ke`,
							  `p7`.`pihak_id` AS `ID`,
							  `p7`.`perkara_id` AS `IDPerkara`,
							  `p7`.`nama` AS `nama`,
							  (
							    CASE
							      WHEN (
							        `pihak`.`tanggal_lahir` IS NOT NULL
							      ) 
							      THEN TIMESTAMPDIFF(
							        YEAR,
							        `pihak`.`tanggal_lahir`,
							        `p`.`tanggal_pendaftaran`
							      ) 
							      ELSE NULL 
							    END
							  ) AS `umur`,
							  `pihak`.`jenis_kelamin` AS `jenis_kelamin`,
							  `p7`.`urutan` AS `urutan` 
							FROM
							  (
							    (
							      `perkara_pihak_pembimbing_masyarakat` `p7` 
							      LEFT JOIN `perkara` `p` 
							        ON (
							          (
							            `p`.`perkara_id` = `p7`.`perkara_id`
							          )
							        )
							    ) 
							    LEFT JOIN `pihak` 
							      ON ((`pihak`.`id` = `p7`.`pihak_id`))
							  );");

        $this->db->query("DROP VIEW IF EXISTS `viewperkaraputusanweb`");
        $this->db->query("CREATE VIEW `viewperkaraputusanweb` AS 
							SELECT
							  `put`.`perkara_id`                     AS `IDPerkara`,
							  `put`.`tanggal_putusan`                AS `tglPutusan`,
							  `put`.`putusan_verstek`                AS `isVerstek`,
							  `s`.`nama`                             AS `sumberHukum`,
							  `put`.`status_putusan_id`              AS `IDStatusPutusan`,
							  `sp`.`nama`                            AS `statusPutusan`,
							  `put`.`tanggal_cabut`                  AS `tglCabut`,
							  `put`.`tanggal_gugur`                  AS `tglGugur`,
							  (CASE WHEN (`p`.`alur_perkara_id` = 118) THEN 'Disamarkan' WHEN (`p`.`jenis_perkara_id` IN (64,98,293,359,346,347)) THEN 'Disamarkan' ELSE `put`.`amar_putusan` END) AS `amar`,
							  `put`.`penetapan_hakim_pengawas`       AS `tglPenetapanHakimPengawas`,
							  `put`.`nomor_penetapan_hakim_pengawas` AS `noPenetapanHakimPengawas`,
							  `put`.`hakim_pengawas_id`              AS `IDHakimPengawas`,
							  `put`.`pengurus_id`                    AS `IDPengurus`,
							  `put`.`tanggal_penetapan_kreditur`     AS `tglPenetapanKreditur`,
							  `put`.`panitia_kreditur`               AS `panitiaKreditur`,
							  `put`.`kurator_id`                     AS `IDKurator`,
							  `put`.`tanggal_berita_putusan`         AS `tglMediaBerita`,
							  `put`.`nama_media_berita_putusan`      AS `namaMediaBerita`,
							  `put`.`tanggal_surat_kabar_putusan`    AS `tglSuratKabar`,
							  `put`.`nama_surat_kabar_putusan`       AS `namaSuratKabar`,
							  `put`.`tanggal_minutasi`               AS `tglMinutasi`,
							  `put`.`kirim_salinan_putusan_penyidik` AS `TglKirimSalinanPenyidik`,
							  `put`.`catatan_putusan`                AS `catatan_putusan`,
							  `put`.`nilai_ganti_kerugian`           AS `nilai_ganti_kerugian`
							FROM (((`perkara_putusan` `put`
							     LEFT JOIN `sumber_hukum` `s`
							       ON ((`s`.`id` = `put`.`sumber_hukum_id`)))
							    LEFT JOIN `status_putusan` `sp`
							      ON ((`sp`.`id` = `put`.`status_putusan_id`)))
							   LEFT JOIN `perkara` `p`
							     ON ((`put`.`perkara_id` = `p`.`perkara_id`)))");

        $this->db->query("DROP VIEW IF EXISTS `viewperkarapenuntutanweb`;");
        $this->db->query("CREATE VIEW `viewperkarapenuntutanweb` AS 
							SELECT
							  `perkara_penuntutan`.`perkara_id`         AS `IDPerkara`,
							  `perkara_penuntutan`.`tanggal_penuntutan` AS `tglPenuntutan`,
							  (CASE WHEN (`perkara`.`alur_perkara_id` = 118) THEN 'Disamarkan' WHEN (`perkara`.`jenis_perkara_id` IN (64,98,293)) THEN 'Disamarkan' ELSE `perkara_penuntutan`.`isi_penuntutan` END) AS `isiTuntutan`
							FROM (`perkara_penuntutan`
							   LEFT JOIN `perkara`
							     ON ((`perkara_penuntutan`.`perkara_id` = `perkara`.`perkara_id`)));");

        $this->db->query("DROP VIEW IF EXISTS `viewdataumumweb`;");
        $this->db->query("CREATE VIEW `viewdataumumweb` AS 
							SELECT
							  `perkara`.`perkara_id`           AS `IDPerkara`,
							  `perkara`.`tanggal_pendaftaran`  AS `tglPendaftaran`,
							  `perkara`.`alur_perkara_id`      AS `klasifikasiPerkara`,
							  `perkara`.`jenis_perkara_id`     AS `IDJenisPerkara`,
							  `perkara`.`jenis_perkara_nama`   AS `jenisPerkara`,
							  `perkara`.`nomor_perkara`        AS `noPerkara`,
							  `perkara`.`tanggal_surat`        AS `tglSurat`,
							  `perkara`.`nomor_surat`          AS `noSurat`,
							  (CASE WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 346)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 347)) THEN 'Disamarkan' WHEN (`perkara`.`alur_perkara_id` = 118) THEN 'Disamarkan' WHEN (`perkara`.`jenis_perkara_id` IN (64,98,293,359)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` < 100) AND (`perkara`.`pihak_dipublikasikan` = 'T')) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` < 100) AND (`perkara`.`pihak_dipublikasikan` = 'Y')) THEN `perkara`.`petitum` WHEN ((`perkara`.`alur_perkara_id` > 100) AND (`perkara`.`pihak_dipublikasikan` = 'T')) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` > 100) AND (`perkara`.`pihak_dipublikasikan` = 'Y')) THEN `perkara`.`dakwaan` ELSE 'Error' END) AS `petitumDakwaan`,
							  `perkara`.`pihak_dipublikasikan` AS `dipublikasikan`,
							  `perkara`.`prodeo`               AS `prodeo`,
							  `perkara`.`nilai_sengketa`       AS `nilai_sengketa`,
							  `perkara`.`proses_terakhir_id`   AS `IDProses`,
							  `perkara`.`proses_terakhir_text` AS `statusAkhir`,
							  (CASE WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 64)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 137)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 346)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 347)) THEN 'Disamarkan' WHEN ((`perkara`.`pihak_dipublikasikan` = 'T') AND (`perkara`.`alur_perkara_id` > 100)) THEN `perkara`.`pihak1_text` WHEN ((`perkara`.`pihak_dipublikasikan` = 'T') AND (`perkara`.`pihak1_text` IS NOT NULL) AND (`perkara`.`pihak1_text` <> '')) THEN 'Disamarkan' ELSE `perkara`.`pihak1_text` END) AS `pihakPertama`,
							  (CASE WHEN (`perkara`.`alur_perkara_id` = 118) THEN 'Anak Berhadapan Dengan Hukum' WHEN (`perkara`.`jenis_perkara_id` = 98) THEN 'Terdakwa' WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 64)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 346)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 347)) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 111) AND (`perkara`.`jenis_perkara_id` = 25)) THEN 'Terdakwa' WHEN ((`perkara`.`alur_perkara_id` = 111) AND (`perkara`.`jenis_perkara_id` = 200)) THEN 'Terdakwa' WHEN ((`perkara`.`alur_perkara_id` = 120) AND (`perkara`.`jenis_perkara_id` = 293)) THEN 'Terdakwa' WHEN ((`perkara`.`pihak_dipublikasikan` = 'T') AND (`perkara`.`pihak2_text` IS NOT NULL) AND (`perkara`.`pihak2_text` <> '')) THEN 'Disamarkan' ELSE `perkara`.`pihak2_text` END) AS `pihakKedua`,
							  (CASE WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 64) AND (`perkara`.`pihak3_text` IS NOT NULL) AND (`perkara`.`pihak3_text` <> '')) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 137) AND (`perkara`.`pihak3_text` IS NOT NULL) AND (`perkara`.`pihak3_text` <> '')) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 346) AND (`perkara`.`pihak3_text` IS NOT NULL) AND (`perkara`.`pihak3_text` <> '')) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 347) AND (`perkara`.`pihak3_text` IS NOT NULL) AND (`perkara`.`pihak3_text` <> '')) THEN 'Disamarkan' WHEN ((`perkara`.`pihak_dipublikasikan` = 'T') AND (`perkara`.`pihak3_text` IS NOT NULL) AND (`perkara`.`pihak3_text` <> '')) THEN 'Disamarkan' ELSE `perkara`.`pihak3_text` END) AS `pihakKetiga`,
							  (CASE WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 64) AND ((`perkara`.`pihak4_text` IS NOT NULL) OR (`perkara`.`pihak4_text` <> ''))) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 1) AND (`perkara`.`jenis_perkara_id` = 137) AND ((`perkara`.`pihak4_text` IS NOT NULL) OR (`perkara`.`pihak4_text` <> ''))) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 347) AND ((`perkara`.`pihak4_text` IS NOT NULL) OR (`perkara`.`pihak4_text` <> ''))) THEN 'Disamarkan' WHEN ((`perkara`.`alur_perkara_id` = 15) AND (`perkara`.`jenis_perkara_id` = 346) AND ((`perkara`.`pihak4_text` IS NOT NULL) OR (`perkara`.`pihak4_text` <> ''))) THEN 'Disamarkan' WHEN ((`perkara`.`pihak_dipublikasikan` = 'T') AND ((`perkara`.`pihak4_text` IS NOT NULL) OR (`perkara`.`pihak4_text` <> ''))) THEN 'Disamarkan' ELSE `perkara`.`pihak4_text` END) AS `pihakKeempat`,
							  `p`.`tglPutusan`                 AS `tglPutusan`,
							  `p`.`tglMinutasi`                AS `tglMinutasi`,
							  `perkara`.`pasal_dakwaan`        AS `pasalDakwaan`,
							  `p`.`tglBHT`                     AS `tglBHT`
							FROM (`perkara`
							   LEFT JOIN `viewputusanperkara` `p`
							     ON ((`perkara`.`perkara_id` = `p`.`IDPerkara`)));");
        

        $this->db->query("REPLACE INTO `status_penahanan` (`id`, `nama`) VALUES ('5', 'Dibebaskan');");
        //320-5
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '92';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '93';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '94';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '95';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '96';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '97';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '98';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '99';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '100';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '102';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '103';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '104';");
        $this->db->query("DELETE FROM `status_putusan` WHERE `id` = '105';");
		
		$this->db->query("UPDATE sys_config SET `value` = '3.2.0' WHERE id = '80';");
		
		//update table update patch 3.2.0
		$data = array('updated' => 1,'updated_stamp'=>date("Y-m-d H:i:s"));
		$this->db->where('patch_ver', '3.2.0');
		$this->db->update('updates', $data); 
		
		$this->db->query("SET FOREIGN_KEY_CHECKS=1;");

		return true;
	}

}
