<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_tun extends CI_Controller {

    function index() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); 
        }
    }

    function popup_bap_pertama(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment('3'); 
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		//print_r($idperkara);exit;
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        
		$idsidang=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));
        if(!is_numeric($idsidang) OR !intval($idsidang)>0){
            show_404();
            exit();
        }        
        
        $this->load->model('generate_template/m_template_bap_tun','template');
        $data['penandatangan']=$this->template->getDataPA();
        $cek_sidang= $this->template->cek_sidang($idperkara, $idsidang);
        foreach ( $cek_sidang->result() as $row) {
            $urutan = $row->ke;
            $hadir = $row->hadir;
            if(empty($row->id_kuasa)){
                $kuasa="T";
            }else{
                $kuasa="Y";
            }
        }
        if($hadir==1){
            $nomor=5;
        }elseif($hadir==2){
            $nomor=3;
        }elseif($hadir==3){
            if($kuasa=="Y"){
                $nomor=2;
            }else{
                $nomor=4;
            }
        }elseif($hadir==4){
            if($kuasa=="Y"){
                $nomor=6;
            }else{
                $nomor=1;
            }
        }

        $data['blangko_bap_tun']=$this->template->blangko_bap_tun($nomor);

        $this->load->view('generate_template/tun/popup_bap_tun', $data, FALSE);        
    }

	function cetak_bas_pertama_tun(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->input->post('enc',TRUE);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->input->post('encjadwalsidang',TRUE);
        $data['idjadwal']=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($data['idjadwal']) OR !intval($data['idjadwal'])>0){            
            show_404();
            exit();
        }           
        $data['blangko_bap_tun'] = $this->input->post('blangko_bap_tun',TRUE);
		$filenya="peradilan_tun/Gugatan/BAP/".$data['blangko_bap_tun'].".rtf";
		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
					'jadwal_sidang_id'=> $data['idjadwal']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);  
    }
	
	function cetak_putusan_sela(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }
        $segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment(3);
        $data['jenisTemplate']=$this->uri->segment(4);
        $data['encPutusanSela']=$this->uri->segment(5);
        $jenisTemplate=$data['jenisTemplate'];

        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        $idPutusanSela=$this->encrypt->decode(base64_decode($data['encPutusanSela']));
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2'); 

        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }
        $this->load->model('generate_template/m_template_putusan_tun','template');
        $data['dataPN'] = $this->template->get_data_pn($idperkara);
        $data['dataPihak1']=$this->template->get_data_pihak($idperkara,1);
        $data['dataPengacaraPihak1']=$this->template->get_data_pengacara($idperkara,1);
        $data['dataPihak2']=$this->template->get_data_pihak($idperkara,2);
        $data['dataPengacaraPihak2']=$this->template->get_data_pengacara($idperkara,2);
        $data['dataPihak3']=$this->template->get_data_pihak($idperkara,3);
        $data['dataPengacaraPihak3']=$this->template->get_data_pengacara($idperkara,3);
        $data['dataPihak4']=$this->template->get_data_pihak($idperkara,4);
        $data['dataSaksi']=$this->template->get_data_pihak($idperkara,5);
        $data['dataPerkara']=$this->template->get_data_perkara($idperkara);
        $data['dataPutusan']=$this->template->get_data_putusan($idperkara);
        $data['dataBiayaPerkara']=$this->template->get_biaya_perkara($idperkara);
        $data['dataPenetapan']=$this->template->get_data_penetapan($idperkara);
        $data['dataPenetapanPersiapan']=$this->template->getPenetapanPersiapan($idperkara);
        $data['dataDismissal']=$this->template->get_data_dismissal($idperkara);
        $data['dataCabut']=$this->template->get_data_cabut($idperkara);
        $data['dataPersiapan']=$this->template->get_data_persiapan($idperkara);

        if ($jenisTemplate=='pencabutan_gugatan_dikabulkan'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Pencabutan_gugatan_kabul.rtf";
        } else if ($jenisTemplate=='pencabutan_gugatan_ditolak'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Pencabutan_gugatan_tolak.rtf";
        } else if($jenisTemplate=='ktun_dikabulkan'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Penundaan Pelaksanaan KTUN Dikabulkan.rtf";
        } else if ($jenisTemplate=='ktun_ditolak'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Penundaan Pelaksanaan KTUN Ditolak.rtf";
        } else if ($jenisTemplate=='penetapan_intervensi_dikabulkan'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Putusan_sela_intervensi.rtf";
        } else if ($jenisTemplate=='penetapan_intervensi_ditolak'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/Putusan_sela_tolakintervensi.rtf";
        } else if ($jenisTemplate=='gugatan_tidak_dapat_diterima'){
			$filenya="peradilan_tun/Gugatan/Putusan Sela/penetapan_MH.rtf";
        } else{
            show_404();
            exit();
        }
		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'ditetapkan_oleh'=>$data['options']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
    }
	
	function cetak_putusan_tun(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       

        $segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment('3');
        $jenisTemplate=$this->uri->segment('4');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }
        $jenisTemplate =$segment[4];
        if(!is_numeric($jenisTemplate) OR !intval($jenisTemplate)>0){
             show_404();
             exit();
        }
        $this->load->model('generate_template/m_template_putusan_tun','template');
        $data['dataPN'] = $this->template->get_data_pn($idperkara);
        $data['dataPihak1']=$this->template->get_data_pihak($idperkara,1);
        $data['dataPengacaraPihak1']=$this->template->get_data_pengacara($idperkara,1);
        $data['dataPihak2']=$this->template->get_data_pihak($idperkara,2);
        $data['dataPengacaraPihak2']=$this->template->get_data_pengacara($idperkara,2);
        $data['dataPihak3']=$this->template->get_data_pihak($idperkara,3);
        $data['dataPengacaraPihak3']=$this->template->get_data_pengacara($idperkara,3);
        $data['dataPihak4']=$this->template->get_data_pihak($idperkara,4);
        $data['dataSaksi']=$this->template->get_data_pihak($idperkara,5);
        $data['dataPerkara']=$this->template->get_data_perkara($idperkara);
        $data['dataPutusan']=$this->template->get_data_putusan($idperkara);
        $data['dataBiayaPerkara']=$this->template->get_biaya_perkara($idperkara);
        $data['dataPenetapan']=$this->template->get_data_penetapan($idperkara);
        $data['dataPenetapanPersiapan']=$this->template->getPenetapanPersiapan($idperkara);
        $data['dataDismissal']=$this->template->get_data_dismissal($idperkara);
        $data['dataCabut']=$this->template->get_data_cabut($idperkara);
        $data['dataPersiapan']=$this->template->get_data_persiapan($idperkara);
       
        if($jenisTemplate==1){
			$filenya="peradilan_tun/Gugatan/Putusan/4. Putusan Pencabutan Gugatan.rtf"; //Putusan Cabut
        } else if ($jenisTemplate==2){
			$filenya="peradilan_tun/Gugatan/Putusan/5. Putusan Tidak Diterima.rtf"; //Putusan Tidak Dapat Diterima
        } else if ($jenisTemplate==3){
			$filenya="peradilan_tun/Gugatan/Putusan/2. Putusan Dikabulkan Seluruhnya.rtf"; //Putusan Dikabulkan
        } else if ($jenisTemplate==4){
			$filenya="peradilan_tun/Gugatan/Putusan/1. Putusan Ditolak.rtf"; //Putusan Ditolak
        } else if ($jenisTemplate==5){
			$filenya="peradilan_tun/Gugatan/Putusan/3. Putusan Gugur.rtf"; //Putusan Gugur
        } else if ($jenisTemplate==6){
			$filenya="peradilan_tun/Permohonan/Putusan/FP KABUL.rtf"; //Putusan FP-KABUL
        } else if ($jenisTemplate==7){
			$filenya="peradilan_tun/Permohonan/Putusan/FP-Ditolak.rtf"; //Putusan FP-TOLAK
        }
		else{
            show_404();
            exit();
        }
				$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'ditetapkan_oleh'=>$data['options']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
    }
	#penetapan persiapan
    function cetak_penetapan_persiapan_tun($enc,$jenisTemplate){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       

        $segment = $this->uri->segment_array();       
        $idperkara=$this->encrypt->decode(base64_decode($enc));       
        $data['idperkara'] = $idperkara;
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){            
            show_404();
            exit();
        }   
                
        $data['jenisTemplate'] = $jenisTemplate;        

        $this->load->model('generate_template/m_template_pemberitahuan_putusan_tun','template');
        $data['datapn'] = $this->template->getDataPN();
        $data['datapenetapan'] = $this->template->getDataPenetapanPersiapan($idperkara);        
        $data['datapihakpenggugat'] = $this->template->getPihakPenggugat($idperkara);
        $data['datapihaktergugat'] = $this->template->getPihakTergugat($idperkara);  
		
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if($data['jenisTemplate']==3){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan Pemeriksan Persiapan.rtf";
        }else if($data['jenisTemplate']==5){
			$filenya="peradilan_tun/Gugatan/BAP/BA 1a - BAP Pemeriksaan Persiapan.rtf"; 
        }
		else if($data['jenisTemplate']==6){
			$filenya="peradilan_tun/Gugatan/BAP/BA 1b - BAP Pemeriksaan Persiapan Tunda karena Pihak Tidak Hadir.rtf";
        }        
        else{
            show_404();
            exit();
        }  
 
		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'ditetapkan_oleh'=>$data['options']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
		
    }
	function popup_pilihan_ketua(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Penetapan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(1)),
                'nama' => 'Ketua Pengadilan'),
            array('id' => base64_encode($this->encrypt->encode(2)),
                'nama' => 'Wakil Ketua Pengadilan'),
            array('id' => base64_encode($this->encrypt->encode(5)),
                'nama' => 'Plh Ketua Pengadilan'),
            array('id' => base64_encode($this->encrypt->encode(6)),
                'nama' => 'Plt Ketua Pengadilan')
            );
			//print_r($data); exit();
        $this->load->view('generate_template/tun/popup_tun_pilihan',$data,FALSE);

    }
	function cetak_template(){  
        
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }

        if(empty($_POST)){
            $segment = $this->uri->segment_array();            
            $data['enc'] = $segment[3];
            $idtemplate = $segment[4];
            $data['options'] = '';
            if(!empty($segment[5])){
                $data['idpihak'] =$this->encrypt->decode(base64_decode($segment[5]));
            }
        }else{
            $idtemplate=$this->encrypt->decode(base64_decode($this->input->post('enc_template',TRUE)));
            $idpihak=$this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
            $data['enc'] = $this->input->post('enc',TRUE);
            $data['options'] = $this->encrypt->decode(base64_decode($this->input->post('options',TRUE)));
            $data['idpihak'] = $idpihak;
            $idjadwal = $this->input->post('idjadwal',TRUE);
            if(!empty($idjadwal)){
                $data['idjadwal']=$this->encrypt->decode(base64_decode($idjadwal));
            }            
        }
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
				
		//print_r ($idtemplate); exit();
		if($idtemplate == 1626){
			$filenya="peradilan_tun/Gugatan/Penetapan/penetapan_MH.rtf"; // Cetak Template Penetapan Majelis Hakim
		}else if($idtemplate == 1722){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan_MH_kembali.rtf"; //Cetak Template Penetapan Kembali Majelis Hakim
		}else if ($idtemplate == 1720){
			$filenya="peradilan_tun/Gugatan/Penetapan/penetapan_hakim_tunggal.rtf"; //Cetak Template Penetapan Majelis Hakim Tunggal
		}else if ($idtemplate == 1718){
			$filenya="peradilan_tun/Gugatan/Penetapan/penetapan_hari_sidang_pertama.rtf"; //Cetak Template Penetapan Hari Sidang Pertama
		}else if ($idtemplate == 1780){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan Majelis Hakim Penolakan Acara Singkat.rtf"; //Cetak Template Penetapan Majelis Hakim Penolakan Acara Singkat
		}else if($idtemplate == 1717){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan_MH_Perlawanan.rtf"; //Cetak Template Penetapan Majelis Hakim Perlawanan
		}else if($idtemplate == 1606){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penunjukan_PP_Perlawanan.rtf"; //Cetak Template Penunjukan PP Perlawanan
		}else if($idtemplate == 1583){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan_Haris_sidang_Perlawanan.rtf"; //Cetak Template PHS Perlawanan
		}else if ($idtemplate == 1654){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_sidang_penggugat.rtf";// Cetak Template Relaas Panggilan Pengugat
		}else if ($idtemplate == 1655){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_sidang_tergugat.rtf"; //Cetak Template Relaas Panggilan Tergugat
		}else if ($idtemplate == 1656){
			$filenya="peradilan_tun/Gugatan/Panggilan/Panggilan_sidang_intervensi.rtf"; //Cetak Template Relaas Panggilan Intervensi
		}else if ($idtemplate == 1657){
			$filenya="peradilan_tun/Gugatan/Panggilan/Panggilan_sidang_saksi.rtf"; //Cetak Template Relaas Panggilan Saksi
		}else if ($idtemplate == 1815){
			$filenya="peradilan_tun/Gugatan/Pendaftaran/Penetapan Kuasa Insidentil.rtf"; //Cetak Template Kuasa Insidentil
		}else if($idtemplate == 1595){;
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan Lolos Dismissal.rtf"; //Cetak Template Penetapan Lolos Dismissal
		}else if($idtemplate == 1596){
			$filenya="peradilan_tun/Gugatan/Penetapan/Penetapan Dismissal.rtf"; //Cetak Template Penetapan Dismissal
		}else if($idtemplate == 1627){;
			$filenya="peradilan_tun/Gugatan/Penetapan/Pemberitahuan Penetapan Dismissal Penggugat.rtf"; //Cetak Template Pemberitahuan Dismissal Penggugat
		}else if($idtemplate == 1628){
			$filenya="peradilan_tun/Gugatan/Penetapan/Pemberitahuan Penetapan Dismissal Tergugat.rtf"; //Cetak Template Pemberitahuan Dismissal Tergugat
		}else if($idtemplate == 3001){
			$filenya="peradilan_tun/Permohonan/Penetapan/Penetapan Majelis Hakim.rtf"; //Cetak Template PMH Permohonan 
		}else if($idtemplate == 3002){
			$filenya="peradilan_tun/Permohonan/Penetapan/Penetapan PP dan Juru Sita.rtf"; //Cetak Template Penetapan PP dan Juru Sita Permohonan 
		}else if($idtemplate == 3003){
			$filenya="peradilan_tun/Permohonan/Penetapan/Penetapan Hari Sidang Pertama.rtf"; //Cetak Template PHS Permohonan 
		}else if($idtemplate == 3004){
			$filenya="peradilan_tun/Permohonan/Penetapan/Penetapan Majelis Hakim.rtf"; //Cetak Template PMH Kembali Permohonan 
		}else if($idtemplate == 3005){
			$filenya="peradilan_tun/Permohonan/Penetapan/Penetapan PP dan Juru Sita.rtf"; //Cetak Template Penetapan PP dan Juru Sita Kembali Permohonan 
		}else if($idtemplate == 1620){
			$filenya="peradilan_tun/Gugatan/Penetapan/penunjukan_PP_JS.rtf"; //Cetak Template Penetapan PP dan Juru Sita Kembali Permohonan 
		}else{
            show_404();
            exit();
        }
		
		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
					'jadwal_sidang_id'=> $data['idjadwal'],
                    'ditetapkan_oleh'=>$data['options']);  
		//print_r($data_id); exit();
        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
    }
	
	function popup_pilihan_panitera_pbt(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Pemberitahuan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(3)),
                'nama' => 'Panitera'),
            array('id' => base64_encode($this->encrypt->encode(4)),
                'nama' => 'Wakil Panitera'),
            array('id' => base64_encode($this->encrypt->encode(7)),
                'nama' => 'Plh Panitera'),
            array('id' => base64_encode($this->encrypt->encode(8)),
                'nama' => 'Plt Panitera')
            );
        $this->load->view('generate_template/tun/popup_tun_pilihan',$data,FALSE);

    }
	function popup_pilihan_panitera_ppjsp(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Penunjukan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(3)),
                'nama' => 'Panitera'),
            array('id' => base64_encode($this->encrypt->encode(4)),
                'nama' => 'Wakil Panitera'),
            array('id' => base64_encode($this->encrypt->encode(7)),
                'nama' => 'Plh Panitera'),
            array('id' => base64_encode($this->encrypt->encode(8)),
                'nama' => 'Plt Panitera')
            );
        $this->load->view('generate_template/tun/popup_tun_pilihan_ppjsp',$data,FALSE);
    }
	//Cetak penetapan Panitera Pengganti dan JSP
	function cetak_template_ppjsp(){  
        
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }

        if(empty($_POST)){
            $segment = $this->uri->segment_array();            
            $data['enc'] = $segment[3];
            $idtemplate = $segment[4];
            $data['options'] = '';
            if(!empty($segment[5])){
                $data['idpihak'] =$this->encrypt->decode(base64_decode($segment[5]));
            }
        }else{
            $idtemplate=$this->encrypt->decode(base64_decode($this->input->post('enc_template',TRUE)));
            $idpihak=$this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
            $data['enc'] = $this->input->post('enc',TRUE);
            $data['options'] = $this->encrypt->decode(base64_decode($this->input->post('options',TRUE)));
            $data['idpihak'] = $idpihak;
            $idjadwal = $this->input->post('idjadwal',TRUE);
            if(!empty($idjadwal)){
                $data['idjadwal']=$this->encrypt->decode(base64_decode($idjadwal));
            }            
        }
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		//print_r ($idtemplate); exit();
		$this->load->model('generate_template/m_template_tun_perlawanan','template');
		$template=$this->template->get_cek_perubahan_pp($idperkara);
		//$i=0;
        $jumdata=count($template->result());
		if ($jumdata==0){
                 $filenya="peradilan_tun/Gugatan/Penetapan/penunjukan_PP_JS.rtf"; //Cetak Template Penunjukan PP dan JSP
            }else{
                 $filenya="peradilan_tun/Gugatan/Penetapan/Penunjukan_PP_kembali.rtf"; //Cetak Template Penunjukan PP dan JSP
            }

		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'ditetapkan_oleh'=>$data['options']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
		
    }
	function popup_pilihan_panitera(){
        $data['isclickable'] = TRUE;
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $data['judul'] = 'Cetak Dokumen Penunjukan';
        $data['nama_kolom'] = 'Tanda Tangan Oleh';
        $data['idoption'] = 'options';
        $data['pilihan'] = array(
            array('id' => 0,
                'nama' => 'Pilih Jabatan'),
            array('id' => base64_encode($this->encrypt->encode(3)),
                'nama' => 'Panitera'),
            array('id' => base64_encode($this->encrypt->encode(4)),
                'nama' => 'Wakil Panitera'),
            array('id' => base64_encode($this->encrypt->encode(7)),
                'nama' => 'Plh Panitera'),
            array('id' => base64_encode($this->encrypt->encode(8)),
                'nama' => 'Plt Panitera')
            );
        $this->load->view('generate_template/tun/popup_tun_pilihan',$data,FALSE);
    }
	
	function popup_pilihan_pihak_dis($enc,$encPersiapanProses,$pihakke){
        $segment = $this->uri->segment_array();
        $data['enc'] = $enc;       
        $idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['idjadwal'] = $encPersiapanProses; 
		$idjadwal=$this->encrypt->decode(base64_decode($encPersiapanProses));		
        $data['judul'] = 'Cetak Dokumen Pemberitahuan/Panggilan';
        $data['nama_kolom'] = 'Kepada';               
        $data['nama_kolom_ttd'] = 'Tanda Tangan Oleh';
        $data['pilihan'] = array();
        $this->load->model('generate_template/m_template_pemberitahuan_putusan_tun','model_template');
        if($pihakke==1 OR $pihakke==2){
            $list_pihak = $this->model_template->getListPihak($idperkara,$pihakke);
            $data['pihakke'] = base64_encode($this->encrypt->encode($pihakke));
        }        
        if($pihakke==3 OR $pihakke==4){
            $data['penandaTangan'] = $this->model_template->penandaTangan();
            if($pihakke==3){
                $idpihak=1;
            }elseif($pihakke==4){
                $idpihak=2;
            }
            $list_pihak = $this->model_template->getListPihak($idperkara,$idpihak);
            $data['pihakke'] = base64_encode($this->encrypt->encode($idpihak));            
        }
        $data['idpihak'] = base64_encode($this->encrypt->encode($pihakke));            
        $data['isclickable'] = TRUE;
        if($list_pihak->num_rows>0){
            $i=1;
            $data['pilihan'] = array(array('id' => 0,
                'nama' => 'Pilih Pihak'));
            foreach ($list_pihak->result() as $row) {
                $data['pilihan'][$i] = array(
                    'id' => base64_encode($this->encrypt->encode($row->id)),
                    'nama' => $row->nama
                );
                $i++;
            }
        }else{
            $data['pilihan'] = array(
            array('id' => base64_encode($this->encrypt->encode(0)),
                'nama' => 'Pihak Tidak Ditemukan')
            );
            /* Jika Pihak Tidak Ditemukan, Maka Tombol Cetak Tidak Ditampilkan */
            $data['isclickable'] = FALSE;
        }
        $this->load->view('generate_template/tun/popup_tun_dismissal',$data,FALSE);

    }
	function cetak_panggil_persiapan_tun(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }                   
        $idperkara=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));       
        $data['idperkara'] = $idperkara;
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){            
            show_404();
            exit();
        } 
        $idjadwal=$this->encrypt->decode(base64_decode($this->input->post('idjadwal',TRUE)));       
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){            
            show_404();
            exit();
        }    
        
        $idpihak=$this->encrypt->decode(base64_decode($this->input->post('pilihan',TRUE)));
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){            
            show_404();
            exit();
        } 
        $jenisTemplate=$this->encrypt->decode(base64_decode($this->input->post('pihakke',TRUE)));        
        if(!is_numeric($jenisTemplate) OR !intval($jenisTemplate)>0){            
            show_404();
            exit();
        }
        $idpenandatangan = $this->encrypt->decode(base64_decode($this->input->post('penandaT',TRUE)));
        if(!empty($idpenandatangan)){
            if(!is_numeric($idpenandatangan) OR !intval($idpenandatangan)>0){            
                show_404();
                exit();
            }
            
        } 
        $data['penandatangan'] = $idpenandatangan;
        $pihak=$this->encrypt->decode(base64_decode($this->input->post('idtemplate',TRUE)));
        $jenisTemplate = $pihak;       
        $data['jenisTemplate'] = $jenisTemplate; 
              
        $this->load->model('generate_template/m_template_pemberitahuan_putusan_tun','template');
        $data['datapn'] = $this->template->getDataPN();
        $data['dataumum'] = $this->template->getDataPersiapan($idperkara,$idjadwal);
        $data['datadismissal'] = $this->template->getPanggilDismissal($idperkara,$idjadwal);
        $data['datapenggugat'] = $this->template->getDataPenggugat($idperkara,$idpihak);
        $data['datapihaktergugat'] = $this->template->getPihakTergugat($idperkara);
        $data['datapihakpenggugat'] = $this->template->getPihakPenggugat($idperkara);
        $data['datatergugat'] = $this->template->getDataTergugat($idperkara,$idpihak);                           

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2'); 

        if($data['jenisTemplate']==1){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_pemeriksaan_persiapan_penggugat.rtf"; 
			//Surat Panggilan Pemeriksaan Persiapan kepada Penggugat
        }else if($data['jenisTemplate']==2){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_pemeriksaan_persiapan_tergugat.rtf";
            //Surat Panggilan Pemeriksaan Persiapan kepada Tergugat
        }else if($data['jenisTemplate']==3){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_dismissal_penggugat.rtf";
            //Surat Panggilan Proses Dissmisal kepada Penggugat
        }else if($data['jenisTemplate']==4){
			$filenya="peradilan_tun/Gugatan/Panggilan/panggilan_dismissal_tergugat.rtf";
            //Surat Panggilan Proses Dissmisal kepada Tergugat
        }
		else{
            show_404();
            exit();
        }  

		$data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
					'idpihak'=>$idpihak,
					'persiapan_proses_id'=>$idjadwal,
                    'ditetapkan_oleh'=>$data['penandatangan']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);
		
    }
	
	function popup_pilihan_pihak_pp($enc,$encPersiapanProses,$pihakke){
        $segment = $this->uri->segment_array();
        $data['enc'] = $enc;       
        $idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['idjadwal'] = $encPersiapanProses;            
        $data['judul'] = 'Cetak Dokumen Pemberitahuan/Panggilan';
        $data['nama_kolom'] = 'Kepada';               
        $data['nama_kolom_ttd'] = 'Tanda Tangan Oleh';
        $data['pilihan'] = array();
        $this->load->model('generate_template/m_template_pemberitahuan_putusan_tun','model_template');
        if($pihakke==1 OR $pihakke==2){
            $list_pihak = $this->model_template->getListPihak($idperkara,$pihakke);
            $data['pihakke'] = base64_encode($this->encrypt->encode($pihakke));
        }        
        if($pihakke==3 OR $pihakke==4){
            $data['penandaTangan'] = $this->model_template->penandaTangan();
            if($pihakke==3){
                $idpihak=1;
            }elseif($pihakke==4){
                $idpihak=2;
            }
            $list_pihak = $this->model_template->getListPihak($idperkara,$idpihak);
            $data['pihakke'] = base64_encode($this->encrypt->encode($idpihak));            
        }
        $data['idpihak'] = base64_encode($this->encrypt->encode($pihakke));            
        $data['isclickable'] = TRUE;
        if($list_pihak->num_rows>0){
            $i=1;
            $data['pilihan'] = array(array('id' => 0,
                'nama' => 'Pilih Pihak'));
            foreach ($list_pihak->result() as $row) {
                $data['pilihan'][$i] = array(
                    'id' => base64_encode($this->encrypt->encode($row->id)),
                    'nama' => $row->nama
                );
                $i++;
            }
        }else{
            $data['pilihan'] = array(
            array('id' => base64_encode($this->encrypt->encode(0)),
                'nama' => 'Pihak Tidak Ditemukan')
            );
            /* Jika Pihak Tidak Ditemukan, Maka Tombol Cetak Tidak Ditampilkan */
            $data['isclickable'] = FALSE;
        }
        $this->load->view('generate_template/tun/popup_tun_pemeriksaan',$data,FALSE);

    }
	function cetak_pemberitahuan_putusan_tun($enc,$idpihak,$jenisTemplate){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       

        $segment = $this->uri->segment_array();       
        $idperkara=$this->encrypt->decode(base64_decode($enc));       
        $data['idperkara'] = $idperkara;
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){            
            show_404();
            exit();
        }   
        
        $idpihak=$this->encrypt->decode(base64_decode($idpihak));
        $data['idpihak'] = $idpihak;
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){            
            show_404();
            exit();
        }   
        $data['jenisTemplate'] = $jenisTemplate;

        $this->load->model('generate_template/m_template_pemberitahuan_putusan_tun','template');
        $data['datapn'] = $this->template->getDataPN();
        $data['dataumum'] = $this->template->getDataUmum($idperkara);
        $data['datapenggugat'] = $this->template->getDataPenggugat($idperkara,$idpihak);
        $data['datatergugat'] = $this->template->getDataTergugat($idperkara,$idpihak);
        $data['datapihakpenggugat'] = $this->template->getPihakPenggugat($idperkara);
        $data['datapihaktergugat'] = $this->template->getPihakTergugat($idperkara);               

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if($data['jenisTemplate']==1){
            $filenya="peradilan_tun/Gugatan/Panggilan/Surat Pemberitahuan Amar Putusan kepada Penggugat.rtf";
			//Surat Pemberitahuan Amar Putusan kepada Tergugat
        }
        else if($data['jenisTemplate']==2){
            $filenya="peradilan_tun/Gugatan/Panggilan/Surat Pemberitahuan Amar Putusan kepada Tergugat.rtf";
			//Surat Pemberitahuan Amar Putusan kepada Penggugat
        }
        else{
            show_404();
            exit();
        }  
        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'ditetapkan_oleh'=>$data['options']);  

        $this->load->model('generate_template/var_template_tun','var_template_tun');
        $this->var_template_tun->kirim_variabel($data_id);     
    }
	function popup_pilihan_pihak(){
        $segment = $this->uri->segment_array();
        $data['enc'] = $segment[3];
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_template'] = base64_encode($this->encrypt->encode($segment[4]));
        $pihakke = $segment[5];
        if(!empty($segment[6])){
            $data['idjadwal'] = $segment[6];
        }        
        $data['judul'] = 'Cetak Dokumen Pemberitahuan/Panggilan';
        $data['nama_kolom'] = 'Kepada';
        $data['idoption'] = 'enc_pihak';

        $data['pilihan'] = array();
        $this->load->model('generate_template/m_template_tun_perlawanan','model_template');
        $list_pihak = $this->model_template->getListPihak($idperkara,$pihakke);
        $data['isclickable'] = TRUE;
        if($list_pihak->num_rows>0){
            $i=1;
            $data['pilihan'] = array(array('id' => 0,
                'nama' => 'Pilih Pihak'));
            foreach ($list_pihak->result() as $row) {
                $data['pilihan'][$i] = array(
                    'id' => base64_encode($this->encrypt->encode($row->id)),
                    'nama' => $row->nama
                );
                $i++;
            }
        }else{
            $data['pilihan'] = array(
            array('id' => base64_encode($this->encrypt->encode(0)),
                'nama' => 'Pihak Tidak Ditemukan')
            );
            /* Jika Pihak Tidak Ditemukan, Maka Tombol Cetak Tidak Ditampilkan */
            $data['isclickable'] = FALSE;
        }
        $this->load->view('generate_template/tun/popup_tun_pilihan',$data,FALSE);
	}
}
?>